<?php
    function selectCurrentContent($inputData) {
        $inputData['table'] = 'cms_image';
        $lastModified = getMaxDate($inputData);


        if(isset($inputData['lastModified']) && $inputData['lastModified'] == $lastModified) {
            $data['status'] = 'Success';
            $data['message'] = 'No new content';
            return $data;
        }else{
            $pdo = $inputData['db']['dbApp'];
            $pdo->setAttribute(PDO::ATTR_ERRMODE, PDO::ERRMODE_EXCEPTION);
            $result = []; // Initialize result array to handle the case where no rows are found
            $cmsCont = [];

            $whereClauses = ["is_deleted = 0", "parent_id = 0"];
            $params = [];

            if (!empty($inputData['imageId'])) {
                $whereClauses[] = "id = :imageId";
                $params[':imageId'] = $inputData['imageId'];
            } else {
                if (!empty($inputData['pageId'])) {
                    $whereClauses[] = "page_id = :pageId";
                    $params[':pageId'] = $inputData['pageId'];
                }
                if (!empty($inputData['imageName'])) {
                    $whereClauses[] = "image_name = :imageName";
                    $params[':imageName'] = $inputData['imageName'];
                }
                if (!empty($inputData['imageTitle'])) {
                    $whereClauses[] = "image_title = :imageTitle";
                    $params[':imageTitle'] = $inputData['imageTitle'];
                }
            }

            $whereSQL = implode(" AND ", $whereClauses);

            $sql = "SELECT id, parent_id, image_title, image_name, image_path, image_alt, IFNULL(image_priority, 0) AS image_priority, page_id FROM cms_image where $whereSQL";
            
            
            $stmt = $pdo->prepare($sql);
            
            if (!empty($params)) {
                foreach ($params as $key => $value) {
                    $stmt->bindParam($key, $value);
                }
            }
            $stmt->execute();

            $cmsCont = [];

            while ($row = $stmt->fetch(PDO::FETCH_ASSOC)) {
                $inputData['cmsImageId'] = $row['id'];
            
                // Common core structure
                $res = [
                    'imagePath' => $row['image_path'],
                    'imageTag'  => getTagPerImage($inputData)
                ];
            
                if (!empty($inputData['DataForLog'])) {
                    // Simplified DataForLog version (single value output)
                    $res['imageTitle']    = $row['image_title'];
                    $res['imageName']     = $row['image_name'];
                    $res['imageAlt']      = $row['image_alt'];
                    $res['imagePriority'] = $row['image_priority'];
            
                    $cmsCont[] = $res; // Still an array if multiple rows
                } else {
                    // Standard mode: array aggregation per image block
                    $res['imageTitle']    = [$row['image_title']];
                    $res['imageName']     = [$row['image_name']];
                    $res['imageAlt']      = [$row['image_alt']];
                    $res['imagePriority'] = [$row['image_priority']];
            
                    // Add children if any
                    $inputData['parentId'] = $row['id'];
                    $childImages = getChildImages($inputData);
            
                    foreach ($childImages as $childImage) {
                        $res['imageTitle'][]    = $childImage['imageTitle'];
                        $res['imageName'][]     = $childImage['imageName'];
                        $res['imageAlt'][]      = $childImage['imageAlt'];
                        $res['imagePriority'][] = $childImage['imagePriority'];
                    }
            
                    if (!isset($inputData['pageId'])) {
                        $res['pageId'] = $row['page_id'];
                    }
            
                    $cmsCont[] = $res;
                }
            }
            
            if (!empty($cmsCont)) {
                $result['cmsCont'] = $cmsCont;
                $result['lastModified'] = $lastModified;
                $result['status'] = 'success';
            //    $result['sql'] = $sql;
            }else{
                $result['status'] = 'Failed';
                $result['message'] = 'No content found';
            //    $result['sql'] = $sql;
                
            }

        }
        return $result;
    }

    function getChildImages($inputData){
        $pdo = $inputData['db']['dbApp'];
        $sql = 'SELECT image_title, image_name, image_path, image_alt, IFNULL(image_priority, 0) AS image_priority FROM cms_image WHERE parent_id = :parentId AND is_deleted = 0';
        $stmt = $pdo->prepare($sql);
        $stmt->bindParam(':parentId', $inputData['parentId']);
        $stmt->execute();
        $childImages = [];
        $i = 1;
        while ($row = $stmt->fetch(PDO::FETCH_ASSOC)) {
            $res = [];
            $res['imageTitle']      = $row['image_title'];
            $res['imageName']       = $row['image_name'];
            $res['imagePath']       = $row['image_path'];
            $res['imageAlt']        = $row['image_alt'];
            $res['imagePriority'] = ($row['image_priority'] == 0) ? (string)$i : $row['image_priority'];
            $childImages[] = $res;
            $i++;
        }
        return $childImages;
    }

    function getMaxDate($inputData) {
        $pdo = $inputData['db']['dbApp'];
        $table = $inputData['table'];
        $sql = "SELECT MAX(modified_date) as modified_date FROM $table ";
        $sqlAdd = '';
        if (isset($inputData['tagName'])) {
            $sqlAdd .= ' AND tagName = :tagName ';
        }
        if (isset($inputData['pageId'])) {
            $sqlAdd .= ' AND page_id = :pageId ';
        }
        // ✅ Ensure WHERE is used correctly
        $sqlAdd = preg_replace('/\bAND\b/', 'WHERE', $sqlAdd, 1);
        $sql .= $sqlAdd;
        // ✅ Prepare the statement
        $stmt = $pdo->prepare($sql);
        if (isset($inputData['pageId'])) {
            $stmt->bindParam(':pageId', $inputData['pageId']);
        }
        if (isset($inputData['tagName'])) {
            $stmt->bindParam(':tagName', $inputData['tagName']);
        }
        $stmt->execute();
        // ✅ Use `fetch()` safely
        $row = $stmt->fetch(PDO::FETCH_ASSOC);
        // ✅ Return modified_date or NULL if not found
        return $row['modified_date'] ?? null;
    }

    function getTagList($inputData) {
        $inputData['table'] = 'cms_image_tag';
        $lastModified = getMaxDate($inputData);
    
        if (isset($inputData['lastModified']) && $inputData['lastModified'] == $lastModified) {
            return [
                'status' => 'Success',
                'message' => 'No new content'
            ];
        }
    
        $tagSql = '';
        if (isset($inputData['tagId'])) {
            $tagSql .= ' AND tag_id = :tagId ';
        }
    
        $pdo = $inputData['db']['dbApp'];
        $pdo->setAttribute(PDO::ATTR_ERRMODE, PDO::ERRMODE_EXCEPTION);
    
        $sql = "SELECT tag_id, tag_name FROM cms_image_tag WHERE is_deleted = 0 " . $tagSql;
        $stmt = $pdo->prepare($sql);
    
        if (isset($inputData['tagId'])) {
            $stmt->bindParam(':tagId', $inputData['tagId']);
        }
    
        $stmt->execute();
        $rows = $stmt->fetchAll(PDO::FETCH_ASSOC);
    
        $result = [];
    
        if (!empty($rows)) {
            $tagList = [];
            foreach ($rows as $row) {
                $tagList[] = [
                    'id' => $row['tag_id'],
                    'tagName' => $row['tag_name']
                ];
            }
    
            $result['tagList'] = $tagList;
            $result['lastModified'] = $lastModified;
            $result['status'] = 'success';
        } else {
            $result['status'] = 'Failed';
            $result['message'] = 'No content found';
        }
    
        return $result;
    }  

    function getTagPerImage($inputData) {
        $pdo = $inputData['db']['dbApp'];
    
        $sql = 'SELECT tag_name
                FROM cms_image_tag CIT
                INNER JOIN cms_image_tag_map CITM ON CIT.tag_id = CITM.tag_id
                WHERE CITM.image_id = :imageId 
                  AND CIT.is_deleted = 0 
                  AND CITM.is_deleted = 0';
    
        $stmt = $pdo->prepare($sql);
        $stmt->bindParam(':imageId', $inputData['cmsImageId'], PDO::PARAM_INT);
        $stmt->execute();
    
        $results = $stmt->fetchAll(PDO::FETCH_ASSOC);
    
        if (!empty($results)) {
            $tagList = array_column($results, 'tag_name');
        } else {
            $tagList = ['No Tags Found'];
        }
    
        return $tagList;
    }
    
    function checkTagExists($inputData) {
        $pdo = $inputData['db']['dbApp'];
        $sql = 'SELECT tag_id, is_deleted FROM cms_image_tag WHERE tag_name = :tagName';
        $stmt = $pdo->prepare($sql);
        $stmt->bindParam(':tagName', $inputData['tagName']);
        $stmt->execute();
        // ✅ Fetch directly instead of using rowCount()
        $row = $stmt->fetch(PDO::FETCH_ASSOC);
        if ($row) {  // ✅ `fetch()` returns false if no rows
            return [
                'tagId'     => $row['tag_id'],
                'isDeleted' => $row['is_deleted'],
                'status'    => 'success'
            ];
        } else {
            return [
                'status'  => 'failed',
                'message' => 'No Tag Found'
            ];
        }
    }
    

    function checkMappingExists($inputData){
        $pdo = $inputData['db']['dbApp'];
        $sql = 'SELECT map_id, is_deleted FROM cms_image_tag_map WHERE tag_id = :tagId AND image_Id = :imageId';
        $stmt = $pdo->prepare($sql);
        $stmt->bindParam(':tagId',   $inputData['tagId']);
        $stmt->bindParam(':imageId', $inputData['imageId']);
        $stmt->execute();
        if ($stmt->rowCount() > 0) {
            $row = $stmt->fetch(PDO::FETCH_ASSOC);
            $result['mapId'] = $row['map_id'];
            $result['isDeleted'] = $row['is_deleted'];
            $result['status'] = 'success';
        }else{
            $result['status'] = 'failed';
            $result['message'] = 'No Mapping Found';
        }
        return $result;
    }
?>