CREATE TABLE cms_image (
    id              INT AUTO_INCREMENT PRIMARY KEY,
    parent_id       INT NULL default 0,  -- A reference to the parent image, if applicable
    page_id         INT NOT NULL,
    image_title     VARCHAR(50) NOT NULL,
    image_name      VARCHAR(50) NOT NULL,  -- MEDIUMTEXT can store up to 16MB, which should be adequate for large text
    image_path      VARCHAR(100),
    image_alt       VARCHAR(100),
    image_priority  INT NULL,  -- A simple integer to determine the order of images
    created_date    DATETIME DEFAULT CURRENT_TIMESTAMP,
    modified_date   DATETIME DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
    is_deleted      TINYINT(1) DEFAULT 0,  -- A simple flag to mark the row as deleted
    deleted_date    DATETIME DEFAULT NULL,  -- Timestamp for when the page was marked as deleted
    deprecated_date DATETIME DEFAULT NULL,  -- Timestamp for when the page was marked as deprecated
    UNIQUE (page_id, image_title, image_name)
);


-- alter statment to add UNIQUE (page_id, image_title, image_name) to the table

CREATE TABLE cms_image_changes (
    change_id       INT AUTO_INCREMENT PRIMARY KEY,
    parent_id       INT NULL default 0,
    page_id         INT NOT NULL,
    image_title     VARCHAR(50) NOT NULL,
    previous_image  VARCHAR(50),
    image_path      VARCHAR(100),
    image_alt       VARCHAR(100),
    image_priority  INT NULL,
    changed_at      DATETIME DEFAULT CURRENT_TIMESTAMP,
    FOREIGN KEY (page_id) REFERENCES cms_image(page_id)
);

CREATE Table cms_image_tag (
    tag_id          INT AUTO_INCREMENT PRIMARY KEY,
    tag_name        VARCHAR(50) NOT NULL,
    created_date    DATETIME DEFAULT CURRENT_TIMESTAMP,
    modified_date   DATETIME DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
    is_deleted      TINYINT(1) DEFAULT 0,
    deleted_date    DATETIME DEFAULT NULL,
    UNIQUE (tag_name)
);

CREATE TABLE cms_image_tag_changes (
    change_id       INT AUTO_INCREMENT PRIMARY KEY,
    tag_id          INT NOT NULL,
    previous_tagname VARCHAR(50),
    changed_at      DATETIME DEFAULT CURRENT_TIMESTAMP,
    FOREIGN KEY (tag_id) REFERENCES cms_image_tags(tag_id)
);

CREATE TABLE cms_image_tag_map (
    map_id          INT AUTO_INCREMENT PRIMARY KEY,
    image_id        INT NOT NULL,
    tag_id          INT NOT NULL,
    created_date    DATETIME DEFAULT CURRENT_TIMESTAMP,
    modified_date   DATETIME DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
    is_deleted      TINYINT(1) DEFAULT 0,
    deleted_date    DATETIME DEFAULT NULL,
    FOREIGN KEY (image_id) REFERENCES cms_image(id),
    FOREIGN KEY (tag_id) REFERENCES cms_image_tag(tag_id)
);

Go;

CREATE TRIGGER cms_image_update_modified_date
BEFORE UPDATE ON cms_image
FOR EACH ROW
BEGIN
    SET NEW.modified_date = NOW();
END $$

--  Set the delimiter in sql to "$$" othewerwise we will get failure


