<?php
    ini_set('error_log', 'php://stderr');
    error_log("Something went wrong");

    use PHPUnit\Framework\TestCase;
    
    //require_once __DIR__ . '/../../tests/scripts/bootstrap.php'; // ✅ Use shared mock DB
    //require_once __DIR__ . '/../src/function.php';
    echo "\n>>>>>>>>>>>>>>>>>>>>>>>>>====<<<<<<<<<<<<<<<<<<<<<<<<<\n";
    echo "\nT04_CmsImagesTest.php\n";
    
    // Print list of table that exist in the database
    //$tables = $GLOBALS['mockPdo']->query("SELECT name FROM sqlite_master WHERE type='table';")->fetchAll(PDO::FETCH_COLUMN);
    //echo("\n🔍 Tables: " . implode(', ', $tables). "\n");
    
    class T04_CmsImageTest extends TestCase
    {
        private $mockPdo;
        private static $lastModified;

    protected function setUp(): void{
        // ✅ Use the shared mock database connection
        $_SESSION = [];
        $_GET = [];
        $_POST = [];
        $_SERVER['REMOTE_ADDR'] = '127.0.0.1';
        $_SERVER['HTTP_REFERER'] = 'http://localhost/test';
        $this->mockPdo = $GLOBALS['mockPdo'];
        if (session_status() !== PHP_SESSION_ACTIVE) {
            session_start();
        }
    }

    private function executeFunctionPhp(): array {
        ob_start();
        require __DIR__ . '/../src/function.php';
        $output = ob_get_clean();
    
        // ✅ Ensure only valid JSON output
        $decodedOutput = json_decode($output, true);
        if (json_last_error() !== JSON_ERROR_NONE) {
            throw new Exception("Invalid JSON output: " . json_last_error_msg() . "\nOutput: " . $output);
        }
    
        return [$output, $decodedOutput];
    }

    public function testDummyTest(): void{
        $this->assertTrue(true);
    }
    

    public function testCmsImageContent(): void {

        $_GET = [
            'action' => 'CMSImageContent'
        ];
        
        list($output, $_GET) = $this->executeFunctionPhp();

        $decodedOutput = json_decode($output, true);

        //echo print_r($decodedOutput);
        
        // help build the expected data results
        $expectedDataResults = [
            'cmsCont' => [
                0 => [
                    'imageTitle' => [
                                        0 => 'Media Wall 1 ', 
                                        1 => 'Media Wall 1 ',
                                        2 => 'Media Wall 1 ',
                                        3 => 'Media Wall 1 '
                                    ],
                    'imageName' => [ 
                                        0 => 'IMG_0061.jpeg',
                                        1 => 'IMG_0062.jpeg',
                                        2 => 'IMG_0063.jpeg',
                                        3 => 'IMG_0064.jpeg'
                                    ],
                    'imagePath' => 'https://stv2bournbespokeimg.blob.core.windows.net/bourne-bespoke-web-img/dev',
                    'imageAlt' => [
                                        0 => 'IMG_0061.jpeg',
                                        1 => 'IMG_0062.jpeg',
                                        2 => 'IMG_0063.jpeg',
                                        3 => 'IMG_0064.jpeg'
                                    ],
                    'imagePriority' => [
                                        0 => 0,
                                        1 => 1,
                                        2 => 2,
                                        3 => 3
                                    ],
                    'imageTag' => ['Wardrobes'],
                    'pageId' => 1
                ],
                1 => [
                    'imageTitle' => ['Media Wall 1 '],
                    'imageName' => ['IMG_0222.jpg'],
                    'imagePath' => 'https://stv2bournbespokeimg.blob.core.windows.net/bourne-bespoke-web-img/dev',
                    'imageAlt' => ['IMG_0222.jpg'],
                    'imagePriority' => [0],
                    'imageTag' => ['Media Walls'],
                    'pageId' => 1
                ],
                2 => [
                    'imageTitle' => ['Media Wall 1 '],
                    'imageName' => ['IMG_0223.jpg'],
                    'imagePath' => 'https://stv2bournbespokeimg.blob.core.windows.net/bourne-bespoke-web-img/dev',
                    'imageAlt' => ['IMG_0223.jpg'],
                    'imagePriority' => [0],
                    'imageTag' => ['Media Walls'],
                    'pageId' => 1
                ],
                3 => [
                    'imageTitle' => ['Media Wall 1 '],
                    'imageName' => ['IMG_0224.jpg'],
                    'imagePath' => 'https://stv2bournbespokeimg.blob.core.windows.net/bourne-bespoke-web-img/dev',
                    'imageAlt' => ['IMG_0224.jpg'],
                    'imagePriority' => [0],
                    'imageTag' => ['Drinks Bars'],
                    'pageId' => 1
                ],
                4 => [
                    'imageTitle' => ['Media Wall 1 '],
                    'imageName' => ['IMG_0226.jpg'],
                    'imagePath' => 'https://stv2bournbespokeimg.blob.core.windows.net/bourne-bespoke-web-img/dev',
                    'imageAlt' => ['IMG_0226.jpg'],
                    'imagePriority' => [0],
                    'imageTag' => ['Offices'],
                    'pageId' => 2
                ],
                5 => [
                    'imageTitle' => ['Media Wall 1 '],
                    'imageName' => ['IMG_0227.jpg'],
                    'imagePath' => 'https://stv2bournbespokeimg.blob.core.windows.net/bourne-bespoke-web-img/dev',
                    'imageAlt' => ['IMG_0227.jpg'],
                    'imagePriority' => [0],
                    'imageTag' => ['Media Walls'],
                    'pageId' => 2
                ],
                6 => [
                    'imageTitle' => ['Media Wall 1 '],
                    'imageName' => ['IMG_0228.jpg'],
                    'imagePath' => 'https://stv2bournbespokeimg.blob.core.windows.net/bourne-bespoke-web-img/dev',
                    'imageAlt' => ['IMG_0228.jpg'],
                    'imagePriority' => [0],
                    'imageTag' => ['Media Walls'],
                    'pageId' => 2
                ]
            ]
        ];
        $this->assertArrayHasKey('action', $decodedOutput);
        $this->assertEquals('CMSImageContent', $decodedOutput['action']);
        $this->assertArrayHasKey('cmsCont', $decodedOutput);
        $this->assertEquals($expectedDataResults['cmsCont'], $decodedOutput['cmsCont']);
        // modified_date
        $this->assertArrayHasKey('lastModified', $decodedOutput);
        self::$lastModified = $decodedOutput['lastModified'];
    }


    public function testCmsImageContentWithPageId(): void {
        $_GET = [
            'action' => 'CMSImageContent',
            'pageId' => 1
        ];
        
        list($output, $_GET) = $this->executeFunctionPhp();

        $decodedOutput = json_decode($output, true);

        //echo print_r($decodedOutput);

        $expectedDataResults = [
            'cmsCont' => [
                0 => [
                    'imageTitle' => [
                                        0 => 'Media Wall 1 ', 
                                        1 => 'Media Wall 1 ',
                                        2 => 'Media Wall 1 ',
                                        3 => 'Media Wall 1 '
                                    ],
                    'imageName' => [ 
                                        0 => 'IMG_0061.jpeg',
                                        1 => 'IMG_0062.jpeg',
                                        2 => 'IMG_0063.jpeg',
                                        3 => 'IMG_0064.jpeg'
                                    ],
                    'imagePath' => 'https://stv2bournbespokeimg.blob.core.windows.net/bourne-bespoke-web-img/dev',
                    'imageAlt' => [
                                        0 => 'IMG_0061.jpeg',
                                        1 => 'IMG_0062.jpeg',
                                        2 => 'IMG_0063.jpeg',
                                        3 => 'IMG_0064.jpeg'
                                    ],
                    'imagePriority' => [
                                        0 => 0,
                                        1 => 1,
                                        2 => 2,
                                        3 => 3
                                    ],
                    'imageTag' => ['Wardrobes']
                ],
                1 => [
                    'imageTitle' => ['Media Wall 1 '],
                    'imageName' => ['IMG_0222.jpg'],
                    'imagePath' => 'https://stv2bournbespokeimg.blob.core.windows.net/bourne-bespoke-web-img/dev',
                    'imageAlt' => ['IMG_0222.jpg'],
                    'imagePriority' => [0],
                    'imageTag' => ['Media Walls']
                ],
                2 => [
                    'imageTitle' => ['Media Wall 1 '],
                    'imageName' => ['IMG_0223.jpg'],
                    'imagePath' => 'https://stv2bournbespokeimg.blob.core.windows.net/bourne-bespoke-web-img/dev',
                    'imageAlt' => ['IMG_0223.jpg'],
                    'imagePriority' => [0],
                    'imageTag' => ['Media Walls']
                ],
                3 => [
                    'imageTitle' => ['Media Wall 1 '],
                    'imageName' => ['IMG_0224.jpg'],
                    'imagePath' => 'https://stv2bournbespokeimg.blob.core.windows.net/bourne-bespoke-web-img/dev',
                    'imageAlt' => ['IMG_0224.jpg'],
                    'imagePriority' => [0],
                    'imageTag' => ['Drinks Bars']
                ]
            ]
        ];

        $this->assertArrayHasKey('action', $decodedOutput);
        $this->assertEquals('CMSImageContent', $decodedOutput['action']);
        $this->assertArrayHasKey('cmsCont', $decodedOutput);
        $this->assertEquals($expectedDataResults['cmsCont'], $decodedOutput['cmsCont']);
        // modified_date
        $this->assertArrayHasKey('lastModified', $decodedOutput);
        self::$lastModified = $decodedOutput['lastModified'];
    }


    // i want to test the funcanality of last modified date 
    public function testCmsImageContentWithLastModifiedMatch(): void {
        $_GET = [
            'action' => 'CMSImageContent',
            'lastModified' => self::$lastModified
        ];
        
        list($output, $_GET) = $this->executeFunctionPhp();

        $decodedOutput = json_decode($output, true);

        //echo print_r($decodedOutput);

        $expectedDataResults = [
            'status' => 'success',
            'message' => 'No content found'
        ];

        $this->assertArrayHasKey('status', $decodedOutput);
        $this->assertEquals('Success', $decodedOutput['status']);
        $this->assertArrayHasKey('message', $decodedOutput);
        $this->assertEquals('No new content', $decodedOutput['message']);
    }

    // test a modidate -1h from the last modified date self::$lastModified

    public function testCmsImageContentWithLastModifiedNotMatch(): void {
        $_GET = [
            'action' => 'CMSImageContent',
            'lastModified' => date('Y-m-d H:i:s', strtotime(self::$lastModified . ' -1 hour'))
        ];
        
        list($output, $_GET) = $this->executeFunctionPhp();

        $decodedOutput = json_decode($output, true);

        //echo print_r($decodedOutput);

        $expectedDataResults = [
            'cmsCont' => [
                0 => [
                    'imageTitle' => [
                                        0 => 'Media Wall 1 ', 
                                        1 => 'Media Wall 1 ',
                                        2 => 'Media Wall 1 ',
                                        3 => 'Media Wall 1 '
                                    ],
                    'imageName' => [ 
                                        0 => 'IMG_0061.jpeg',
                                        1 => 'IMG_0062.jpeg',
                                        2 => 'IMG_0063.jpeg',
                                        3 => 'IMG_0064.jpeg'
                                    ],
                    'imagePath' => 'https://stv2bournbespokeimg.blob.core.windows.net/bourne-bespoke-web-img/dev',
                    'imageAlt' => [
                                        0 => 'IMG_0061.jpeg',
                                        1 => 'IMG_0062.jpeg',
                                        2 => 'IMG_0063.jpeg',
                                        3 => 'IMG_0064.jpeg'
                                    ],
                    'imagePriority' => [
                                        0 => 0,
                                        1 => 1,
                                        2 => 2,
                                        3 => 3
                                    ],
                    'imageTag' => ['Wardrobes'],
                    'pageId' => 1
                ],
                1 => [
                    'imageTitle' => ['Media Wall 1 '],
                    'imageName' => ['IMG_0222.jpg'],
                    'imagePath' => 'https://stv2bournbespokeimg.blob.core.windows.net/bourne-bespoke-web-img/dev',
                    'imageAlt' => ['IMG_0222.jpg'],
                    'imagePriority' => [0],
                    'imageTag' => ['Media Walls'],
                    'pageId' => 1
                ],
                2 => [
                    'imageTitle' => ['Media Wall 1 '],
                    'imageName' => ['IMG_0223.jpg'],
                    'imagePath' => 'https://stv2bournbespokeimg.blob.core.windows.net/bourne-bespoke-web-img/dev',
                    'imageAlt' => ['IMG_0223.jpg'],
                    'imagePriority' => [0],
                    'imageTag' => ['Media Walls'],
                    'pageId' => 1
                ],
                3 => [
                    'imageTitle' => ['Media Wall 1 '],
                    'imageName' => ['IMG_0224.jpg'],
                    'imagePath' => 'https://stv2bournbespokeimg.blob.core.windows.net/bourne-bespoke-web-img/dev',
                    'imageAlt' => ['IMG_0224.jpg'],
                    'imagePriority' => [0],
                    'imageTag' => ['Drinks Bars'],
                    'pageId' => 1
                ],
                4 => [
                    'imageTitle' => ['Media Wall 1 '],
                    'imageName' => ['IMG_0226.jpg'],
                    'imagePath' => 'https://stv2bournbespokeimg.blob.core.windows.net/bourne-bespoke-web-img/dev',
                    'imageAlt' => ['IMG_0226.jpg'],
                    'imagePriority' => [0],
                    'imageTag' => ['Offices'],
                    'pageId' => 2
                ],
                5 => [
                    'imageTitle' => ['Media Wall 1 '],
                    'imageName' => ['IMG_0227.jpg'],
                    'imagePath' => 'https://stv2bournbespokeimg.blob.core.windows.net/bourne-bespoke-web-img/dev',
                    'imageAlt' => ['IMG_0227.jpg'],
                    'imagePriority' => [0],
                    'imageTag' => ['Media Walls'],
                    'pageId' => 2
                ],
                6 => [
                    'imageTitle' => ['Media Wall 1 '],
                    'imageName' => ['IMG_0228.jpg'],
                    'imagePath' => 'https://stv2bournbespokeimg.blob.core.windows.net/bourne-bespoke-web-img/dev',
                    'imageAlt' => ['IMG_0228.jpg'],
                    'imagePriority' => [0],
                    'imageTag' => ['Media Walls'],
                    'pageId' => 2
                ]
            ]
        ];

        $this->assertArrayHasKey('action', $decodedOutput);
        $this->assertEquals('CMSImageContent', $decodedOutput['action']);
        $this->assertArrayHasKey('cmsCont', $decodedOutput);
        $this->assertEquals($expectedDataResults['cmsCont'], $decodedOutput['cmsCont']);
    }


    // test CMSImageInsert with valid data not logged in 
    public function testCmsImageInsertNoAuth(): void {
        $_POST = [
            'action' => 'CMSImageInsert',
            'pageId' => 1,
            'imageTitle' => 'Media Wall 1',
            'imageName' => 'IMG_0229.jpg',
            'imagePath' => 'https://stv2bournbespokeimg.blob.core.windows.net/bourne-bespoke-web-img/dev',
            'imageAlt' => 'IMG_0229.jpg',
            'imagePriority' => 0
        ];
        
        list($output, $_POST) = $this->executeFunctionPhp();

        $decodedOutput = json_decode($output, true);

        //echo print_r($decodedOutput);

        $expectedDataResults = [
            'status' => 'success',
            'message' => 'Item inserted successfully'
        ];

        $this->assertArrayHasKey('status', $decodedOutput);
        $this->assertEquals('failed', $decodedOutput['status']);
        $this->assertArrayHasKey('message', $decodedOutput);
        $this->assertEquals('User is not logged in', $decodedOutput['message']);
    }

    // test CMSImageInsert with valid data logged in
    public function testCmsImageInsert(): void {
        $_SESSION['id'] = 1;

        $_POST = [
            'action' => 'CMSImageInsert',
            'pageId' => 1,
            'imageTitle' => 'Media Wall 1',
            'imageName' => 'IMG_0229.jpg',
            'imagePath' => 'https://stv2bournbespokeimg.blob.core.windows.net/bourne-bespoke-web-img/dev',
            'imageAlt' => 'IMG_0229.jpg',
            'imagePriority' => 0
        ];

        list($output, $_POST) = $this->executeFunctionPhp();

        $decodedOutput = json_decode($output, true);

        //echo print_r($decodedOutput);

        $this->assertArrayHasKey('status', $decodedOutput);
        $this->assertEquals('success', $decodedOutput['status']);
        $this->assertArrayHasKey('message', $decodedOutput);
        $this->assertEquals('Item inserted successfully', $decodedOutput['message']);

    }


    // test CMSImageInsert with duplicate data logged in
    public function testCmsImageInsertDuplicate(): void {
        $_SESSION['id'] = 1;

        $_POST = [
            'action' => 'CMSImageInsert',
            'pageId' => 1,
            'imageTitle' => 'Media Wall 1',
            'imageName' => 'IMG_0229.jpg',
            'imagePath' => 'https://stv2bournbespokeimg.blob.core.windows.net/bourne-bespoke-web-img/dev',
            'imageAlt' => 'IMG_0229.jpg',
            'imagePriority' => 0
        ];

        list($output, $_POST) = $this->executeFunctionPhp();

        $decodedOutput = json_decode($output, true);

        //echo print_r($decodedOutput);

        $this->assertArrayHasKey('status', $decodedOutput);
        $this->assertEquals('error', $decodedOutput['status']);
        $this->assertArrayHasKey('message', $decodedOutput);
        $this->assertEquals('SQLSTATE[23000]: Integrity constraint violation: 19 UNIQUE constraint failed: cms_image.page_id, cms_image.image_title, cms_image.image_name', $decodedOutput['message']);
    }

    // test CMSImageInsert with missing data

    public function testCmsImageInsertMissingImagePath(): void {
        $_SESSION['id'] = 1;

        $_POST = [
            'action' => 'CMSImageInsert',
            'pageId' => 2,
            'imageTitle' => 'Media Wall 1',
            'imageName' => 'IMG_0229.jpg',
            'imageAlt' => 'IMG_0229.jpg',
            'imagePriority' => 0
        ];

        list($output, $_POST) = $this->executeFunctionPhp();

        $decodedOutput = json_decode($output, true);

        //echo print_r($decodedOutput);

        $this->assertArrayHasKey('status', $decodedOutput);
        $this->assertEquals('failed', $decodedOutput['status']);
        $this->assertArrayHasKey('message', $decodedOutput);
        $this->assertEquals('Image path is required', $decodedOutput['message']);
    }

    public function testCmsImageInsertMissingImageName(): void {
        $_SESSION['id'] = 1;

        $_POST = [
            'action' => 'CMSImageInsert',
            'pageId' => 2,
            'imageTitle' => 'Media Wall 1',
            'imagePath' => 'https://stv2bournbespokeimg.blob.core.windows.net/bourne-bespoke-web-img/dev',
            'imageAlt' => 'IMG_0229.jpg',
            'imagePriority' => 0
        ];

        list($output, $_POST) = $this->executeFunctionPhp();

        $decodedOutput = json_decode($output, true);

        //echo print_r($decodedOutput);

        $this->assertArrayHasKey('status', $decodedOutput);
        $this->assertEquals('failed', $decodedOutput['status']);
        $this->assertArrayHasKey('message', $decodedOutput);
        $this->assertEquals('Image name is required', $decodedOutput['message']);
    }

    public function testCmsImageInsertMissingPageId(): void {
        $_SESSION['id'] = 1;

        $_POST = [
            'action' => 'CMSImageInsert',
            'imageTitle' => 'Media Wall 1',
            'imageName' => 'IMG_0229.jpg',
            'imagePath' => 'https://stv2bournbespokeimg.blob.core.windows.net/bourne-bespoke-web-img/dev',
            'imageAlt' => 'IMG_0229.jpg',
            'imagePriority' => 0
        ];

        list($output, $_POST) = $this->executeFunctionPhp();

        $decodedOutput = json_decode($output, true);

        //echo print_r($decodedOutput);

        $this->assertArrayHasKey('status', $decodedOutput);
        $this->assertEquals('failed', $decodedOutput['status']);
        $this->assertArrayHasKey('message', $decodedOutput);
        $this->assertEquals('Page id is required', $decodedOutput['message']);
    }


    public function testCmsImageInsertMissingImageTitle(): void {
        $_SESSION['id'] = 1;

        $_POST = [
            'action' => 'CMSImageInsert',
            'pageId' => 2,
            'imageName' => 'IMG_0229.jpg',
            'imagePath' => 'https://stv2bournbespokeimg.blob.core.windows.net/bourne-bespoke-web-img/dev',
            'imageAlt' => 'IMG_0229.jpg',
            'imagePriority' => 0
        ];

        list($output, $_POST) = $this->executeFunctionPhp();

        $decodedOutput = json_decode($output, true);

        //echo print_r($decodedOutput);

        $this->assertArrayHasKey('status', $decodedOutput);
        $this->assertEquals('failed', $decodedOutput['status']);
        $this->assertArrayHasKey('message', $decodedOutput);
        $this->assertEquals('Image title is required', $decodedOutput['message']);
    }

    // test CMSImageUpdate with data not logged in
    public function testCmsImageUpdateNoAuth(): void {
        $_POST = [
            'action' => 'CMSImageUpdate',
            'pageId' => 1,
            'imageTitle' => 'Media Wall 1',
            'imageName' => 'IMG_0229.jpg',
            'imagePath' => 'https://stv2bournbespokeimg.blob.core.windows.net/bourne-bespoke-web-img/dev',
            'imageAlt' => 'IMG_0229.jpg',
            'imagePriority' => 0
        ];
        
        list($output, $_POST) = $this->executeFunctionPhp();

        $decodedOutput = json_decode($output, true);

        //echo print_r($decodedOutput);

        $this->assertArrayHasKey('status', $decodedOutput);
        $this->assertEquals('failed', $decodedOutput['status']);
        $this->assertArrayHasKey('message', $decodedOutput);
        $this->assertEquals('User is not logged in', $decodedOutput['message']);
    }

    public function testCmsImageUpdateNoPageId(): void{
        $_SESSION['id'] = 1;

        $_POST = [
            'action' => 'CMSImageUpdate',
            'imageTitle' => 'Media Wall 1',
            'imageName' => 'IMG_0229.jpg',
            'imagePath' => 'https://stv2bournbespokeimg.blob.core.windows.net/bourne-bespoke-web-img/dev',
            'imageAlt' => 'IMG_0229.jpg',
            'imagePriority' => 0
        ];

        list($output, $_POST) = $this->executeFunctionPhp();

        $decodedOutput = json_decode($output, true);

        //echo print_r($decodedOutput);

        $this->assertArrayHasKey('status', $decodedOutput);
        $this->assertEquals('failed', $decodedOutput['status']);
        $this->assertArrayHasKey('message', $decodedOutput);
        $this->assertEquals('Missing required fields', $decodedOutput['message']);
    }

    public function testCmsImageUpdateNoPageTitle(): void{
        $_SESSION['id'] = 1;

        $_POST = [
            'action' => 'CMSImageUpdate',
            'pageId' => 1,
            'imageName' => 'IMG_0229.jpg',
            'imagePath' => 'https://stv2bournbespokeimg.blob.core.windows.net/bourne-bespoke-web-img/dev',
            'imageAlt' => 'IMG_0229.jpg',
            'imagePriority' => 0
        ];

        list($output, $_POST) = $this->executeFunctionPhp();

        $decodedOutput = json_decode($output, true);

        //echo print_r($decodedOutput);

        $this->assertArrayHasKey('status', $decodedOutput);
        $this->assertEquals('failed', $decodedOutput['status']);
        $this->assertArrayHasKey('message', $decodedOutput);
        $this->assertEquals('Missing required fields', $decodedOutput['message']);
    }

    public function testCmsImageUpdateNoPageName(): void{
        $_SESSION['id'] = 1;

        $_POST = [
            'action' => 'CMSImageUpdate',
            'pageId' => 1,
            'imageTitle' => 'Media Wall 1',
            'imagePath' => 'https://stv2bournbespokeimg.blob.core.windows.net/bourne-bespoke-web-img/dev',
            'imageAlt' => 'IMG_0229.jpg',
            'imagePriority' => 0
        ];

        list($output, $_POST) = $this->executeFunctionPhp();

        $decodedOutput = json_decode($output, true);

        //echo print_r($decodedOutput);

        $this->assertArrayHasKey('status', $decodedOutput);
        $this->assertEquals('failed', $decodedOutput['status']);
        $this->assertArrayHasKey('message', $decodedOutput);
        $this->assertEquals('Missing required fields', $decodedOutput['message']);
    }

    public function testCmsImageUpdateNoPagePath(): void{
        $_SESSION['id'] = 1;

        $_POST = [
            'action' => 'CMSImageUpdate',
            'pageId' => 1,
            'imageTitle' => 'Media Wall 1',
            'imageName' => 'IMG_0229.jpg',
            'imageAlt' => 'IMG_0229.jpg',
            'imagePriority' => 0
        ];

        list($output, $_POST) = $this->executeFunctionPhp();

        $decodedOutput = json_decode($output, true);

        //echo print_r($decodedOutput);

        $this->assertArrayHasKey('status', $decodedOutput);
        $this->assertEquals('failed', $decodedOutput['status']);
        $this->assertArrayHasKey('message', $decodedOutput);
        $this->assertEquals('Missing required fields', $decodedOutput['message']);
    }

    public function testCmsImageUpdateNoId(): void {
        $_SESSION['id'] = 1;

        $_POST = [
            'action' => 'CMSImageUpdate',
            'pageId' => 1,
            'imageTitle' => 'Media Wall 1',
            'imageName' => 'IMG_1229.jpg',
            'imagePath' => 'https://stv2bournbespokeimg.blob.core.windows.net/bourne-bespoke-web-img/dev',
            'imageAlt' => 'IMG_1229.jpg',
            'imagePriority' => 0
        ];

        list($output, $_POST) = $this->executeFunctionPhp();

        $decodedOutput = json_decode($output, true);

        //echo print_r($decodedOutput);

        $this->assertArrayHasKey('status', $decodedOutput);
        $this->assertEquals('failed', $decodedOutput['status']);
        $this->assertArrayHasKey('message', $decodedOutput);
        $this->assertEquals('Missing required fields', $decodedOutput['message']);
    }

    public function testCmsImageUpdate(): void {
        $_SESSION['id'] = 1;

        $_POST = [
            'action' => 'CMSImageUpdate',
            'pageId' => 1,
            'imageTitle' => 'Media Wall 1',
            'imageName' => 'IMG_1229.jpg',
            'imagePath' => 'https://stv2bournbespokeimg.blob.core.windows.net/bourne-bespoke-web-img/dev',
            'imageAlt' => 'IMG_1229.jpg',
            'imagePriority' => 0,
            'imageId' => 5,
            'debug' => 'CSD'
        ];

        list($output, $_POST) = $this->executeFunctionPhp();

        $decodedOutput = json_decode($output, true);

       // echo print_r($decodedOutput);

        $this->assertArrayHasKey('status', $decodedOutput);
        $this->assertEquals('success', $decodedOutput['status']);

        $_POST = [];

        $_GET = [
            'action' => 'CMSImageContent',
            'imageId' => 5,
        ];

        list($output, $_GET) = $this->executeFunctionPhp();

        $decodedOutput = json_decode($output, true);

    //    echo print_r($decodedOutput);

        $expectedDataResults = [
            'cmsCont' => [
                0 => [
                    'imageTitle' => [
                                        0 => 'Media Wall 1'
                                    ],
                    'imageName' =>  [ 
                                        0 => 'IMG_1229.jpg'
                                    ],
                    'imagePath' => 'https://stv2bournbespokeimg.blob.core.windows.net/bourne-bespoke-web-img/dev',
                    'imageAlt' =>   [
                                        0 => 'IMG_1229.jpg'
                                    ],
                    'imagePriority' => [
                                        0 => 0
                                    ],
                    'imageTag' => ['Media Walls'],
                    'pageId' => 1
                ]
            ]
        ];

        $this->assertArrayHasKey('action', $decodedOutput);
        $this->assertEquals('CMSImageContent', $decodedOutput['action']);
        $this->assertArrayHasKey('cmsCont', $decodedOutput);
        $this->assertEquals($expectedDataResults['cmsCont'], $decodedOutput['cmsCont']);

    }

    function testGetCmsTagNamesNoAuth(): void {
        $_GET = [
            'action' => 'CMSTagNames'
        ];
        
        list($output, $_GET) = $this->executeFunctionPhp();

        $decodedOutput = json_decode($output, true);

        //echo print_r($decodedOutput);

        $this->assertArrayHasKey('status', $decodedOutput);
        $this->assertEquals('failed', $decodedOutput['status']);
        $this->assertArrayHasKey('message', $decodedOutput);
        $this->assertEquals('User is not logged in', $decodedOutput['message']);
    }

    function testGetCmsTagNames(): void {
        $_SESSION['id'] = 1;

        $_GET = [
            'action' => 'CMSTagNames'
        ];
        
        list($output, $_GET) = $this->executeFunctionPhp();

        $decodedOutput = json_decode($output, true);

        $expectedDataResults = [
            'status' => 'success',
            'tagList' => [
                0 => [
                    'id' => 1,
                    'tagName' => 'Media Walls'
                ],
                1 => [
                    'id' => 2,
                    'tagName' => 'Drinks Bars'
                ],
                2 => [
                    'id' => 3,
                    'tagName' => 'Offices'
                ],
                3 => [
                    'id' => 4,
                    'tagName' => 'Wardrobes'
                ],
                4 => [
                    'id' => 5,
                    'tagName' => 'Other'
                ]
            ]
        ];


        //echo print_r($decodedOutput);

        $this->assertArrayHasKey('status', $decodedOutput);
        $this->assertEquals('success', $decodedOutput['status']);
        $this->assertArrayHasKey('tagList', $decodedOutput);
        $this->assertEquals($expectedDataResults['tagList'], $decodedOutput['tagList']);
    }

    public function testCmsDeleteNoAuth(): void {
        $_POST = [
            'action' => 'CMSImageDelete',
            'imageId' => 5
        ];
        
        list($output, $_POST) = $this->executeFunctionPhp();

        $decodedOutput = json_decode($output, true);

        //echo print_r($decodedOutput);

        $this->assertArrayHasKey('status', $decodedOutput);
        $this->assertEquals('failed', $decodedOutput['status']);
        $this->assertArrayHasKey('message', $decodedOutput);
        $this->assertEquals('User is not logged in', $decodedOutput['message']);
    }

    public function testCmsDeleteNoImageId(): void {
        $_SESSION['id'] = 1;

        $_POST = [
            'action' => 'CMSImageDelete'
        ];
        
        list($output, $_POST) = $this->executeFunctionPhp();

        $decodedOutput = json_decode($output, true);

        //echo print_r($decodedOutput);

        $this->assertArrayHasKey('status', $decodedOutput);
        $this->assertEquals('failed', $decodedOutput['status']);
        $this->assertArrayHasKey('message', $decodedOutput);
        $this->assertEquals('Missing required fields', $decodedOutput['message']);
    }

    public function testCmsDelete(): void {
        $_SESSION['id'] = 1;

        $_POST = [
            'action' => 'CMSImageDelete',
            'imageId' => 5,
            'debug' => 'CSD'
        ];
        
        list($output, $_POST) = $this->executeFunctionPhp();

        $decodedOutput = json_decode($output, true);

        //echo print_r($decodedOutput);

        $this->assertArrayHasKey('status', $decodedOutput);
        $this->assertEquals('success', $decodedOutput['status']);
        $this->assertArrayHasKey('message', $decodedOutput);
        $this->assertEquals('Item deleted successfully', $decodedOutput['message']);

        $_POST = [];

        $_GET = [
            'action' => 'CMSImageContent',
            'imageId' => 5,
        ];

        list($output, $_GET) = $this->executeFunctionPhp();

        $decodedOutput = json_decode($output, true);

        //echo print_r($decodedOutput);

        $this->assertArrayHasKey('status', $decodedOutput);
        $this->assertEquals('Failed', $decodedOutput['status']);
        $this->assertArrayHasKey('message', $decodedOutput);
        $this->assertEquals('No content found', $decodedOutput['message']);

    }

    public function testCmsNewImageTagNoAuth(): void {
        $_POST = [
            'action' => 'CMSNewImageTag',
            'tagName' => 'New Tag'
        ];
        
        list($output, $_POST) = $this->executeFunctionPhp();

        $decodedOutput = json_decode($output, true);

        //echo print_r($decodedOutput);

        $this->assertArrayHasKey('status', $decodedOutput);
        $this->assertEquals('failed', $decodedOutput['status']);
        $this->assertArrayHasKey('message', $decodedOutput);
        $this->assertEquals('User is not logged in', $decodedOutput['message']);
    }

    public function testCmsNewImageTagNoTagName(): void {
        $_SESSION['id'] = 1;

        $_POST = [
            'action' => 'CMSNewImageTag'
        ];
        
        list($output, $_POST) = $this->executeFunctionPhp();

        $decodedOutput = json_decode($output, true);

        //echo print_r($decodedOutput);

        $this->assertArrayHasKey('status', $decodedOutput);
        $this->assertEquals('failed', $decodedOutput['status']);
        $this->assertArrayHasKey('message', $decodedOutput);
        $this->assertEquals('Missing required fields', $decodedOutput['message']);
    }

    public function testCmsNewImageTagDuplicate(): void {
        $_SESSION['id'] = 1;

        $_POST = [
            'action' => 'CMSNewImageTag',
            'tagName' => 'Other'
        ];
        
        list($output, $_POST) = $this->executeFunctionPhp();

        $decodedOutput = json_decode($output, true);

        //echo print_r($decodedOutput);

        $this->assertArrayHasKey('status', $decodedOutput);
        $this->assertEquals('failed', $decodedOutput['status']);
        $this->assertArrayHasKey('message', $decodedOutput);
        $this->assertEquals('Tag already exists', $decodedOutput['message']);
    }

    public function testCmsNewImageTag(): void {
        $_SESSION['id'] = 1;

        $_POST = [
            'action' => 'CMSNewImageTag',
            'tagName' => 'New Tag'
        ];
        
        list($output, $_POST) = $this->executeFunctionPhp();

        $decodedOutput = json_decode($output, true);

        //echo print_r($decodedOutput);

        $this->assertArrayHasKey('status', $decodedOutput);
        $this->assertEquals('success', $decodedOutput['status']);
        $this->assertArrayHasKey('message', $decodedOutput);
        $this->assertEquals('Tag inserted successfully', $decodedOutput['message']);

        $_POST = [];

        $_GET = [
            'action' => 'CMSTagNames'
        ];

        list($output, $_GET) = $this->executeFunctionPhp();

        $decodedOutput = json_decode($output, true);

        //echo print_r($decodedOutput);

        $this->assertArrayHasKey('status', $decodedOutput);
        $this->assertEquals('success', $decodedOutput['status']);
        $this->assertArrayHasKey('tagList', $decodedOutput);
        $this->assertContains('New Tag', array_column($decodedOutput['tagList'], 'tagName'));
    }

    public function testCmsReEnableTag(): void {
        $_SESSION['id'] = 1;

        $_POST = [
            'action' => 'CMSNewImageTag',
            'tagName' => 'Kitchen'
        ];
        
        list($output, $_POST) = $this->executeFunctionPhp();

        $decodedOutput = json_decode($output, true);

        //echo print_r($decodedOutput);

        $this->assertArrayHasKey('status', $decodedOutput);
        $this->assertEquals('success', $decodedOutput['status']);
        $this->assertArrayHasKey('message', $decodedOutput);
        $this->assertEquals('Tag inserted successfully', $decodedOutput['message']);

        $_POST = [];

        $_GET = [
            'action' => 'CMSTagNames'
        ];

        list($output, $_GET) = $this->executeFunctionPhp();

        $decodedOutput = json_decode($output, true);

        //echo print_r($decodedOutput);

        $expectedDataResults = [
            'status' => 'success',
            'tagList' => [
                0 => [
                    'id' => 1,
                    'tagName' => 'Media Walls'
                ],
                1 => [
                    'id' => 2,
                    'tagName' => 'Drinks Bars'
                ],
                2 => [
                    'id' => 3,
                    'tagName' => 'Offices'
                ],
                3 => [
                    'id' => 4,
                    'tagName' => 'Wardrobes'
                ],
                4 => [
                    'id' => 5,
                    'tagName' => 'Other'
                ],
                5 => [
                    'id' => 7,
                    'tagName' => 'New Tag'
                ],
                6 => [
                    'id' => 8,
                    'tagName' => 'Kitchen'
                ]
            ]
        ];

        $this->assertArrayHasKey('status', $decodedOutput);
        $this->assertEquals('success', $decodedOutput['status']);
        $this->assertArrayHasKey('tagList', $decodedOutput);
        $this->assertEquals($expectedDataResults['tagList'], $decodedOutput['tagList']);

    }

    public function testCmsImageTagDisableNoAuth(): void {
        $_POST = [
            'action' => 'CMSImageTagDisable',
            'tagId' => 8
        ];
        
        list($output, $_POST) = $this->executeFunctionPhp();

        $decodedOutput = json_decode($output, true);

        //echo print_r($decodedOutput);

        $this->assertArrayHasKey('status', $decodedOutput);
        $this->assertEquals('failed', $decodedOutput['status']);
        $this->assertArrayHasKey('message', $decodedOutput);
        $this->assertEquals('User is not logged in', $decodedOutput['message']);
    }

    public function testCmsImageTagDisableNoTagId(): void {
        $_SESSION['id'] = 1;

        $_POST = [
            'action' => 'CMSImageTagDisable'
        ];
        
        list($output, $_POST) = $this->executeFunctionPhp();

        $decodedOutput = json_decode($output, true);

        //echo print_r($decodedOutput);

        $this->assertArrayHasKey('status', $decodedOutput);
        $this->assertEquals('failed', $decodedOutput['status']);
        $this->assertArrayHasKey('message', $decodedOutput);
        $this->assertEquals('Missing required fields', $decodedOutput['message']);
    }

    public function testCmsImageTagDisable(): void {
        $_SESSION['id'] = 1;

        $_POST = [
            'action' => 'CMSImageTagDisable',
            'tagId' => 8
        ];
        
        list($output, $_POST) = $this->executeFunctionPhp();

        $decodedOutput = json_decode($output, true);

        //echo print_r($decodedOutput);

        $this->assertArrayHasKey('status', $decodedOutput);
        $this->assertEquals('success', $decodedOutput['status']);
        $this->assertArrayHasKey('message', $decodedOutput);
        $this->assertEquals('Disabled successfully', $decodedOutput['message']);

        $_POST = [];

        $_GET = [
            'action' => 'CMSTagNames'
        ];

        list($output, $_GET) = $this->executeFunctionPhp();

        $decodedOutput = json_decode($output, true);

        //echo print_r($decodedOutput);

        $expectedDataResults = [
            'status' => 'success',
            'tagList' => [
                0 => [
                    'id' => 1,
                    'tagName' => 'Media Walls'
                ],
                1 => [
                    'id' => 2,
                    'tagName' => 'Drinks Bars'
                ],
                2 => [
                    'id' => 3,
                    'tagName' => 'Offices'
                ],
                3 => [
                    'id' => 4,
                    'tagName' => 'Wardrobes'
                ],
                4 => [
                    'id' => 5,
                    'tagName' => 'Other'
                ],
                5 => [
                    'id' => 7,
                    'tagName' => 'New Tag'
                ]
            ]
        ];

        $this->assertArrayHasKey('status', $decodedOutput);
        $this->assertEquals('success', $decodedOutput['status']);
        $this->assertArrayHasKey('tagList', $decodedOutput);
        $this->assertEquals($expectedDataResults['tagList'], $decodedOutput['tagList']);


    }

    public function testCmsNewImageMappingNoAuth() {
        $_POST = [
            'action' => 'CMSNewImageMapping',
            'imageId' => 1,
            'tagId' => 1
        ];
        
        list($output, $_POST) = $this->executeFunctionPhp();

        $decodedOutput = json_decode($output, true);

        //echo print_r($decodedOutput);

        $this->assertArrayHasKey('status', $decodedOutput);
        $this->assertEquals('failed', $decodedOutput['status']);
        $this->assertArrayHasKey('message', $decodedOutput);
        $this->assertEquals('User is not logged in', $decodedOutput['message']);
    }

    public function testCmsNewImageMappingNoImageId() {
        $_SESSION['id'] = 1;

        $_POST = [
            'action' => 'CMSNewImageMapping',
            'tagId' => 1
        ];
        
        list($output, $_POST) = $this->executeFunctionPhp();

        $decodedOutput = json_decode($output, true);

        //echo print_r($decodedOutput);

        $this->assertArrayHasKey('status', $decodedOutput);
        $this->assertEquals('failed', $decodedOutput['status']);
        $this->assertArrayHasKey('message', $decodedOutput);
        $this->assertEquals('Missing required fields', $decodedOutput['message']);
    }

    public function testCmsNewImageMappingNoTagId() {
        $_SESSION['id'] = 1;

        $_POST = [
            'action' => 'CMSNewImageMapping',
            'imageId' => 1
        ];
        
        list($output, $_POST) = $this->executeFunctionPhp();

        $decodedOutput = json_decode($output, true);

        //echo print_r($decodedOutput);

        $this->assertArrayHasKey('status', $decodedOutput);
        $this->assertEquals('failed', $decodedOutput['status']);
        $this->assertArrayHasKey('message', $decodedOutput);
        $this->assertEquals('Missing required fields', $decodedOutput['message']);
    }

    public function testCmsNewImageMappingPreExists() {
        $_SESSION['id'] = 1;

        $_POST = [
            'action' => 'CMSNewImageMapping',
            'imageId' => 6,
            'tagId' => 1
        ];
        
        list($output, $_POST) = $this->executeFunctionPhp();

        $decodedOutput = json_decode($output, true);

        //echo print_r($decodedOutput);

        $this->assertArrayHasKey('status', $decodedOutput);
        $this->assertEquals('failed', $decodedOutput['status']);
        $this->assertArrayHasKey('message', $decodedOutput);
        $this->assertEquals('Mapping already exists', $decodedOutput['message']);

    }

    public function testCmsNewImageMapping() {
        $_SESSION['id'] = 1;

        $_GET = [
            'action' => 'CMSImageContent',
            'imageId' => 6,
        ];

        list($output, $_GET) = $this->executeFunctionPhp();

        $decodedOutput = json_decode($output, true);

        //echo print_r($decodedOutput);

        $expectedDataResults = [
            'cmsCont' => [
                0 => [
                    'imageTitle' => [
                                        0 => 'Media Wall 1 '
                                    ],
                    'imageName' =>  [ 
                                        0 => 'IMG_0223.jpg'
                                    ],
                    'imagePath' => 'https://stv2bournbespokeimg.blob.core.windows.net/bourne-bespoke-web-img/dev',
                    'imageAlt' =>   [
                                        0 => 'IMG_0223.jpg'
                                    ],
                    'imagePriority' => [
                                        0 => 0
                                    ],
                    'imageTag' => ['Media Walls'],
                    'pageId' => 1
                ]
            ]
        ];

        $this->assertArrayHasKey('action', $decodedOutput);
        $this->assertEquals('CMSImageContent', $decodedOutput['action']);
        $this->assertArrayHasKey('cmsCont', $decodedOutput);
        $this->assertEquals($expectedDataResults['cmsCont'], $decodedOutput['cmsCont']);

        $_GET = [];

        $_POST = [
            'action' => 'CMSNewImageMapping',
            'imageId' => 6,
            'tagId' => 2,
            'debug' => 'CSD'
        ];
        
        list($output, $_POST) = $this->executeFunctionPhp();

        $decodedOutput = json_decode($output, true);

        //echo print_r($decodedOutput);

        $this->assertArrayHasKey('status', $decodedOutput);
        $this->assertEquals('success', $decodedOutput['status']);
        $this->assertArrayHasKey('message', $decodedOutput);
        $this->assertEquals('Mapping inserted successfully', $decodedOutput['message']);

        $_POST = [];

        $_GET = [
            'action' => 'CMSImageContent',
            'imageId' => 6,
        ];

        list($output, $_GET) = $this->executeFunctionPhp();

        $decodedOutput = json_decode($output, true);

        //echo print_r($decodedOutput);

        $expectedDataResults = [
            'cmsCont' => [
                0 => [
                    'imageTitle' => [
                                        0 => 'Media Wall 1 '
                                    ],
                    'imageName' =>  [ 
                                        0 => 'IMG_0223.jpg'
                                    ],
                    'imagePath' => 'https://stv2bournbespokeimg.blob.core.windows.net/bourne-bespoke-web-img/dev',
                    'imageAlt' =>   [
                                        0 => 'IMG_0223.jpg'
                                    ],
                    'imagePriority' => [
                                        0 => 0
                                    ],
                    'imageTag' => ['Media Walls', 'Drinks Bars'],
                    'pageId' => 1
                ]
            ]
        ];

        $this->assertArrayHasKey('action', $decodedOutput);
        $this->assertEquals('CMSImageContent', $decodedOutput['action']);
        $this->assertArrayHasKey('cmsCont', $decodedOutput);
        $this->assertEquals($expectedDataResults['cmsCont'], $decodedOutput['cmsCont']);


    }

    public function testCmsImageMappingDisableNoAuth() {
        $_POST = [
            'action' => 'CMSImageMappingDisable',
            'imageId' => 6,
            'tagId' => 2
        ];
        
        list($output, $_POST) = $this->executeFunctionPhp();

        $decodedOutput = json_decode($output, true);

        //echo print_r($decodedOutput);

        $this->assertArrayHasKey('status', $decodedOutput);
        $this->assertEquals('failed', $decodedOutput['status']);
        $this->assertArrayHasKey('message', $decodedOutput);
        $this->assertEquals('User is not logged in', $decodedOutput['message']);
    }


    public function testCmsImageMappingDisableNoMapId() {
        $_SESSION['id'] = 1;

        $_POST = [
            'action' => 'CMSImageMappingDisable',
        ];
        
        list($output, $_POST) = $this->executeFunctionPhp();

        $decodedOutput = json_decode($output, true);

        //echo print_r($decodedOutput);

        $this->assertArrayHasKey('status', $decodedOutput);
        $this->assertEquals('failed', $decodedOutput['status']);
        $this->assertArrayHasKey('message', $decodedOutput);
        $this->assertEquals('Missing required fields', $decodedOutput['message']);
    }

    public function testCmsImageMappingDisable() {
        $_SESSION['id'] = 1;

        $_POST = [
            'action' => 'CMSImageMappingDisable',
            'mapId' => 11
        ];
        
        list($output, $_POST) = $this->executeFunctionPhp();

        $decodedOutput = json_decode($output, true);

        //echo print_r($decodedOutput);

        $this->assertArrayHasKey('status', $decodedOutput);
        $this->assertEquals('success', $decodedOutput['status']);
        $this->assertArrayHasKey('message', $decodedOutput);
        $this->assertEquals('Disabled successfully', $decodedOutput['message']);

        $_POST = [];

        $_GET = [
            'action' => 'CMSImageContent',
            'imageId' => 6,
        ];

        list($output, $_GET) = $this->executeFunctionPhp();

        $decodedOutput = json_decode($output, true);

        //echo print_r($decodedOutput);

        $expectedDataResults = [
            'cmsCont' => [
                0 => [
                    'imageTitle' => [
                                        0 => 'Media Wall 1 '
                                    ],
                    'imageName' =>  [ 
                                        0 => 'IMG_0223.jpg'
                                    ],
                    'imagePath' => 'https://stv2bournbespokeimg.blob.core.windows.net/bourne-bespoke-web-img/dev',
                    'imageAlt' =>   [
                                        0 => 'IMG_0223.jpg'
                                    ],
                    'imagePriority' => [
                                        0 => 0
                                    ],
                    'imageTag' => ['Media Walls'],
                    'pageId' => 1
                ]
            ]
        ];

        $this->assertArrayHasKey('action', $decodedOutput);
        $this->assertEquals('CMSImageContent', $decodedOutput['action']);
        $this->assertArrayHasKey('cmsCont', $decodedOutput);
        $this->assertEquals($expectedDataResults['cmsCont'], $decodedOutput['cmsCont']);

    }
    

    //Extra test for later
        // update an image to be a duplicate of another -- page_id, image_title, image_name

    public function testCmsUpdateDuplicateValues(){
        $_SESSION['id'] = 1;

        $_POST = [
            'action' => 'CMSImageUpdate',
            'pageId' => 1,
            'imageTitle' => 'Media Wall 1 ',
            'imageName' => 'IMG_0223.jpg',
            'imagePath' => 'https://stv2bournbespokeimg.blob.core.windows.net/bourne-bespoke-web-img/dev',
            'imageAlt' => 'IMG_0223.jpg',
            'imagePriority' => 0,
            'imageId' => 6,
            'debug' => 'CSD'
        ];

        list($output, $_POST) = $this->executeFunctionPhp();

        $decodedOutput = json_decode($output, true);

        //echo print_r($decodedOutput);

        $this->assertArrayHasKey('status', $decodedOutput);
        $this->assertEquals('success', $decodedOutput['status']);
        
        $_POST = [];

        $_POST = [
            'action' => 'CMSImageUpdate',
            'pageId' => 1,
            'imageTitle' => 'Media Wall 1 ',
            'imageName' => 'IMG_0223.jpg',
            'imagePath' => 'https://stv2bournbespokeimg.blob.core.windows.net/bourne-bespoke-web-img/dev',
            'imageAlt' => 'IMG_0223.jpg',
            'imagePriority' => 0,
            'imageId' => 7,
            'debug' => 'CSD'
        ];

        list($output, $_POST) = $this->executeFunctionPhp();

        $decodedOutput = json_decode($output, true);

        //echo print_r($decodedOutput);

        $this->assertArrayHasKey('status', $decodedOutput);
        $this->assertEquals('failed', $decodedOutput['status']);
        $this->assertArrayHasKey('message', $decodedOutput);
        $this->assertEquals('SQLSTATE[23000]: Integrity constraint violation: 19 UNIQUE constraint failed: cms_image.page_id, cms_image.image_title, cms_image.image_name', $decodedOutput['message']);


    }
}

?>