<?php

    function updateContent($inputData) {
        $pdo = $inputData['db']['dbApp'];
        $pdo->setAttribute(PDO::ATTR_ERRMODE, PDO::ERRMODE_EXCEPTION);
        $sql = "UPDATE cms_content_pages SET content = :content WHERE page_id = :pageId and tagname = :tagName";
        $stmt = $pdo->prepare($sql);
        $stmt->bindParam(':pageId',     $inputData['pageId']);
        $stmt->bindParam(':tagName',    $inputData['tagName']);
        $stmt->bindParam(':content',    $inputData['content']);
        $stmt->execute();
        return ['status' => 'success', 'message' => 'Item Updated successfully'];
    }

    function softDeleteContent($inputData) {
        $pdo = $inputData['db']['dbApp'];
        $pdo->setAttribute(PDO::ATTR_ERRMODE, PDO::ERRMODE_EXCEPTION);
        $tagName = "";
        if(isset($inputData['tagName'])){
            $tagName = "AND tagname = :tagName";
        }
        $sql = "UPDATE cms_content_pages SET is_deleted = 1, deleted_date = CURRENT_TIMESTAMP WHERE page_id = :pageId ". $tagName;
        $stmt = $pdo->prepare($sql);
        $stmt->bindParam(':pageId',     $inputData['pageId']);
        if($tagName !== ""){
            $stmt->bindParam(':tagName',    $inputData['tagName']);
        }
        $stmt->execute();
        return ['status' => 'success', 'message' => 'Item Deleted successfully'];
    }
    
?>