<?php

    function selectCurrentContent($inputData) {
        $inputData['table'] = 'cms_content_pages';
        $lastModified = getMaxDate($inputData);

        if(isset($inputData['lastModified']) && $inputData['lastModified'] == $lastModified) {
            $data['status'] = 'Success';
            $data['message'] = 'No new content';
            return $data;
        }else{
            $pdo = $inputData['db']['dbApp'];
            $pdo->setAttribute(PDO::ATTR_ERRMODE, PDO::ERRMODE_EXCEPTION);
            $sqlAdd = '';
            $result = []; // Initialize result array to handle the case where no rows are found
            $cmsCont = [];

            if(isset($inputData['tagName'])){
                $sqlAdd .= ' AND tagName = :tagName ';
            }
            if(!isset($inputData['pageId'])){
                $sql = "SELECT tagname, content, page_id FROM cms_content_pages WHERE is_deleted = 0 " . $sqlAdd;
            }else{
                $sql = "SELECT tagname, content FROM cms_content_pages WHERE page_id = :pageId and is_deleted = 0 " . $sqlAdd;
            }
            
            $stmt = $pdo->prepare($sql);
            
            if(isset($inputData['pageId'])){
            $stmt->bindParam(':pageId', $inputData['pageId']);
            }

            if(isset($inputData['tagName'])){
                $stmt->bindParam(':tagName', $inputData['tagName']);
            }

            $stmt->execute();

            $cmsCont = []; // Ensure it's initialized

            while ($row = $stmt->fetch(PDO::FETCH_ASSOC)) {
                $res = [
                    'tagName' => $row['tagname'],
                    'content' => $row['content'],
                    'pageId' => $inputData['pageId'] ?? $row['page_id']
                ];
                $cmsCont[] = $res;
            }
            
            if (!empty($cmsCont)) {
                $result = [
                    'cmsCont' => $cmsCont,
                    'lastModified' => $lastModified,
                    'status' => 'success'
                ];
            } else {
                $result = [
                    'status' => 'Failed',
                    'message' => 'No content found'
                ];
            }
        }
        return $result;
    }


    function getMaxDate($inputData) {
        $pdo = $inputData['db']['dbApp'];
        $table = $inputData['table'];
        $sql = "SELECT MAX(modified_date) as modified_date FROM $table ";
        $sqlAdd = '';
        if (isset($inputData['tagName'])) {
            $sqlAdd .= ' AND tagName = :tagName ';
        }
        if (isset($inputData['pageId'])) {
            $sqlAdd .= ' AND page_id = :pageId ';
        }
        // ✅ Ensure WHERE is used correctly
        $sqlAdd = preg_replace('/\bAND\b/', 'WHERE', $sqlAdd, 1);
        $sql .= $sqlAdd;
        // ✅ Prepare the statement
        $stmt = $pdo->prepare($sql);
        if (isset($inputData['pageId'])) {
            $stmt->bindParam(':pageId', $inputData['pageId']);
        }
        if (isset($inputData['tagName'])) {
            $stmt->bindParam(':tagName', $inputData['tagName']);
        }
        $stmt->execute();
        // ✅ Use `fetch()` safely
        $row = $stmt->fetch(PDO::FETCH_ASSOC);
        // ✅ Return modified_date or NULL if not found
        return $row['modified_date'] ?? null;
    }
?>    