CREATE TABLE IF NOT EXISTS cms_content_pages (
    id              INT AUTO_INCREMENT PRIMARY KEY,
    page_id         INT NOT NULL,
    tagname         VARCHAR(50) NOT NULL,
    content         MEDIUMTEXT,  -- MEDIUMTEXT can store up to 16MB, which should be adequate for large text
    created_date    DATETIME DEFAULT CURRENT_TIMESTAMP,
    modified_date   DATETIME DEFAULT CURRENT_TIMESTAMP,
    is_deleted      TINYINT(1) DEFAULT 0,  -- A simple flag to mark the row as deleted
    deleted_date    DATETIME DEFAULT NULL,  -- Timestamp for when the page was marked as deleted
    deprecated_date DATETIME DEFAULT NULL,  -- Timestamp for when the page was marked as deprecated
    UNIQUE (page_id, tagname)  -- Ensures the combination of page_id and tagname is unique
);

CREATE TRIGGER IF NOT EXISTS update_modified_date
AFTER UPDATE ON cms_content_pages
FOR EACH ROW
BEGIN
    UPDATE cms_content_pages
    SET modified_date = CURRENT_TIMESTAMP
    WHERE id = old.id;
END;


CREATE TABLE IF NOT EXISTS cms_content_changes (
    change_id           INT AUTO_INCREMENT PRIMARY KEY,
    page_id             INT NOT NULL,
    tagname             VARCHAR(20) NOT NULL,
    previous_content    MEDIUMTEXT,
    changed_at          DATETIME DEFAULT CURRENT_TIMESTAMP
);



 INSERT INTO cms_content_pages (page_id, tagname, content) VALUES (1, 'home', 'Welcome to the home page');
 INSERT INTO cms_content_pages (page_id, tagname, content) VALUES (2, 'about', 'This is the about page');
 INSERT INTO cms_content_pages (page_id, tagname, content) VALUES (3, 'contact', 'Contact us at 123 Main St, Springfield, IL 62701');
 INSERT INTO cms_content_pages (page_id, tagname, content) VALUES (4, 'services', 'We offer a wide range of services');
 INSERT INTO cms_content_pages (page_id, tagname, content) VALUES (2, 'blog', 'Check out our latest blog posts');