<?php

    use PHPUnit\Framework\TestCase;

    
    require_once __DIR__ . DIRECTORY_SEPARATOR . '..' . DIRECTORY_SEPARATOR . '..' . DIRECTORY_SEPARATOR . 'core' . DIRECTORY_SEPARATOR . 'unit-test' . DIRECTORY_SEPARATOR . 'scripts' . DIRECTORY_SEPARATOR . 'bootstrap.php'; // ✅ Use shared mock DB
    //require_once __DIR__ . '/../src/function.php';
    echo "\n>>>>>>>>>>>>>>>>>>>>>>>>>====<<<<<<<<<<<<<<<<<<<<<<<<<\n";
    echo "\nT03_CmsTest.php\n";
    
    // Print list of table that exist in the database
    //$tables = $GLOBALS['mockPdo']->query("SELECT name FROM sqlite_master WHERE type='table';")->fetchAll(\PDO::FETCH_COLUMN);
    //echo("\n🔍 Tables: " . implode(', ', $tables). "\n");
    
    
    
    class T03_CmsTest extends TestCase
    {
        private $mockPdo;
        private static $lastModified;

    protected function setUp(): void
    {
        // ✅ Use the shared mock database connection
        $_SESSION = [];
        $_GET = [];
        $_POST = [];
        $_SERVER['REMOTE_ADDR'] = '127.0.0.1';
        $_SERVER['HTTP_REFERER'] = 'http://localhost/test';
        $this->mockPdo = $GLOBALS['mockPdo'];
        if (session_status() !== PHP_SESSION_ACTIVE) {
            if (session_status() !== PHP_SESSION_ACTIVE && !headers_sent()) {
                session_start();
            }
        }

    }

    private function executeFunctionPhp(): array {
        ob_start();
        // Flexible path resolution for module function.php
        if (file_exists(__DIR__ . DIRECTORY_SEPARATOR . '..' . DIRECTORY_SEPARATOR . 'src' . DIRECTORY_SEPARATOR . 'function.php')) {
            require __DIR__ . DIRECTORY_SEPARATOR . '..' . DIRECTORY_SEPARATOR . 'src' . DIRECTORY_SEPARATOR . 'function.php';
        } else {
            require __DIR__ . DIRECTORY_SEPARATOR . '..' . DIRECTORY_SEPARATOR . 'function.php';
        }
        $output = ob_get_clean();
    
        // ✅ Ensure only valid JSON output
        $decodedOutput = json_decode($output, true);
        if (json_last_error() !== JSON_ERROR_NONE) {
            throw new Exception("Invalid JSON output: " . json_last_error_msg() . "\nOutput: " . $output);
        }
    
        return [$output, $decodedOutput];
    }
    
    public function testDummyTest(): void{
        $this->assertTrue(true);
    }

    public function testInputDataPopulation(): void {
        // ✅ Mock request data    
        $_GET = [
            'action' => 'CMSContent'
        ];

        list($output, $_GET) = $this->executeFunctionPhp();
        $decodedOutput = json_decode($output, true);

        //echo print_r($decodedOutput);

        $expectedDataResults = [
            'cmsCont' => '[{"tagName":"home","content":"Welcome to the home page","pageId":1},{"tagName":"about","content":"This is the about page","pageId":2},{"tagName":"contact","content":"Contact us at 123 Main St, Springfield, IL 62701","pageId":3},{"tagName":"services","content":"We offer a wide range of services","pageId":4},{"tagName":"blog","content":"Check out our latest blog posts","pageId":2}]'
        ];

        $this->assertArrayHasKey('action', $decodedOutput);
        $this->assertEquals('CMSContent', $decodedOutput['action']);
        $this->assertArrayHasKey('cmsCont', $decodedOutput);
        $this->assertEquals($expectedDataResults['cmsCont'], json_encode($decodedOutput['cmsCont']));
        // modified_date
        $this->assertArrayHasKey('lastModified', $decodedOutput);
        self::$lastModified = $decodedOutput['lastModified'];

    }

    public function testSelectContentWithLastModifiedEqual(): void {
        // ✅ Mock input with `lastModified` equal to current data
        $this->assertNotNull(self::$lastModified, "❌ Last modified was not saved!");

        $_GET = [
            'action' => 'CMSContent',
            'lastModified' => self::$lastModified 
        ];

        // ✅ Call the function
        list($output, $_GET) = $this->executeFunctionPhp();
        
        $decodedOutput = json_decode($output, true);

        //echo print_r($decodedOutput);

        // ✅ Assertions: Should return all available content
        $this->assertEquals('Success', $decodedOutput['status']);
        $this->assertEquals('No new content', $decodedOutput['message']);
    }

    // last modified date is newer than the current data to get no update
    public function testSelectContentWithLastModifiedOlder(): void {
        // ✅ Mock input with `lastModified` newer than current data
        $this->assertNotNull(self::$lastModified, "❌ Last modified was not saved!");

        $timestamp = strtotime(self::$lastModified); // ✅ Convert to timestamp
        $updatedTimestamp = $timestamp - 1000; // 
        $updatedTimestamp = date('Y-m-d H:i:s', $updatedTimestamp);

        $_GET = [
            'action' => 'CMSContent',
            'lastModified' => $updatedTimestamp
        ];

        // ✅ Call the function
        list($output, $_GET) = $this->executeFunctionPhp();
        
        $decodedOutput = json_decode($output, true);

        //echo print_r($decodedOutput);

        $expectedDataResults = ['cmsCont' => '[{"tagName":"home","content":"Welcome to the home page","pageId":1},{"tagName":"about","content":"This is the about page","pageId":2},{"tagName":"contact","content":"Contact us at 123 Main St, Springfield, IL 62701","pageId":3},{"tagName":"services","content":"We offer a wide range of services","pageId":4},{"tagName":"blog","content":"Check out our latest blog posts","pageId":2}]'];

        $this->assertArrayHasKey('action', $decodedOutput);
        $this->assertEquals('CMSContent', $decodedOutput['action']);
        $this->assertArrayHasKey('cmsCont', $decodedOutput);
        $this->assertEquals($expectedDataResults['cmsCont'], json_encode($decodedOutput['cmsCont']));
        $this->assertArrayHasKey('lastModified', $decodedOutput);
        $this->assertGreaterThanOrEqual($updatedTimestamp, $decodedOutput['lastModified']);
    }

    public function testSelectContentWithInvalidPageId(): void {

        
        $_GET = [
            'action' => 'CMSContent',
            'pageId' => 999
        ];

        // ✅ Call the function
        list($output, $_GET) = $this->executeFunctionPhp();
        
        $decodedOutput = json_decode($output, true);

        //echo print_r($decodedOutput);

        $this->assertEquals('Failed', $decodedOutput['status']);
        $this->assertEquals('No content found', $decodedOutput['message']);
    }

    public function testSelectContentWithNoPageId(): void {
        // ✅ Mock input WITHOUT `pageId`
        $_GET = [
            'action' => 'CMSContent'
        ];

        // ✅ Call the function
        list($output, $_GET) = $this->executeFunctionPhp();
        
        $decodedOutput = json_decode($output, true);

        //echo print_r($decodedOutput);

        // ✅ Assertions: Should return all available content
        $this->assertEquals('success', $decodedOutput['status']);
        $this->assertArrayHasKey('cmsCont', $decodedOutput);
        $this->assertGreaterThanOrEqual(2, count($decodedOutput['cmsCont'])); // At least 2 rows exist
    }

    public function testGetSpecificCmsContentWithTagname(): void{
        // Simulate an API request
        $_GET = [
            'action' => 'CMSContent',
            'tagName' => 'about'
        ];

        list($output, $_GET) = $this->executeFunctionPhp();
        
        $decodedOutput = json_decode($output, true);

        //echo print_r($decodedOutput);

        // Validate response format
        $this->assertIsArray($decodedOutput);
        $this->assertArrayHasKey('status', $decodedOutput);
        $this->assertEquals('success', $decodedOutput['status']);
        $this->assertArrayHasKey('cmsCont', $decodedOutput);
        $this->assertIsArray($decodedOutput['cmsCont']);
        $this->assertArrayHasKey('tagName', $decodedOutput['cmsCont'][0]);
        $this->assertEquals('about', $decodedOutput['cmsCont'][0]['tagName']);
        $this->assertArrayHasKey('content', $decodedOutput['cmsCont'][0]);
        $this->assertEquals('This is the about page', $decodedOutput['cmsCont'][0]['content']);
        $this->assertArrayHasKey('pageId', $decodedOutput['cmsCont'][0]);
        $this->assertEquals(2, $decodedOutput['cmsCont'][0]['pageId']);
    }

    public function testGetSpecificCmsContentWithPageId(): void{
        // Simulate an API request
        $_GET = [
            'action' => 'CMSContent',
            'pageId' => '2'
        ];

        list($output, $_GET) = $this->executeFunctionPhp();
        
        $decodedOutput = json_decode($output, true);

        //echo print_r($decodedOutput);

        // Validate response format
        $this->assertIsArray($decodedOutput);
        $this->assertArrayHasKey('status', $decodedOutput);
        $this->assertEquals('success', $decodedOutput['status']);
        $this->assertArrayHasKey('cmsCont', $decodedOutput);
        $this->assertIsArray($decodedOutput['cmsCont']);
        $this->assertArrayHasKey('tagName', $decodedOutput['cmsCont'][0]);
        $this->assertEquals('about', $decodedOutput['cmsCont'][0]['tagName']);
        $this->assertArrayHasKey('content', $decodedOutput['cmsCont'][0]);
        $this->assertEquals('This is the about page', $decodedOutput['cmsCont'][0]['content']);
    }

    public function testInsertNewContentNoSessionFail(): void {
        // This test should not insert any content as there is no session
        // Simulate an API request
        $_POST = [
            'action' => 'CMSInsert',
            'pageId' => 4,   
            'tagName' => 'test',
            'content' => 'This is a test',
        ];

        list($output, $_POST) = $this->executeFunctionPhp();
        
        $decodedOutput = json_decode($output, true);

        //echo print_r($decodedOutput);

        // Validate response format
        $this->assertIsArray($decodedOutput);
        $this->assertArrayHasKey('status', $decodedOutput);
        $this->assertEquals('failed', $decodedOutput['status']);
        $this->assertArrayHasKey('message', $decodedOutput);
        $this->assertEquals('User is not logged in', $decodedOutput['message']);
    }

    // our next test will be to add a new content 
    public function testInsertNewContent(): void {
        // Simulate an API request
        $_SESSION['id'] = 1;

        $_POST = [
            'action' => 'CMSInsert',
            'pageId' => 4,   
            'tagName' => 'test',
            'content' => 'This is a test',
        ];

        list($output, $_POST) = $this->executeFunctionPhp();
        
        $decodedOutput = json_decode($output, true);

        //echo print_r($decodedOutput);

        // Validate response format
        $this->assertIsArray($decodedOutput);
        $this->assertArrayHasKey('status', $decodedOutput);
        $this->assertEquals('success', $decodedOutput['status']);
        $this->assertArrayHasKey('message', $decodedOutput);
        $this->assertEquals('Item inserted successfully', $decodedOutput['message']);
    }

    public function testInsertNewContentDuplicated(): void {
        // Simulate an API request
        $_SESSION['id'] = 1;

        $_POST = [
            'action' => 'CMSInsert',
            'pageId' => 4,   
            'tagName' => 'test',
            'content' => 'This is a test',
        ];

        list($output, $_POST) = $this->executeFunctionPhp();
        
        $decodedOutput = json_decode($output, true);

        //echo print_r($decodedOutput);

        // Validate response format
        $this->assertIsArray($decodedOutput);
        $this->assertArrayHasKey('status', $decodedOutput);
        $this->assertEquals('Failed', $decodedOutput['status']);
        $this->assertArrayHasKey('error', $decodedOutput);
        $this->assertEquals('Unknown failure', $decodedOutput['error']);

    }
    // Next set of test will be to update the content
    public function testUpdateContentNoSessionFail(): void {
        // This test should not insert any content as there is no session
        // Simulate an API request
        $_POST = [
            'action' => 'CMSUpdate',
            'pageId' => 4,   
            'tagName' => 'test',
            'content' => 'This is a test',
        ];

        list($output, $_POST) = $this->executeFunctionPhp();
        
        $decodedOutput = json_decode($output, true);

        //echo print_r($decodedOutput);

        // Validate response format
        $this->assertIsArray($decodedOutput);
        $this->assertArrayHasKey('status', $decodedOutput);
        $this->assertEquals('failed', $decodedOutput['status']);
        $this->assertArrayHasKey('message', $decodedOutput);
        $this->assertEquals('User is not logged in', $decodedOutput['message']);
    }

    public function testUpdateContent(): void {
        // Simulate an API request
        $_SESSION['id'] = 1;

        $_POST = [
            'action' => 'CMSUpdate',
            'pageId' => 1,   
            'tagName' => 'home',
            'content' => 'This is a test updated',
            ];
            
            list($output, $_POST) = $this->executeFunctionPhp();
            
            $decodedOutput = json_decode($output, true);
            
            //echo print_r($decodedOutput);
            
            // Validate response format
            $this->assertIsArray($decodedOutput);
            // check if insert to history is done
            $this->assertArrayHasKey('status', $decodedOutput['output'][1]);
            $this->assertEquals('success', $decodedOutput['output'][1]['status']);
            $this->assertArrayHasKey('message', $decodedOutput['output'][1]);
            $this->assertEquals('Item inserted successfully', $decodedOutput['output'][1]['message']);

            // check if insert to history is done
            $this->assertArrayHasKey('status', $decodedOutput['output'][2]);
            $this->assertEquals('success', $decodedOutput['output'][2]['status']);
            $this->assertArrayHasKey('message', $decodedOutput['output'][2]);
            $this->assertEquals('Item Updated successfully', $decodedOutput['output'][2]['message']);
    }

    public function testUpdateContentNoPageId(): void {
        // Simulate an API request
        $_SESSION['id'] = 1;
        
        $_POST = [
            'action' => 'CMSUpdate',
            'tagName' => 'test',
            'content' => 'This is a test updated 2',
            ];
            
            list($output, $_POST) = $this->executeFunctionPhp();
            
            $decodedOutput = json_decode($output, true);
            
            //echo print_r($decodedOutput);
            
            // Validate response format
            $this->assertIsArray($decodedOutput);
            // check if insert to history is done
            $this->assertArrayHasKey('status', $decodedOutput['output'][1]);
            $this->assertEquals('success', $decodedOutput['output'][1]['status']);
            $this->assertArrayHasKey('message', $decodedOutput['output'][1]);
            $this->assertEquals('Item inserted successfully', $decodedOutput['output'][1]['message']);

            // check if insert to history is done
            $this->assertArrayHasKey('status', $decodedOutput['output'][2]);
            $this->assertEquals('success', $decodedOutput['output'][2]['status']);
            $this->assertArrayHasKey('message', $decodedOutput['output'][2]);
            $this->assertEquals('Item Updated successfully', $decodedOutput['output'][2]['message']);
    }

    public function testUpdateContentNoTagNameShouldFail(): void {
        // Simulate an API request
        $_SESSION['id'] = 1;
        
        $_POST = [
            'action' => 'CMSUpdate',
            'pageId' => 4,   
            'content' => 'This is a test updated',
            ];
            
            list($output, $_POST) = $this->executeFunctionPhp();
            
            $decodedOutput = json_decode($output, true);
            
            //echo print_r($decodedOutput);
            
            // Validate response format
            $this->assertIsArray($decodedOutput);
            // check if insert to history is done
            $this->assertArrayHasKey('status', $decodedOutput);
            $this->assertEquals('failed', $decodedOutput['status']);
            $this->assertArrayHasKey('message', $decodedOutput);
            $this->assertEquals('Tag name is required', $decodedOutput['message']);
    }

    public function testUpdateContentEmptyContent(): void {
        // Simulate an API request
        $_SESSION['id'] = 1;
        
        $_POST = [
            'action' => 'CMSUpdate',
            'tagName' => 'test',
            'pageId' => 4,
            'content' => '',
            ];
            
            list($output, $_POST) = $this->executeFunctionPhp();
            
            $decodedOutput = json_decode($output, true);
            
            //echo print_r($decodedOutput);
            
            // Validate response format
            $this->assertIsArray($decodedOutput);
            // check if insert to history is done
            $this->assertArrayHasKey('status', $decodedOutput['output'][1]);
            $this->assertEquals('success', $decodedOutput['output'][1]['status']);
            $this->assertArrayHasKey('message', $decodedOutput['output'][1]);
            $this->assertEquals('Item inserted successfully', $decodedOutput['output'][1]['message']);

            // check if insert to history is done
            $this->assertArrayHasKey('status', $decodedOutput['output'][2]);
            $this->assertEquals('success', $decodedOutput['output'][2]['status']);
            $this->assertArrayHasKey('message', $decodedOutput['output'][2]);
            $this->assertEquals('Item Updated successfully', $decodedOutput['output'][2]['message']);
    }

    public function testUpdateContentNoContent(): void {
        // Simulate an API request
        $_SESSION['id'] = 1;
        
        $_POST = [
            'action' => 'CMSUpdate',
            'tagName' => 'test',
            'pageId' => 4
            ];
            
            list($output, $_POST) = $this->executeFunctionPhp();
            
            $decodedOutput = json_decode($output, true);
            
            //echo print_r($decodedOutput);
            
            // Validate response format
            $this->assertIsArray($decodedOutput);
            // check if insert to history is done
            $this->assertArrayHasKey('status', $decodedOutput);
            $this->assertEquals('failed', $decodedOutput['status']);
            $this->assertArrayHasKey('message', $decodedOutput);
            $this->assertEquals('Content is required', $decodedOutput['message']);
    }

    //  need to test the delete function 
    public function testDeleteContentNoSessionFail(): void {
        // This test should not insert any content as there is no session
        // Simulate an API request
        $_POST = [
            'action' => 'CMSDelete',
            'pageId' => 4,   
            'tagName' => 'test',
        ];

        list($output, $_POST) = $this->executeFunctionPhp();
        
        $decodedOutput = json_decode($output, true);

        //echo print_r($decodedOutput);

        // Validate response format
        $this->assertIsArray($decodedOutput);
        $this->assertArrayHasKey('status', $decodedOutput);
        $this->assertEquals('failed', $decodedOutput['status']);
        $this->assertArrayHasKey('message', $decodedOutput);
        $this->assertEquals('User is not logged in', $decodedOutput['message']);

    }

       public function testDeleteContent(): void {
        // Simulate an API request
        $_SESSION['id'] = 1;
        
        $_POST = [
            'action' => 'CMSDelete',
            'pageId' => 4,   
            'tagName' => 'test',
        ];
            
        list($output, $_POST) = $this->executeFunctionPhp();
            
        $decodedOutput = json_decode($output, true);
            
        //echo print_r($decodedOutput);
            
        // Validate response format
        $this->assertIsArray($decodedOutput);
        // check if insert to history is done
        $this->assertArrayHasKey('status', $decodedOutput);
        $this->assertEquals('success', $decodedOutput['status']);
        $this->assertArrayHasKey('message', $decodedOutput);
        $this->assertEquals('Item Deleted successfully', $decodedOutput['message']);
    }

    public function testDeleteTagNameOnlyFail(): void {
        // Simulate an API request
        $_SESSION['id'] = 1;
        
        $_POST = [
            'action' => 'CMSDelete',
            'tagName' => 'contact',
        ];
            
        list($output, $_POST) = $this->executeFunctionPhp();
            
        $decodedOutput = json_decode($output, true);
            
        //echo print_r($decodedOutput);
            
        // Validate response format
        $this->assertIsArray($decodedOutput);
        // check if insert to history is done
        $this->assertArrayHasKey('status', $decodedOutput);
        $this->assertEquals('failed', $decodedOutput['status']);
        $this->assertArrayHasKey('message', $decodedOutput);
        $this->assertEquals('Page ID is required', $decodedOutput['message']);
    }

    public function testDeletePageIdRelatedContent(): void {
        // Simulate an API request
        $_SESSION['id'] = 1;
        
        $_POST = [
            'action' => 'CMSDelete',
            'pageId' => 2,
        ];
            
        list($output, $_POST) = $this->executeFunctionPhp();
            
        $decodedOutput = json_decode($output, true);
            
        //echo print_r($decodedOutput);
            
        // Validate response format
        $this->assertIsArray($decodedOutput);
        // check if insert to history is done
        $this->assertArrayHasKey('status', $decodedOutput);
        $this->assertEquals('success', $decodedOutput['status']);
        $this->assertArrayHasKey('message', $decodedOutput);
        $this->assertEquals('Item Deleted successfully', $decodedOutput['message']);
    }

    public function testCheckRemainingData() :void{
        $_GET = [
            'action' => 'CMSContent'
        ];

        list($output, $_GET) = $this->executeFunctionPhp();
        $decodedOutput = json_decode($output, true);

        //echo print_r($decodedOutput);

        $expectedDataResults = [
            'cmsCont' => '[{"tagName":"home","content":"This is a test updated","pageId":1},{"tagName":"contact","content":"Contact us at 123 Main St, Springfield, IL 62701","pageId":3},{"tagName":"services","content":"We offer a wide range of services","pageId":4}]'
        ];

        $this->assertArrayHasKey('action', $decodedOutput);
        $this->assertEquals('CMSContent', $decodedOutput['action']);
        $this->assertArrayHasKey('cmsCont', $decodedOutput);
        $this->assertEquals($expectedDataResults['cmsCont'], json_encode($decodedOutput['cmsCont']));
    }
}


?>