<?php

    namespace Azui\Orbit\CMS;

    function updatePageContentWithLogging($inputData) {
    // Start transaction
        $pdo = $inputData['db']['dbApp'];
        $pdo->beginTransaction();
        $result = [];
        try {
            // Select the current content
            $inputData['nextOperation']      = __NAMESPACE__ . '\selectCurrentContent';
            $result['nextOperation'][]      ='selectCurrentContent';
            $data                           = executeDatabaseOperation($inputData);
            $inputData['getOldContent']     = $data['cmsCont'][0]['content'];
            $inputData['getOldPageId']      = $data['cmsCont'][0]['pageId'];
            $inputData['getOldTagName']     = $data['cmsCont'][0]['tagName'];
            $result['getOldContent']        = $inputData['getOldContent'];
            $result['getOldPageId']         = $inputData['getOldPageId'];
            $result['getOldTagName']        = $inputData['getOldTagName'];
            $result['output'][]             = $data;


            if(is_null($inputData['getOldContent'])){
                $inputData['nextOperation']      = __NAMESPACE__ . '\insertNewItem';
                $result['nextOperation'][]  = $inputData['nextOperation'];
                $data                       = executeDatabaseOperation($inputData);
                $result['output'][]         = $data;
            }else{

            // Insert a change log record
            $inputData['nextOperation']      = __NAMESPACE__ . '\insertChangeRecord';
            $result['nextOperation'][]      = $inputData['nextOperation'];
            $data                           = executeDatabaseOperation($inputData);
            $inputData['insertChangeRecord']= $data;
            $result['output'][]             = $data;
            //insertChangeRecord($inputData);
            
            // Update the page with new content
            $inputData['nextOperation']      = __NAMESPACE__ . '\updateContent';
            $result['nextOperation'][]     = $inputData['nextOperation'];
            $data                          = executeDatabaseOperation($inputData);
            $inputData['updateContent']    = $data;
            $result['output'][]            = $data;
            // Commit transaction
            }
            $pdo->commit();
        } catch (\Exception $e) {
            // Rollback transaction on error
            $pdo->rollback();
            $result['error'] =  $e;
        }
        return $result;
    }


    function executeDatabaseOperation($inputData) {
        $operation = $inputData['nextOperation'];
        try {
            $results =  $operation($inputData);
        } catch (\PDOException $e) {
            $errorInfo = $e->errorInfo ?? [];
            $errorCode = $errorInfo[1] ?? 0; // SQL error code
            $errorMessage = $e->getMessage();
    
            // Determine the type of error
            if ($errorCode == 1062) {
                $results =  ['status' => 'Failed', 'error' => "Duplicate entry detected: " . $errorMessage];
            }else{
                $results = ['status' => 'Failed', 'error' => "Unknown failure", 'errorInfo' => $errorMessage];
            }
        }
        return $results;
    }

?>