<?php

    namespace Azui\Orbit\CMS;

    function insertNewItem($inputData) {
        $pdo = $inputData['db']['dbApp'];
        $pdo->setAttribute(\PDO::ATTR_ERRMODE, \PDO::ERRMODE_EXCEPTION);
        $sql = "INSERT INTO cms_content_pages (page_id, tagname, content) VALUES (:pageId, :tagName, :content)";
        $stmt = $pdo->prepare($sql);
        $stmt->bindParam(':pageId',     $inputData['pageId']);
        $stmt->bindParam(':tagName',    $inputData['tagName']);
        $stmt->bindParam(':content',    $inputData['content']);
        $stmt->execute();
        return ['status' => 'success', 'message' => 'Item inserted successfully'];
    }


    function insertChangeRecord($inputData) {
        $pdo = $inputData['db']['dbApp'];
        $pdo->setAttribute(\PDO::ATTR_ERRMODE, \PDO::ERRMODE_EXCEPTION);
        $sql = "INSERT INTO cms_content_changes (page_id, tagname, previous_content) VALUES (:pageId, :tagName, :currentContent)";
        $stmt = $pdo->prepare($sql);
        $stmt->bindParam(':pageId',         $inputData['getOldPageId']);
        $stmt->bindParam(':tagName',        $inputData['getOldTagName']);
        $stmt->bindParam(':currentContent', $inputData['getOldContent']);
        $stmt->execute();
        return ['status' => 'success', 'message' => 'Item inserted successfully'];
    }

?>