<?php
// this should only be used for testing purposes
if (defined('TEST_ENV')) {
    //require_once __DIR__ . '/../../orbit-core/src/config.php';
    require_once __DIR__ . '\..\..\core\src\Fcors.php';
    require_once __DIR__ . '\..\..\tests\scripts\bootstrap.php';
    require_once __DIR__ . '\..\..\core\src\generic.php';
    $testInfo['0'] = ("\nFunction Running in Test Environment\n");
} else {
    // this is code for live environment Dev, Uat, Production
    require_once __DIR__ . "./../generic.php";
}

require_once __DIR__ . "/core.php";
require_once __DIR__ . "/view.php";
require_once __DIR__ . "/insert.php";
require_once __DIR__ . "/update.php";

$inputData = initializeGeneric();  // ✅ Ensures fresh initialization in each test

$inputData['requiresAdmin'] = ['CMSUpdate', 'CMSInsert', 'CMSDelete','CMSImageUpdate', 'CMSImageInsert', 'CMSImageDelete' ];
$inputData['keepLive'] = checkLive();

if(isset($inputData['action'])){
    $action = $inputData['action'];
}else{
    $action = null;
}

// check if action need auth and if does check it valid otherwise move to swithc statments 
$security = SecurityCheck($inputData); // skip security for a bit 



if($security['security'] === '1'){
    switch ($action) {
        case "CMSContent":
            $inputData['nextOperation'] = 'selectCurrentContent';
            $out = executeDatabaseOperation($inputData);
            break;
        case "CMSUpdate":
            // check if tag name exists in the input data
            if(!isset($inputData['tagName'])){
                $out = failed($inputData);
                $out['result']['message'] = 'Tag name is required';
                break;
            }
            // content not set
            if(!isset($inputData['content'])){
                $out = failed($inputData);
                $out['result']['message'] = 'Content is required';
                break;
            }
            $out = updatePageContentWithLogging($inputData);
            break;
        case "CMSInsert":
            $inputData['nextOperation'] = 'insertNewItem';
            $out = executeDatabaseOperation($inputData);
            break;
        case "CMSDelete":
            if(!isset($inputData['pageId'])){
                $out['message'] = 'Page ID is required';
                $out['status'] = 'failed';
                break;
            }
            $inputData['nextOperation'] = 'softDeleteContent';
            $out = executeDatabaseOperation($inputData);
            break;
        case "testActionCMS":
            $out = ['status' => 'success', 'message' => 'Test Action Success'];
            break;
        default:
           $out = failed($inputData);
           break;
    }
}else{
    $out = $security;
    if($security['security'] === '0'){
        unset($out['security']);
    }

}
if(defined('TEST_ENV')){
//    $out['testInfo']['1'] = $testInfo;
//    $out['testInfo']['2'] = $_GET;
//    $out['testInfo']['3'] = $_POST;
//    $out['inputData'] = $inputData;
      $out['security'] = $security;
      $out['action'] = $action;
}

echo json_encode(propagateStatusAndMessage($out));
?>
