<?php

// error_log("TEST_ENV db: " . (defined('TEST_ENV') ? 'DEFINED' : 'NOT DEFINED'));
/**
 * Creates and returns the main database connection.
 *
 * @return PDO|null
 */
function getDb() {    
    if (defined('TEST_ENV') && TEST_ENV === true) {
        static $db = null; // ✅ Ensure persistence for the test database
        if ($db) {
            return $db; // ✅ Reuse the persistent test database connection
        }
        $db = new PDO('sqlite:file::memory:?cache=shared'); // ✅ Persistent in-memory DB
        $db->setAttribute(PDO::ATTR_ERRMODE, PDO::ERRMODE_EXCEPTION);
        return $db;
    }

    // ✅ Production: The credentials are included from another file, no need for `global`
    try {
        $pdo = new PDO("mysql:host=$host;dbname=$sche", $user, $pass, [
            PDO::MYSQL_ATTR_FOUND_ROWS => true
        ]);
        $pdo->setAttribute(PDO::ATTR_ERRMODE, PDO::ERRMODE_WARNING);
        return $pdo;
    } catch (PDOException $e) {
        error_log("Main DB Connection Failed: " . $e->getMessage());
        throw new PDOException("Database connection error", 0, $e);
    }
}



/**
 * Creates and returns the login database connection.
 *
 * @return PDO|null
 */
function getDbLogin() {
    if (defined('TEST_ENV') && TEST_ENV === true) {
        static $dbLogin = null; // ✅ Ensures SQLite database persists across function calls
        if ($dbLogin) {
            return $dbLogin; // ✅ Reuse the same connection
        }
        $dbLogin = new PDO('sqlite:file::memory:?cache=shared'); // ✅ Persistent in-memory DB
        $dbLogin->setAttribute(PDO::ATTR_ERRMODE, PDO::ERRMODE_EXCEPTION);
        return $dbLogin;
    }

    // ✅ Production: Use credentials from the included config file
    try {
        $pdo = new PDO("mysql:host=$host;dbname=$scheGen", $user, $pass, [
            PDO::MYSQL_ATTR_FOUND_ROWS => true
        ]);
        $pdo->setAttribute(PDO::ATTR_ERRMODE, PDO::ERRMODE_WARNING);
        return $pdo;
    } catch (PDOException $e) {
        error_log("Login DB Connection Failed: " . $e->getMessage());
        throw new PDOException("Database connection error", 0, $e);
    }
}

?>
