<?php
//
function initializeGeneric() {
    if (!defined('TEST_ENV')) {
        require_once __DIR__ . "/Fcors.php";
        require_once __DIR__ . "/config.php";
        require_once __DIR__ . "/db.php";
    }else{
        require_once __DIR__ . "\config.php";
        require_once __DIR__ . "\db.php";
    }

    $dbInfo = getDbInfo();

    if(defined('TEST_ENV') && TEST_ENV === true){
        $inputData['db']['dbLogin'] = $GLOBALS['mockPdo'];
        $inputData['db']['dbApp']   = $GLOBALS['mockPdo'];
    }else{
        $inputData['db']['dbLogin'] = getDbLogin($dbInfo);
        $inputData['db']['dbApp']   = getDb($dbInfo); 
    }
    
    $inputData['systemId']      = "1"; 
    $inputData['debugModebug']   = "CSD";
    $inputData['requiresAdmin'] = [];

    $testInfo['file'][] = "Generic.php";
    $testInfo['date'][] = date('Y-m-d H:i:s');

    // get session timeout
    $sessionTimeout = ini_get("session.gc_maxlifetime");
    $_SESSION['last_activity'] = time();
    $sessionExpiresAt = $_SESSION['last_activity'] + $sessionTimeout;
    $inputData['sessionTimeOut']  = $sessionExpiresAt;

    // Process GET requests
    if (!empty($_GET)) {
        $inputData = array_merge($inputData, sanitizeInput($_GET));
        $inputData['reqType'] = "GET";
        $testInfo['GET'] = $_GET;

    }

    // Process POST requests
    if (!empty($_POST)) {
        $inputData = array_merge($inputData, sanitizeInput($_POST));
        $inputData['reqType'] = "POST";
        $testInfo['POST'] = $_POST;
    }
    

    // Handle JSON input from other HTTP methods like PUT, PATCH, or POST with JSON
    if (empty($_GET) && empty($_POST)) {
        $rawInput = file_get_contents('php://input');
        $decodedInput = json_decode($rawInput, true);
        if (is_array($decodedInput)) {
            $inputData = array_merge($inputData, sanitizeInput($decodedInput));
            $inputData['reqType'] = "Raw JSON";
        }
    }

    if(isset($inputData['action'])){
        $action = $inputData['action'] ?? null;  // ✅ Prevents notice if `action` is missing
    };

    if(isset($action)){
        if($action === "defaultAction"){
            $data['status'] = 'failed';
            $data['message'] = 'default-action called'; 
            echo json_encode($data);
            exit();
        }
    }

    if(isset($_SESSION['id'])){
        $inputData['userId']    = $_SESSION['id'];
    }

    if(isset($_SESSION['roleValue'])){
        $inputData['roleId'] = $_SESSION['roleValue'];
    }else{
        $inputData['roleId'] = 0;
    }

    if (isset($action)   && $action === "getSessionInfo") {
        $inputData['sessionInfo'] = $_SESSION;
    }

    // Remove this at a later point
    $inputData['sessionInfo'] = $_SESSION;

    $inputData['testInfo']['1'] = $testInfo;

    return $inputData;
}

// Helper function to sanitize inputs
function sanitizeInput($data) {
    if (is_array($data)) {
        return array_map('sanitizeInput', $data);
    }
    return htmlspecialchars($data);
}

function killSessions() {
    $_SESSION = [];

    // ✅ Ensure session is active before destroying
    if (session_status() === PHP_SESSION_ACTIVE) {
        session_destroy();
        session_write_close(); // Ensure session is fully closed
    }
}

function checkLive(){
    $results['status']  = session_status();
    if(isset($_SESSION['id'])){
        $results['userEnabled'] = true;
        $results['reload']      = null;
        $results['active']      = 1;
        $results['status']      = 'success';
    }else{
        $results['reload']      = 'home';
        $results['active']      = 0;
        $results['status']      = 'failed';
        killSessions();
    }
    return $results;
}


function checkUserStatus($keepLive) {
    if (!isset($keepLive['active']) || $keepLive['active'] != 1) {
        $data['result']['status'] = 'failed';
        $data['result']['message'] = 'User is logged out';
        $data['result']['logout'] = 'true';
    } else{
        $data['result']['logout'] = 'false';
    }
    return $data;
}

function SecurityCheck($inputData){
    // i need to check if is array and if it is not empty
    if (in_array($inputData['action'], $inputData['requiresAdmin'])) {
        $inputData['keepLive'] = checkLive();
        if (!isset($_SESSION['id'])) {
            $data = checkUserStatus($inputData['keepLive']);
            $data['result']['status'] = 'failed';
            $data['result']['message'] = 'User is not logged in';
            $data['result']['logout'] = 'true';
            $data['security'] = '0';
            
        }else{
            $data['security'] = '1';
        }
    }else{
        $data['security'] = '1';
    }
    return $data;
}


function failed($inputData){
    $data['result']['status']   = 'failed';
    $data['result']['message']  = 'No Action Found';
    $data['result']['action']   = $inputData['action'] ?? 'Set-Action-At-Failed';
    return $data;
}


// i want to log to a db a single recored for any request that comes in
// let include the action and the user id if there is one and a timestamp
// lets also include the ip address of the user
// can we add the calling url

function logRequest($inputData) {
    if (empty($inputData['action']) || !isset($inputData['db']['dbApp'])) {
        return; // ✅ Skip logging if action is missing or DB is not set
    }

    $pdo = $inputData['db']['dbApp'];

    $sql = "INSERT INTO `request_log` (`action`, `userId`, `ip`, `time`, `url`) 
            VALUES (:action, :userId, :ip, :time, :url)";
    
    $stmt = $pdo->prepare($sql);
    $stmt->bindValue(':action', $inputData['action']);
    $stmt->bindValue(':userId', $inputData['userId'] ?? null);
    $stmt->bindValue(':ip', $_SERVER['REMOTE_ADDR'] ?? '127.0.0.1');
    $stmt->bindValue(':time', date('Y-m-d H:i:s'));
    $stmt->bindValue(':url', $_SERVER['HTTP_REFERER'] ?? null);

    $stmt->execute();
}





if (defined('TEST_ENV') && TEST_ENV === false) { 
    logRequest($inputData);  // ✅ Only log in production, not in tests
}

initializeGeneric();

?>