<?php

function getDb($dbInfo) {
    if (defined('TEST_ENV') && TEST_ENV === true) {
        static $db = null;
        if ($db) return $db;

        // Use a NAMED in-memory DB so multiple connections can share if needed
        // (Change "main" to a different name if you want main/login isolated)
        $db = new PDO('sqlite:file:main?mode=memory&cache=shared');
        $db->setAttribute(PDO::ATTR_ERRMODE, PDO::ERRMODE_EXCEPTION);
        // Optional but recommended for SQLite:
        $db->exec('PRAGMA foreign_keys = ON;');
        pinConnectionTimezoneToUtc($db); // no-op for SQLite, but harmless
        return $db;
    } else {
        try {
            $dsn = 'mysql:host='.$dbInfo['host'].';dbname='.$dbInfo['sche'].';charset=utf8mb4';
            $pdo = new PDO($dsn, $dbInfo['user'], $dbInfo['pass'], [
                PDO::MYSQL_ATTR_FOUND_ROWS => true,
                PDO::ATTR_ERRMODE => PDO::ERRMODE_EXCEPTION,   // use exceptions in prod too
                PDO::ATTR_EMULATE_PREPARES => false,           // better typing
            ]);
            pinConnectionTimezoneToUtc($pdo);                 // ✅ lock session to UTC
            return $pdo;
        } catch (PDOException $e) {
            error_log("Main DB Connection Failed: " . $e->getMessage());
            throw new PDOException("Database connection error", 0, $e);
        }
    }
}


/**
 * Creates and returns the login database connection.
 *
 * @return PDO|null
 */
function getDbLogin($dbInfo) {
    if (defined('TEST_ENV') && TEST_ENV === true) {
        static $dbLogin = null;
        if ($dbLogin) return $dbLogin;

        // If you want the login DB to be separate in tests, use a different name
        $dbLogin = new PDO('sqlite:file:login?mode=memory&cache=shared');
        $dbLogin->setAttribute(PDO::ATTR_ERRMODE, PDO::ERRMODE_EXCEPTION);
        $dbLogin->exec('PRAGMA foreign_keys = ON;');
        pinConnectionTimezoneToUtc($dbLogin);
        return $dbLogin;
    } else {
        try {
            $dsn = 'mysql:host='.$dbInfo['host'].';dbname='.$dbInfo['scheGen'].';charset=utf8mb4';
            $pdo = new PDO($dsn, $dbInfo['user'], $dbInfo['pass'], [
                PDO::MYSQL_ATTR_FOUND_ROWS => true,
                PDO::ATTR_ERRMODE => PDO::ERRMODE_EXCEPTION,
                PDO::ATTR_EMULATE_PREPARES => false,
            ]);
            pinConnectionTimezoneToUtc($pdo);                 // ✅ lock session to UTC
            return $pdo;
        } catch (PDOException $e) {
            error_log("Login DB Connection Failed: " . $e->getMessage());
            throw new PDOException("Database connection error", 0, $e);
        }
    }
}

?>
