<?php
use PHPUnit\Framework\TestCase;

    // Flexible path resolution for core files
    if (file_exists(__DIR__ . '/../../core/src/fcors.php')) {
        require_once __DIR__ . '/../../core/src/fcors.php';
    } else {
        require_once __DIR__ . '/../../core/fcors.php';
    }
    
    if (file_exists(__DIR__ . '/../../core/src/db.php')) {
        require_once __DIR__ . '/../../core/src/db.php';
    } else {
        require_once __DIR__ . '/../../core/db.php';
    }
    echo "\n>>>>>>>>>>>>>>>>>>>>>>>>>====<<<<<<<<<<<<<<<<<<<<<<<<<\n";
    echo "\nT01_DbConnectionTest.php\n";

    class FcorsTest extends TestCase {
        protected function setUp(): void {
            // Set REQUEST_METHOD explicitly before including Fcors.php
            $_SERVER['REQUEST_METHOD'] = 'CLI';
        }

        public function testRequestMethodIsSet() {
            $this->assertArrayHasKey('REQUEST_METHOD', $_SERVER);
            $this->assertNotEmpty($_SERVER['REQUEST_METHOD']);
            $this->assertEquals('CLI', $_SERVER['REQUEST_METHOD']); // Ensure it is set to CLI
        }
    }

    class T01_DbConnectionTest extends TestCase {
        //private $mockPdo;
    
        protected function setUp(): void {

        }
    
        public function test001GetDbConnectionSuccess() {
            $dbInfo = [
                'host' => 'localhost',
                'sche' => 'test_db',
                'user' => 'test_user',
                'pass' => 'test_pass'
            ];

            $db = getDb($dbInfo);
            $this->assertInstanceOf(PDO::class, $db);
        }
    
        public function test002GetDbLoginConnectionSuccess() {

            $dbInfo = [
                'host' => 'localhost',
                'sche' => 'test_db',
                'user' => 'test_user',
                'pass' => 'test_pass'
            ];


            $dbLogin = getDbLogin($dbInfo);
            $this->assertInstanceOf(PDO::class, $dbLogin);
        }
    
        public function test003DbUsesSqliteInTestMode() {
            $dbInfo = [
                'host' => 'localhost',
                'sche' => 'test_db',
                'user' => 'test_user',
                'pass' => 'test_pass'
            ];

            $db = getDb($dbInfo);
            $this->assertEquals('sqlite', $db->getAttribute(PDO::ATTR_DRIVER_NAME));
        }
    
        public function test004DbLoginUsesSqliteInTestMode() {
            $dbInfo = [
                'host' => 'localhost',
                'sche' => 'test_db',
                'user' => 'test_user',
                'pass' => 'test_pass'
            ];

            $dbLogin = getDbLogin($dbInfo);
            $this->assertEquals('sqlite', $dbLogin->getAttribute(PDO::ATTR_DRIVER_NAME));
        }
    }
?>