<?php

echo "🔄 Running Orbit-Core Post-Update Script...\n";

if (getenv('Test_ENV') === 'true') {
    echo "Test environment detected, skipping post-update script.\n";
    exit(0);
}

$rootDir = dirname(__DIR__, 4); // Go up four levels to reach the main project
$vendorDir = __DIR__ . '/../../../../vendor/adminprodigydesign/'; // Vendor directory

$coreDir = __DIR__ . '/../src/';  // Where Orbit-Core files are stored
$coreSQLDir = __DIR__ . '/../SQL/'; // SQL directory inside Orbit-Core
$coreFiles = ['db.php', 'Fcors.php', 'generic.php', 'error_monitor.php']; // Core files to move

// 1️⃣ Copy Orbit-Core files to the root directory
echo "🚀 Copying Orbit-Core files to root directory...\n";
foreach ($coreFiles as $file) {
    $source = $coreDir . $file;
    $destination = $rootDir . '/' . $file;

    if (file_exists($source)) {
        copy($source, $destination);
        echo "✅ Copied $file to project root.\n";
    } else {
        echo "⚠️ $file not found in Orbit-Core.\n";
    }
}

// 2️⃣ Debugging: List contents of $vendorDir to check if path is correct
echo "🔍 Listing contents of $vendorDir to verify path:\n";

$debugList = scandir($vendorDir);
if ($debugList === false) {
    echo "⚠️ Unable to read directory: $vendorDir\n";
} else {
    foreach ($debugList as $item) {
        echo " - $item\n";
    }
}

// 3️⃣ Detect and move other installed packages to `root/{package-name}/`
echo "🔍 Checking for other installed packages...\n";
$installedPackages = glob($vendorDir . '*', GLOB_ONLYDIR);

foreach ($installedPackages as $packagePath) {
    $packageName = basename($packagePath);
    // temp stop so core is copyed for testing but added to git ignore so it does not cause issues for others
    //if ($packageName === 'orbit-core') {
    //    continue; // Skip Orbit-Core (already handled)
    //}

    // Extract package name from format `orbit-package`
    $packageNameParts = explode('-', $packageName, 2);
    if (count($packageNameParts) < 2) {
        echo "⚠️ Unable to determine package name for $packageName, skipping...\n";
        continue;
    }
    $packageName = $packageNameParts[1];

    $packageTarget = $rootDir . '/' . $packageName;
    if (!is_dir($packageTarget)) {
        mkdir($packageTarget, 0777, true);
    }

    echo "🚀 Moving files for $packageName to $packageTarget/...\n";
    
    // Move `src/` files
    $packageSrc = $packagePath . '/src/';
    if (is_dir($packageSrc)) {
        $files = glob($packageSrc . '*');
        foreach ($files as $file) {
            $filename = basename($file);
            rename($file, $packageTarget . '/' . $filename);
        }
        echo "✅ Moved src/ files for $packageName.\n";
    } else {
        echo "⚠️ No src/ directory found in $packageName, skipping...\n";
    }

    // Move `SQL/` files
    $packageSQL = $packagePath . '/SQL/';
    if (is_dir($packageSQL)) {
        $sqlTarget = $packageTarget . '/SQL/';
        if (!is_dir($sqlTarget)) {
            mkdir($sqlTarget, 0777, true);
        }
        
        $files = glob($packageSQL . '*');
        foreach ($files as $file) {
            $filename = basename($file);
            rename($file, $sqlTarget . $filename);
        }
        echo "✅ Moved SQL/ files for $packageName.\n";
    } else {
        echo "⚠️ No SQL/ directory found in $packageName, skipping...\n";
    }

    // Move `tests/` files
    $packageTests = $packagePath . '/tests/';
    if (is_dir($packageTests)) {
        $testsTarget = $packageTarget . '/tests/';
        if (!is_dir($testsTarget)) {
            mkdir($testsTarget, 0777, true);
        }
        
        $files = glob($packageTests . '*');
        foreach ($files as $file) {
            $filename = basename($file);
            rename($file, $testsTarget . $filename);
        }
        echo "✅ Moved tests/ files for $packageName.\n";
    } else {
        echo "⚠️ No tests/ directory found in $packageName, skipping...\n";
    }

    // Special handling for core package - move `unit-test/` directory
    if ($packageName === 'core') {
        $packageUnitTest = $packagePath . '/unit-test/';
        if (is_dir($packageUnitTest)) {
            $unitTestTarget = $packageTarget . '/unit-test/';
            
            // Function to recursively copy directory
            function copyDirectory($source, $destination) {
                if (!is_dir($destination)) {
                    mkdir($destination, 0777, true);
                }
                
                // Normalize source path for comparison
                $source = rtrim(str_replace('\\', '/', $source), '/') . '/';
                
                $iterator = new RecursiveIteratorIterator(
                    new RecursiveDirectoryIterator($source, RecursiveDirectoryIterator::SKIP_DOTS),
                    RecursiveIteratorIterator::SELF_FIRST
                );
                
                foreach ($iterator as $file) {
                    $filePath = str_replace('\\', '/', $file->getPathname());
                    $relativePath = substr($filePath, strlen($source));
                    $targetPath = rtrim($destination, '/') . '/' . $relativePath;
                    
                    if ($file->isDir()) {
                        if (!is_dir($targetPath)) {
                            mkdir($targetPath, 0777, true);
                        }
                    } else {
                        $targetDir = dirname($targetPath);
                        if (!is_dir($targetDir)) {
                            mkdir($targetDir, 0777, true);
                        }
                        copy($file->getPathname(), $targetPath);
                    }
                }
            }
            
            copyDirectory($packageUnitTest, $unitTestTarget);
            echo "✅ Copied unit-test/ directory for core.\n";
        } else {
            echo "⚠️ No unit-test/ directory found in core, skipping...\n";
        }

        // Move `misc/` directory for core package
        $packageMisc = $packagePath . '/misc/';
        if (is_dir($packageMisc)) {
            $miscTarget = $packageTarget . '/misc/';
            copyDirectory($packageMisc, $miscTarget);
            echo "✅ Copied misc/ directory for core.\n";
        } else {
            echo "⚠️ No misc/ directory found in core, skipping...\n";
        }
    }
}

echo "✅ Post-Update Process Complete!\n";

?>
