<?php
namespace Stripe;

class Customer
{
    /** Unique identifier for the Customer (e.g., "cus_1234...") */
    public string $id;

    /** The customer's email address */
    public ?string $email = null;

    /** The customer's name */
    public ?string $name = null;

    /** Phone number if provided */
    public ?string $phone = null;

    /** Array of metadata key/value pairs */
    public array $metadata = [];

    public static function create(array $params = []): self { return new self(); }

    public static function retrieve(string $id, array $opts = []): self { return new self(); }

    public function update(array $params = []): self { return $this; }

    public function delete(array $params = []): self { return $this; }
}
