<?php
$base = sys_get_temp_dir() . DIRECTORY_SEPARATOR . 'phpunit_test.sqlite';
$files = [$base, $base . '-wal', $base . '-shm'];

echo "🧹 Cleanup: removing SQLite test DB files...\n";
gc_collect_cycles();

foreach ($files as $f) {
    if (file_exists($f)) {
        if (@unlink($f)) {
            echo "✅ Deleted: {$f}\n";
        } else {
            echo "⚠️ Could not delete (locked?): {$f}\n";
        }
    }
}
