<?php

echo "🔄 Running Orbit-Core Post-Update Script...\n";

if (getenv('Test_ENV') === 'true') {
    echo "Test environment detected, skipping post-update script.\n";
    exit(0);
}

$rootDir = dirname(__DIR__, 4); // Go up four levels to reach the main project
$vendorDir = __DIR__ . '/../../../../vendor/adminprodigydesign/'; // Vendor directory

$coreDir = __DIR__ . '/../src/';  // Where Orbit-Core files are stored
$coreSQLDir = __DIR__ . '/../SQL/'; // SQL directory inside Orbit-Core
$coreFiles = ['db.php', 'Fcors.php', 'generic.php', 'error_monitor.php']; // Core files to move

// 1️⃣ Copy Orbit-Core files to the root directory
echo "🚀 Copying Orbit-Core files to root directory...\n";
foreach ($coreFiles as $file) {
    $source = $coreDir . $file;
    $destination = $rootDir . '/' . $file;

    if (file_exists($source)) {
        copy($source, $destination);
        echo "✅ Copied $file to project root.\n";
    } else {
        echo "⚠️ $file not found in Orbit-Core.\n";
    }
}

// 2️⃣ Debugging: List contents of $vendorDir to check if path is correct
echo "🔍 Listing contents of $vendorDir to verify path:\n";

$debugList = scandir($vendorDir);
if ($debugList === false) {
    echo "⚠️ Unable to read directory: $vendorDir\n";
} else {
    foreach ($debugList as $item) {
        echo " - $item\n";
    }
}

// 3️⃣ Detect and move other installed packages to `root/{package-name}/`
echo "🔍 Checking for other installed packages...\n";
$installedPackages = glob($vendorDir . '*', GLOB_ONLYDIR);

foreach ($installedPackages as $packagePath) {
    $packageName = basename($packagePath);
    // temp stop so core is copyed for testing but added to git ignore so it does not cause issues for others
    //if ($packageName === 'orbit-core') {
    //    continue; // Skip Orbit-Core (already handled)
    //}

    // Extract package name from format `orbit-package`
    $packageNameParts = explode('-', $packageName, 2);
    if (count($packageNameParts) < 2) {
        echo "⚠️ Unable to determine package name for $packageName, skipping...\n";
        continue;
    }
    $packageName = $packageNameParts[1];

    $packageTarget = $rootDir . '/' . $packageName;
    if (!is_dir($packageTarget)) {
        mkdir($packageTarget, 0777, true);
    }

    echo "🚀 Moving files for $packageName to $packageTarget/...\n";
    
    // Move `src/` files
    $packageSrc = $packagePath . '/src/';
    if (is_dir($packageSrc)) {
        $files = glob($packageSrc . '*');
        foreach ($files as $file) {
            $filename = basename($file);
            rename($file, $packageTarget . '/' . $filename);
        }
        echo "✅ Moved src/ files for $packageName.\n";
    } else {
        echo "⚠️ No src/ directory found in $packageName, skipping...\n";
    }

    // Move `SQL/` files
    $packageSQL = $packagePath . '/SQL/';
    if (is_dir($packageSQL)) {
        $sqlTarget = $packageTarget . '/SQL/';
        if (!is_dir($sqlTarget)) {
            mkdir($sqlTarget, 0777, true);
        }
        
        $files = glob($packageSQL . '*');
        foreach ($files as $file) {
            $filename = basename($file);
            rename($file, $sqlTarget . $filename);
        }
        echo "✅ Moved SQL/ files for $packageName.\n";
    } else {
        echo "⚠️ No SQL/ directory found in $packageName, skipping...\n";
    }
}

echo "✅ Post-Update Process Complete!\n";

?>
