<?php
namespace Stripe;

class StripeClient
{
    /** @var string */
    private string $apiKey;

    /** @var \Stripe\Service\PaymentIntentService */
    public $paymentIntents;

    /** @var \Stripe\Service\CustomerService */
    public $customers;

    /** @var \Stripe\Service\ChargeService */
    public $charges;

    /** @var \Stripe\Service\RefundService */
    public $refunds;

    /** @var \Stripe\Service\ApplicationFeeService */
    public $applicationFees;

    /** @var \Stripe\Service\BalanceTransactionService */
    public $balanceTransactions;

    public function __construct(string $apiKey)
    {
        $this->apiKey = $apiKey;

        $this->paymentIntents       = new \Stripe\Service\PaymentIntentService();
        $this->customers            = new \Stripe\Service\CustomerService();
        $this->charges              = new \Stripe\Service\ChargeService();
        $this->refunds              = new \Stripe\Service\RefundService();
        $this->applicationFees      = new \Stripe\Service\ApplicationFeeService();
        $this->balanceTransactions  = new \Stripe\Service\BalanceTransactionService();
    }
}
