<?php

    function insertEvent($inputData){
        $data = [];
        $db = $inputData['db']['dbLogin'];
        $stmt = $db->prepare("insert into event_details (`title`, `small_summary`, `rich_explanation`, `location`, `formatted_address`, `latitude`, `longitude`, `start_datetime`, `end_datetime`, `owner_id`, `is_enabled`) values(:title, :small_summary, :rich_explanation, :location, :formatted_address, :latitude, :longitude, :start_datetime, :end_datetime, :owner_id, :is_enabled)");
        $stmt->bindParam(':title', $inputData['title']);
        $stmt->bindParam(':small_summary', $inputData['smallSummary']);
        $stmt->bindParam(':rich_explanation', $inputData['richExplanation']);
        $stmt->bindParam(':location', $inputData['location']);
        $stmt->bindParam(':formatted_address', $inputData['formattedAddress']);
        $stmt->bindParam(':latitude', $inputData['latitude']);
        $stmt->bindParam(':longitude', $inputData['longitude']);
        $stmt->bindParam(':start_datetime', $inputData['startDate']);
        $stmt->bindParam(':end_datetime', $inputData['endDate']);
        $stmt->bindParam(':owner_id', $inputData['userId']);
        $stmt->bindParam(':is_enabled', $inputData['isEnabled']);
        $stmt->execute();
        $eventid = $db->lastInsertId();
        if ($stmt->rowCount() > 0){
            $data['eventId']   = $eventid;
            $data['message']  = 'Event created successfully';
            $data['status']   = 'success';
            return $data;
        }else{
            $data['status'] = 'failed';
            $data['eventId'] =  '0';
            return $data;
        }
    }



    // example of payload coverImageUrl: https://stv2mechhaven.blob.core.windows.net/dev/imageCovers/test_event_2024-12-18/bb84f004-5eec-4c05-a59d-23c933831d46.jpg documentUrls: ["https://stv2mechhaven.blob.core.windows.net/dev/documents/test_event_2024-12-18/61b405e0-c1b0-491e-bbba-a65a5319196d.jpg","https://stv2mechhaven.blob.core.windows.net/dev/documents/test_event_2024-12-18/61b405e0-c1b0-491e-bbba-a65a5319196d.jpg"]

    function eventFiles($inputData) {
        $data = [];
        $db = $inputData['db']['dbLogin'];

        $decodedUrls = html_entity_decode($inputData['documentFiles']);
        $documentUrls = json_decode($decodedUrls, true);
    
        // Insert cover image URL
        $stmt = $db->prepare("
            INSERT INTO event_files 
            (`event_id`, `uploader_id`, `file_name`, `file_url`, `is_public`, `file_type`) 
            VALUES (:event_id, :uploader_id, :file_name, :file_url, :is_public, :file_type)
        ");
    
        // Handle cover image
        if (!empty($inputData['coverImageUrl'])) {
            $stmt->bindParam(':event_id', $inputData['eventId']);
            $stmt->bindParam(':uploader_id', $inputData['userId']);
            $stmt->bindParam(':file_name', basename($inputData['coverImageUrl']));
            $stmt->bindParam(':file_url', $inputData['coverImageUrl']);
            $stmt->bindParam(':is_public', $inputData['isPublic']);
            $fileType = 'Cover Image';
            $stmt->bindParam(':file_type', $fileType);
            $stmt->execute();
    
            if ($stmt->rowCount() === 0) {
                $data['status'] = 'failed';
                $data['message'] = 'Failed to insert cover image.';
                return $data;
            }
        }
    
        // Handle document URLs
        if (!empty($inputData['documentFiles'])) {
            foreach ($documentUrls as $file) {
                if (is_array($file) && isset($file['name'], $file['url'])) {
                    $fileUrl = $file['url'];
                    $fileName = $file['name'];
                    $stmt->bindParam(':event_id', $inputData['eventId']);
                    $stmt->bindParam(':uploader_id', $inputData['userId']);
                    $stmt->bindParam(':file_name', $fileName);
                    $stmt->bindParam(':file_url', $fileUrl);
                    $stmt->bindParam(':is_public', $inputData['isPublic']);
                    $fileType = 'Event Documentation';
                    $stmt->bindParam(':file_type', $fileType);
                    $stmt->execute();
    
                    if ($stmt->rowCount() === 0) {
                        $data['status'] = 'failed';
                        $data['message'] = 'Failed to insert document URLs.';
                    }
                } else {
                    $data['status'] = 'failed';
                    $data['message'] = 'Invalid file entry.';
                }
            }
        } else {
            $data['status'] = 'failed';
            $data['message'] = 'No document URLs provided.';
        }
  
        $data['status'] = 'success';
        $data['message'] = 'Files Inserted successfully.';
        return $data;
    }

?>