<?php
    function liveEvents($inputData){
        $db = $inputData['db']['dbLogin'];
        $userid = $inputData['userId'];
        $roleId = $inputData['roleId'];
        $extraSql = '  ';
        $isOwner  = ' 0 as is_owner , 1 as is_enabled '; 
        if(isset($userid) && ($roleId == 1 || $roleId == 2 || $roleId == 3)){
            $extraSql = " OR ed.owner_id = :userId" ;
            $isOwner  = ' CASE WHEN ed.owner_id = :userId THEN 1 ELSE 0 END AS is_owner, is_enabled';
        }

        $stmt = $db->prepare("SELECT 
                    ed.id AS event_id, 
                    ed.title, 
                    ed.small_summary, 
                    ed.location, 
                    ed.start_datetime, 
                    ed.end_datetime, 
                    ed.formatted_address,
                    ef.file_name,
                    ef.file_url,
                    ". $isOwner ."
                FROM event_details ed
                LEFT JOIN event_files ef ON ed.id = ef.event_id AND ef.file_type = 'Cover Image'
                WHERE
                    (ed.is_enabled = 1  ". $extraSql ." )
                    AND DATE(ed.end_datetime) >= CURDATE()
                ORDER BY ed.start_datetime ASC");
        if(isset($userid) && ($roleId == 1 || $roleId == 2 || $roleId == 3)){
            $stmt->bindParam(':userId', $userid, PDO::PARAM_INT);
        }
        $stmt->execute();
        if ($stmt->rowCount() > 0) {
            while ($row = $stmt->fetch(PDO::FETCH_ASSOC)) {
                $result = [];
                $result['eventID']              = $row['event_id'];
                $result['title']                = $row['title'];
                $result['smallSummary']         = $row['small_summary'];
                $result['location']             = $row['location'];
                $result['startDatetime']        = $row['start_datetime'];
                $result['endDatetime']          = $row['end_datetime'];
                $result['formattedAddress']     = $row['formatted_address'];
                $result['coverImage']           = $row['file_url'];
                $result['coverImageName']       = $row['file_name'];
                $result['isOwner']              = $row['is_owner'];
                $result['isEnabled']            = $row['is_enabled'];
                $data['event'][]= $result;
            }
            $data['status'] = 'success';
            $data['message'] = 'Live Events';
        } else {
            $data['status'] = 'failed';
            $data['message'] = 'No Events Found';
        }
        return $data;
    }

    function getCoverImage($inputData){
        $db = $inputData['db']['dbLogin'];
        $stmt = $db->prepare("SELECT 
                    ef.id,
                    ef.file_url
                FROM event_files ef
                WHERE
                        ef.event_id = :eventId
                    AND ef.file_type = 'Cover Image'
                    AND ef.is_public =  1");
        $stmt->bindParam(':eventId', $inputData['eventId'], PDO::PARAM_INT);
        $stmt->execute();
        if ($stmt->rowCount() > 0) {
            $row = $stmt->fetch(PDO::FETCH_ASSOC);
            $result = [];
            $result['fileUrl']   = $row['file_url'];
            $result['Id'] = $row['id'];
            $data['coverImage']= $result;
            $data['status'] = 'success';
            $data['message'] = 'Cover Image';
        } else {
            $data['status'] = 'failed';
            $data['message'] = 'No Cover Image Found';
            $data['coverImage'] = [];
        }
        return $data;
    }

    function getEventFiles($inputData){
        $db = $inputData['db']['dbLogin'];
        $stmt = $db->prepare("SELECT 
                    ef.id,
                    ef.file_name,
                    ef.file_url
                FROM event_files ef
                WHERE
                        ef.event_id  = :eventId
                    AND ef.file_type = 'Event Documentation'
                    AND ef.is_public = 1");
        $stmt->bindParam(':eventId', $inputData['eventId'], PDO::PARAM_INT);
        $stmt->execute();
        if ($stmt->rowCount() > 0) {
            while ($row = $stmt->fetch(PDO::FETCH_ASSOC)) {
                $result = [];
                $result['Id'] = $row['id'];
                $result['fileName'] = $row['file_name'];
                $result['fileUrl'] = $row['file_url'];
                $data['eventFiles'][]= $result;
            }
            $data['status'] = 'success';
            $data['message'] = 'Event Files';
        } else {
            $data['status'] = 'failed';
            $data['message'] = 'No Files Found';
            $data['eventFiles'] = [];
        }
        return $data;
    }

    function viewEventById($inputData){
        $db = $inputData['db']['dbLogin'];
        $eventID = $inputData['eventID'];
        $stmt = $db->prepare("SELECT 
                    ed.title, 
                    ed.small_summary, 
                    ed.rich_explanation,
                    ed.location, 
                    ed.start_datetime, 
                    ed.end_datetime, 
                    ed.formatted_address,
                    ed.is_enabled,
                    ed.latitude,
                    ed.longitude
                FROM event_details ed
                WHERE
                        ed.id = :eventId
                    AND ed.owner_id = :userId");
        $stmt->bindParam(':eventId',    $inputData['eventId'], PDO::PARAM_INT);
        $stmt->bindParam(':userId',     $inputData['userId'], PDO::PARAM_INT);
        $stmt->execute();
        if ($stmt->rowCount() > 0) {
            $row = $stmt->fetch(PDO::FETCH_ASSOC);
            $result = [];
            $result['title']                = $row['title'];
            $result['smallSummary']         = $row['small_summary'];
            $result['richExplanation']      = $row['rich_explanation'];
            $result['location']             = $row['location'];
            $result['startDatetime']        = $row['start_datetime'];
            $result['endDatetime']          = $row['end_datetime'];
            $result['formattedAddress']     = $row['formatted_address'];
            $result['isEnabled']            = $row['is_enabled'];
            $result['latitude']             = $row['latitude'];
            $result['longitude']            = $row['longitude'];
            $coverIamge                     = getCoverImage($inputData);
            $eventFiles                     = getEventFiles($inputData);
            $result['coverImage']           = $coverIamge['coverImage'];
            $result['eventFiles']           = $eventFiles['eventFiles'];
            $data['event']= $result;
            $data['status'] = 'success';
            $data['message'] = 'Event Details';
        } else {
            $data['status'] = 'failed';
            $data['message'] = 'No Events Found';
        }
        return $data;
    }
?>

