<?php
    function toggleEvent($inputData){
        $data = [];
        $db = $inputData['db']['dbLogin'];
        $stmt = $db->prepare("
            UPDATE event_details 
            SET is_enabled = :is_enabled
            WHERE id = :event_id and owner_id = :owner_id");

        $stmt->bindParam(':is_enabled', $inputData['isEnabled']);
        $stmt->bindParam(':event_id', $inputData['eventId']);
        $stmt->bindParam(':owner_id', $inputData['userId']);
        $stmt->execute();
        // check if the event was toggled
        if($stmt->rowCount() === 0){
            $data['status'] = 'failed';
            $data['message'] = 'Event not found or you do not have permission to toggle this event';
        }else{
            $data['status'] = 'success';
            $data['message'] = 'Event has been toggled';
        }
        return $data;

    }
?>