<?php

function menuTableColumnMapping($table = null, $roleId = null) {
    $allMappings = [
        'menu_menus' => [
            'fields' => [
                'id'          => ['mapping' => 'id',           'updateRole' => [2, 4, 5], 'optionalInsert' => null, 'optionalUpdate' => 1, 'dataType' => 'int',     'expectedValue' => null],
                'tenantId'    => ['mapping' => 'tenant_id',    'updateRole' => [2, 4, 5], 'optionalInsert' => 0,    'optionalUpdate' => 0, 'dataType' => 'int',     'expectedValue' => null],
                'name'        => ['mapping' => 'name',         'updateRole' => [2, 4, 5], 'optionalInsert' => 0,    'optionalUpdate' => 0, 'dataType' => 'string',  'expectedValue' => null],
                'description' => ['mapping' => 'description',  'updateRole' => [2, 4, 5], 'optionalInsert' => 1,    'optionalUpdate' => 0, 'dataType' => 'string',  'expectedValue' => null],
                'isActive'    => ['mapping' => 'is_active',    'updateRole' => [2, 4, 5], 'optionalInsert' => 1,    'optionalUpdate' => 0, 'dataType' => 'int',     'expectedValue' => [0,1]],
                'isDeleted'   => ['mapping' => 'is_deleted',   'updateRole' => [2, 4, 5], 'optionalInsert' => 1,    'optionalUpdate' => 0, 'dataType' => 'int',     'expectedValue' => [0,1]],
            ],
        'relationships' => [['table' => 'menu_categories', 'foreignKey' => 'menuId']],
        ],
        'menu_categories' => [
            'fields' => [
                'id'          => ['mapping' => 'id',           'updateRole' => [2, 4, 5], 'optionalInsert' => null, 'optionalUpdate' => 1, 'dataType' => 'int',     'expectedValue' => null],
                'menuId'      => ['mapping' => 'menu_id',      'updateRole' => [2, 4, 5], 'optionalInsert' => 0,    'optionalUpdate' => 0, 'dataType' => 'int',     'expectedValue' => null],
                'parentId'    => ['mapping' => 'parent_id',    'updateRole' => [2, 4, 5], 'optionalInsert' => 1,    'optionalUpdate' => 0, 'dataType' => 'int',     'expectedValue' => null],
                'name'        => ['mapping' => 'name',         'updateRole' => [2, 4, 5], 'optionalInsert' => 0,    'optionalUpdate' => 0, 'dataType' => 'string',  'expectedValue' => null],
                'description' => ['mapping' => 'description',  'updateRole' => [2, 4, 5], 'optionalInsert' => 1,    'optionalUpdate' => 0, 'dataType' => 'string',  'expectedValue' => null],
                'sortOrder'   => ['mapping' => 'sort_order',   'updateRole' => [2, 4, 5], 'optionalInsert' => 1,    'optionalUpdate' => 0, 'dataType' => 'int',     'expectedValue' => null],
                'isActive'    => ['mapping' => 'is_active',    'updateRole' => [2, 4, 5], 'optionalInsert' => 1,    'optionalUpdate' => 0, 'dataType' => 'int',     'expectedValue' => null],
                'isDeleted'   => ['mapping' => 'is_deleted',   'updateRole' => [2, 4, 5], 'optionalInsert' => 1,    'optionalUpdate' => 0, 'dataType' => 'int',     'expectedValue' => [0,1]],
            ],
            'relationships' => [['table' => 'menu_items', 'foreignKey' => 'categoryId']],
        ],
        'menu_items' => [
            'fields' => [
                'id'             => ['mapping' => 'id',               'updateRole' => [2, 4, 5],     'optionalInsert' => null,  'optionalUpdate' => 1, 'dataType' => 'int',     'expectedValue' => null],
                'menuId'         => ['mapping' => 'menu_id',          'updateRole' => [2, 4, 5],     'optionalInsert' => 0,     'optionalUpdate' => 0, 'dataType' => 'int',     'expectedValue' => null],
                'categoryId'     => ['mapping' => 'category_id',      'updateRole' => [2, 4, 5],     'optionalInsert' => 0,     'optionalUpdate' => 0, 'dataType' => 'int',     'expectedValue' => null],
                'parentId'       => ['mapping' => 'parent_id',        'updateRole' => [2, 4, 5],     'optionalInsert' => 1,     'optionalUpdate' => 0, 'dataType' => 'int',     'expectedValue' => null],
                'name'           => ['mapping' => 'name',             'updateRole' => [2, 4, 5],     'optionalInsert' => 0,     'optionalUpdate' => 0, 'dataType' => 'string',  'expectedValue' => null],
                'description'    => ['mapping' => 'description',      'updateRole' => [2, 4, 5],     'optionalInsert' => 1,     'optionalUpdate' => 0, 'dataType' => 'string',  'expectedValue' => null],
                'basePrice'      => ['mapping' => 'base_price',       'updateRole' => [2, 4, 5],     'optionalInsert' => 0,     'optionalUpdate' => 0, 'dataType' => 'float',   'expectedValue' => null],
                'imageUrl'       => ['mapping' => 'image_url',        'updateRole' => [2, 4, 5],     'optionalInsert' => 1,     'optionalUpdate' => 0, 'dataType' => 'string',  'expectedValue' => null],
                'sortOrder'      => ['mapping' => 'sort_order',       'updateRole' => [2, 4, 5],     'optionalInsert' => 1,     'optionalUpdate' => 0, 'dataType' => 'int',     'expectedValue' => null],
                'isAvailable'    => ['mapping' => 'is_available',     'updateRole' => [2, 4, 5, 6],  'optionalInsert' => 1,     'optionalUpdate' => 0, 'dataType' => 'int',     'expectedValue' => [0,1]],
                'availableFrom'  => ['mapping' => 'available_from',   'updateRole' => [2, 4, 5],     'optionalInsert' => 1,     'optionalUpdate' => 0, 'dataType' => 'string',  'expectedValue' => null],
                'availableTo'    => ['mapping' => 'available_to',     'updateRole' => [2, 4, 5],     'optionalInsert' => 1,     'optionalUpdate' => 0, 'dataType' => 'string',  'expectedValue' => null],
                'availableDays'  => ['mapping' => 'available_days',   'updateRole' => [2, 4, 5],     'optionalInsert' => 1,     'optionalUpdate' => 0, 'dataType' => 'string',  'expectedValue' => null],
                'visibilityRule' => ['mapping' => 'visibility_rule',  'updateRole' => [2, 4, 5],     'optionalInsert' => 1,     'optionalUpdate' => 0, 'dataType' => 'string',  'expectedValue' => null],
                'contextTags'    => ['mapping' => 'context_tags',     'updateRole' => [2, 4, 5],     'optionalInsert' => 1,     'optionalUpdate' => 0, 'dataType' => 'string',  'expectedValue' => null],
                'calories'       => ['mapping' => 'calories',         'updateRole' => [2, 4, 5],     'optionalInsert' => 1,     'optionalUpdate' => 0, 'dataType' => 'float',   'expectedValue' => null],
                'proteinGrams'   => ['mapping' => 'protein_grams',    'updateRole' => [2, 4, 5],     'optionalInsert' => 1,     'optionalUpdate' => 0, 'dataType' => 'float',   'expectedValue' => null],
                'fatGrams'       => ['mapping' => 'fat_grams',        'updateRole' => [2, 4, 5],     'optionalInsert' => 1,     'optionalUpdate' => 0, 'dataType' => 'float',   'expectedValue' => null],
                'carbsGrams'     => ['mapping' => 'carbs_grams',      'updateRole' => [2, 4, 5],     'optionalInsert' => 1,     'optionalUpdate' => 0, 'dataType' => 'float',   'expectedValue' => null],
                'sugarGrams'     => ['mapping' => 'sugar_grams',      'updateRole' => [2, 4, 5],     'optionalInsert' => 1,     'optionalUpdate' => 0, 'dataType' => 'float',   'expectedValue' => null],
                'saltGrams'      => ['mapping' => 'salt_grams',       'updateRole' => [2, 4, 5],     'optionalInsert' => 1,     'optionalUpdate' => 0, 'dataType' => 'float',   'expectedValue' => null],
                'tags'           => ['mapping' => 'tags',             'updateRole' => [2, 4, 5],     'optionalInsert' => 1,     'optionalUpdate' => 0, 'dataType' => 'string',  'expectedValue' => null],
                'isDeleted'      => ['mapping' => 'is_deleted',       'updateRole' => [2, 4, 5],     'optionalInsert' => 1,     'optionalUpdate' => 0, 'dataType' => 'int',     'expectedValue' => [0,1]],
            ],
            'relationships' => [],
        ]
    ];

    if (!$table) {
        return $allMappings;
    }

    $table = toSnakeCase($table);
    if (!isset($allMappings[$table])) {
        return null;
    }

    if ($roleId === null) {
        return $allMappings[$table];
    }

    $filtered = [];
    //foreach ($allMappings[$table] as $key => $meta) {
    foreach ($allMappings[$table]['fields'] as $key => $meta) {
        if (in_array($roleId, $meta['updateRole'])) {
            $filtered[$key] = $meta;
        }
    }

    return ['filtered' => $filtered];
}
function updateContent($inputData) {
    $pdo = $inputData['db']['dbApp'];
    $pdo->setAttribute(PDO::ATTR_ERRMODE, PDO::ERRMODE_EXCEPTION);
    try {
        $pdo->beginTransaction(); // Start transaction
        $tableName = toSnakeCase($inputData['table']) ?? null;
        $inputData['dataKey'] = extractDataKeyFromTableName($tableName);
        $changeType = $inputData['recordType'] ?? null;
        // ✅ Check if the extracted data block actually exists
        if (!isset($inputData['dataKey']) || empty($inputData['dataKey'])) {
            $pdo->rollback(); // Rollback transaction
            return ['status' => 'failed', 'message' => "Missing data block for table: {$tableName}"];
        }
        
        // 00: Validate ID, prepare $inputData with idField, id, checkParent
        $res = validateUpdateInputStep($inputData);
        if ($res['status'] !== 'success') {
            $pdo->rollback(); // Rollback transaction
            return $res;
        }

        // 01: check item is not marked as deleted no update is possible
        $inputData['nextOperation'] = 'checkIfDeleted';
        $res = executeDatabaseOperation($inputData);
        if ($res['status'] !== 'success') {
            $pdo->rollback(); // Rollback transaction
            return $res;
        }


    if($changeType === 'delete' || $changeType === 'update') {
        // 02: Fetch existing history data (before change)
        $inputData['nextOperation'] = 'getDataForHistory';
        $res = executeDatabaseOperation($inputData);
        if ($res['status'] !== 'success') {
            $pdo->rollback(); // Rollback transaction
            return $res;
        }
        $inputData['historyData'] = $res['historyData'] ?? null;

        // 03: Insert history record into history table
        $inputData['nextOperation'] = 'saveHistoryRecordStep';
        $res = executeDatabaseOperation($inputData);

        if ($res['status'] !== 'success') {
            $pdo->rollback(); // Rollback transaction
            return $res;
        }
    }
        // 04: check if this is an update or a delete action
        
        if($changeType === 'delete') {
            // check if premission to delete is allowed
            $inputData['nextOperation'] = 'deleteContent';
            $res = executeDatabaseOperation($inputData);
        }

        // 05: check if this is an update or a delete action
        if($changeType === 'update') {
            $inputData['nextOperation'] = 'updateMenuTable';
            $res = executeDatabaseOperation($inputData);
        }

        // 06: check if this is a duplicate action
        if($changeType === 'duplicate') {
            $inputData['nextOperation'] = 'duplicateRecored';
            $res = executeDatabaseOperation($inputData);
        }

        // 07: check if the delete or update was successful
        if($res['status'] !== 'success') {
            $pdo->rollback(); // Rollback transaction
            return $res;
       }

        
        
        $pdo->commit();
        return [ 'status' => 'success','message' => 'Update completed successfully'];
    } catch (Exception $e) {
        $pdo->rollback(); // Rollback transaction on error
        $errorInfo = $e->errorInfo ?? [];
        $errorCode = $errorInfo[1] ?? 0; // SQL error code
        $errorMessage = $e->getMessage();

        // Determine the type of error
        if ($errorCode == 1062) {
            return ['status' => 'failed', 'message' => "Duplicate entry detected: " . $errorMessage];
        } elseif (isset($inputData['debug']) && $inputData['debug'] === $inputData['debugModeFlag ']) {
            return ['status' => 'failed', 'message' => $errorMessage];
        } else {
            return ['status' => 'failed', 'message' => "Unknown failure"];
        }
    }
}
function findIdInData($data, $primaryKey) {
    foreach ($data as $key => $value) {
        if (is_array($value)) {
            // Recurse into sub-arrays
            $found = findIdInData($value, $primaryKey);
            if ($found !== null) {
                return $found;
            }
        } else {
            if ($key === $primaryKey) {
                return $value;
            }
        }
    }
    return null;
}
function validateUpdateInputStep(&$inputData) {
    $table = $inputData['table'] ?? null;
    $tableName = toSnakeCase($table);
    $roleId = $inputData['roleId'] ?? null;
    $dataKey = $inputData['dataKey'];

    if (!$tableName) {
        return ['status' => 'failed', 'message' => 'Table name not specified in input'];
    }

    if (!$dataKey) {
        return ['status' => 'failed', 'message' => 'Data key not extracted from table name'];
    }


    $tableData = $inputData[$dataKey] ?? [];
        
    $map = menuTableColumnMapping($tableName, $roleId);

    $columnMap = $map['filtered'] ?? null;
    
    if (!$columnMap) {
        return ['status' => 'failed', 'message' => 'No column mapping found for table: '. $tableName];
    }

    // 🆕 Find the primary key field
    $primaryKey = null;
    foreach ($columnMap as $key => $meta) {
        if (isset($meta['mapping']) && strtolower($meta['mapping']) === 'id') {
            $primaryKey = $key;
            break;
        }
    }

    if (!$primaryKey) {
        return ['status' => 'failed', 'message' => "No primary key (id) field found for table: {$tableName}"];
    }

    // 🆕 Recursively search for the ID value
    $idValue = findIdInData($tableData, $primaryKey);

    if ($idValue === null || $idValue === '') {
        return ['status' => 'failed', 'message' => "Missing required ID field: {$primaryKey}.{$tableName}", 'dataKey' => $dataKey];
    }

    // Set ID info for future steps
    $inputData['idField'] = $primaryKey;
    $inputData['id'] = $idValue;

    // Set checkParent flag
    $inputData['checkParent'] = array_key_exists('parentId', $columnMap) ? 1 : 0;

    return ['status' => 'success'];
}
function executeDatabaseOperation( $inputData) {
    $operation = $inputData['nextOperation'];
    try {
        $results =  $operation($inputData);
    } catch (PDOException $e) {
        $errorInfo = $e->errorInfo ?? [];
        $errorCode = $errorInfo[1] ?? 0; // SQL error code
        $errorMessage = $e->getMessage();

        // Determine the type of error
        if ($errorCode == 1062) {
            $results =  ['status' => 'failed', 'message' => "Duplicate entry detected: " . $errorMessage];
        } elseif (isset($inputData['debug']) && $inputData['debug'] === $inputData['debugModeFlag ']) {
            $results = ['status' => 'failed', 'message' => $errorMessage];
        }else{
            $results = ['status' => 'failed', 'message' => "Unknown failure"];
        }
    }
    return $results;
}
function convertKeysToCamelCase($array) {
    $converted = [];

    foreach ($array as $key => $value) {
        // Convert snake_case to camelCase
        $camelKey = preg_replace_callback('/_([a-z])/', function ($matches) {
            return strtoupper($matches[1]);
        }, $key);

        // Lowercase first character to enforce camelCase
        $camelKey = lcfirst($camelKey);

        // Recursively handle nested arrays
        if (is_array($value)) {
            $converted[$camelKey] = convertKeysToCamelCase($value);
        } else {
            $converted[$camelKey] = $value;
        }
    }

    return $converted;
}
function toSnakeCase($input) {
    return strtolower(preg_replace('/([a-z])([A-Z])/', '$1_$2', $input));
}
function renameIdKeys($array, $newKeyName) {
    $converted = [];

    foreach ($array as $key => $value) {
        // Recursively handle nested arrays
        if (is_array($value)) {
            $value = renameIdKeys($value, $newKeyName);
        }

        if ($key === 'id') {
            $converted[$newKeyName] = $value;
        } else {
            $converted[$key] = $value;
        }
    }

    return $converted;
}
function extractDataKeyFromTableName($tableName) {
    $parts = explode('_', $tableName, 2);
    $base = $parts[1] ?? $tableName;

    $baseParts = explode('_', $base);

    $camelCase = array_shift($baseParts);

    foreach ($baseParts as $part) {
        $camelCase .= ucfirst($part);
    }

    return $camelCase;
}
function roleViewType($roleId) {
    if(in_array($roleId, [1, 2, 3])) {
        return 'sysAdmin';
    } elseif($roleId == 4) {
        return 'owner';
    } elseif($roleId == 5) {
        return 'manager';
    } elseif($roleId == 6) {
        return 'staff';
    } else{
        return 'guest';
    }
}
?>