<?php
    function insertIntoMenuTable($inputData) {
        $pdo = $inputData['db']['dbApp'];
        $pdo->setAttribute(PDO::ATTR_ERRMODE, PDO::ERRMODE_EXCEPTION);

        $table = $inputData['table'] ?? null;
        $table = toSnakeCase($table);
        $roleId = $inputData['roleId'] ?? 0;
        $dataKey = extractDataKeyFromTableName($inputData['table']);
        $data = $inputData[$dataKey] ?? [];
        
        if (!$table) {
            return ['status' => 'failed', 'message' => 'Table not specified'];
        }
        

        $map = menuTableColumnMapping($table, $roleId);

        $columnMap = $map['filtered'] ?? null;

        if (!$columnMap) {
            return ['status' => 'failed', 'message' => 'Invalid table or insufficient permissions'];
        }
        
        $insertData = [];
        $errors = [];
        
        foreach ($columnMap as $key => $meta) {
            // Skip if optionalInsert is null (e.g., auto-increment ID)
            if (array_key_exists('optionalInsert', $meta) && $meta['optionalInsert'] === null) {
                continue;
            }
            
            $dbField = $meta['mapping'] ?? null;
            if (!$dbField) {
                continue; // No valid mapping
            }
            
            if (!isset($data[$key]) || $data[$key] === '') {
                if (!empty($meta['optionalInsert']) && $meta['optionalInsert'] == 1) {
                    // Field is optional, allow skipping
                    continue;
                }
                // Field is required, error
                $errors[] = "$key is required";
            } else {
                $insertData[$dbField] = $data[$key];
            }
        }
        
        if (!empty($errors)) {
            return [
                'status' => 'failed',
                'message' => implode(', ', $errors)
            ];
        }
        
        if (empty($insertData)) {
            return [
                'status' => 'failed',
                'message' => 'No valid data to insert'
            ];
        }
        
        $columns = implode(', ', array_keys($insertData));
        $placeholders = implode(', ', array_map(fn($k) => ':' . $k, array_keys($insertData)));
        
    
        $sql = "INSERT INTO {$table} ($columns) VALUES ($placeholders)";
        $stmt = $pdo->prepare($sql);

        foreach ($insertData as $key => $value) {
            $stmt->bindValue(":$key", $value);
        }

        $stmt->execute();
        $lastInsertId = $pdo->lastInsertId();

        return [
            'status' => 'success',
            'message' => 'Record inserted successfully',
            'id' => $lastInsertId
        ];
    }
    function saveHistoryRecordStep($inputData){
        $pdo = $inputData['db']['dbApp'];
        $pdo->setAttribute(PDO::ATTR_ERRMODE, PDO::ERRMODE_EXCEPTION);
        $table              = 'menu_history';
        $changeType         = $inputData['recordType'];
        $toJsonhistoryData  = json_encode($inputData['historyData'], JSON_PRETTY_PRINT);
        $tableOfSource      = toSnakeCase($inputData['table']);

        $sql = "INSERT INTO {$table} (tenant_id, action_type, table_of_source, old_value, action_by) VALUES (:tenantId, :actionType, :tableOfSource, :historyData, :actionBy)";
        $stmt = $pdo->prepare($sql);
        $stmt->bindValue(':tenantId', $inputData['tenantId'], PDO::PARAM_INT);
        $stmt->bindValue(':actionType', $changeType, PDO::PARAM_STR);
        $stmt->bindValue(':tableOfSource', $tableOfSource, PDO::PARAM_STR);
        $stmt->bindValue(':historyData', $toJsonhistoryData, PDO::PARAM_STR);
        $stmt->bindValue(':actionBy', $inputData['userId'], PDO::PARAM_INT);
        $stmt->execute();
        $lastInsertId = $pdo->lastInsertId();
        return [
            'status' => 'success',
            'message' => 'History record saved successfully',
            'id' => $lastInsertId
        ];
    }
    function duplicateRecored($inputData){
        return ['status' => 'success', 'message' => 'Duplicate record not allowed'];
    }
    
?>