
# 🍽️ Orbit Menu Module — Functional Specification

This document outlines all recommended functions for managing and interacting with the `orbit-menu` schema, grouped by user role and purpose.

---

## 🔧 SYSTEM ADMIN FUNCTIONS

### Menu Structure Management
- `admin_create_menu($tenantId, $menuData)`
- `admin_update_menu($menuId, $updates)`
- `admin_set_active_menu($tenantId, $menuId)`
- `admin_duplicate_menu($menuId)`

### Global Compliance
- `admin_add_allergen($data)`
- `admin_update_allergen($id, $data)`
- `admin_view_all_allergens()`

### Translations
- `admin_add_translation($entityType, $entityId, $locale, $data)`
- `admin_get_translations($entityType, $entityId)`

---

## 🏪 RESTAURANT OWNER FUNCTIONS

### Menu Setup
- `owner_create_category($menuId, $data)`
- `owner_create_item($menuId, $categoryId, $itemData)`
- `owner_update_item($itemId, $data)`
- `owner_set_item_availability($itemId, $available)`

### Customization
- `owner_add_variant($itemId, $variantData)`
- `owner_add_item_allergens($itemId, $allergenIds)`
- `owner_define_nutrition($itemId, $nutritionData)`

### Meal Combos
- `owner_create_meal($menuId, $mealData)`
- `owner_add_fixed_items_to_meal($mealId, $itemList)`
- `owner_create_option_group($mealId, $groupData)`
- `owner_add_items_to_option_group($groupId, $itemList)`

### Public Control
- `owner_set_menu_visibility($menuId, $rule)`
- `owner_schedule_item($itemId, $from, $to, $days)`
- `owner_add_context_tag($itemId, $contextArray)`

---

## 🌐 PUBLIC VIEWER FUNCTIONS

### Dynamic Menu Retrieval
- `get_active_menu($tenantId, $locale = 'en', $context = null, $datetime = null)`

### Menu Details
- `get_menu_structure($menuId)`
- `get_meal_builder_config($mealId)`

---

## 🧮 UTILITY FUNCTIONS

- `get_item_allergens($itemId)`
- `get_meal_allergens($mealId)`
- `compute_meal_price($mealId, $selectedItemIds[])`
- `get_context_filtered_items($tenantId, $context, $time, $day)`

---

## ✅ FUNCTION IMPLEMENTATION CHECKLIST

| Function Name                          | Built ✔ / ✘ |
|----------------------------------------|-------------|
| admin_create_menu                      | ✔           |
| admin_update_menu                      | ✔           |
| admin_delete_menu                      | ✔           |
| admin_set_active_menu                  | ✘           |
| admin_duplicate_menu                   | ✘           |
| admin_add_allergen                     | ✘           |
| admin_update_allergen                  | ✘           |
| admin_view_all_allergens               | ✘           |
| admin_add_translation                  | ✘           |
| admin_get_translations                 | ✘           |
| owner_create_category                  | ✘           |
| owner_create_item                      | ✘           |
| owner_update_item                      | ✘           |
| owner_set_item_availability            | ✘           |
| owner_add_variant                      | ✘           |
| owner_add_item_allergens               | ✘           |
| owner_define_nutrition                 | ✘           |
| owner_create_meal                      | ✘           |
| owner_add_fixed_items_to_meal          | ✘           |
| owner_create_option_group              | ✘           |
| owner_add_items_to_option_group        | ✘           |
| owner_set_menu_visibility              | ✘           |
| owner_schedule_item                    | ✘           |
| owner_add_context_tag                  | ✘           |
| get_active_menu                        | ✘           |
| get_menu_structure                     | ✘           |
| get_meal_builder_config                | ✘           |
| get_item_allergens                     | ✘           |
| get_meal_allergens                     | ✘           |
| compute_meal_price                     | ✘           |
| get_context_filtered_items             | ✘           |
| view_menu_top_level                    | ✘           |
