<?php

    namespace Azui\Orbit\FoodMenu;

    function updateMenuTable($inputData) {
        $pdo = $inputData['db']['dbApp'];
        $pdo->setAttribute(\PDO::ATTR_ERRMODE, \PDO::ERRMODE_EXCEPTION);

        $table = $inputData['table'] ?? null;
        $roleId = $inputData['roleId'] ?? 0;
        $dataKey = $inputData['dataKey'];
        $data = $inputData[$dataKey] ?? [];
        $idField = $inputData['idField'] ?? 'id'; // Default to 'id' unless specified
        $tableName = $inputData['table'] ?? null;
        $table = toSnakeCase($table);
        if (!$table) {
            return ['status' => 'failed', 'message' => 'Table not specified'];
        }

        $map = menuTableColumnMapping($table, $roleId);
        $columnMap = $map['filtered'] ?? null;

        if (!$columnMap) {
            return ['status' => 'failed', 'message' => 'Invalid table or insufficient permissions'];
        }

        $updateParts = [];
        $bindParams = [];
        $errors = [];

        foreach ($columnMap as $key => $meta) {
            // Skip fields with optionalUpdate === null (cannot update)
            if (array_key_exists('optionalUpdate', $meta) && $meta['optionalUpdate'] === null) {
                continue;
            }

            $dbField = $meta['mapping'] ?? null;
            if (!$dbField) {
                continue;
            }

            if ($key === $idField || $dbField === $idField) {
                continue;
            } 

            if (isset($data[$key])) {
                // Check if the user role is allowed to update this field
                if (!in_array($roleId, $meta['updateRole'] ?? [])) {
                    $errors[] = "Role $roleId not allowed to update $key";
                    continue;
                }

                $updateParts[] = "$dbField = :$key";
                $bindParams[$key] = $data[$key];
            } else {
                if (!empty($meta['optionalUpdate']) && $meta['optionalUpdate'] == 1) {
                    // Field is optional for update, OK to skip
                    continue;
                }
                // If field is required and not present, error (optional, depends how strict you want update to be)
            }
        }

        if (!empty($errors)) {
            return [
                'status' => 'failed',
                'message' => implode(', ', $errors)
            ];
        }

        if (empty($updateParts)) {
            return [
                'status' => 'failed',
                'message' => 'No valid fields to update'
            ];
        }

        // if the $updateParts is empty or only contains the idField, we cannot update
        if (count($updateParts) === 1 && in_array("$idField = :id", $updateParts)) {
            return [
                'status' => 'failed',
                'message' => 'No fields to update other than ID'
            ];
        }

        $rowId = $data[$idField] ?? null;
        if ($rowId === null) {
            return [
                'status' => 'failed',
                'message' => "Missing $idField value for WHERE clause"
            ];
        }

        if($table == 'menu_menus'){
            if(isset($data['isActive']) && $data['isActive'] == 1){
                if(in_array('isActive', array_keys($columnMap))){    
                    $tempRes = disableAnyActive($inputData, $table); // empty string as may break update function
                    if($tempRes['status'] == 'failed'){  
                        return ['res' => $tempRes];
                    }
                }
                    
            }
        }
        
        // Build SQL
        $setClause = implode(', ', $updateParts);
        $whereClause = "{$idField} = :id";
        $sql = "UPDATE {$table} SET {$setClause} WHERE {$whereClause}";

        $stmt = $pdo->prepare($sql);

        foreach ($bindParams as $param => $value) {
            $stmt->bindValue(":$param", $value);
        }
        $stmt->bindValue(":id", $rowId);

        $stmt->execute();

        if ($stmt->rowCount() === 0) {
            return [
                'status' => 'failed',
                'message' => "No rows updated. Data may be identical or {$idField} not found."
            ];
        }

        return [
            'status' => 'success',
            'message' => 'Record updated successfully'
        ];
    }
    function deleteContent($inputData) {
        $pdo = $inputData['db']['dbApp'];
        $pdo->setAttribute(\PDO::ATTR_ERRMODE, \PDO::ERRMODE_EXCEPTION);

        // Step 1: Validate table, id, and data structure
        $res = validateUpdateInputStep($inputData);
        if ($res['status'] !== 'success') {
            $pdo->rollback();
            return $res;
        }

        $tableName = toSnakeCase($inputData['table']);
        
        //$tableName =   //$inputData['table'];
        $roleId = $inputData['roleId'];
        $dataKey = $inputData['dataKey'];
        $tableData = $inputData[$dataKey];
        $idField = $inputData['idField'];
        $idValue = $inputData['id'];
        $extraSetsSql = "  ";

        // Step 2: Check if record exists and is not already deleted
        $checkSql = "SELECT is_deleted FROM {$tableName} WHERE {$idField} = :id LIMIT 1";
        $checkStmt = $pdo->prepare($checkSql);
        $checkStmt->bindValue(':id', $idValue);
        $checkStmt->execute();
        $record = $checkStmt->fetch(\PDO::FETCH_ASSOC);

        if (!$record) {
            $pdo->rollback();
            return ['status' => 'failed', 'message' => "Record not found for ID {$idValue}"];
        }

        if (!empty($record['is_deleted'])) {
            $pdo->rollback();
            return ['status' => 'failed', 'message' => "Record with ID {$idValue} is already deleted"];
        }

        // Step 3: Check user permission to update (delete is an update of is_deleted field)
        $map = menuTableColumnMapping($tableName, $roleId);
        $columnMap = $map['filtered'] ?? null;
        
        if (!$columnMap || !isset($columnMap['isDeleted'])) {
            $pdo->rollback();
            return ['status' => 'failed', 'message' => "Delete permission configuration missing for {$tableName}"];
        }

        if (!in_array($roleId, $columnMap['isDeleted']['updateRole'] ?? [])) {
            $pdo->rollback();
            return ['status' => 'failed', 'message' => "User role not permitted to delete this record"];
        }

        // Step 4: check if there is an is_active field and if it is set to 0 then do delete
        if(in_array('isActive', array_keys($columnMap))){
            $extraSetsSql .= " , is_active = 0 ";
        }

        // Step 5: Perform the soft delete
        $sql = "UPDATE {$tableName} SET is_deleted = 1 {$extraSetsSql} WHERE {$idField} = :id";
        $stmt = $pdo->prepare($sql);
        $stmt->bindValue(":id", $idValue);
        $stmt->execute();

        if ($stmt->rowCount() === 0) {
            $pdo->rollback();
            return ['status' => 'failed', 'message' => "Failed to delete record with ID {$idValue}"];
        }

        return ['status' => 'success', 'message' => 'Record marked as deleted successfully'];
    }
    function disableAnyActive($inputData, $tableName){
            $tenantId = $inputData['tenantId'];
            $pdo = $inputData['db']['dbApp'];
            $pdo->setAttribute(\PDO::ATTR_ERRMODE, \PDO::ERRMODE_EXCEPTION);

            // Step 1: check if there are any reccords that match our condition

            $sql = "select count(*) as count from $tableName where tenant_id = :tenantId and is_deleted = 0";
            $stmt = $pdo->prepare($sql);
            $stmt->bindParam(':tenantId', $tenantId);
            $stmt->execute();
            $result = $stmt->fetch(\PDO::FETCH_ASSOC);
            $rowCount = $result['count'];
            if($rowCount == 0){
                return [
                    'status' => 'success',
                    'message' => 'No rows found.',
                    'tenantId' => $tenantId,
                    'tableName' => $tableName
                ];
            }else{
                // Step 2: update all recoreds to is_applied = 'no' where is_applied = 'yes' and tenant_id = :tenantId and status = 'draft'
                $sql = "update $tableName set is_active = '0'  where is_active = '1' and tenant_id = :tenantId and is_deleted = 0";
                $stmt = $pdo->prepare($sql);
                $stmt->bindParam(':tenantId', $tenantId);
                $stmt->execute();
                // Step 3: count how many rows are updated
                $rowCount = $stmt->rowCount();
                if ($rowCount === 0) {
                    return [
                        'status' => 'Success',
                        'message' => 'No rows updated. None match requierments.'
                    ];
                }else{
                    // rows updated successfully message
                    return [
                        'status' => 'success',
                        'message' => 'Rows updated successfully.',
                        'rowCount' => $rowCount
                    ];
                }


                return [
                    'status' => 'success',
                    'message' => 'Rows found.',
                    'rowCount' => $rowCount
                ];
            }
    }
?>