# Menu API Interface Specification

---

## Overview

This document outlines the API contract for managing menu configurations in the system. It includes endpoints for creating, updating, deleting, viewing, and duplicating menu entries (`menu_menus`). All requests are processed through a single PHP entry point (`function.php`) using `POST` requests, with operations determined by the `action` field in the payload.

---

## API Summary Table

| Action                        | Method    | Auth Required | Payload Object                                            | Description                                                     |
|-------------------------------|-----------|---------------|-----------------------------------------------------------|-----------------------------------------------------------------|
| [`insertIntoMenuMenus`](#insertIntoMenuMenus)         | POST      | Yes           | `menuMenus`                                               | Insert a new menu item                                          |
| [`insertIntoMenuCategories`](#insertIntoMenuCategories)    | POST      | Yes           | `menuCategories`                                          | Insert a new Categories                                         |
| [`insertItemIntoMenu`](#insertItemIntoMenu)          | POST      | Yes           | `menuItems`                                               | Insert a new Categories                                         |
| [`insertItemIntoMenuCategory`](#insertItemIntoMenuCategory)  | POST      | Yes           | `menuCategoryItems`                                       | Insert a link between an item and a Category                    |
| [`insertMenuOptionsSet`](#insertMenuOptionsSet)        | POST      | Yes           | `menuOptionGroups`, `menuOptionExtra`, `menuOptionJoins`  | Insert a link between an item and options and option items      |
| [`insertMenuOptionExtra`](#insertMenuOptionExtra)       | POST      | Yes           | `menuOptionExtra`                                         | Insert a option items                                           |
| [`insertMenuOptionJoins`](#insertMenuOptionJoins)       | POST      | Yes           | `menuOptionJoins`                                         | Insert a linki to an option group and item option               |
| [`insertMenuLinkOptions`](#insertMenuLinkOptions)       | POST      | Yes           | `insertMenuLinkOptions                                    | Insert a link betwwen item and option group                     |
| [`updateMenuMenus`](#updateMenuMenus)             | POST      | Yes           | `menuMenus`                                               | Update an existing menu item                                    |
| [`updateMenuCategories`](#updateMenuCategories)        | POST      | Yes           | `categories`                                              | Update an existing Categories                                   |
| [`updateMenuItems`](#updateMenuItems)             | POST      | Yes           | `items`                                                   | Update an existing item                                         |
| [`updateMenuCategoryItems`](#updateMenuCategoryItems)     | POST      | Yes           | `categoryItems`                                           | Update the active status                                        |
| [`updateMenuOptionGroup`](#updateMenuOptionGroup)       | POST      | Yes           | `optionGroups`                                            | Update the opton values                                         |
| [`updateMenuOptionExtra`](#updateMenuOptionExtra)       | POST      | Yes           | `optionExtra`                                             | Update the option item values                                   |
| [`updateMenuOptionJoins`](#updateMenuOptionJoins)       | POST      | Yes           | `optionJoins`                                             | Update the option item values                                   |
| [`updateMenuLinkOptions`](#updateMenuLinkOptions)       | POST      | Yes           | `itemToOptions`                                           | Update the join to enable or dissabled                          |
| [`deleteMenuMenus`](#deleteMenuMenus)             | POST      | Yes           | `menuMenus`                                               | Soft-delete a menu                                              |
| [`deleteMenuCategories`](#deleteMenuCategories)        | POST      | Yes           | `categories`                                              | Soft-delete a menu Categories items                             |
| [`deleteMenuItems`](#deleteMenuItems)             | POST      | Yes           | `items`                                                   | Soft-delete a items                                             |
| [`deleteMenuCategoryItems`](#deleteMenuCategoryItems)     | POST      | Yes           | `categoryItems`                                           | Soft-delete a category Items                                    |
| [`deleteMenuOptionExtra`](#deleteMenuOptionItem)       | POST      | Yes           | `optionItems`                                             | Soft-delete a option Items                                      |
| [`deleteMenuOptionGroup`](#deleteMenuOptionGroup)       | POST      | Yes           | `optionGroups`                                            | Soft-delete a option group                                      |
| [`deleteMenuOptionJoins`](#deleteMenuLinkOptions)       | POST      | Yes           | `optionJoins`                                             | Soft-delete a join group                                        |
| [`deleteMenuLinkOptions`](#deleteMenuLinkOptions)       | POST      | Yes           | `itemToOptions`                                           | Soft-delete a join group and menu Item                          |
| ~~`viewMenuMenus`~~           |~~ GET ~~ | ~~No~~         | —                                                         | ~~View menu items available to the user's role and tenant~~     |
| [`viewSuperAdminMenus`](#viewSuperAdminMenus)         | GET       | Yes           | —                                                         | View Menu                                                       |
| [`viewAdminMenus`](#viewAdminMenus)              | GET       | Yes           | —                                                         | View Menu                                                       |
| [`viewPublicMenus`](#viewPublicMenus)             | GET       | No            | —                                                         | View Menu                                                       |
| [`viewItemExtras`](#viewItemExtras)              | GET       | No            | —                                                         | View Extra list relating to a tennant                           |
| [`viewMenuGroups`](#viewMenuGroups)              | GET       | Yes           |                                                           | Get list of all non deleted option groups                       |
| [`duplicateMenuMenus`](#duplicateMenuMenus)          | POST      | Yes           | `menuMenus`                                               | Duplicate a menu by ID (Owner only)   __(Not Implemented)__     |

---
## Adding an extra

### New Group and Extras:
call [`viewItemExtras`](#viewItemExtras) to get current insert extra options 
use function [`insertMenuOptionsSet`](#insertMenuOptionsSet) 
  Place into the ``menuOptionGroups``: itemId and other needed data
  Place into ``menuOptionExtra`` any new extras that dont exist 
  Place into ``menuOptionJoins`` any pre existing extras

### Adding a prexisting extra to a pre existing group 
if the extra allready exist and you want to add to group call: [`viewItemExtras`](#viewItemExtras)
Then place into the [`menuOptionJoins`](#insertMenuOptionJoins) the extraId and other Data 

### Add a new extra to a pre existing group
insert a new extra by calling [`insertMenuOptionExtra`](#insertMenuOptionExtra) use the returned id and the current groupId with [`menuOptionJoins`](#insertMenuOptionJoins) to link them

### To update a price
to update the price for an extra that is linked to the group uses the [`updateMenuOptionJoins`](#updateMenuOptionJoins) function call
to update the default price which currenlty does nothing but helps with the intital build uses [`updateMenuOptionExtra`](#updateMenuOptionExtra)

---

## Payload Structures

### <a id="insertIntoMenuMenus"></a>`insertIntoMenuMenus`
```json
{
  "action": "insertIntoMenuMenus",
  "menuMenus": {
    "name": "Main Menu",
    "description": "Primary navigation",
    "isActive": 1,
  }
}
```

### <a id="insertIntoMenuCategories"></a>`insertIntoMenuCategories`
```json
{
  "action": "insertIntoMenuCategories",
  "menuCategories": {
    "menuId":       int,
    "parentId":     int optional,
    "name":         string,
    "description":  string,
    "isActive" :    int (0,1),
    "sortOrder" :   int optional,
    "isDeleted" :   int (0,1) optional
  }
}
```

### <a id="insertItemIntoMenu"></a>`insertItemIntoMenu`
```json
{
  "action": "insertItemIntoMenu", // Suggested otherwise this item is not linked to a menu and will be need to be linked another way
  "menuItems": {
    "menuId":       int,
    "categoryId":   int,
    "name":         string,
    "description":  string,
    "basePrice" :   decimal,
    "isActive" :    int optional,
  }
}
```

### <a id="insertItemIntoMenuCategory"></a>`insertItemIntoMenuCategory`
```json
{
  "action": "insertItemIntoMenuCategory",
  "menuCategoryItems": {
    "categoryId": int,
    "itemId":     int
  }
}
```

### <a id="insertMenuOptionsSet"></a>`insertMenuOptionsSet`
```json
{
  "action": "insertMenuOptionsSet",
  "menuOptionGroups": {
    "groupName":        string,
    "groupDescription": string,
    "minSelect":        int,      // Minumun that can be selcted in the grouping  
    "maxSelect":        int,      // Maximun that can be selcted in the grouping  
    "isRequired":       int,      // [0|1]
    "isActive":         int
  },
  "menuOptionExtra": { // optional 
      {
          "extraName":         string,
          "extraDescription":  string,
          "isDefault":         int,
          "priceAdjustment":   decimal,
          "isActive":          int
      },{
          "extraName":         string,
          "extraDescription":  string,
          "isDefault":         int,
          "priceAdjustment":   decimal,
          "isActive":          int
      },
      {...},
  },
  "menuOptionJoins":{ // optional
    {
      "extraId":           int,
      "isActive":          int, (0|1)
      "isDefault":         int,
      "priceAdjustment":   decimal,
    },
    {...}
  }
}
```

### <a id="insertMenuOptionExtra"></a>`insertMenuOptionExtra`
```json
{
  "action": "insertMenuOptionExtra",
  "menuOptionExtra": {
    "extraName":          string,
    "extraDescription":   string,
    "priceAdjustment":    decimal,
    "isActive":           int
  }
}
```

### <a id="insertMenuOptionJoins"></a>`insertMenuOptionJoins`
```json
{
  "action": "insertMenuOptionJoins",
  "menuOptionJoins": {
    "extraId":            int,
    "groupId":            int,
    "priceAdjustment":    decimal, // optional if a price is available 
    "is_default"     :    int (0|1),
    "isActive":           int
  }
}
```


### <a id="insertMenuLinkOptions"></a>`insertMenuLinkOptions`
```json
{
  "action" : "insertMenuLinkOptions",
  "menuItemToOptions": {
    "itemId":             int,
    "groupId":            int,
    "isActive":           int
  }
}
```


### <a id="updateMenuMenus"></a>`updateMenuMenus`
```json
{
  "action": "updateMenuMenus",
  "menus": {
    "id":           int,
    "name":         string optional,
    "description":  string optional,
    "isActive":     int    optional,
  }
}
```

### <a id="updateMenuCategories"></a>`updateMenuCategories`
```json
{
  "action": "updateMenuCategories",
  "categories": {
    "id":           int,
    "menuId":       int    optional,  
    "parentId":     int    optional,
    "name":         string optional,
    "description":  string optional,
    "isActive":     int    optional,
  }
}
```

### <a id="updateMenuItems"></a>`updateMenuItems`
```json
{
  "action": "updateMenuItems",
  "items": {
    "id":               int,
    "categoryId":       int     optional,
    "itemName":         string  optional,
    "itemDescription":  string  optional,
    "basePrice" :       decimal optional,
    "isActive" :        int     optional,
  }
}
```

### <a id="updateMenuCategoryItems"></a>`updateMenuCategoryItems`
```json
{
  "action": "updateMenuCategoryItems",
  "categoryItems": {
    "id":       int,
    "isActive": int (0|1),
  }
}
```

### <a id="updateMenuOptionGroup"></a>`updateMenuOptionGroup`
```json
{
  "action": "updateMenuOptionGroup",
  "optionGroups": {
    "id":               int,
    "groupName":        string optional,
    "groupDescription": string optional,
    "minSelect":        int optional,
    "maxSelect":        int optional,
    "isActive":         int (0|1) int optional
  }
}
```

-- this will update the default one but wont change the live prices 
### <a id="updateMenuOptionExtra"></a>`updateMenuOptionExtra`
```json
{
  "action": "updateMenuOptionExtra",
  "optionExtra": {
    "id":                 int,
    "extraName":          string    optional,
    "extraDiscription":   string    optional,
    "isDefault":          int       optional,
    "priceAdjustment":    decimal   optional,
    "isActive":           int (0|1) optional, 
  }
}
```

-- this will update the current price value 
### <a id="updateMenuOptionJoins"></a>`updateMenuOptionJoins`
```json
{
  "action": "optionJoins",
  "categoryItems": {
    "id":       int,
    "isActive": int (0|1),
    "isDefault":          int       optional,
    "priceAdjustment":    decimal   optional,
  }
}
```

### <a id="updateMenuLinkOptions"></a>`updateMenuLinkOptions`
```json
{
  "action":"updateMenuLinkOptions",
  "itemToOptions":{
    "id": int,
    "isActive": int (0|1)
  }
}
```

### <a id="deleteMenuMenus"></a>`deleteMenuMenus`
```json
{
  "action": "deleteMenuMenus",
  "menus": {
    "id": int
  }
}
```

### <a id="deleteMenuCategories"></a>`deleteMenuCategories`
```json
{
  "action": "deleteMenuCategories",
  "categories": {
    "id": int
  }
}
```

### <a id="deleteMenuItems"></a>`deleteMenuItems`
```json
{
  "action": "deleteMenuItems",
  "items": {
    "id": int
  }
}
```

### <a id="deleteMenuCategoryItems"></a>`deleteMenuCategoryItems`
```json
{
  "action": "deleteMenuCategoryItems",
  "categories": {
    "id": int
  }
}
```

### <a id="deleteMenuOptionItem"></a>`deleteMenuOptionItem`
```json
{
  "action": "deleteMenuOptionItem",
  "optionItems": {
    "id": int
  }
}
```

### <a id="deleteMenuOptionGroup"></a>`deleteMenuOptionGroup`
```json
{
  "action": "deleteMenuOptionGroup",
  "optionGroups": {
    "id": int
  }
}
```

### <a id="deleteMenuLinkOptions"></a>`deleteMenuLinkOptions`
```json
{
  "action": "deleteMenuLinkOptions",
  "itemToOptions" :{
    "id": int
  }
}
```

### <a id="viewSuperAdminMenus"></a>`viewSuperAdminMenus`
```json
{
  "action": "viewSuperAdminMenus"
}
```

### <a id="viewAdminMenus"></a>`viewAdminMenus`
```json
{
  "action": "viewAdminMenus"
}
```

### <a id="viewPublicMenus"></a>`viewPublicMenus`
```json
{
  "action": "viewPublicMenus"
}
```

### <a id="viewMenuMenus"></a>`viewMenuMenus`
```json
{
  "action": "viewMenuMenus"
}
```


### <a id="viewItemExtras"></a>`viewItemExtras`
```json
{
  "action": "viewItemExtras"
}
```

### <a id="viewMenuGroups"></a>`viewMenuGroups`
```json
{
  "action": "viewMenuGroups"
}
```

### <a id="duplicateMenuMenus"></a>`duplicateMenuMenus`
```json
{
  "action": "duplicateMenuMenus",
  "menuMenus": {
    "menueId": 7
  }
}
```

---

## Response Format

### Success
```json
{
  "status": "success",
  "message": "Record inserted successfully"
}
```

### Failure
```json
{
  "status": "failed",
  "message": "Access denied: insufficient permissions"
}
```

---

## Permissions and Role Behavior

| Role         | Can Insert | Can Update | Can Delete | Can View | Can Duplicate |
|--------------|------------|------------|------------|----------|---------------|
| Owner (4)    | ✅         | ✅         | ✅         | ✅       | ✅            |
| SysAdmin (1) | ❌         | ❌         | ❌         | ✅       | ❌            |
| Public (0)   | ❌         | ❌         | ❌         | ✅ (limited) | ❌        |

- All actions require the user to be authenticated and belong to a valid tenant.
- Insert/update/delete actions log entries into `menu_history` for auditing.

---

## Notes

- Menu items are soft-deleted by setting the `is_deleted` flag.
- `themeStatus` is optional and only used when applicable.
- Update and delete operations require the `id` field.
- Owner role has full CRUD access; other roles have restrictions.
- Returned timestamps (`createdAt`, `updatedAt`) are dynamic and ISO formatted.
- Duplicate and insert actions will return specific error messages if permissions are insufficient.

## Work Flows 

- Insert a new option group then view.
  - [`insertMenuOptionsSet`](#insertMenuOptionsSet) → [`viewMenuGroups`](#viewMenuGroups)

- Insert an option group then insert a new option extra and join to option group.
  - [`insertMenuOptionsSet`](#insertMenuOptionsSet) → [`insertMenuOptionExtra`](#insertMenuOptionExtra) → [`insertMenuOptionJoins`](#insertMenuOptionJoins) → [`viewMenuGroups`](#viewMenuGroups)

- Insert an option group then view an existing option extra and join to option group.
  - [`insertMenuOptionsSet`](#insertMenuOptionsSet) → [`viewItemExtras`](#viewItemExtras) → [`insertMenuOptionJoins`](#insertMenuOptionJoins) → [`viewMenuGroups`](#viewMenuGroups)

- View all current Extras, Create a new option group adding some of the extras and or creating new ones via the option set insert method.
  - [`viewItemExtras`](#viewItemExtras) → [`insertMenuOptionsSet`](#insertMenuOptionsSet) →  [`viewMenuGroups`](#viewMenuGroups)

- Insert an exsiting option into an exisintg option group
  - [`viewItemExtras`](#viewItemExtras) → [`insertMenuOptionJoins`](#insertMenuOptionJoins) → [`viewMenuGroups`](#viewMenuGroups)

- Join an option group with an Item 
  - [`viewMenuGroups`](#viewMenuGroups) + ([`viewAdminMenus`](#viewAdminMenus) | [`viewSuperAdminMenus`](#viewSuperAdminMenus) ) → [`insertMenuLinkOptions`](#insertMenuLinkOptions)


_End of Document_
