-- Guest User Table
CREATE TABLE food_order_guest_user (
    id INT AUTO_INCREMENT PRIMARY KEY,
    f_name VARCHAR(50),
    l_name VARCHAR(50),
    phone_number VARCHAR(25),
    user_email VARCHAR(254),
    created_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP,
    updated_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP
);

-- Address Table
CREATE TABLE food_order_address (
    id INT AUTO_INCREMENT PRIMARY KEY,
    address_line_1 VARCHAR(255),
    address_line_2 VARCHAR(255),
    city VARCHAR(100),
    state VARCHAR(100),
    country VARCHAR(100),
    postal_code VARCHAR(20),
    created_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP,
    updated_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP
);

-- Order Table
CREATE TABLE food_order_order (
    id INT AUTO_INCREMENT PRIMARY KEY,
    user_id INT DEFAULT NULL,
    guest_user_id INT DEFAULT NULL,
    tenant_id INT NOT NULL,
    delivery_address_id INT,
    billing_address_id INT,
    order_status ENUM('pending', 'completed', 'cancelled') NOT NULL DEFAULT 'pending',
    order_type ENUM('delivery', 'pickup', 'dine-in') NOT NULL DEFAULT 'delivery',
    total_order_price DECIMAL(10,2) NOT NULL DEFAULT 0.00,
    total_order_modified_price DECIMAL(10,2),
    total_order_modified_reason VARCHAR(255),
    payment_status ENUM('unpaid', 'paid', 'refunded', 'partial_refund') NOT NULL DEFAULT 'unpaid',
    comment TEXT,
    tenant_comment TEXT,
    currency VARCHAR(3) DEFAULT 'GBP',
    transaction_id VARCHAR(64),
    created_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP,
    updated_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
    CONSTRAINT chk_user_guest CHECK (
        (user_id IS NOT NULL AND guest_user_id IS NULL) OR
        (user_id IS NULL AND guest_user_id IS NOT NULL)
    )
    FOREIGN KEY (guest_user_id) REFERENCES food_order_guest_user(id),
    FOREIGN KEY (delivery_address_id) REFERENCES food_order_address(id),    
    FOREIGN KEY (billing_address_id) REFERENCES food_order_address(id),);

-- Item Table
CREATE TABLE food_order_item (
    id INT AUTO_INCREMENT PRIMARY KEY,
    order_id INT NOT NULL,
    menu_item_id INT NOT NULL,
    item_name VARCHAR(255),
    item_base_price DECIMAL(10,2),
    item_modified_price DECIMAL(10,2),
    item_modified_reason VARCHAR(255),
    item_quantity INT NOT NULL DEFAULT 1,
    item_note TEXT,
    item_status ENUM('pending', 'prepared', 'served', 'cancelled') DEFAULT 'pending',
    item_tenant_comment TEXT,
    created_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP,
    updated_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
    FOREIGN KEY (order_id) REFERENCES food_order_order(id) ON DELETE CASCADE
);

-- Extra Table
CREATE TABLE food_order_extra (
    id INT AUTO_INCREMENT PRIMARY KEY,
    item_id INT NOT NULL,
    menu_extra_id INT DEFAULT NULL,
    extra_name VARCHAR(255),
    extra_price DECIMAL(10,2) DEFAULT 0.00,
    created_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP,
    updated_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
    FOREIGN KEY (item_id) REFERENCES food_order_item(id) ON DELETE CASCADE
);




/*

"basket": [
  {
    "items": [ 
          "id": 1, //Fish & Chips
          "quantity": 1,
          "options": [
              {
                "id": 1, //Extra Source Groups // need this to be able too work out any rules eg must be one selected or no more than two or something of that nature
                "extras":[
                  {
                    "id": 1, //"Tartar Sauce"
                  },
                  {
                    "id": 2, //"Tartar Sauce"

                  }
                ]
              },
              {
                "id": 2, //Extra Size Groups
                "extras":[
                  {
                    "id": 3, //"Small"
                  },
                  
                ]
              }
          ]
        },
        {
          "id": 1 ,//Fish & Chips
          "quantity": 2,
        }}
  ],
  "promotion" : [
    {
      "code": "FISH10",
      "description": "10% off Fish & Chips",
    }
  ]
  "guestUser": { -- Logged in or this information
    "f_name": "John",
    "l_name": "Doe",
    "phone_number": "1234567890",
    "user_email": "jon@test.net",
    "address": {
      "address_line_1": "123 Main St",
      "address_line_2": "Apt 4B",
      "city": "Springfield",
      "county": "hampshire",
      "country": "uk",
      "postal_code": "S023 4AB"
    }
]


-- user_login -- Prexisting table for user login information



-- Guest User Table
    id,
    f_name
    l_name
    phone_number
    user_email
    created_at
    updated_at


-- Address Table
    id,
    address_line_1,
    address_line_2,
    city,
    state,
    country,
    postal_code,
    created_at,
    updated_at


-- Order Table
    id,
    user_id,        -- Foreign key to User Table
    guest_user_id,  -- Foreign key to Guest User Table
    tenant_id, -- Foreign key to Tenant Table
    delivery_address_id, -- Foreign key to Address Table
    billing_address_id, -- Foreign key to Address Table
    order_status, -- e.g., 'pending', 'completed', 'cancelled'
    order_type, -- e.g., 'delivery', 'pickup', 'dine-in'
    total_order_price,
    total_order_modified_price, -- e.g., after discounts or promotions
    total_order_modified_reason, -- e.g., 'promotion', 'discount'
    payment_status  -- e.g., 'paid', 'unpaid', 'refunded', partial_refund
    comment, -- e.g., any special instructions or comments from the user
    tenant_comment, -- e.g., any special instructions or comments from the restaurant
    currency -- e.g., 'GBP', 'EUR'
    transaction_id, -- e.g., unique identifier for the payment transaction
    created_at,
    updated_at
    -- Foreign key: either user_id or guest_user_id must be present, but not both

-- Item Table
    id,
    order_id,
    menu_item_id -- Foreign key to Item Table
    item_name
    item_base_price -- e.g., base price before any modifications at the time of order
    item_modified_price -- e.g., price after modifications like size changes or extras
    item_modified_reason -- e.g., 'size change', 'extra added', promotions -- disccount off 
    item_quantity -- e.g., quantity of the item ordered
    item_note
    item_status, -- e.g., 'pending', 'prepared', 'served', 'cancelled'
    item_tenant_comment, -- e.g., any special instructions or comments from the restaurant regarding the item
    created_at
    updated_at

-- Extra Table linked to Item Table
    id,
    item_id, -- Foreign key to Item Table as part of the order not from the menu
    menu_extra_id, -- Foreign key to Extra Table 
    extra_name, 
    extra_price, -- e.g., price of the extra item at the time of order
    created_at,
    updated_at

    */