# Frontend API Interface Specification

---

## Overview
This document outlines the frontend API contract required to interact with the backend PHP application. All operations are triggered via a single endpoint (function.php) using POST or GET requests, with the action defined in the action field. Role-based access is enforced via session variables.

---

## Role Definitions

```sql
INSERT INTO `user_role` (`pk_role_id`, `role_name`, `scope`) VALUES
(1, "SystemAdmin", "Platform"),
(2, "SupportAgent", "Platform"),
(3, "ContentModerator", "Platform"),
(4, "BusinessOwner", "Tenant"),
(5, "BusinessManager", "Tenant"),
(6, "Staff", "Tenant"),
(7, "Operator", "Tenant"),
(8, "Customer", "Public");
```

## API Summary Table

| Action                            | Method | Required Role      | Payload Object           | Description                                                            |
|-----------------------------------|--------|--------------------|--------------------------|------------------------------------------------------------------------|
| `getPreAuthPayments`              | GET    |  2,4,5,6           |                          | Get a list of pre auth payment to decided to accept or reject          |
| `acceptedRejectPreAuthPayment`    | POST   |  2,4,5,6           | foodOrder                | From a list of pre auth payment to decided to accept or reject         |
| `getOrderList`                    | GET    |  2,4,5,6           |                          | View all orders that are active and any completed up to 2 hours old    |
| `viewOrderDetails`                | GET    |  2,4,5,6           |                          | View order details                                                     |
| `updateStatusOrder`               | POST   |  2,4,5,6           | foodOrder                | Update the Order Status                                                |
| `updateStatusItem`                | POST   |  2,4,5,6           | foodOrderItem            | Update the Order Item Status                                           |


### `getPreAuthPayments`
```json
    "action" : "getPreAuthPayments",
```

### `acceptedRejectPreAuthPayment`
```json
    "action" : "acceptedRejectPreAuthPayment",
    "foodOrder'" : 
            [
                "id" : "int",
                "accepted" : int [1: Accept, 0:reject]
            ]
```

### `getOrderList`
```json
    "action" : "getOrderList",
```

### `viewOrderDetails`
```json
    "action" : "viewOrderDetails",
    "orderId": "int" 
```

### `updateStatusOrder`
```json
    "action" : "updateStatusOrder",
    "foodOrder" : [
        "id":"int", orderId
        "orderStatus":"string" ["cooking", "delivery", "completed"]
    ]
```

### `updateStatusItem`
```json
    "action" : "updateStatusItem",
    "foodOrderItem" : [
        "id":"int", itemId
        "itemStatus":"string" ["prepared", "served", "cancelled"]
    ]
```



## Payload Structures
