<?php
    function getListOfOrdersOutSide2Hours($inputData){
        $db = $inputData['db']['dbApp'];
        $cutoff = (new DateTime('-2 hours'))->format('Y-m-d H:i:s');
        $sql = "SELECT fo.id, fo.payment_intent_id, te.payment_api_key, te.id as tenant_id
                FROM 	`food_order`  fo
                LEFT JOIN tenant te ON te.id = fo.tenant_id
                WHERE 	fo.`payment_status` 	= 'payment_pre_auth'
                AND 	fo.`order_status` 		= 'pending'
                AND 	fo.`updated_at` 		<= :cutoffTime";

        $stmt = $db->prepare($sql);
        $stmt->bindValue(':cutoffTime', $cutoff);
        $stmt->execute();

        $data = $stmt->fetchAll(PDO::FETCH_ASSOC);

        if (!$data) {
            return ['status' => 'failed', 'message' => 'No Orders to cancel'];
        } else {
            return ['status' => 'success', 'data' => $data];
        }
    }
    function getListOfOrdersForgottenOrders4Hours($inputData){
        $db = $inputData['db']['dbApp'];
        $cutoff = (new DateTime('-4 hours'))->format('Y-m-d H:i:s');
        $sql = "SELECT fo.id, fo.payment_intent_id, te.payment_api_key
                FROM 	`food_order`  fo
                LEFT JOIN tenant te ON te.id = fo.tenant_id
                WHERE 	fo.`payment_status` 	= 'payment_intent'
                AND 	fo.`order_status` 		= 'pending'
                AND 	fo.`updated_at` 		<= :cutoffTime";

        $stmt = $db->prepare($sql);
        $stmt->bindValue(':cutoffTime', $cutoff);
        $stmt->execute();

                $data = $stmt->fetchAll(PDO::FETCH_ASSOC);

        if (!$data) {
            return ['status' => 'failed', 'message' => 'No Orders to cancel'];
        } else {
            return ['status' => 'success', 'data' => $data];
        }
    }
    function viewFullOrderDetails($inputData) {
        $db        = $inputData['db']['dbApp'];
        $paymentIntentId = $inputData['secure']['paymentIntentId'] ?? null;
        $tenantId  = isset($inputData['tenantId']) ? (int)$inputData['tenantId'] : null;
        $viewLevel = $inputData['viewLevel']  ?? null;       // 'full' to include details/address
        $receipt   = $inputData['receipt']    ?? null;       // 'enabled' to include fees + user fields
        $tenantTz  = $inputData['tenantTz']   ?? 'Europe/London';

        if (!$paymentIntentId)  return ['status' => 'failed', 'message' => 'Payment Intent Id is required'];
        error_log($paymentIntentId);
        $db->setAttribute(PDO::ATTR_ERRMODE, PDO::ERRMODE_EXCEPTION);

        // Base SELECT
        $sql = "SELECT 
                    fo.`id`,
                    fo.`order_status`,
                    fo.`order_type`,
                    fo.`total_order_modified_price`,
                    fo.`payment_status`,
                    fo.`comment`,
                    fo.`tenant_comment`,
                    fo.`delivery_address_id`,
                    fo.`created_at`,
                    fo.`delivery_fee`,
                    fo.`order_fee`,
                    fo.`small_order_fee`,
                    fo.`user_id`,
                    fo.`guest_user_id`,
                    COALESCE(ul.`user_email`, g.`user_email`)   AS `user_email`,
                    COALESCE(ul.`f_name`, g.`f_name`)           AS `f_name`,
                    COALESCE(ul.`l_name`, g.`l_name`)           AS `l_name`
                FROM `food_order` fo
                LEFT JOIN `user_login` ul           ON ul.`pk_user_id`  = fo.`user_id`
                LEFT JOIN `food_order_guest_user` g ON g.`id`           = fo.`guest_user_id`
                WHERE fo.payment_intent_id = :payment_intent_id LIMIT 1";

        $stmt = $db->prepare($sql);
        $stmt->bindParam(':payment_intent_id', $paymentIntentId, PDO::PARAM_STR);
        $stmt->execute();
        $row = $stmt->fetch(PDO::FETCH_ASSOC);

        if (!$row) {
            return ['status' => 'failed', 'message' => 'No order details found'];
        }

        // ---- Transform keys & amounts
        $order = convertKeysToCamelCase($row);

        // Always format price consistently (string w/ 2dp)
        if (isset($order['totalOrderModifiedPrice'])) {
            $order['totalOrderModifiedPrice'] = number_format((float)$order['totalOrderModifiedPrice'], 2, '.', '');
        }

        // ---- createdAt handling (DB stored as UTC "Y-m-d H:i:s")
        if (!empty($order['createdAt'])) {
            $utcYmdHis              = $order['createdAt'];
            $order['createdAt']     = utc_to_iso8601z($utcYmdHis);                  // e.g. "2025-08-26T22:55:12Z"
            $order['createdAtDisplay'] = format_utc_for_tz($utcYmdHis, $tenantTz, 'Y-m-d H:i:s'); // tenant-local string
        } else {
            $order['createdAt']        = null;
            $order['createdAtDisplay'] = null;
        }

        // ---- Delivery address (only when needed)
            unset($order['deliveryAddressId']);

        // ---- Receipt enrichment (fees + user fields)
        
        // Normalise user fields even if JOINs returned null
            $order['userEmail'] = $order['userEmail'] ?? ($order['user_email'] ?? '');
            $order['firstName'] = $order['firstName'] ?? ($order['fName'] ?? '');
            $order['lastName']  = $order['lastName']  ?? ($order['lName'] ?? '');
        // Clean up alternative casings brought by convertKeysToCamelCase
            unset($order['user_email'], $order['fName'], $order['lName']);
        
        // Wrap as array to preserve your external shape: orderDetails => [ … ]
        $payload = [$order];

        // Optional: comment this out in production to avoid leaking PII in logs
        // error_log(print_r($payload, true));

        return ['status' => 'success', 'orderDetails' => $payload];
    }
    // Tenant details
    function getTenantDetails(&$inputData) {
        $tenantId = $inputData['tenantId'] ?? null;
        if (!$tenantId) {
            return ['status' => 'failed', 'message' => 'Tenant ID is required'];
        }

        $db        = $inputData['db']['dbApp'];
        $db->setAttribute(PDO::ATTR_ERRMODE, PDO::ERRMODE_EXCEPTION);

        $sql = "SELECT company_name as companyName, company_number as tenantNumber, domain FROM `tenant` WHERE `id` = :tenant_id LIMIT 1";
        $stmt = $db->prepare($sql);
        $stmt->bindParam(':tenant_id', $tenantId, PDO::PARAM_INT);
        $stmt->execute();
        $tenant = $stmt->fetch(PDO::FETCH_ASSOC);

        if (!$tenant) {
            return ['status' => 'failed', 'message' => 'Tenant not found'];
        }

        $inputData['tenantDetails'] = $tenant;

        return ['status' => 'success', 'tenantDetails' => $tenant];
    }
    function shopAddress(&$inputData) {
        $pdo = $inputData['db']['dbApp'];
        $pdo->setAttribute(PDO::ATTR_ERRMODE, PDO::ERRMODE_EXCEPTION);

        $tenantId = $inputData['tenantId'] ?? null;
        if ($tenantId === null) {
            return ['status' => 'failed', 'message' => 'Missing required tenantId'];
        }

        $sql = "SELECT `contact_value`, `label` FROM `tenant_contact` WHERE `tenant_id` = :tenant_id AND is_primary = 'yes' AND is_deleted = 0 AND label = 'Shop Address' ";
        $stmt = $pdo->prepare($sql);
        $stmt->bindParam(':tenant_id', $tenantId);
        $stmt->execute();
        $row = $stmt->fetch(PDO::FETCH_ASSOC);

        if ($row) {
            $inputData['shopAddress'] = $row;
            return [
                'status' => 'success',
            ];
        } else {
            return ['status' => 'failed', 'message' => "Shop address not found or deleted"];
        }
    }

    function viewLatestTerms(&$inputData) {
        $db = $inputData['db']['dbApp'];
        $tenantId = $inputData['tenantId'];

        if (!isset($tenantId)) {
            return ['status' => 'failed', 'message' => 'Tenant ID is required'];
        }

        $stmt = $db->prepare("SELECT versions, title, content, is_active, updated_at FROM food_order_terms_of_service WHERE tenant_id = :tenant_id ORDER BY updated_at DESC LIMIT 1");
        $stmt->bindParam(':tenant_id', $tenantId, PDO::PARAM_INT);
        $stmt->execute();
        $data = $stmt->fetch(PDO::FETCH_ASSOC);

        if (!$data) {
            return ['status' => 'failed', 'message' => 'No terms and conditions found for this tenant'];
        }

        return ['status' => 'success', 'termsAndConditions' => $data];
    }
?>