<?php
    ini_set('error_log', 'php://stderr');


    use PHPUnit\Framework\TestCase;
    
    require_once __DIR__ . DIRECTORY_SEPARATOR . '..' . DIRECTORY_SEPARATOR . '..' . DIRECTORY_SEPARATOR . 'core' . DIRECTORY_SEPARATOR . 'unit-test' . DIRECTORY_SEPARATOR . 'scripts' . DIRECTORY_SEPARATOR . 'bootstrap.php'; // ✅ Use shared mock DB
    //require_once __DIR__ . '/../src/function.php';
    error_log(">>>>>>>>>>>>>>>>>>>>>>>>>====<<<<<<<<<<<<<<<<<<<<<<<<<");
    error_log("T11_FoodOrderingSuperAdminTest.php");
    
    // Print list of table that exist in the database
    //$tables = $GLOBALS['mockPdo']->query("SELECT name FROM sqlite_master WHERE type='table';")->fetchAll(\PDO::FETCH_COLUMN);
    //echo("\n🔍 Tables: " . implode(', ', $tables). "\n");
    
    class T11_FoodOrderingSuperAdminTest extends TestCase
    {
        private $mockPdo;
        private static $lastModified;

    protected function setUp(): void{
        // ✅ Use the shared mock database connection
        $_SESSION = [];
        $_GET = [];
        $_POST = [];
        $_SERVER['REMOTE_ADDR'] = '127.0.0.1';
        $_SERVER['HTTP_REFERER'] = 'http://localhost/test';
        $this->mockPdo = $GLOBALS['mockPdo'];
        if (session_status() !== PHP_SESSION_ACTIVE) {
            if (session_status() !== PHP_SESSION_ACTIVE && !headers_sent()) {
                session_start();
            }
        }
    }

    private function executeFunctionPhp(): array {
        ob_start();
        // Flexible path resolution for module function.php
        if (file_exists(__DIR__ . DIRECTORY_SEPARATOR . '..' . DIRECTORY_SEPARATOR . 'src' . DIRECTORY_SEPARATOR . 'function.php')) {
            require __DIR__ . DIRECTORY_SEPARATOR . '..' . DIRECTORY_SEPARATOR . 'src' . DIRECTORY_SEPARATOR . 'function.php';
        } else {
            require __DIR__ . DIRECTORY_SEPARATOR . '..' . DIRECTORY_SEPARATOR . 'function.php';
        }
        $output = ob_get_clean();
    
        // ✅ Ensure only valid JSON output
        $decodedOutput = json_decode($output, true);
        if (json_last_error() !== JSON_ERROR_NONE) {
            throw new Exception("Invalid JSON output: " . json_last_error_msg() . "\nOutput: " . $output);
        }
    
        return [$output, $decodedOutput];
    }

    public function test001DummyTest(): void{
        $this->assertTrue(true);
    }
    public function test002SetupData(): void {
        // Clear existing data
    
        // Insert test data

                $this->mockPdo->exec("INSERT INTO 'food_order'
                                        (guest_user_id, tenant_id, delivery_address_id, billing_address_id, order_status, order_type,
                                        total_order_price, total_order_modified_price, total_order_modified_reason, payment_status,
                                        comment, tenant_comment, currency, transaction_id, payment_intent_id, created_at)
                                        VALUES
                                        (NULL, 1, 1, 1, 'pending', 'delivery', 14.30, 1.30, 'Small Order Fee Applied, Delivery Charge Applied, Admin Fee Applied', 'payment_pre_auth',    NULL, NULL, 'GBP', NULL, 'pi_3RuTdYDMt3vZ38M11Ze26li0',     datetime('now','-3 hours')),
                                        (NULL, 1, 1, 1, 'pending', 'delivery', 14.30, 2.30, 'Small Order Fee Applied, Delivery Charge Applied, Admin Fee Applied', 'payment_pre_auth',    NULL, NULL, 'GBP', NULL, 'pi_3RuTdYDMt3vZ38M11Ze26li0',     datetime('now','-1 hours')),
                                        (NULL, 1, 1, 1, 'pending', 'delivery', 14.30, 3.30, 'Small Order Fee Applied, Delivery Charge Applied, Admin Fee Applied', 'payment_pre_auth',    NULL, NULL, 'GBP', NULL, 'pi_3RuTdYDMt3vZ38M11Ze26li0',     datetime('now','-4 hours')),
                                        (NULL, 1, 1, 1, 'pending', 'delivery', 14.30, 4.30, 'Small Order Fee Applied, Delivery Charge Applied, Admin Fee Applied', 'payment_pre_auth',    NULL, NULL, 'GBP', NULL, 'pi_3RuTdYDMt3vZ38M11Ze26li0',     datetime('now','-5 hours')),
                                        (NULL, 1, 1, 1, 'pending', 'delivery', 14.30, 5.30, 'Small Order Fee Applied, Delivery Charge Applied, Admin Fee Applied', 'payment_pre_auth',    NULL, NULL, 'GBP', NULL, 'pi_3RuTdYDMt3vZ38M11Ze26li0',     datetime('now','-2 hours')),
                                        (NULL, 1, 1, 1, 'pending', 'delivery', 14.30, 6.30, 'Small Order Fee Applied, Delivery Charge Applied, Admin Fee Applied', 'payment_pre_auth',    NULL, NULL, 'GBP', NULL, 'pi_3RuTdYDMt3vZ38M11Ze26li0',     datetime('now','-1 hours')),
                                        (NULL, 1, 1, 1, 'pending', 'delivery', 14.30, 2.30, 'Small Order Fee Applied, Delivery Charge Applied, Admin Fee Applied', 'payment_pre_auth',    NULL, NULL, 'GBP', NULL, 'pi_3RuTdYDMt3vZ38M11Ze26li0',     datetime('now','-3 hours')),
                                        (NULL, 1, 1, 1, 'pending', 'delivery', 14.30, 2.30, 'Small Order Fee Applied, Delivery Charge Applied, Admin Fee Applied', 'payment_pre_auth',    NULL, NULL, 'GBP', NULL, 'pi_3RuTdYDMt3vZ38M11Ze26li0',     datetime('now','-90 minutes')),
                                        (NULL, 1, 1, 1, 'pending', 'delivery', 14.30, 2.30, 'Small Order Fee Applied, Delivery Charge Applied, Admin Fee Applied', 'payment_pre_auth',    NULL, NULL, 'GBP', NULL, 'pi_3RuTdYDMt3vZ38M11Ze26li0',     datetime('now','-118 minutes')),
                                        (NULL, 1, 1, 1, 'pending', 'delivery', 14.30, 2.30, 'Small Order Fee Applied, Delivery Charge Applied, Admin Fee Applied', 'payment_pre_auth',    NULL, NULL, 'GBP', NULL, 'pi_3RuTdYDMt3vZ38M11Ze26li0',     datetime('now','-121 minutes')),
                                        (NULL, 1, 1, 1, 'pending', 'delivery', 14.30, 2.30, 'Small Order Fee Applied, Delivery Charge Applied, Admin Fee Applied', 'payment_pre_auth',    NULL, NULL, 'GBP', NULL, 'pi_3RuTdYDMt3vZ38M11Ze26li0',     datetime('now','-120 minutes')),
                                        (NULL, 1, 1, 1, 'pending', 'delivery', 14.30, 2.30, 'Small Order Fee Applied, Delivery Charge Applied, Admin Fee Applied', 'payment_pre_auth',    NULL, NULL, 'GBP', NULL, 'pi_3RuTdYDMt3vZ38M11Ze26li0',     datetime('now','-75 minutes'));
                                        ");
    
        // Verify data insertion
        $this->assertEquals(1,1);
    }
    function test003ViewDeadDate(){
        // View All orders in the table that have a `payment_status` = 'payment_pre_auth' AND `order_status` = 'pending'
        $stmt = $this->mockPdo->query("SELECT id, created_at, updated_at, CAST((julianday(updated_at) - julianday(created_at)) * 24 * 60 AS INTEGER)  FROM food_order WHERE payment_status = 'payment_pre_auth' AND order_status = 'pending'");
        $orders = $stmt->fetchAll(\PDO::FETCH_ASSOC);
        //print_r($orders);

        $_SESSION['userId'] = 1;
        $_SESSION['role'] = 5; // sysadmin
        $_GET['action'] = 'killOrdersOutSide2Hours';
        list($output, $decodedOutput) = $this->executeFunctionPhp();
        // Debug output
        //echo(print_r($decodedOutput, true)); // or var_dump($decodedOutput)
        //$this->assertEquals("success", $decodedOutput['status']);
        // count the number of orders returned
        // we need to count the $decodedOutput['data'] array and compare to the number of orders that are older than 2 hours and pending

        $this->assertEquals("failed", $decodedOutput['status']);
        $this->assertEquals("No Orders to cancel", $decodedOutput['message']);
    }
    function test004ViewOrdersByDefaultDateRange(){
        $_SESSION['id'] = 293;
        $_SESSION['roleValue'] = 1;
        $_POST = [
            'action' => 'viewOrdersByDateRange',
            'debug' => 'CSD'
        ];
        list($output, $decodedOutput) = $this->executeFunctionPhp();
        $decodedOutput = json_decode($output, true);
        //echo print_r($decodedOutput);
        $this->assertEquals('success', $decodedOutput['status']);
        $this->assertArrayHasKey('data', $decodedOutput, "Response should contain 'data' key.");
        $this->assertIsArray($decodedOutput['data'], "'data' should be an array.");
        // Further assertions can be made based on expected data structure and content
    }
    function test005ViewOrdersByDateRange(){
        $_SESSION['id'] = 293;
        $_SESSION['roleValue'] = 1;
        $_POST = [
            'action' => 'viewOrdersByDateRange',
            'startDate' => '2024-01-01',
            'endDate' => '2024-12-31',
            'debug' => 'CSD'
        ];
        list($output, $decodedOutput) = $this->executeFunctionPhp();
        $decodedOutput = json_decode($output, true);
        //echo print_r($decodedOutput);
        $this->assertEquals('success', $decodedOutput['status']);
        $this->assertArrayHasKey('data', $decodedOutput, "Response should contain 'data' key.");
        $this->assertEquals('No data found for this date range 2024-01-01 - 2024-12-31', $decodedOutput['message'], "Data retrieved successfully");
        // Further assertions can be made based on expected data structure and content
    }
    function test006ViewOrdersByDateRange(){
        $_SESSION['id'] = 293;
        $_SESSION['roleValue'] = 4; // owner role should not have access to this action
        $_POST = [
            'action' => 'viewOrdersByDateRange',
            'startDate' => '2024-01-01',
            'endDate' => '2024-12-31',
            'debug' => 'CSD'
        ];
        list($output, $decodedOutput) = $this->executeFunctionPhp();
        $decodedOutput = json_decode($output, true);
        //echo print_r($decodedOutput);
        $this->assertEquals('failed', $decodedOutput['status']);
        $this->assertEquals('Access denied: insufficient permissions', $decodedOutput['message'], "Owner role should not have access to view orders by date range");
        // Further assertions can be made based on expected data structure and content
    }
/*`
    public function test004GetCurrentAccountInfo(){
        $stmt = $this->mockPdo->query("SELECT * FROM tenant_history");
        $rows = $stmt->fetchAll(\PDO::FETCH_ASSOC);
    
        // Debug output
        print_r($rows); // or var_dump($rows)
        $this->assertEquals("1", "1");
    }
*/

    /* To Do: 
        - test view as sysadmin with a deleted tenant
        - test view as owner with a deleted tenant
        - test view as public with a deleted tenant
    */
}

?>