<?php

    namespace Azui\Orbit\FoodOrderSuperAdmin;

    function updateCancelled($inputData) {
        $pdo = $inputData['db']['dbApp'];
        $pdo->setAttribute(\PDO::ATTR_ERRMODE, \PDO::ERRMODE_EXCEPTION);
        $paymentIntentId = $inputData['secure']['paymentIntentId'] ?? null;

        if (!$paymentIntentId) {
            return ['status' => 'failed', 'message' => 'Payment Intent ID is required'];
        }

        // Update the order status to 'cancelled'
        $sql = "UPDATE food_order SET order_status = 'cancelled', payment_status = 'unpaid' WHERE payment_intent_id = :payment_intent_id";
        $stmt = $pdo->prepare($sql);
        $stmt->bindValue(':payment_intent_id', $paymentIntentId);
        try {
            $stmt->execute();
            return ['status' => 'success', 'message' => 'Order status updated to cancelled'];
        } catch (\PDOException $e) {
            return ['status' => 'failed', 'message' => 'Database error: ' . $e->getMessage()];
        }
    } 
?>