<?php
    function checkIfDeleted($inputData) {
        $table = $inputData['table'];
        $table = toSnakeCase($table);
        $id = $inputData['id'];
        $db = $inputData['db']['dbApp'];
        $stmt = $db->prepare("SELECT id FROM $table WHERE id = :id and is_deleted = 1");
        $stmt->bindParam(':id', $id, PDO::PARAM_INT);
        $stmt->execute();
        $data = $stmt->fetch(PDO::FETCH_ASSOC);
            if ($data) {
                        return ['status' => 'failed', 'message' => 'Record already deleted'];
            } else {
                return ['status' => 'success'];
            }
    }
    function getDataForHistory($inputData) {
        $table = $inputData['table'];
        $table = toSnakeCase($table);
        $id = $inputData['id'];
        $db = $inputData['db']['dbApp'];
        $stmt = $db->prepare("SELECT * FROM $table WHERE id = :id");
        $stmt->bindParam(':id', $id, PDO::PARAM_INT);
        $stmt->execute();
        // convert result to json with column names as keys
        $data = $stmt->fetch(PDO::FETCH_ASSOC);
        json_encode($data);
        if ($data) {
            return ['status' => 'success', 'historyData' => $data];
        } else {
            return ['status' => 'failed', 'message' => 'Record not found'];
        }
    }
    function setTenantId($inputData) {
        $pdo = $inputData['db']['dbApp'];
        $pdo->setAttribute(PDO::ATTR_ERRMODE, PDO::ERRMODE_EXCEPTION);
        $host = $_SERVER['HTTP_HOST'] ?? '';
        $host = strtolower($host);
        $parts = explode('.', $host);
        $cleanParts = array_filter($parts, fn($part) => $part !== 'admin');
        $cleanHost = implode('.', $cleanParts);
        $cleanUrl = 'https://' . $cleanHost;

        // Build SQL
        $sql = "SELECT id FROM tenant WHERE domain = :http";
        $stmt = $pdo->prepare($sql);
        $stmt->bindParam(':http', $cleanUrl);
        $stmt->execute();
        $data = $stmt->fetch(PDO::FETCH_ASSOC);
        if ($data) {
            $_SESSION['tenantId']       = $data['id'];
            return ['status' => 'success', 'message' => 'Tenant ID found'];
        } else {
            return ['status' => 'failed', 'message' => 'Tenant ID not found'];
        }
    }
    function viewPreAuthPayments($inputData) {
        $db = $inputData['db']['dbApp'];
        $tenantId = $inputData['tenantId'];
        $stmt = $db->prepare("SELECT distinct id, `total_order_modified_price` as `totalOrderModifiedPrice`, `order_status` as `orderStatus`, `updated_at` as `updatedAt` FROM `food_order` 
                                where	`payment_status` 	= 'payment_pre_auth'
                                AND 	`tenant_id`			= :tenant_id
                                order by updated_at desc");
                                    
        $stmt->bindParam(':tenant_id', $tenantId, PDO::PARAM_INT);
        $stmt->execute();
        $data = $stmt->fetchAll(PDO::FETCH_ASSOC);
        if (!$data) {
            return ['status' => 'failed', 'message' => 'No pre-auth payments found'];
        }
        

        foreach ($data as &$payment) {
            $payment['totalOrderModifiedPrice'] = number_format($payment['totalOrderModifiedPrice'], 2, '.', '');
        }

        $group = [];
        unset($payment); // break the reference!

        foreach ($data as $payment) {
            $status = $payment['orderStatus'];
            $group[$status][] = $payment;
        }

        $data = $group; // replace the flat array with the grouped one

        // convert to cammelCase
        foreach ($data as $status => $payments) {
            foreach ($payments as &$payment) {
                $payment = convertKeysToCamelCase($payment);
            }
            unset($payment); // break the reference!
        }       

        return ['status' => 'success', 'preAuthPayments' => $data];
    }
    function viewOrders($inputData) {
        $db = $inputData['db']['dbApp'];
        $tenantId = $inputData['tenantId'];

        $stmt = $db->prepare("
            SELECT `id`, `order_status`, `order_type`, `total_order_modified_price`, `payment_status`, `comment`, `tenant_comment` FROM `food_order` 
                WHERE	`order_status` 	in ('confirmed','cooking','delivery','completed')
                AND 	`payment_status` = 'paid'
                AND 	`tenant_id`		 = :tenant_id
        ");
        $stmt->bindParam(':tenant_id', $tenantId, PDO::PARAM_INT);
        $stmt->execute();
        $data = $stmt->fetchAll(PDO::FETCH_ASSOC);
        if (!$data) {
            return ['status' => 'failed', 'message' => 'No orders found'];
        }
        foreach ($data as &$order) {
            $order['totalOrderModifiedPrice'] = number_format($order['totalOrderModifiedPrice'], 2, '.', '');
            // if viewFullOrderDetails is true, add full order details
            if (isset($inputData['viewFullOrderDetails']) && $inputData['viewFullOrderDetails'] === true) {
                $inputData['orderId'] = $order['id'];
                $order['fullOrderDetails'] = viewFullOrderDetails($inputData);
            }
        }

    }
    function viewPaymentIntentOrderById($inputData){
        $db = $inputData['db']['dbApp'];
        $id = $inputData['id'];

        $db->setAttribute(PDO::ATTR_ERRMODE, PDO::ERRMODE_EXCEPTION);

        $stmt = $db->prepare(
            'SELECT payment_intent_id AS paymentIntentId
            FROM food_order
            WHERE id = :id
            LIMIT 1'
        );

        $stmt->bindValue(':id', is_numeric($id) ? (int)$id : (string)$id,
                        is_numeric($id) ? PDO::PARAM_INT : PDO::PARAM_STR);

        $stmt->execute();
        $row = $stmt->fetch(PDO::FETCH_ASSOC);

        return $row ? ['status'=>'success','data'=>$row]
                    : ['status'=>'failed','message'=>'Payment Intent not found'];
    }
    function viewFullOrderDetails($inputData) {
        $db = $inputData['db']['dbApp'];
        $orderId = $inputData['orderId'];
        $tenantId = $inputData['tenantId'];
        $viewLevel = $inputData['viewLevel'] ?? null; 

        if (!isset($orderId)) {
            return ['status' => 'failed', 'message' => 'Order ID is required'];
        }

        $db->setAttribute(PDO::ATTR_ERRMODE, PDO::ERRMODE_EXCEPTION);
        $stmt = $db->prepare("SELECT `id`, `order_status`, `order_type`, `total_order_modified_price`, `payment_status`, `comment`, `tenant_comment`, `delivery_address_id`  FROM `food_order` 
                                WHERE id = :order_id
                                AND tenant_id = :tenant_id");
        $stmt->bindParam(':order_id', $orderId, PDO::PARAM_INT);
        $stmt->bindParam(':tenant_id', $tenantId, PDO::PARAM_INT);
        $stmt->execute();
        $data = $stmt->fetchAll(PDO::FETCH_ASSOC);

        if (!$data) {
            return ['status' => 'failed', 'message' => 'No order details found'];
        }

        // Convert to camelCase
        foreach ($data as &$order) {
            $order = convertKeysToCamelCase($order);
            $order['totalOrderModifiedPrice'] = number_format($order['totalOrderModifiedPrice'], 2, '.', '');
            if ($viewLevel === 'full') {
                if ($order['orderType'] === 'delivery') {
                    $inputData['deliveryAddressId'] = $order['deliveryAddressId'];
                    $res = viewDeliveryAddress($inputData);
                    if ($res['status'] === 'success') {
                        $order['delivery'] = $res['deliveryAddress'];
                    } else {
                        return ['status' => 'failed', 'message' => 'Delivery address not found'];
                    }
                }else{
                    unset($order['deliveryAddressId']); // else
                }
                $res = getOrderDetails($inputData);
                $order['details'] = $res['status'] === 'success' ? $res['orderDetails'] : "";
            }
        }   
        return ['status' => 'success', 'orderDetails' => $data];
    }
    function getOrderDetails($inputData) {
        $db = $inputData['db']['dbApp'];
        $orderId = $inputData['orderId'];

        if (!isset($orderId)) {
            return ['status' => 'failed', 'message' => 'Order ID is required'];
        }

        $stmt = $db->prepare("SELECT id, item_name, item_modified_price, item_quantity, item_note, item_status, item_tenant_comment, updated_at
                                FROM food_order_item 
                                WHERE order_id = :order_id");
        $stmt->bindParam(':order_id', $orderId, PDO::PARAM_INT);
      
        $stmt->execute();
        $data = $stmt->fetchAll(PDO::FETCH_ASSOC);

        if (!$data) {
            return ['status' => 'failed', 'message' => 'No order details found'];
        }

        // Convert to camelCase
        foreach ($data as &$detail) {
            // change id to foodOrderItemId
            // if order_type is delivery, add delivery_address_id
            $detail = convertKeysToCamelCase($detail);
            $detail['foodOrderItemId'] = $detail['id'];
            $detail['itemModifiedPrice'] = number_format($detail['itemModifiedPrice'], 2, '.', '');
            $detail['updatedAt'] = date('Y-m-d H:i:s', strtotime($detail['updatedAt']));
            // get extras details
            $inputData['foodOrderItemId'] = $detail['foodOrderItemId'];
            $res = getOrderExtras($inputData);
            $detail['extras'] = $res['status'] === 'success' ? $res['orderDetails'] : [];
            unset($detail['id']); // remove the old id
        }
        
        return ['status' => 'success', 'orderDetails' => $data];
    }
    function getOrderExtras($inputData){
        $db = $inputData['db']['dbApp'];
        $foodOrderItemId = $inputData['foodOrderItemId'];

        if (!isset($foodOrderItemId)) {
            return ['status' => 'failed', 'message' => 'Food Order Item ID is required'];
        }

        $stmt = $db->prepare("SELECT id, extra_name, extra_price, extra_quantity, extra_quantity
                                FROM food_order_extra 
                                WHERE item_id = :food_order_item_id");
        $stmt->bindParam(':food_order_item_id', $foodOrderItemId, PDO::PARAM_INT);
      
        $stmt->execute();
        $data = $stmt->fetchAll(PDO::FETCH_ASSOC);

        if (!$data) {
            return ['status' => 'failed', 'message' => 'No order extras found'];
        }

        // Convert to camelCase
        foreach ($data as &$extra) {
            $extra = convertKeysToCamelCase($extra);
            $extra['extraPrice'] = number_format($extra['extraPrice'], 2, '.', '');
            unset($extra['id']); // remove the old id
        }
        
        return ['status' => 'success', 'orderDetails' => $data];
    }
    function viewDeliveryAddress($inputData) {
        $db = $inputData['db']['dbApp'];
        $deliveryAddressId = $inputData['deliveryAddressId'];

        if (!isset($deliveryAddressId)) {
            return ['status' => 'failed', 'message' => 'Delivery Address ID is required'];
        }

        $stmt = $db->prepare("SELECT address_line_1, address_line_2, city, county, country, postal_code FROM food_order_address WHERE id = :id");
        $stmt->bindParam(':id', $deliveryAddressId, PDO::PARAM_INT);
        $stmt->execute();
        $data = $stmt->fetch(PDO::FETCH_ASSOC);

        if (!$data) {
            return ['status' => 'failed', 'message' => 'No delivery address found for this order'];
        }

       foreach ($data as &$address) {
            //$address = convertKeysToCamelCase($address);
        }

        return ['status' => 'success', 'deliveryAddress' => $data];
    }
    function viewAcceptedOrders($inputData) {
        $db = $inputData['db']['dbApp'];
        $tenantId = $inputData['tenantId'];
        $cutoffTime = (new DateTime('-2 hours'))->format('Y-m-d H:i:s');
            
        $sql = "SELECT DISTINCT 
                    id, 
                    total_order_modified_price AS totalOrderModifiedPrice, 
                    order_status AS orderStatus, 
                    updated_at AS updatedAt
                FROM food_order
                WHERE payment_status = 'paid'
                    AND tenant_id = :tenant_id
                    AND order_status IN ('confirmed', 'cooking', 'delivery', 'completed')
                    AND (
                        order_status <> 'completed' 
                        OR updated_at >= :cutoff
                        )
                ORDER BY updated_at DESC";

        $stmt = $db->prepare($sql);
        $stmt->bindParam(':cutoff', $cutoffTime);
        $stmt->bindParam(':tenant_id', $tenantId, PDO::PARAM_INT);
        $stmt->execute();
        $data = $stmt->fetchAll(PDO::FETCH_ASSOC);
        if (!$data) {
            return ['status' => 'failed', 'message' => 'No pre-auth payments found'];
        }
        

        foreach ($data as &$payment) {
            $payment['totalOrderModifiedPrice'] = number_format($payment['totalOrderModifiedPrice'], 2, '.', '');
        }

        $group = [];
        unset($payment); // break the reference!

        foreach ($data as $payment) {
            $status = $payment['orderStatus'];
            $group[$status][] = $payment;
        }

        $data = $group; // replace the flat array with the grouped one

        // convert to cammelCase
        foreach ($data as $status => $payments) {
            foreach ($payments as &$payment) {
                $payment = convertKeysToCamelCase($payment);
            }
            unset($payment); // break the reference!
        }       

        return ['status' => 'success', 'preAuthPayments' => $data];
    }
?>
