<?php
    function menuTableColumnMapping($table = null, $roleId = null, $actionType = null) {
       $allMappings = [
            'food_order' => [
                'fields' => [
                    'id'                        => ['mapping' => 'id',                          'insertRole'    => [0,1,2,3,4,5,6],         'updateRole' => [2, 4, 5],            'optionalInsert' => null,         'optionalUpdate' => 1, 'dataType' => 'int',    'expectedValue' => null],
                    'userId'                    => ['mapping' => 'user_id',                     'insertRole'    => [0,1,2,3,4,5,6],         'updateRole' => [2, 4, 5],            'optionalInsert' => 1,            'optionalUpdate' => 0, 'dataType' => 'int',    'expectedValue' => null],
                    'guestUserId'               => ['mapping' => 'guest_user_id',               'insertRole'    => [0,1,2,3,4,5,6],         'updateRole' => [2, 4, 5],            'optionalInsert' => 1,            'optionalUpdate' => 0, 'dataType' => 'int',    'expectedValue' => null],
                    'tenantId'                  => ['mapping' => 'tenant_id',                   'insertRole'    => [0,1,2,3,4,5,6],         'updateRole' => [2, 4, 5],            'optionalInsert' => 1,            'optionalUpdate' => 0, 'dataType' => 'int',    'expectedValue' => null],
                    'deliveryAddressId'         => ['mapping' => 'delivery_address_id',         'insertRole'    => [0,1,2,3,4,5,6],         'updateRole' => [2, 4, 5],            'optionalInsert' => 1,            'optionalUpdate' => 0, 'dataType' => 'int',    'expectedValue' => null],
                    'billingAddressId'          => ['mapping' => 'billing_address_id',          'insertRole'    => [0,1,2,3,4,5,6],         'updateRole' => [2, 4, 5],            'optionalInsert' => 1,            'optionalUpdate' => 0, 'dataType' => 'int',    'expectedValue' => null],
                    'orderStatus'               => ['mapping' => 'order_status',                'insertRole'    => [0,1,2,3,4,5,6],         'updateRole' => [2, 4, 5, 6],         'optionalInsert' => 1,            'optionalUpdate' => 1, 'dataType' => 'string', 'expectedValue' => ['pending','completed','cancelled']],
                    'orderType'                 => ['mapping' => 'order_type',                  'insertRole'    => [0,1,2,3,4,5,6],         'updateRole' => [2, 4, 5],            'optionalInsert' => 1,            'optionalUpdate' => 1, 'dataType' => 'string', 'expectedValue' => ['delivery','pickup','dine-in','collection']],
                    'paymentStatus'             => ['mapping' => 'payment_status',              'insertRole'    => [0,1,2,3,4,5,6],         'updateRole' => [2, 4, 5],            'optionalInsert' => 1,            'optionalUpdate' => 1, 'dataType' => 'string', 'expectedValue' => ['unpaid','paid','refunded','partial_refund','payment_intent','payment_pre_auth']],
                    'deliveryFee'               => ['mapping' => 'delivery_fee',                'insertRole'    => [0,1,2,3,4,5,6],         'updateRole' => [2, 4, 5],            'optionalInsert' => 1,            'optionalUpdate' => 1, 'dataType' => 'float',  'expectedValue' => null],
                    'orderFee'                  => ['mapping' => 'order_fee',                   'insertRole'    => [0,1,2,3,4,5,6],         'updateRole' => [2, 4, 5],            'optionalInsert' => 1,            'optionalUpdate' => 1, 'dataType' => 'float',  'expectedValue' => null],
                    'smallOrderFee'             => ['mapping' => 'small_order_fee',             'insertRole'    => [0,1,2,3,4,5,6],         'updateRole' => [2, 4, 5],            'optionalInsert' => 1,            'optionalUpdate' => 1, 'dataType' => 'float',  'expectedValue' => null],
                    'currency'                  => ['mapping' => 'currency',                    'insertRole'    => [0,1,2,3,4,5,6],         'updateRole' => [2, 4, 5],            'optionalInsert' => 1,            'optionalUpdate' => 1, 'dataType' => 'string', 'expectedValue' => null],
                    'transactionId'             => ['mapping' => 'transaction_id',              'insertRole'    => [0,1,2,3,4,5,6],         'updateRole' => [2, 4, 5],            'optionalInsert' => 1,            'optionalUpdate' => 1, 'dataType' => 'string', 'expectedValue' => null],
                    'paymentIntentId'           => ['mapping' => 'payment_intent_id',           'insertRole'    => [0,1,2,3,4,5,6],         'updateRole' => [2, 4, 5],            'optionalInsert' => 1,            'optionalUpdate' => 1, 'dataType' => 'string', 'expectedValue' => null],
                    'comment'                   => ['mapping' => 'comment',                     'insertRole'    => [0,1,2,3,4,5,6],         'updateRole' => [2, 4, 5],            'optionalInsert' => 1,            'optionalUpdate' => 1, 'dataType' => 'string', 'expectedValue' => null],
                    'tenantComment'             => ['mapping' => 'tenant_comment',              'insertRole'    => [0,1,2,3,4,5,6],         'updateRole' => [2, 4, 5],            'optionalInsert' => 1,            'optionalUpdate' => 1, 'dataType' => 'string', 'expectedValue' => null],
                    'totalOrderPrice'           => ['mapping' => 'total_order_price',           'insertRole'    => [0,1,2,3,4,5,6],         'updateRole' => [2, 4, 5],            'optionalInsert' => 1,            'optionalUpdate' => 1, 'dataType' => 'float',  'expectedValue' => null],
                    'totalOrderModifiedPrice'   => ['mapping' => 'total_order_modified_price',  'insertRole'    => [0,1,2,3,4,5,6],         'updateRole' => [2, 4, 5],            'optionalInsert' => 1,            'optionalUpdate' => 1, 'dataType' => 'float',  'expectedValue' => null],
                    'totalOrderModifiedReason'  => ['mapping' => 'total_order_modified_reason', 'insertRole'    => [0,1,2,3,4,5,6],         'updateRole' => [2, 4, 5],            'optionalInsert' => 1,            'optionalUpdate' => 1, 'dataType' => 'string', 'expectedValue' => null],
                ],
                'relationships' => [['table' => 'food_order_item', 'foreignKey' => 'orderId']],
            ],
            'food_order_item' => [
                'fields' => [
                    'id'                    => ['mapping' => 'id',                      'insertRole'    => [0,1,2,3,4,5,6],    'updateRole' => [2, 4, 5],           'optionalInsert' => null,       'optionalUpdate' => 1, 'dataType' => 'int',    'expectedValue' => null],
                    'orderId'               => ['mapping' => 'order_id',                'insertRole'    => [0,1,2,3,4,5,6],    'updateRole' => [2, 4, 5],           'optionalInsert' => 0,          'optionalUpdate' => 0, 'dataType' => 'int',    'expectedValue' => null],
                    'menuItemId'            => ['mapping' => 'menu_item_id',            'insertRole'    => [0,1,2,3,4,5,6],    'updateRole' => [2, 4, 5],           'optionalInsert' => 0,          'optionalUpdate' => 0, 'dataType' => 'int',    'expectedValue' => null],
                    'itemName'              => ['mapping' => 'item_name',               'insertRole'    => [0,1,2,3,4,5,6],    'updateRole' => [2, 4, 5],           'optionalInsert' => 0,          'optionalUpdate' => 0, 'dataType' => 'string', 'expectedValue' => null],
                    'itemBasePrice'         => ['mapping' => 'item_base_price',         'insertRole'    => [0,1,2,3,4,5,6],    'updateRole' => [2, 4, 5],           'optionalInsert' => 0,          'optionalUpdate' => 1, 'dataType' => 'float',  'expectedValue' => null],
                    'itemModifiedPrice'     => ['mapping' => 'item_modified_price',     'insertRole'    => [0,1,2,3,4,5,6],    'updateRole' => [2, 4, 5],           'optionalInsert' => 1,          'optionalUpdate' => 1, 'dataType' => 'float',  'expectedValue' => null],
                    'itemModifiedReason'    => ['mapping' => 'item_modified_reason',    'insertRole'    => [0,1,2,3,4,5,6],    'updateRole' => [2, 4, 5],           'optionalInsert' => 1,          'optionalUpdate' => 1, 'dataType' => 'string', 'expectedValue' => null],
                    'itemQuantity'          => ['mapping' => 'item_quantity',           'insertRole'    => [0,1,2,3,4,5,6],    'updateRole' => [2, 4, 5],           'optionalInsert' => 0,          'optionalUpdate' => 1, 'dataType' => 'int',    'expectedValue' => null],
                    'itemNote'              => ['mapping' => 'item_note',               'insertRole'    => [0,1,2,3,4,5,6],    'updateRole' => [2, 4, 5],           'optionalInsert' => 1,          'optionalUpdate' => 1, 'dataType' => 'string', 'expectedValue' => null],
                    'itemStatus'            => ['mapping' => 'item_status',             'insertRole'    => [0,1,2,3,4,5,6],    'updateRole' => [2, 4, 5],           'optionalInsert' => 1,          'optionalUpdate' => 1, 'dataType' => 'string', 'expectedValue' => ['pending','prepared','served','cancelled']],
                    'itemTenantComment'     => ['mapping' => 'item_tenant_comment',     'insertRole'    => [0,1,2,3,4,5,6],    'updateRole' => [2, 4, 5],           'optionalInsert' => 1,          'optionalUpdate' => 1, 'dataType' => 'string', 'expectedValue' => null],
                ],
                'relationships' => [['table' => 'food_order_extra', 'foreignKey' => 'itemId']],
            ],
            'food_order_extra' => [
                'fields' => [
                    'id'                    => ['mapping' => 'id',                      'insertRole'    => [0,1,2,3,4,5,6],     'updateRole' => [2, 4, 5],          'optionalInsert' => null,       'optionalUpdate' => 1, 'dataType' => 'int',    'expectedValue' => null],
                    'itemId'                => ['mapping' => 'item_id',                 'insertRole'    => [0,1,2,3,4,5,6],     'updateRole' => [2, 4, 5],          'optionalInsert' => 0,          'optionalUpdate' => 0, 'dataType' => 'int',    'expectedValue' => null],
                    'menuExtraId'           => ['mapping' => 'menu_extra_id',           'insertRole'    => [0,1,2,3,4,5,6],     'updateRole' => [2, 4, 5],          'optionalInsert' => 1,          'optionalUpdate' => 0, 'dataType' => 'int',    'expectedValue' => null],
                    'extraName'             => ['mapping' => 'extra_name',              'insertRole'    => [0,1,2,3,4,5,6],     'updateRole' => [2, 4, 5],          'optionalInsert' => 0,          'optionalUpdate' => 1, 'dataType' => 'string', 'expectedValue' => null],
                    'extraPrice'            => ['mapping' => 'extra_price',             'insertRole'    => [0,1,2,3,4,5,6],     'updateRole' => [2, 4, 5],          'optionalInsert' => 0,          'optionalUpdate' => 1, 'dataType' => 'float',  'expectedValue' => null],
                ],
                'relationships' => [],
            ],
            'food_order_guest_user' => [
                'fields' => [
                    'id'                    => ['mapping' => 'id',                      'insertRole'    => [0,1,2,3,4,5,6],       'updateRole' => [2, 4, 5],        'optionalInsert' => null,       'optionalUpdate' => 1, 'dataType' => 'int',    'expectedValue' => null],
                    'fName'                 => ['mapping' => 'f_name',                  'insertRole'    => [0,1,2,3,4,5,6],       'updateRole' => [2, 4, 5],        'optionalInsert' => 0,          'optionalUpdate' => 1, 'dataType' => 'string', 'expectedValue' => null],
                    'lName'                 => ['mapping' => 'l_name',                  'insertRole'    => [0,1,2,3,4,5,6],       'updateRole' => [2, 4, 5],        'optionalInsert' => 0,          'optionalUpdate' => 1, 'dataType' => 'string', 'expectedValue' => null],
                    'phoneNumber'           => ['mapping' => 'phone_number',            'insertRole'    => [0,1,2,3,4,5,6],       'updateRole' => [2, 4, 5],        'optionalInsert' => 0,          'optionalUpdate' => 1, 'dataType' => 'string', 'expectedValue' => null],
                    'userEmail'             => ['mapping' => 'user_email',              'insertRole'    => [0,1,2,3,4,5,6],       'updateRole' => [2, 4, 5],        'optionalInsert' => 0,          'optionalUpdate' => 1, 'dataType' => 'string', 'expectedValue' => null],
                ],
                'relationships' => [['table' => 'food_order', 'foreignKey' => 'guestUserId']],
            ],
            'food_order_address' => [
                'fields' => [
                    'id'                    => ['mapping' => 'id',                      'insertRole'    => [0,1,2,3,4,5,6],        'updateRole' => [2, 4, 5],       'optionalInsert' => null,       'optionalUpdate' => 1, 'dataType' => 'int',    'expectedValue' => null],
                    'addressLine1'          => ['mapping' => 'address_line_1',          'insertRole'    => [0,1,2,3,4,5,6],        'updateRole' => [0, 2, 4, 5],    'optionalInsert' => 0,          'optionalUpdate' => 1, 'dataType' => 'string', 'expectedValue' => null],
                    'addressLine2'          => ['mapping' => 'address_line_2',          'insertRole'    => [0,1,2,3,4,5,6],        'updateRole' => [2, 4, 5],       'optionalInsert' => 1,          'optionalUpdate' => 1, 'dataType' => 'string', 'expectedValue' => null],
                    'city'                  => ['mapping' => 'city',                    'insertRole'    => [0,1,2,3,4,5,6],        'updateRole' => [2, 4, 5],       'optionalInsert' => 0,          'optionalUpdate' => 1, 'dataType' => 'string', 'expectedValue' => null],
                    'county'                => ['mapping' => 'county',                  'insertRole'    => [0,1,2,3,4,5,6],        'updateRole' => [2, 4, 5],       'optionalInsert' => 1,          'optionalUpdate' => 1, 'dataType' => 'string', 'expectedValue' => null],
                    'country'               => ['mapping' => 'country',                 'insertRole'    => [0,1,2,3,4,5,6],        'updateRole' => [2, 4, 5],       'optionalInsert' => 0,          'optionalUpdate' => 1, 'dataType' => 'string', 'expectedValue' => null],
                    'postalCode'            => ['mapping' => 'postal_code',             'insertRole'    => [0,1,2,3,4,5,6],        'updateRole' => [2, 4, 5],       'optionalInsert' => 0,          'optionalUpdate' => 1, 'dataType' => 'string', 'expectedValue' => null],
                    'checkSum'              => ['mapping' => 'check_sum',               'insertRole'    => [0,1,2,3,4,5,6],        'updateRole' => [2, 4, 5],       'optionalInsert' => 1,          'optionalUpdate' => 1, 'dataType' => 'string', 'expectedValue' => null],
                ],
                'relationships' => [
                    ['table' => 'food_order', 'foreignKey' => 'deliveryAddressId'],
                    ['table' => 'food_order', 'foreignKey' => 'billingAddressId'],
                ],
            ],
            'food_order_user_address' => [
                'fields' => [
                    'id'                    => ['mapping' => 'id',                      'insertRole'    => [0,1,2,3,4,5,6],        'updateRole' => [2, 4, 5],       'optionalInsert' => null,       'optionalUpdate' => 1, 'dataType' => 'int',    'expectedValue' => null],
                    'userId'                => ['mapping' => 'user_id',                 'insertRole'    => [0,1,2,3,4,5,6],        'updateRole' => [2, 4, 5],       'optionalInsert' => 0,          'optionalUpdate' => 0, 'dataType' => 'int',    'expectedValue' => null],
                    'addressId'             => ['mapping' => 'address_id',              'insertRole'    => [0,1,2,3,4,5,6],        'updateRole' => [0, 2, 4, 5],    'optionalInsert' => 0,          'optionalUpdate' => 0, 'dataType' => 'int',    'expectedValue' => null],
                    'isDefault'             => ['mapping' => 'is_default',              'insertRole'    => [0,1,2,3,4,5,6],        'updateRole' => [2, 4, 5],       'optionalInsert' => 1,          'optionalUpdate' => 1, 'dataType' => 'int',    'expectedValue' => null],
                    'isActive'              => ['mapping' => 'is_active',               'insertRole'    => [0,1,2,3,4,5,6],        'updateRole' => [2, 4, 5],       'optionalInsert' => 1,          'optionalUpdate' => 1, 'dataType' => 'int',    'expectedValue' => null],
                    'isDeleted'             => ['mapping' => 'is_deleted',              'insertRole'    => [0,1,2,3,4,5,6],        'updateRole' => [2, 4, 5],       'optionalInsert' => 1,          'optionalUpdate' => 1, 'dataType' => 'int',    'expectedValue' => null],
                ],
                // No relationships for this table
                'relationships' => [],
            ],
        ];
        
        if (!$table) {
            return $allMappings;
        }
    
        $table = toSnakeCase($table);
        if (!isset($allMappings[$table])) {
            return null;
        }
    
        if ($roleId === null) {
            return $allMappings[$table];
        }
    
        $filtered = [];
        foreach ($allMappings[$table]['fields'] as $key => $meta) {
            if ($actionType === 'update' && isset($meta['updateRole'])) {
                if (in_array($roleId, $meta['updateRole'])) {
                    $filtered[$key] = $meta;
                }
            }
            if ($actionType === 'insert' && isset($meta['insertRole'])) {
                if (in_array($roleId, $meta['insertRole'])) {
                    $filtered[$key] = $meta;
                }
            }
            if ($actionType === 'view' && isset($meta['viewRole'])) {
                if (in_array($roleId, $meta['viewRole'])) {
                    $filtered[$key] = $meta;
                }
            }
        }

    
        return ['filtered' => $filtered, 'abc' => $table, 'roleId' => $roleId];
    }
    function updateContent(&$inputData) {
        $pdo = $inputData['db']['dbApp'];
        $pdo->setAttribute(PDO::ATTR_ERRMODE, PDO::ERRMODE_EXCEPTION);
        $stage = [];
        try {
            $pdo->beginTransaction(); // Start transaction
            $tableName = toSnakeCase($inputData['table']) ?? null;
            $inputData['dataKey'] = $inputData['table'];
            $changeType = $inputData['recordType'] ?? null;
            // ✅ Check if the extracted data block actually exists
            if (!isset($inputData['dataKey']) || empty($inputData['dataKey'])) {
                $pdo->rollback(); // Rollback transaction
                return ['status' => 'failed', 'message' => "Missing data block for table: {$tableName}"];
            }
            $stage[] = '00: Validate ID, prepare $inputData with idField, id, checkParent';
            // 00: Validate ID, prepare $inputData with idField, id, checkParent
            $res = validateUpdateInputStep($inputData);
            if ($res['status'] !== 'success') {
                $pdo->rollback(); // Rollback transaction
                if (isset($inputData['debug']) && $inputData['debug'] === $inputData['debugModeFlag']) {
                    $res['stage'] = $stage;
                }
                return $res;
            }

            $stage[] = '01: check item is not marked as deleted no update is possible';
            
    

        if($changeType === 'update') {
            $stage[] = '02: Fetch existing history data (before change)';
            // 02: Fetch existing history data (before change)
            $inputData['nextOperation'] = 'getDataForHistory';
            $res = executeDatabaseOperation($inputData);
            if ($res['status'] !== 'success') {
                $pdo->rollback(); // Rollback transaction
                if (isset($inputData['debug']) && $inputData['debug'] === $inputData['debugModeFlag']) {
                    $res['stage'] = $stage;
                }
                return $res;
            }
            $inputData['historyData'] = $res['historyData'] ?? null;

            $stage[] = '03: Insert history record into history table';
            // 03: Insert history record into history table
            $inputData['nextOperation'] = 'saveHistoryRecordStep';
            $res = executeDatabaseOperation($inputData);

            if ($res['status'] !== 'success') {
                $pdo->rollback(); // Rollback transaction
                if (isset($inputData['debug']) && $inputData['debug'] === $inputData['debugModeFlag']) {
                    $res['stage'] = $stage;
                }
                return $res;
            }
        }
            $stage[] = '04: check if this is an update or a delete action';
            // 04: check if this is an update or a delete action

            $stage[] = '05: check if this is an update or a duplicate action';
            // 05: check if this is an update or a delete action
            if($changeType === 'update') {
                $inputData['nextOperation'] = 'updateMenuTable';
                $res = executeDatabaseOperation($inputData);
            }

            $stage[] = '06: check if this is a duplicate action';
            // 06: check if this is a duplicate action
            if($changeType === 'duplicate') {
                $inputData['nextOperation'] = 'duplicateRecored';
                $res = executeDatabaseOperation($inputData);
            }

            $stage[] = '07: check if the delete or update was successful';
            // 07: check if the delete or update was successful
            if($res['status'] !== 'success') {
                $pdo->rollback(); // Rollback transaction
                if (isset($inputData['debug']) && $inputData['debug'] === $inputData['debugModeFlag']) {
                    $res['stage'] = $stage;
                }
                return $res;
           }
            $pdo->commit();
            return [ 'status' => 'success','message' => 'Update completed successfully'];
        } catch (Exception $e) {
            $pdo->rollback(); // Rollback transaction on error
            $errorInfo = $e->errorInfo ?? [];
            $errorCode = $errorInfo[1] ?? 0; // SQL error code
            $errorMessage = $e->getMessage();
    
            // Determine the type of error
            if ($errorCode == 1062) {
                return ['status' => 'failed', 'message' => "Duplicate entry detected: " . $errorMessage];
            } elseif (isset($inputData['debug']) && $inputData['debug'] === $inputData['debugModeFlag']) {
                return ['status' => 'failed', 'message' => $errorMessage, 'stage' => $stage];
            } else {
                error_log("Error in updateContent: " . $e->getMessage());
                return ['status' => 'failed', 'message' => "Unknown failure"];
            }
        }
    }
    function validateUpdateInputStep(&$inputData) {
        $table = $inputData['table'] ?? null;
        $tableName = toSnakeCase($table);
        $roleId = $inputData['roleId'] ?? null;
        $dataKey = $inputData['table'];
        $actionType = $inputData['recordType'] ?? null;
    
        if (!$tableName) {
            return ['status' => 'failed', 'message' => 'Table name not specified in input'];
        }
    
        if (!$dataKey) {
            return ['status' => 'failed', 'message' => 'Data key not extracted from table name'];
        }


        $tableData = $inputData[$dataKey] ?? [];
            
        $map = menuTableColumnMapping($tableName, $roleId, $actionType);

        $columnMap = $map['filtered'] ?? null;
        
        if (!$columnMap) {
            return ['status' => 'failed', 'message' => 'No column mapping found for table: '. $tableName];
        }
    
        // 🆕 Find the primary key field
        $primaryKey = null;
        foreach ($columnMap as $key => $meta) {
            if (isset($meta['mapping']) && strtolower($meta['mapping']) === 'id') {
                $primaryKey = $key;
                break;
            }
        }
    
        if (!$primaryKey) {
            return ['status' => 'failed', 'message' => "No primary key (id) field found for table: {$tableName}"];
        }
    
        // 🆕 Recursively search for the ID value
        $idValue = findIdInData($tableData, $primaryKey);
    
        if ($idValue === null || $idValue === '') {
            return ['status' => 'failed', 'message' => "Missing required Id field: {$primaryKey} key: {$tableName}"];
        }
    
        // Set ID info for future steps
        $inputData['idField'] = $primaryKey;
        $inputData['id'] = $idValue;
    
        // Set checkParent flag
        $inputData['checkParent'] = array_key_exists('parentId', $columnMap) ? 1 : 0;

        return ['status' => 'success'];
    }
    function findIdInData($data, $primaryKey) {
        foreach ($data as $key => $value) {
            if (is_array($value)) {
                // Recurse into sub-arrays
                $found = findIdInData($value, $primaryKey);
                if ($found !== null) {
                    return $found;
                }
            } else {
                if ($key === $primaryKey) {
                    return $value;
                }
            }
        }
        return null;
    }
    function executeDatabaseOperation(&$inputData) {
        $operation = $inputData['nextOperation'];
        try {
            $results =  $operation($inputData);
        } catch (PDOException $e) {
            $errorInfo = $e->errorInfo ?? [];
            $errorCode = $errorInfo[1] ?? 0; // SQL error code
            $errorMessage = $e->getMessage();
    
            // Determine the type of error
            if ($errorCode == 1062) {
                $results =  ['status' => 'failed', 'message' => "Duplicate entry detected: " . $errorMessage];
            } elseif (isset($inputData['debug']) && $inputData['debug'] === $inputData['debugModeFlag']) {
                $results = ['status' => 'failed', 'message' => $errorMessage];
            }else{
                $results = ['status' => 'failed', 'message' => "Unknown failure"];
            }
        }
        return $results;
    }
    function convertKeysToCamelCase($array) {
        $converted = [];

        foreach ($array as $key => $value) {
            // Convert snake_case to camelCase
            $camelKey = preg_replace_callback('/_([a-z])/', function ($matches) {
                return strtoupper($matches[1]);
            }, $key);

            // Lowercase first character to enforce camelCase
            $camelKey = lcfirst($camelKey);

            // Recursively handle nested arrays
            if (is_array($value)) {
                $converted[$camelKey] = convertKeysToCamelCase($value);
            } else {
                $converted[$camelKey] = $value;
            }
        }

        return $converted;
    }
    function toSnakeCase($input) {
        return strtolower(preg_replace('/([a-z])([A-Z])/', '$1_$2', $input));
    }
    function renameIdKeys($array, $newKeyName) {
        $converted = [];

        foreach ($array as $key => $value) {
            // Recursively handle nested arrays
            if (is_array($value)) {
                $value = renameIdKeys($value, $newKeyName);
            }

            if ($key === 'id') {
                $converted[$newKeyName] = $value;
            } else {
                $converted[$key] = $value;
            }
        }

        return $converted;
    }
    function extractDataKeyFromTableName($tableName) {
        $parts = explode('_', $tableName, 2);
        $base = $parts[1] ?? $tableName;
    
        $baseParts = explode('_', $base);
    
        $camelCase = array_shift($baseParts);
    
        foreach ($baseParts as $part) {
            $camelCase .= ucfirst($part);
        }
    
        return $camelCase;
    }
    function roleViewType($roleId) {
        if(in_array($roleId, [1, 2, 3])) {
            return 'sysAdmin';
        } elseif($roleId == 4) {
            return 'owner';
        } elseif($roleId == 5) {
            return 'manager';
        } elseif($roleId == 6) {
            return 'staff';
        } else{
            return 'guest';
        }
    }
    function generateChecksum(array $data): string{
        // Sort the array by key (alphabetically)
        ksort($data);

        // Normalize values (e.g., trim and cast to string)
        $normalizedValues = array_map(function ($value) {
            return is_null($value) ? '' : trim((string)$value);
        }, $data);

        // Join values with a consistent separator (e.g., pipe)
        $inputString = implode('|', $normalizedValues);

        // Generate checksum (SHA-256)
        return hash('sha256', $inputString);
    }
    function acceptedPreAuthPayment($inputData){
        // check if the id is set
        $inputData['step'][] = 'acceptedPreAuthPayment()';

        if (isset($inputData['foodOrder']) && is_array($inputData['foodOrder'])) {
            if (isset($inputData['foodOrder'][0]) && is_array($inputData['foodOrder'][0])) {
                $inputData['foodOrder'] = $inputData['foodOrder'][0];
            }
        }

        $inputData['step'][] = 'acceptedPreAuthPayment() - validation';
        if(!isset($inputData['foodOrder']['id']) || empty($inputData['foodOrder']['id'])) {
            return ['status' => 'failed', 'message' => 'Order ID is required for pre-auth payment.'];
        }

        $inputData['step'][] = 'acceptedPreAuthPayment() - check accepted or rejected';
        //check if accepted or rejected 1 or 0 is set
        if(!isset($inputData['foodOrder']['accepted']) || !in_array($inputData['foodOrder']['accepted'], [0, 1])) {
            return ['status' => 'failed', 'message' => 'Accepted value is required for pre-auth payment.'];
        }

        $inputData['step'][] = 'acceptedPreAuthPayment() - set order status';
        // unset the accepted key
        if($inputData['foodOrder']['accepted'] == 0) {
            // if accepted is 0, then we will cancel the order
            $inputData['foodOrder']['orderStatus'] = 'cancelled';
            $inputData['step'][] = 'acceptedPreAuthPayment() - order status set to cancelled';
        }else{
            // if accepted is 1, then we will confirm the order
            $inputData['foodOrder']['orderStatus'] = 'confirmed';
            $inputData['step'][] = 'acceptedPreAuthPayment() - order status set to confirmed';
        }

        // unset the accepted key
        $inputData['step'][] = 'acceptedPreAuthPayment() - unsetting accepted key';
        unset($inputData['foodOrder']['accepted']);



        // get the payment intent id from the order
        $inputData['step'][] = 'acceptedPreAuthPayment() - getting payment intent id from order';
        $inputData['nextOperation'] = 'viewPaymentIntentOrderById';
        $inputData['id'] = $inputData['foodOrder']['id'];
        $res = executeDatabaseOperation($inputData);

        $inputData['step'][] = 'acceptedPreAuthPayment() - getting payment intent id from order';
        if($res['status'] !== 'success') {
            if(isset($inputData['debug']) && $inputData['debug'] === $inputData['debugModeFlag']) {
                return ['status' => 'failed', 'message' => $res['message'], 'step' => $inputData['step']];
            }
            return ['status' => 'failed', 'message' => $res['message']];
        }


        // check if the payment intent id is set
        if(!isset($res['data']['paymentIntentId']) || empty($res['data']['paymentIntentId'])) {
            // if debug mode is on, return the error
            if(isset($inputData['debug']) && $inputData['debug'] === $inputData['debugModeFlag']) {
                return ['status' => 'failed', 'message' => 'Payment intent ID is missing from the order.', 'step' => $inputData['step']];
            }else{
                return ['status' => 'failed', 'message' => 'Payment intent ID is missing from the order.'];
            }
        }
        
        // set the payment intent id in the inputData
        $inputData['step'][] = 'acceptedPreAuthPayment() - payment intent id found';
        $inputData['secure']['paymentIntentId'] = $res['data']['paymentIntentId'];


        // get the payment Account Id from tenant info
        $inputData['step'][] = 'acceptedPreAuthPayment() - getting tenant API key';
        $inputData['nextOperation'] = 'viewTenantInfo';
        $res = executeDatabaseOperation($inputData);

        if($res['status'] !== 'success') {
            if(isset($inputData['debug']) && $inputData['debug'] === $inputData['debugModeFlag']) {
                return ['status' => 'failed', 'message' => $res['message'], 'step' => $inputData['step']];
            }
            return ['status' => 'failed', 'message' => $res['message']];
        }

        $inputData['step'][] = 'acceptedPreAuthPayment() - tenant API key found';
        $inputData['secure']['stripeAccountKey'] = $res['tenantInfo']['paymentApiKey'] ?? null;


        $inputData['step'][] = 'acceptedPreAuthPayment() - stripe secret key found';
        if($inputData['foodOrder']['orderStatus'] == 'cancelled') {
            // if the order is cancelled, we will cancel the payment intent
            $inputData['step'][] = 'acceptedPreAuthPayment() - cancelling payment intent';
            $res = cancelPayment($inputData);
            if($res['status'] !== 'success') {
                if(isset($inputData['debug']) && $inputData['debug'] === $inputData['debugModeFlag']) {
                    return ['status' => 'failed', 'message' => $res['message'], 'step' => $inputData['step']];
                }
                return ['status' => 'failed', 'message' => $res['message']];
            }
        }
        if($inputData['foodOrder']['orderStatus'] == 'confirmed') {
            $inputData['step'][] = 'acceptedPreAuthPayment() - charging payment intent';
            // if the order is confirmed, we will charge the payment intent
            $res = chargePayment($inputData);
            if($res['status'] !== 'success') {
                if(isset($inputData['debug']) && $inputData['debug'] === $inputData['debugModeFlag']) {
                    return ['status' => 'failed', 'message' => $res['message'], 'step' => $inputData['step']];
                }
                return ['status' => 'failed', 'message' => $res['message']];
            }
        }

        $inputData['step'][] = 'acceptedPreAuthPayment() - updating order status';
        // set the next operation to update the order

        $res = updateSuccessful($inputData);
        $inputData['step'][] = 'acceptedPreAuthPayment() - order status updated';

        if($res['status'] !== 'success') {
            if(isset($inputData['debug']) && $inputData['debug'] === $inputData['debugModeFlag']) {
                return ['status' => 'failed', 'message' => $res['message'], 'step' => $inputData['step']];
            }
            return ['status' => 'failed', 'message' => $res['message']];
        }

        return ['status' => 'success', 'message' => 'Order pre-auth payment accepted successfully.'];
    }
    function chargePayment($inputData, $captureAmountInPence = null) {
        if (empty($inputData['secure']['paymentIntentId'])) {
            return ['status' => 'failed', 'message' => 'Payment intent ID is required'];
        }

        if (defined('TEST_ENV') && TEST_ENV) {
            return ['status' => 'success', 'message' => 'Test environment – not charging'];
        }

        require_once __DIR__ . '/../vendor/autoload.php';
        if (!class_exists('\Stripe\Stripe')) {
            return ['status' => 'failed', 'message' => 'Stripe dependency not available'];
        }
        \Stripe\Stripe::setApiKey($inputData['secure']['stripeSecretKey']);
        \Stripe\Stripe::setAccountId($inputData['secure']['stripeAccountKey'] ?? null);
        $piId = $inputData['secure']['paymentIntentId'];

        try {
            $pi = \Stripe\PaymentIntent::retrieve($piId);

            if ($pi->status === 'requires_confirmation') {
                $pi = $pi->confirm(); // only if client didn’t confirm
            }

            if ($pi->status === 'requires_capture') {
                $captureParams = [];
                if (is_int($captureAmountInPence)) {
                    $captureParams['amount_to_capture'] = max(1, $captureAmountInPence);
                }
                $pi = $pi->capture($captureParams);
            }

            if ($pi->status === 'succeeded') {
                // last charge ID is available in the PaymentIntent object
                $inputData['secure']['chargeId'] = $pi->latest_charge;
                // url of receipt
                $inputData['secure']['receiptUrl'] = $pi->charges->data[0]->receipt_url ?? null;


                $res = updateWithChargeId($inputData);
                if ($res['status'] !== 'success') {
                    return ['status' => 'failed', 'message' => $res['message']];
                }

                return ['status' => 'success', 'message' => 'Payment charged successfully'];

            }

            return ['status' => 'failed', 'message' => "Cannot charge payment in status '{$pi->status}'"];
        } catch (\Stripe\Exception\ApiErrorException $e) {
            return ['status' => 'failed', 'message' => $e->getMessage()];
        }
    }
    function cancelPayment($inputData, $cancellationReason = 'abandoned') {
        // Validate
        if (empty($inputData['secure']['paymentIntentId'])) {
            return ['status' => 'failed', 'message' => 'Payment intent ID is required for cancelling payment.'];
        }

        // Respect test mode
        if (defined('TEST_ENV') && TEST_ENV) {
            return ['status' => 'success', 'message' => 'Test environment – not cancelling.'];
        }

        require_once __DIR__ . '/../vendor/autoload.php';
        if (!class_exists('\Stripe\Stripe')) {
            return ['status' => 'failed', 'message' => 'Stripe dependency not available'];
        }

        \Stripe\Stripe::setApiKey($inputData['secure']['stripeSecretKey']);
        \Stripe\Stripe::setAccountId($inputData['secure']['stripeAccountKey'] ?? null);
        $piId = $inputData['secure']['paymentIntentId'];

        // If you created the PI on a connected account directly, set this:
        // $opts = ['stripe_account' => $inputData['secure']['shopStripeAccountId']];
        $opts = [];

        try {
            /** @var \Stripe\PaymentIntent $pi */
            $pi = \Stripe\PaymentIntent::retrieve($piId, $opts);

            // If already cancelled, we're done
            if ($pi->status === 'canceled') {
                return ['status' => 'success', 'message' => 'Payment already canceled (hold released).'];
            }

            // Allowed-to-cancel (releases the hold) — do NOT refund
            $cancellable = [
                'requires_capture',       // auth placed, waiting for capture
                'requires_confirmation',  // not confirmed yet
                'requires_payment_method',
                'requires_action',
                'processing',             // may cancel depending on timing/method
            ];

            if (in_array($pi->status, $cancellable, true)) {
                $pi = $pi->cancel(['cancellation_reason' => $cancellationReason], $opts);
                return ['status' => 'success', 'message' => 'Authorization hold released (payment canceled).', 'data' => $pi];
            }

            // If already captured, do NOT refund (per your rule)
            if ($pi->status === 'succeeded') {

                $res = updateCancelled($inputData);
                if ($res['status'] !== 'success') {
                    return ['status' => 'failed', 'message' => $res['message']];
                }

                // If already captured, do NOT refund (per your rule)
                return [
                    'status'  => 'failed',
                    'message' => 'Payment already captured; cannot release hold without refund (refunds are disabled).'
                ];
            }

            // Any other odd status
            return [
                'status'  => 'failed',
                'message' => "Cannot cancel payment in status '{$pi->status}'."
            ];
        } catch (\Stripe\Exception\ApiErrorException $e) {
            return ['status' => 'failed', 'message' => 'Stripe error: ' . $e->getMessage()];
        } catch (\Exception $e) {
            return ['status' => 'failed', 'message' => 'Error: ' . $e->getMessage()];
        }
    }
?>