<?php
    function menuTableColumnMapping($table = null, $roleId = null, $actionType = null) {
       $allMappings = [
            'food_order' => [
                'fields' => [
                    'id'                        => ['mapping' => 'id',                          'insertRole'    => [0,1,2,3,4,5,6],         'updateRole' => [2, 4, 5],            'optionalInsert' => null,         'optionalUpdate' => 1, 'dataType' => 'int',    'expectedValue' => null],
                    'userId'                    => ['mapping' => 'user_id',                     'insertRole'    => [0,1,2,3,4,5,6],         'updateRole' => [2, 4, 5],            'optionalInsert' => 1,            'optionalUpdate' => 0, 'dataType' => 'int',    'expectedValue' => null],
                    'guestUserId'               => ['mapping' => 'guest_user_id',               'insertRole'    => [0,1,2,3,4,5,6],         'updateRole' => [2, 4, 5],            'optionalInsert' => 1,            'optionalUpdate' => 0, 'dataType' => 'int',    'expectedValue' => null],
                    'tenantId'                  => ['mapping' => 'tenant_id',                   'insertRole'    => [0,1,2,3,4,5,6],         'updateRole' => [2, 4, 5],            'optionalInsert' => 1,            'optionalUpdate' => 0, 'dataType' => 'int',    'expectedValue' => null],
                    'deliveryAddressId'         => ['mapping' => 'delivery_address_id',         'insertRole'    => [0,1,2,3,4,5,6],         'updateRole' => [2, 4, 5],            'optionalInsert' => 1,            'optionalUpdate' => 0, 'dataType' => 'int',    'expectedValue' => null],
                    'billingAddressId'          => ['mapping' => 'billing_address_id',          'insertRole'    => [0,1,2,3,4,5,6],         'updateRole' => [2, 4, 5],            'optionalInsert' => 1,            'optionalUpdate' => 0, 'dataType' => 'int',    'expectedValue' => null],
                    'orderStatus'               => ['mapping' => 'order_status',                'insertRole'    => [0,1,2,3,4,5,6],         'updateRole' => [2, 4, 5, 6],         'optionalInsert' => 1,            'optionalUpdate' => 1, 'dataType' => 'string', 'expectedValue' => ['pending','completed','cancelled']],
                    'orderType'                 => ['mapping' => 'order_type',                  'insertRole'    => [0,1,2,3,4,5,6],         'updateRole' => [2, 4, 5],            'optionalInsert' => 1,            'optionalUpdate' => 1, 'dataType' => 'string', 'expectedValue' => ['delivery','pickup','dine-in','collection']],
                    'paymentStatus'             => ['mapping' => 'payment_status',              'insertRole'    => [0,1,2,3,4,5,6],         'updateRole' => [2, 4, 5],            'optionalInsert' => 1,            'optionalUpdate' => 1, 'dataType' => 'string', 'expectedValue' => ['unpaid','paid','refunded','partial_refund','payment_intent','payment_pre_auth']],
                    'deliveryFee'               => ['mapping' => 'delivery_fee',                'insertRole'    => [0,1,2,3,4,5,6],         'updateRole' => [2, 4, 5],            'optionalInsert' => 1,            'optionalUpdate' => 1, 'dataType' => 'float',  'expectedValue' => null],
                    'orderFee'                  => ['mapping' => 'order_fee',                   'insertRole'    => [0,1,2,3,4,5,6],         'updateRole' => [2, 4, 5],            'optionalInsert' => 1,            'optionalUpdate' => 1, 'dataType' => 'float',  'expectedValue' => null],
                    'smallOrderFee'             => ['mapping' => 'small_order_fee',             'insertRole'    => [0,1,2,3,4,5,6],         'updateRole' => [2, 4, 5],            'optionalInsert' => 1,            'optionalUpdate' => 1, 'dataType' => 'float',  'expectedValue' => null],
                    'currency'                  => ['mapping' => 'currency',                    'insertRole'    => [0,1,2,3,4,5,6],         'updateRole' => [2, 4, 5],            'optionalInsert' => 1,            'optionalUpdate' => 1, 'dataType' => 'string', 'expectedValue' => null],
                    'transactionId'             => ['mapping' => 'transaction_id',              'insertRole'    => [0,1,2,3,4,5,6],         'updateRole' => [2, 4, 5],            'optionalInsert' => 1,            'optionalUpdate' => 1, 'dataType' => 'string', 'expectedValue' => null],
                    'paymentIntentId'           => ['mapping' => 'payment_intent_id',           'insertRole'    => [0,1,2,3,4,5,6],         'updateRole' => [2, 4, 5],            'optionalInsert' => 1,            'optionalUpdate' => 1, 'dataType' => 'string', 'expectedValue' => null],
                    'comment'                   => ['mapping' => 'comment',                     'insertRole'    => [0,1,2,3,4,5,6],         'updateRole' => [2, 4, 5],            'optionalInsert' => 1,            'optionalUpdate' => 1, 'dataType' => 'string', 'expectedValue' => null],
                    'tenantComment'             => ['mapping' => 'tenant_comment',              'insertRole'    => [0,1,2,3,4,5,6],         'updateRole' => [2, 4, 5],            'optionalInsert' => 1,            'optionalUpdate' => 1, 'dataType' => 'string', 'expectedValue' => null],
                    'totalOrderPrice'           => ['mapping' => 'total_order_price',           'insertRole'    => [0,1,2,3,4,5,6],         'updateRole' => [2, 4, 5],            'optionalInsert' => 1,            'optionalUpdate' => 1, 'dataType' => 'float',  'expectedValue' => null],
                    'totalOrderModifiedPrice'   => ['mapping' => 'total_order_modified_price',  'insertRole'    => [0,1,2,3,4,5,6],         'updateRole' => [2, 4, 5],            'optionalInsert' => 1,            'optionalUpdate' => 1, 'dataType' => 'float',  'expectedValue' => null],
                    'totalOrderModifiedReason'  => ['mapping' => 'total_order_modified_reason', 'insertRole'    => [0,1,2,3,4,5,6],         'updateRole' => [2, 4, 5],            'optionalInsert' => 1,            'optionalUpdate' => 1, 'dataType' => 'string', 'expectedValue' => null],
                ],
                'relationships' => [['table' => 'food_order_item', 'foreignKey' => 'orderId']],
            ],
            'food_order_item' => [
                'fields' => [
                    'id'                    => ['mapping' => 'id',                      'insertRole'    => [0,1,2,3,4,5,6],    'updateRole' => [2, 4, 5],           'optionalInsert' => null,       'optionalUpdate' => 1, 'dataType' => 'int',    'expectedValue' => null],
                    'orderId'               => ['mapping' => 'order_id',                'insertRole'    => [0,1,2,3,4,5,6],    'updateRole' => [2, 4, 5],           'optionalInsert' => 0,          'optionalUpdate' => 0, 'dataType' => 'int',    'expectedValue' => null],
                    'menuItemId'            => ['mapping' => 'menu_item_id',            'insertRole'    => [0,1,2,3,4,5,6],    'updateRole' => [2, 4, 5],           'optionalInsert' => 0,          'optionalUpdate' => 0, 'dataType' => 'int',    'expectedValue' => null],
                    'itemName'              => ['mapping' => 'item_name',               'insertRole'    => [0,1,2,3,4,5,6],    'updateRole' => [2, 4, 5],           'optionalInsert' => 0,          'optionalUpdate' => 0, 'dataType' => 'string', 'expectedValue' => null],
                    'itemBasePrice'         => ['mapping' => 'item_base_price',         'insertRole'    => [0,1,2,3,4,5,6],    'updateRole' => [2, 4, 5],           'optionalInsert' => 0,          'optionalUpdate' => 1, 'dataType' => 'float',  'expectedValue' => null],
                    'itemModifiedPrice'     => ['mapping' => 'item_modified_price',     'insertRole'    => [0,1,2,3,4,5,6],    'updateRole' => [2, 4, 5],           'optionalInsert' => 1,          'optionalUpdate' => 1, 'dataType' => 'float',  'expectedValue' => null],
                    'itemModifiedReason'    => ['mapping' => 'item_modified_reason',    'insertRole'    => [0,1,2,3,4,5,6],    'updateRole' => [2, 4, 5],           'optionalInsert' => 1,          'optionalUpdate' => 1, 'dataType' => 'string', 'expectedValue' => null],
                    'itemQuantity'          => ['mapping' => 'item_quantity',           'insertRole'    => [0,1,2,3,4,5,6],    'updateRole' => [2, 4, 5],           'optionalInsert' => 0,          'optionalUpdate' => 1, 'dataType' => 'int',    'expectedValue' => null],
                    'itemNote'              => ['mapping' => 'item_note',               'insertRole'    => [0,1,2,3,4,5,6],    'updateRole' => [2, 4, 5],           'optionalInsert' => 1,          'optionalUpdate' => 1, 'dataType' => 'string', 'expectedValue' => null],
                    'itemStatus'            => ['mapping' => 'item_status',             'insertRole'    => [0,1,2,3,4,5,6],    'updateRole' => [2, 4, 5],           'optionalInsert' => 1,          'optionalUpdate' => 1, 'dataType' => 'string', 'expectedValue' => ['pending','prepared','served','cancelled']],
                    'itemTenantComment'     => ['mapping' => 'item_tenant_comment',     'insertRole'    => [0,1,2,3,4,5,6],    'updateRole' => [2, 4, 5],           'optionalInsert' => 1,          'optionalUpdate' => 1, 'dataType' => 'string', 'expectedValue' => null],
                ],
                'relationships' => [['table' => 'food_order_extra', 'foreignKey' => 'itemId']],
            ],
            'food_order_extra' => [
                'fields' => [
                    'id'                    => ['mapping' => 'id',                      'insertRole'    => [0,1,2,3,4,5,6],     'updateRole' => [2, 4, 5],          'optionalInsert' => null,       'optionalUpdate' => 1, 'dataType' => 'int',    'expectedValue' => null],
                    'itemId'                => ['mapping' => 'item_id',                 'insertRole'    => [0,1,2,3,4,5,6],     'updateRole' => [2, 4, 5],          'optionalInsert' => 0,          'optionalUpdate' => 0, 'dataType' => 'int',    'expectedValue' => null],
                    'menuExtraId'           => ['mapping' => 'menu_extra_id',           'insertRole'    => [0,1,2,3,4,5,6],     'updateRole' => [2, 4, 5],          'optionalInsert' => 1,          'optionalUpdate' => 0, 'dataType' => 'int',    'expectedValue' => null],
                    'extraName'             => ['mapping' => 'extra_name',              'insertRole'    => [0,1,2,3,4,5,6],     'updateRole' => [2, 4, 5],          'optionalInsert' => 0,          'optionalUpdate' => 1, 'dataType' => 'string', 'expectedValue' => null],
                    'extraPrice'            => ['mapping' => 'extra_price',             'insertRole'    => [0,1,2,3,4,5,6],     'updateRole' => [2, 4, 5],          'optionalInsert' => 0,          'optionalUpdate' => 1, 'dataType' => 'float',  'expectedValue' => null],
                ],
                'relationships' => [],
            ],
            'food_order_guest_user' => [
                'fields' => [
                    'id'                    => ['mapping' => 'id',                      'insertRole'    => [0,1,2,3,4,5,6],       'updateRole' => [2, 4, 5],        'optionalInsert' => null,       'optionalUpdate' => 1, 'dataType' => 'int',    'expectedValue' => null],
                    'fName'                 => ['mapping' => 'f_name',                  'insertRole'    => [0,1,2,3,4,5,6],       'updateRole' => [2, 4, 5],        'optionalInsert' => 0,          'optionalUpdate' => 1, 'dataType' => 'string', 'expectedValue' => null],
                    'lName'                 => ['mapping' => 'l_name',                  'insertRole'    => [0,1,2,3,4,5,6],       'updateRole' => [2, 4, 5],        'optionalInsert' => 0,          'optionalUpdate' => 1, 'dataType' => 'string', 'expectedValue' => null],
                    'phoneNumber'           => ['mapping' => 'phone_number',            'insertRole'    => [0,1,2,3,4,5,6],       'updateRole' => [2, 4, 5],        'optionalInsert' => 0,          'optionalUpdate' => 1, 'dataType' => 'string', 'expectedValue' => null],
                    'userEmail'             => ['mapping' => 'user_email',              'insertRole'    => [0,1,2,3,4,5,6],       'updateRole' => [2, 4, 5],        'optionalInsert' => 0,          'optionalUpdate' => 1, 'dataType' => 'string', 'expectedValue' => null],
                ],
                'relationships' => [['table' => 'food_order', 'foreignKey' => 'guestUserId']],
            ],
            'food_order_address' => [
                'fields' => [
                    'id'                    => ['mapping' => 'id',                      'insertRole'    => [0,1,2,3,4,5,6],        'updateRole' => [2, 4, 5],       'optionalInsert' => null,       'optionalUpdate' => 1, 'dataType' => 'int',    'expectedValue' => null],
                    'addressLine1'          => ['mapping' => 'address_line_1',          'insertRole'    => [0,1,2,3,4,5,6],        'updateRole' => [0, 2, 4, 5],    'optionalInsert' => 0,          'optionalUpdate' => 1, 'dataType' => 'string', 'expectedValue' => null],
                    'addressLine2'          => ['mapping' => 'address_line_2',          'insertRole'    => [0,1,2,3,4,5,6],        'updateRole' => [2, 4, 5],       'optionalInsert' => 1,          'optionalUpdate' => 1, 'dataType' => 'string', 'expectedValue' => null],
                    'city'                  => ['mapping' => 'city',                    'insertRole'    => [0,1,2,3,4,5,6],        'updateRole' => [2, 4, 5],       'optionalInsert' => 0,          'optionalUpdate' => 1, 'dataType' => 'string', 'expectedValue' => null],
                    'county'                => ['mapping' => 'county',                  'insertRole'    => [0,1,2,3,4,5,6],        'updateRole' => [2, 4, 5],       'optionalInsert' => 1,          'optionalUpdate' => 1, 'dataType' => 'string', 'expectedValue' => null],
                    'country'               => ['mapping' => 'country',                 'insertRole'    => [0,1,2,3,4,5,6],        'updateRole' => [2, 4, 5],       'optionalInsert' => 0,          'optionalUpdate' => 1, 'dataType' => 'string', 'expectedValue' => null],
                    'postalCode'            => ['mapping' => 'postal_code',             'insertRole'    => [0,1,2,3,4,5,6],        'updateRole' => [2, 4, 5],       'optionalInsert' => 0,          'optionalUpdate' => 1, 'dataType' => 'string', 'expectedValue' => null],
                    'checkSum'              => ['mapping' => 'check_sum',               'insertRole'    => [0,1,2,3,4,5,6],        'updateRole' => [2, 4, 5],       'optionalInsert' => 1,          'optionalUpdate' => 1, 'dataType' => 'string', 'expectedValue' => null],
                ],
                'relationships' => [
                    ['table' => 'food_order', 'foreignKey' => 'deliveryAddressId'],
                    ['table' => 'food_order', 'foreignKey' => 'billingAddressId'],
                ],
            ],
            'food_order_user_address' => [
                'fields' => [
                    'id'                    => ['mapping' => 'id',                      'insertRole'    => [0,1,2,3,4,5,6],        'updateRole' => [2, 4, 5],       'optionalInsert' => null,       'optionalUpdate' => 1, 'dataType' => 'int',    'expectedValue' => null],
                    'userId'                => ['mapping' => 'user_id',                 'insertRole'    => [0,1,2,3,4,5,6],        'updateRole' => [2, 4, 5],       'optionalInsert' => 0,          'optionalUpdate' => 0, 'dataType' => 'int',    'expectedValue' => null],
                    'addressId'             => ['mapping' => 'address_id',              'insertRole'    => [0,1,2,3,4,5,6],        'updateRole' => [0, 2, 4, 5],    'optionalInsert' => 0,          'optionalUpdate' => 0, 'dataType' => 'int',    'expectedValue' => null],
                    'isDefault'             => ['mapping' => 'is_default',              'insertRole'    => [0,1,2,3,4,5,6],        'updateRole' => [2, 4, 5],       'optionalInsert' => 1,          'optionalUpdate' => 1, 'dataType' => 'int',    'expectedValue' => null],
                    'isActive'              => ['mapping' => 'is_active',               'insertRole'    => [0,1,2,3,4,5,6],        'updateRole' => [2, 4, 5],       'optionalInsert' => 1,          'optionalUpdate' => 1, 'dataType' => 'int',    'expectedValue' => null],
                    'isDeleted'             => ['mapping' => 'is_deleted',              'insertRole'    => [0,1,2,3,4,5,6],        'updateRole' => [2, 4, 5],       'optionalInsert' => 1,          'optionalUpdate' => 1, 'dataType' => 'int',    'expectedValue' => null],
                ],
                // No relationships for this table
                'relationships' => [],
            ],
        ];
        
        if (!$table) {
            return $allMappings;
        }
    
        $table = toSnakeCase($table);
        if (!isset($allMappings[$table])) {
            return null;
        }
    
        if ($roleId === null) {
            return $allMappings[$table];
        }
    
        $filtered = [];
        foreach ($allMappings[$table]['fields'] as $key => $meta) {
            if ($actionType === 'update' && isset($meta['updateRole'])) {
                if (in_array($roleId, $meta['updateRole'])) {
                    $filtered[$key] = $meta;
                }
            }
            if ($actionType === 'insert' && isset($meta['insertRole'])) {
                if (in_array($roleId, $meta['insertRole'])) {
                    $filtered[$key] = $meta;
                }
            }
            if ($actionType === 'view' && isset($meta['viewRole'])) {
                if (in_array($roleId, $meta['viewRole'])) {
                    $filtered[$key] = $meta;
                }
            }
        }

    
        return ['filtered' => $filtered, 'abc' => $table, 'roleId' => $roleId];
    }
    function updateContent(&$inputData) {
        $pdo = $inputData['db']['dbApp'];
        $pdo->setAttribute(PDO::ATTR_ERRMODE, PDO::ERRMODE_EXCEPTION);
        $stage = [];
        try {
            $pdo->beginTransaction(); // Start transaction
            $tableName = toSnakeCase($inputData['table']) ?? null;
            $inputData['dataKey'] = $inputData['table'];
            $changeType = $inputData['recordType'] ?? null;
            // ✅ Check if the extracted data block actually exists
            if (!isset($inputData['dataKey']) || empty($inputData['dataKey'])) {
                $pdo->rollback(); // Rollback transaction
                return ['status' => 'failed', 'message' => "Missing data block for table: {$tableName}"];
            }
            $stage[] = '00: Validate ID, prepare $inputData with idField, id, checkParent';
            // 00: Validate ID, prepare $inputData with idField, id, checkParent
            $res = validateUpdateInputStep($inputData);
            if ($res['status'] !== 'success') {
                $pdo->rollback(); // Rollback transaction
                if (isset($inputData['debug']) && $inputData['debug'] === $inputData['debugModeFlag']) {
                    $res['stage'] = $stage;
                }
                return $res;
            }

            $stage[] = '01: check item is not marked as deleted no update is possible';
            
    

        if($changeType === 'update') {
            $stage[] = '02: Fetch existing history data (before change)';
            // 02: Fetch existing history data (before change)
            $inputData['nextOperation'] = 'getDataForHistory';
            $res = executeDatabaseOperation($inputData);
            if ($res['status'] !== 'success') {
                $pdo->rollback(); // Rollback transaction
                if (isset($inputData['debug']) && $inputData['debug'] === $inputData['debugModeFlag']) {
                    $res['stage'] = $stage;
                }
                return $res;
            }
            $inputData['historyData'] = $res['historyData'] ?? null;

            $stage[] = '03: Insert history record into history table';
            // 03: Insert history record into history table
            $inputData['nextOperation'] = 'saveHistoryRecordStep';
            $res = executeDatabaseOperation($inputData);

            if ($res['status'] !== 'success') {
                $pdo->rollback(); // Rollback transaction
                if (isset($inputData['debug']) && $inputData['debug'] === $inputData['debugModeFlag']) {
                    $res['stage'] = $stage;
                }
                return $res;
            }
        }
            $stage[] = '04: check if this is an update or a delete action';
            // 04: check if this is an update or a delete action

            $stage[] = '05: check if this is an update or a duplicate action';
            // 05: check if this is an update or a delete action
            if($changeType === 'update') {
                $inputData['nextOperation'] = 'updateMenuTable';
                $res = executeDatabaseOperation($inputData);
            }

            $stage[] = '06: check if this is a duplicate action';
            // 06: check if this is a duplicate action
            if($changeType === 'duplicate') {
                $inputData['nextOperation'] = 'duplicateRecored';
                $res = executeDatabaseOperation($inputData);
            }

            $stage[] = '07: check if the delete or update was successful';
            // 07: check if the delete or update was successful
            if($res['status'] !== 'success') {
                $pdo->rollback(); // Rollback transaction
                if (isset($inputData['debug']) && $inputData['debug'] === $inputData['debugModeFlag']) {
                    $res['stage'] = $stage;
                }
                return $res;
           }
            $pdo->commit();
            return [ 'status' => 'success','message' => 'Update completed successfully'];
        } catch (Exception $e) {
            $pdo->rollback(); // Rollback transaction on error
            $errorInfo = $e->errorInfo ?? [];
            $errorCode = $errorInfo[1] ?? 0; // SQL error code
            $errorMessage = $e->getMessage();
    
            // Determine the type of error
            if ($errorCode == 1062) {
                return ['status' => 'failed', 'message' => "Duplicate entry detected: " . $errorMessage];
            } elseif (isset($inputData['debug']) && $inputData['debug'] === $inputData['debugModeFlag']) {
                return ['status' => 'failed', 'message' => $errorMessage, 'stage' => $stage];
            } else {
                error_log("Error in updateContent: " . $e->getMessage());
                return ['status' => 'failed', 'message' => "Unknown failure"];
            }
        }
    }
    function validateUpdateInputStep(&$inputData) {
        $table = $inputData['table'] ?? null;
        $tableName = toSnakeCase($table);
        $roleId = $inputData['roleId'] ?? null;
        $dataKey = $inputData['table'];
        $actionType = $inputData['recordType'] ?? null;
    
        if (!$tableName) {
            return ['status' => 'failed', 'message' => 'Table name not specified in input'];
        }
    
        if (!$dataKey) {
            return ['status' => 'failed', 'message' => 'Data key not extracted from table name'];
        }


        $tableData = $inputData[$dataKey] ?? [];
            
        $map = menuTableColumnMapping($tableName, $roleId, $actionType);

        $columnMap = $map['filtered'] ?? null;
        
        if (!$columnMap) {
            return ['status' => 'failed', 'message' => 'No column mapping found for table: '. $tableName];
        }
    
        // 🆕 Find the primary key field
        $primaryKey = null;
        foreach ($columnMap as $key => $meta) {
            if (isset($meta['mapping']) && strtolower($meta['mapping']) === 'id') {
                $primaryKey = $key;
                break;
            }
        }
    
        if (!$primaryKey) {
            return ['status' => 'failed', 'message' => "No primary key (id) field found for table: {$tableName}"];
        }
    
        // 🆕 Recursively search for the ID value
        $idValue = findIdInData($tableData, $primaryKey);
    
        if ($idValue === null || $idValue === '') {
            return ['status' => 'failed', 'message' => "Missing required Id field: {$primaryKey} key: {$tableName}"];
        }
    
        // Set ID info for future steps
        $inputData['idField'] = $primaryKey;
        $inputData['id'] = $idValue;
    
        // Set checkParent flag
        $inputData['checkParent'] = array_key_exists('parentId', $columnMap) ? 1 : 0;

        return ['status' => 'success'];
    }
    function findIdInData($data, $primaryKey) {
        foreach ($data as $key => $value) {
            if (is_array($value)) {
                // Recurse into sub-arrays
                $found = findIdInData($value, $primaryKey);
                if ($found !== null) {
                    return $found;
                }
            } else {
                if ($key === $primaryKey) {
                    return $value;
                }
            }
        }
        return null;
    }
    function executeDatabaseOperation(&$inputData) {
        $operation = $inputData['nextOperation'];
        try {
            $results =  $operation($inputData);
        } catch (PDOException $e) {
            $errorInfo = $e->errorInfo ?? [];
            $errorCode = $errorInfo[1] ?? 0; // SQL error code
            $errorMessage = $e->getMessage();
    
            // Determine the type of error
            if ($errorCode == 1062) {
                $results =  ['status' => 'failed', 'message' => "Duplicate entry detected: " . $errorMessage];
            } elseif (isset($inputData['debug']) && $inputData['debug'] === $inputData['debugModeFlag']) {
                $results = ['status' => 'failed', 'message' => $errorMessage];
            }else{
                $results = ['status' => 'failed', 'message' => "Unknown failure"];
            }
        }
        return $results;
    }
    function convertKeysToCamelCase($array) {
        $converted = [];

        foreach ($array as $key => $value) {
            // Convert snake_case to camelCase
            $camelKey = preg_replace_callback('/_([a-z])/', function ($matches) {
                return strtoupper($matches[1]);
            }, $key);

            // Lowercase first character to enforce camelCase
            $camelKey = lcfirst($camelKey);

            // Recursively handle nested arrays
            if (is_array($value)) {
                $converted[$camelKey] = convertKeysToCamelCase($value);
            } else {
                $converted[$camelKey] = $value;
            }
        }

        return $converted;
    }
    function toSnakeCase($input) {
        return strtolower(preg_replace('/([a-z])([A-Z])/', '$1_$2', $input));
    }
    function renameIdKeys($array, $newKeyName) {
        $converted = [];

        foreach ($array as $key => $value) {
            // Recursively handle nested arrays
            if (is_array($value)) {
                $value = renameIdKeys($value, $newKeyName);
            }

            if ($key === 'id') {
                $converted[$newKeyName] = $value;
            } else {
                $converted[$key] = $value;
            }
        }

        return $converted;
    }
    function extractDataKeyFromTableName($tableName) {
        $parts = explode('_', $tableName, 2);
        $base = $parts[1] ?? $tableName;
    
        $baseParts = explode('_', $base);
    
        $camelCase = array_shift($baseParts);
    
        foreach ($baseParts as $part) {
            $camelCase .= ucfirst($part);
        }
    
        return $camelCase;
    }
    function roleViewType($roleId) {
        if(in_array($roleId, [1, 2, 3])) {
            return 'sysAdmin';
        } elseif($roleId == 4) {
            return 'owner';
        } elseif($roleId == 5) {
            return 'manager';
        } elseif($roleId == 6) {
            return 'staff';
        } else{
            return 'guest';
        }
    }
    function generateChecksum(array $data): string{
        // Sort the array by key (alphabetically)
        ksort($data);

        // Normalize values (e.g., trim and cast to string)
        $normalizedValues = array_map(function ($value) {
            return is_null($value) ? '' : trim((string)$value);
        }, $data);

        // Join values with a consistent separator (e.g., pipe)
        $inputString = implode('|', $normalizedValues);

        // Generate checksum (SHA-256)
        return hash('sha256', $inputString);
    }
    function acceptedPreAuthPayment($inputData){
        // check if the id is set
        $inputData['step'][] = 'acceptedPreAuthPayment()';

        if (isset($inputData['foodOrder']) && is_array($inputData['foodOrder'])) {
            if (isset($inputData['foodOrder'][0]) && is_array($inputData['foodOrder'][0])) {
                $inputData['foodOrder'] = $inputData['foodOrder'][0];
            }
        }

        $inputData['step'][] = 'acceptedPreAuthPayment() - validation';
        if(!isset($inputData['foodOrder']['id']) || empty($inputData['foodOrder']['id'])) {
            return ['status' => 'failed', 'message' => 'Order ID is required for pre-auth payment.'];
        }

        $inputData['step'][] = 'acceptedPreAuthPayment() - check accepted or rejected';
        //check if accepted or rejected 1 or 0 is set
        if(!isset($inputData['foodOrder']['accepted']) || !in_array($inputData['foodOrder']['accepted'], [0, 1])) {
            return ['status' => 'failed', 'message' => 'Accepted value is required for pre-auth payment.'];
        }

        $inputData['step'][] = 'acceptedPreAuthPayment() - set order status';
        // unset the accepted key
        if($inputData['foodOrder']['accepted'] == 0) {
            // if accepted is 0, then we will cancel the order
            $inputData['foodOrder']['orderStatus'] = 'cancelled';
            $inputData['step'][] = 'acceptedPreAuthPayment() - order status set to cancelled';
        }else{
            // if accepted is 1, then we will confirm the order
            $inputData['foodOrder']['orderStatus'] = 'confirmed';
            $inputData['step'][] = 'acceptedPreAuthPayment() - order status set to confirmed';
        }

        // unset the accepted key
        $inputData['step'][] = 'acceptedPreAuthPayment() - unsetting accepted key';
        unset($inputData['foodOrder']['accepted']);



        // get the payment intent id from the order
        $inputData['step'][] = 'acceptedPreAuthPayment() - getting payment intent id from order';
        $inputData['nextOperation'] = 'viewPaymentIntentOrderById';
        $inputData['id'] = $inputData['foodOrder']['id'];
        $res = executeDatabaseOperation($inputData);

        $inputData['step'][] = 'acceptedPreAuthPayment() - getting payment intent id from order';
        if($res['status'] !== 'success') {
            if(isset($inputData['debug']) && $inputData['debug'] === $inputData['debugModeFlag']) {
                return ['status' => 'failed', 'message' => $res['message'], 'step' => $inputData['step']];
            }
            return ['status' => 'failed', 'message' => $res['message']];
        }


        // check if the payment intent id is set
        if(!isset($res['data']['paymentIntentId']) || empty($res['data']['paymentIntentId'])) {
            // if debug mode is on, return the error
            if(isset($inputData['debug']) && $inputData['debug'] === $inputData['debugModeFlag']) {
                return ['status' => 'failed', 'message' => 'Payment intent ID is missing from the order.', 'step' => $inputData['step']];
            }else{
                return ['status' => 'failed', 'message' => 'Payment intent ID is missing from the order.'];
            }
        }
        
        // set the payment intent id in the inputData
        $inputData['step'][] = 'acceptedPreAuthPayment() - payment intent id found';
        $inputData['secure']['paymentIntentId'] = $res['data']['paymentIntentId'];


        // get the payment Account Id from tenant info
        $inputData['step'][] = 'acceptedPreAuthPayment() - getting tenant API key';
        $inputData['nextOperation'] = 'viewTenantInfo';
        $res = executeDatabaseOperation($inputData);

        if($res['status'] !== 'success') {
            if(isset($inputData['debug']) && $inputData['debug'] === $inputData['debugModeFlag']) {
                return ['status' => 'failed', 'message' => $res['message'], 'step' => $inputData['step']];
            }
            return ['status' => 'failed', 'message' => $res['message']];
        }

        $inputData['step'][] = 'acceptedPreAuthPayment() - tenant API key found';
        $inputData['secure']['stripeAccountKey'] = $res['tenantInfo']['paymentApiKey'] ?? null;


        $inputData['step'][] = 'acceptedPreAuthPayment() - stripe secret key found';
        if($inputData['foodOrder']['orderStatus'] == 'cancelled') {
            // if the order is cancelled, we will cancel the payment intent
            $inputData['step'][] = 'acceptedPreAuthPayment() - cancelling payment intent';
            $res = cancelPayment($inputData);
            if($res['status'] !== 'success') {
                if(isset($inputData['debug']) && $inputData['debug'] === $inputData['debugModeFlag']) {
                    return ['status' => 'failed', 'message' => $res['message'], 'step' => $inputData['step']];
                }
                return ['status' => 'failed', 'message' => $res['message']];
            }
        }
        if($inputData['foodOrder']['orderStatus'] == 'confirmed') {
            $inputData['step'][] = 'acceptedPreAuthPayment() - charging payment intent';
            // if the order is confirmed, we will charge the payment intent
            $res = chargePayment($inputData);
            if($res['status'] !== 'success') {
                if(isset($inputData['debug']) && $inputData['debug'] === $inputData['debugModeFlag']) {
                    return ['status' => 'failed', 'message' => $res['message'], 'step' => $inputData['step']];
                }
                return ['status' => 'failed', 'message' => $res['message']];
            }
        }

        $inputData['step'][] = 'acceptedPreAuthPayment() - updating order status';
        // set the next operation to update the order

        $res = updateSuccessful($inputData);
        $inputData['step'][] = 'acceptedPreAuthPayment() - order status updated';

        if($res['status'] !== 'success') {
            if(isset($inputData['debug']) && $inputData['debug'] === $inputData['debugModeFlag']) {
                return ['status' => 'failed', 'message' => $res['message'], 'step' => $inputData['step']];
            }
            return ['status' => 'failed', 'message' => $res['message']];
        }

        return ['status' => 'success', 'message' => 'Order pre-auth payment accepted successfully.'];
    }
    function chargePayment($inputData, $captureAmountInPence = null) {
        if (empty($inputData['secure']['paymentIntentId'])) {
            return ['status' => 'failed', 'message' => 'Payment intent ID is required'];
        }

        if (defined('TEST_ENV') && TEST_ENV) {
            return ['status' => 'success', 'message' => 'Test environment – not charging'];
        }

        require_once __DIR__ . '/../vendor/autoload.php';
        if (!class_exists('\Stripe\Stripe')) {
            return ['status' => 'failed', 'message' => 'Stripe dependency not available'];
        }
        \Stripe\Stripe::setApiKey($inputData['secure']['stripeSecretKey']);
        \Stripe\Stripe::setAccountId($inputData['secure']['stripeAccountKey'] ?? null);
        $piId = $inputData['secure']['paymentIntentId'];

        try {
            $pi = \Stripe\PaymentIntent::retrieve($piId);

            if ($pi->status === 'requires_confirmation') {
                $pi = $pi->confirm(); // only if client didn’t confirm
            }

            if ($pi->status === 'requires_capture') {
                $captureParams = [];
                if (is_int($captureAmountInPence)) {
                    $captureParams['amount_to_capture'] = max(1, $captureAmountInPence);
                }
                $pi = $pi->capture($captureParams);
            }

            if ($pi->status === 'succeeded') {
                // last charge ID is available in the PaymentIntent object
                $inputData['secure']['chargeId'] = $pi->latest_charge;
                // url of receipt
                $inputData['secure']['receiptUrl'] = $pi->charges->data[0]->receipt_url ?? null;


                $res = updateWithChargeId($inputData);
                if ($res['status'] !== 'success') {
                    return ['status' => 'failed', 'message' => $res['message']];
                }

                return ['status' => 'success', 'message' => 'Payment charged successfully'];

            }

            return ['status' => 'failed', 'message' => "Cannot charge payment in status '{$pi->status}'"];
        } catch (\Stripe\Exception\ApiErrorException $e) {
            return ['status' => 'failed', 'message' => $e->getMessage()];
        }
    }
    function cancelPayment($inputData, $cancellationReason = 'abandoned') {
        // Validate
        if (empty($inputData['secure']['paymentIntentId'])) {
            return ['status' => 'failed', 'message' => 'Payment intent ID is required for cancelling payment.'];
        }

        // Respect test mode
        if (defined('TEST_ENV') && TEST_ENV) {
            return ['status' => 'success', 'message' => 'Test environment – not cancelling.'];
        }

        require_once __DIR__ . '/../vendor/autoload.php';
        if (!class_exists('\Stripe\Stripe')) {
            return ['status' => 'failed', 'message' => 'Stripe dependency not available'];
        }

        \Stripe\Stripe::setApiKey($inputData['secure']['stripeSecretKey']);
        \Stripe\Stripe::setAccountId($inputData['secure']['stripeAccountKey'] ?? null);
        $piId = $inputData['secure']['paymentIntentId'];

        // If you created the PI on a connected account directly, set this:
        // $opts = ['stripe_account' => $inputData['secure']['shopStripeAccountId']];
        $opts = [];

        try {
            /** @var \Stripe\PaymentIntent $pi */
            $pi = \Stripe\PaymentIntent::retrieve($piId, $opts);

            // If already cancelled, we're done
            if ($pi->status === 'canceled') {
                return ['status' => 'success', 'message' => 'Payment already canceled (hold released).'];
            }

            // Allowed-to-cancel (releases the hold) — do NOT refund
            $cancellable = [
                'requires_capture',       // auth placed, waiting for capture
                'requires_confirmation',  // not confirmed yet
                'requires_payment_method',
                'requires_action',
                'processing',             // may cancel depending on timing/method
            ];

            if (in_array($pi->status, $cancellable, true)) {
                $pi = $pi->cancel(['cancellation_reason' => $cancellationReason], $opts);
                return ['status' => 'success', 'message' => 'Authorization hold released (payment canceled).', 'data' => $pi];
            }

            // If already captured, do NOT refund (per your rule)
            if ($pi->status === 'succeeded') {

                $res = updateCancelled($inputData);
                if ($res['status'] !== 'success') {
                    return ['status' => 'failed', 'message' => $res['message']];
                }

                // If already captured, do NOT refund (per your rule)
                return [
                    'status'  => 'failed',
                    'message' => 'Payment already captured; cannot release hold without refund (refunds are disabled).'
                ];
            }

            // Any other odd status
            return [
                'status'  => 'failed',
                'message' => "Cannot cancel payment in status '{$pi->status}'."
            ];
        } catch (\Stripe\Exception\ApiErrorException $e) {
            return ['status' => 'failed', 'message' => 'Stripe error: ' . $e->getMessage()];
        } catch (\Exception $e) {
            return ['status' => 'failed', 'message' => 'Error: ' . $e->getMessage()];
        }
    }
    function esc($v): string { return htmlspecialchars((string)$v, ENT_QUOTES | ENT_SUBSTITUTE, 'UTF-8'); }
    function money($n): string { return '£' . number_format((float)($n ?? 0), 2, '.', ''); }
    function aget(array $arr, string $key, $default = null) { return array_key_exists($key, $arr) ? $arr[$key] : $default; }
    function currentHost(): string {
        return preg_replace('#^https?://#i', '', (string)($_SERVER['HTTP_HOST'] ?? $_SERVER['SERVER_NAME'] ?? 'localhost'));
    }
    function apexDomain(string $host): string {
        $h = strtolower(preg_replace('/[^a-z0-9.\-]/i', '', $host));
        $parts = array_values(array_filter(explode('.', $h)));
        $n = count($parts);
        if ($n < 2) return $h ?: 'localhost';
        $tld = $parts[$n-1];
        $sld = $parts[$n-2];
        $ukLike = ($tld === 'uk' && in_array($sld, ['co','org','ac','gov','ltd','plc','net'], true));
        $keep = $ukLike && $n >= 3 ? 3 : 2;
        return implode('.', array_slice($parts, -$keep));
    }
    function computeNoReplyFrom(?string $fallbackDomain = null): string {
        $host = currentHost();
        $apex = apexDomain($host);
        if ($apex === 'localhost') $apex = ($fallbackDomain ?: 'example.com');
        return "no-reply@{$apex}";
    }
    function computeBaseUrl(): string {
        $https  = $_SERVER['HTTPS'] ?? '';
        $scheme = (!empty($https) && strtolower($https) !== 'off') ? 'https' : 'http';
        return $scheme . '://' . currentHost();
    }
    function absolutizeUrl(string $url, string $base): string {
        if (preg_match('#^https?://#i', $url)) return $url;
        if (strpos($url, '//') === 0) {
            $scheme = parse_url($base, PHP_URL_SCHEME) ?: 'https';
            return $scheme . ':' . $url;
        }
        return rtrim($base, '/') . '/' . ltrim($url, '/');
    }
    function buildTrackUrl(array $order, ?string $baseUrl = null): string {
        $base = $baseUrl ?: computeBaseUrl();
        $q = http_build_query([
            'orderId' => aget($order, 'id', ''),
            'email'   => aget($order, 'userEmail', ''),
        ]);
        return rtrim($base, '/') . '/order-confirmed?' . $q;
    }
    function buildAddressHtml(array $order): string {
        if (strtolower((string)aget($order, 'orderType', '')) !== 'delivery') return '';
        $d = (array) aget($order, 'delivery', []);
        if (!$d) return '';
        return '
        <tr><td style="padding:12px 0 0">
        <h3 style="margin:0 0 8px;font-size:16px;color:#111">Delivery Address</h3>
        <p style="margin:0;line-height:1.5;color:#444">'.
            esc(aget($d,'address_line_1','')).'<br>'.
            (aget($d,'address_line_2') ? esc(aget($d,'address_line_2')).'<br>' : '').
            esc(aget($d,'city','')).(aget($d,'county') ? ', '.esc(aget($d,'county')) : '').'<br>'.
            esc(aget($d,'postal_code','')).'<br>'.
            esc(aget($d,'country','')).'
        </p>
        </td></tr>';
    }
    function buildItemsHtml(array $order): string {
        $items = (array) aget($order, 'details', []);
        if (!$items) return '<tr><td style="padding:8px 0;color:#666">No items.</td></tr>';
        $html = '';
        foreach ($items as $item) {
            $extrasHtml = '';
            $extras = (array) aget($item, 'extras', []);
            if ($extras) {
                $parts = array_map(function($ex){
                    return '<div>+ '.esc(aget($ex,'extraName','')).' (x'.((int)aget($ex,'extraQuantity',1)).', '.money(aget($ex,'extraPrice',0)).')</div>';
                }, $extras);
                $extrasHtml = '<div style="margin-top:4px;color:#666;font-size:13px">'.implode('', $parts).'</div>';
            }
            $html .= '
            <tr><td style="padding:8px 0;border-bottom:1px solid #eee;">
            <div style="display:flex;justify-content:space-between;gap:12px">
                <div><div style="font-weight:600;color:#111">'.esc(aget($item,'itemQuantity',1)).' × '.esc(aget($item,'itemName','')).'</div>'.$extrasHtml.'</div>
                <div style="white-space:nowrap">'.money(aget($item,'itemModifiedPrice',0)).'</div>
            </div>
            </td></tr>';
        }
        return $html;
    }
    function buildTotalsHtml(array $order): array {
        $subtotal      = (float) aget($order, 'totalOrderModifiedPrice', 0);
        $deliveryFee   = (float) aget($order, 'deliveryFee', 0);
        $serviceFee    = (float) aget($order, 'orderFee', 0);
        $smallOrderFee = (float) aget($order, 'smallOrderFee', 0);
        $grandTotal    = $subtotal + $deliveryFee + $serviceFee + $smallOrderFee;

        $rows = [
            ['Subtotal', $subtotal, true],
            ['Delivery Fee', $deliveryFee, $deliveryFee > 0],
            ['Service Fee', $serviceFee, $serviceFee > 0],
            ['Small Order Fee', $smallOrderFee, $smallOrderFee > 0],
        ];
        $html = '';
        foreach ($rows as [$label,$value,$show]) {
            if (!$show) continue;
            $html .= '<tr><td style="padding:6px 0;color:#444">'.esc($label).'</td><td style="padding:6px 0;text-align:right;color:#444">'.money($value).'</td></tr>';
        }
        $html .= '<tr><td style="padding-top:10px;border-top:1px solid #ddd;font-weight:700;color:#111">Total</td><td style="padding-top:10px;border-top:1px solid #ddd;text-align:right;font-weight:700;color:#111">'.money($grandTotal).'</td></tr>';
        return [$html, $grandTotal];
    }
    function buildEmailReceiptHtml(array $order, array $brand = []): string {
        $brandName   = aget($brand,'name','Your Shop');
        $brandColor  = aget($brand,'color','#0b5fff');
        $brandLogo   = aget($brand,'logo',null);
        $supportLine = aget($brand,'support','Reply to this email if you have any questions.');
        $baseUrl     = computeBaseUrl();
        if ($brandLogo) $brandLogo = absolutizeUrl((string)$brandLogo, $baseUrl);

        $status = ucfirst((string) aget($order,'orderStatus','Pending'));
        $pay    = ucfirst((string) aget($order,'paymentStatus','Unpaid'));
        $pillBg = '#eef4ff'; $pillFg = $brandColor;

        $trackUrl     = buildTrackUrl($order, $baseUrl);
        $addressHtml  = buildAddressHtml($order);
        $itemsHtml    = buildItemsHtml($order);
        [$totalsHtml] = buildTotalsHtml($order);

        $id   = esc((string) aget($order,'id','—'));
        $type = ucfirst(esc((string) aget($order,'orderType','')));
        $when = esc((string) aget($order,'createdAtDisplay','—'));

        $custNote   = trim((string) aget($order,'comment',''));
        $tenantNote = trim((string) aget($order,'tenantComment',''));

        return '
                <!doctype html><html lang="en"><head>
                <meta charset="utf-8"><meta name="viewport" content="width=device-width, initial-scale=1"/>
                <title>Order Receipt</title>
                <style>@media(max-width:600px){.container{padding:16px!important}h2{font-size:20px!important}} a{color:'.esc($brandColor).';}</style>
                </head><body style="margin:0;background:#f6f7fb;font-family:Segoe UI,Roboto,Helvetica,Arial,sans-serif;">
                <table role="presentation" width="100%" cellspacing="0" cellpadding="0" style="background:#f6f7fb;padding:20px 0"><tr><td align="center">
                <table role="presentation" width="640" class="container" cellspacing="0" cellpadding="0" style="width:640px;max-width:100%;background:#fff;border-radius:12px;padding:24px;box-shadow:0 4px 18px rgba(18,38,63,.08)">
                <tr><td style="text-align:center;padding:8px 0 18px">'.
                    ($brandLogo ? '<img src="'.esc($brandLogo).'" alt="'.esc($brandName).'" style="max-width:180px;height:auto;display:block;margin:0 auto 8px">' : '').
                    '<div style="font-size:12px;color:#888">'.esc($brandName).'</div></td></tr>
                <tr><td>
                    <div style="display:flex;justify-content:space-between;align-items:center;gap:12px;flex-wrap:wrap">
                    <h2 style="margin:0;color:#111;font-size:22px">Thank you for your order!</h2>
                    <span style="display:inline-block;background:'.$pillBg.';color:'.$pillFg.';font-weight:600;font-size:12px;padding:6px 10px;border-radius:999px;letter-spacing:.3px">'.esc($status).'</span>
                    </div>
                    <p style="margin:10px 0 0;color:#444;line-height:1.5"><strong>Order #</strong> '.$id.' · <strong>Type</strong> '.$type.' · <strong>Placed</strong> '.$when.' · <strong>Payment</strong> '.esc($pay).'</p>
                    <div style="margin:16px 0 0"><a href="'.esc($trackUrl).'" style="display:inline-block;text-decoration:none;background:'.esc($pillFg).';color:#fff;font-weight:600;padding:10px 16px;border-radius:8px" target="_blank" rel="noopener">Track your order</a></div>
                </td></tr>'.
                $addressHtml.
                '<tr><td style="padding:18px 0 6px"><h3 style="margin:0;font-size:16px;color:#111">Items</h3></td></tr>
                <tr><td><table role="presentation" width="100%" cellspacing="0" cellpadding="0">'.$itemsHtml.'</table></td></tr>
                <tr><td style="padding:18px 0 6px"><h3 style="margin:0;font-size:16px;color:#111">Summary</h3></td></tr>
                <tr><td><table role="presentation" width="100%" cellspacing="0" cellpadding="0">'.$totalsHtml.'</table></td></tr>'.
                ($custNote !== '' ? '<tr><td style="padding:16px 0 0"><h3 style="margin:0 0 6px;font-size:16px;color:#111">Customer Note</h3><p style="margin:0;color:#444;line-height:1.5">'.esc($custNote).'</p></td></tr>' : '').
                ($tenantNote !== '' ? '<tr><td style="padding:16px 0 0"><h3 style="margin:0 0 6px;font-size:16px;color:#111">Shop Message</h3><p style="margin:0;color:#444;line-height:1.5">'.esc($tenantNote).'</p></td></tr>' : '').
                '<tr><td style="padding:22px 0 0"><p style="margin:0;color:#666;font-size:13px;line-height:1.5">'.esc($supportLine).'</p><p style="margin:10px 0 0;color:#9aa3b2;font-size:12px">This receipt is for order confirmation. Prices include VAT where applicable.</p></td></tr>
                </table></td></tr></table></body></html>';
    }
    function generateReceiptEmailFromOrder(array $order, array $brand = [], ?string $tenantReplyTo = null): array {
        return [
            'from'     => computeNoReplyFrom(),                                 // e.g. no-reply@yourdomain.tld
            'to'       => (string) aget($order,'userEmail',''),
            'subject'  => 'Your receipt for Order #'.(string) aget($order,'id',''),
            'html'     => buildEmailReceiptHtml($order, $brand),
            'replyTo'  => $tenantReplyTo,                                       // optional
            'fromName' => aget($brand,'name','Waitron'),
        ];
    }
    function sendReceiptEmail_viaMail(array $emailPayload): bool {
        $headers  = "MIME-Version: 1.0\r\n";
        $headers .= "Content-type: text/html; charset=utf-8\r\n";
        $headers .= "From: ".($emailPayload['fromName'] ?? 'No-Reply')." <{$emailPayload['from']}>\r\n";
        if (!empty($emailPayload['replyTo'])) {
            $headers .= "Reply-To: {$emailPayload['replyTo']}\r\n";
        }
        return mail($emailPayload['to'], $emailPayload['subject'], $emailPayload['html'], $headers);
    }
    function sendReceiptEmail_smtpCpanel(array $emailPayload, array $cp): bool {
        if (!class_exists('PHPMailer\PHPMailer\PHPMailer')) {
            error_log('PHPMailer not found (composer require phpmailer/phpmailer).');
            return false;
        }
        $hostGuess = 'mail.'.apexDomain(currentHost());
        $host  = (string) (aget($cp,'host',$hostGuess));
        $port  = (int) (aget($cp,'port', 465));       // cPanel defaults: 465/SSL or 587/TLS
        $secure= strtolower((string) (aget($cp,'secure','ssl'))); // 'ssl' or 'tls'

        $mail = new PHPMailer\PHPMailer\PHPMailer(true);
        try {
            $mail->isSMTP();
            $mail->Host       = $host;
            $mail->Port       = $port;
            $mail->SMTPAuth   = true;
            $mail->Username   = (string) aget($cp,'username','');
            $mail->Password   = (string) aget($cp,'password','');

            if ($secure === 'ssl') {
                $mail->SMTPSecure = PHPMailer\PHPMailer\PHPMailer::ENCRYPTION_SMTPS; // 465
            } else {
                $mail->SMTPSecure = PHPMailer\PHPMailer\PHPMailer::ENCRYPTION_STARTTLS; // 587
            }

            // cPanel servers usually require From to match the authenticated domain/mailbox
            $mail->setFrom($emailPayload['from'], (string)($emailPayload['fromName'] ?? 'No-Reply'));
            $mail->addAddress((string)$emailPayload['to']);
            if (!empty($emailPayload['replyTo'])) {
                $mail->addReplyTo((string)$emailPayload['replyTo'], (string)($emailPayload['fromName'] ?? 'Shop'));
            }

            $mail->isHTML(true);
            $mail->Subject = (string)$emailPayload['subject'];
            $mail->Body    = (string)$emailPayload['html'];
            $mail->AltBody = 'This email requires HTML to view properly.';

            return $mail->send();
        } catch (Throwable $e) {
            error_log('cPanel SMTP send failed: '.$e->getMessage());
            return false;
        }
    }
    function setUpReceipt(array $inputData): array {
        if (empty($inputData['orderId'])) {
            return ['status' => 'failed', 'message' => 'Order ID is required.'];
        }

        $inputData['receipt']   = 'enabled';
        $inputData['viewLevel'] = 'full';
        $orderRes = viewFullOrderDetails($inputData); // <-- your function

        if (!is_array($orderRes) || ($orderRes['status'] ?? 'failed') !== 'success') {
            return ['status' => 'failed', 'message' => $orderRes['message'] ?? 'Order lookup failed.'];
        }

        $orderList = $orderRes['orderDetails'] ?? $orderRes['data']['orderDetails'] ?? [];
        $order     = is_array($orderList) ? ($orderList[0] ?? []) : (array)$orderList;
        if (!$order) {
            return ['status' => 'failed', 'message' => 'Order not found.'];
        }

        // Pass brand + reply-to via $inputData (consistent with your pattern)
        $brand = [
            'name'    => aget($inputData,'brandName','Waitron'),
            'color'   => aget($inputData,'brandColor','#0b5fff'),
            'logo'    => aget($inputData,'brandLogo','/images/logo.png'),
            'support' => aget($inputData,'brandSupport','Reply to this email if you have any questions.'),
        ];
        $tenantReplyTo = aget($inputData,'tenantReplyTo',null);

        $emailPayload = generateReceiptEmailFromOrder($order, $brand, $tenantReplyTo);

        // Send email (choose method as per your setup)
        // if test mode, skip sending
        if (defined('TEST_ENV') && TEST_ENV) {
            $emailSent = false;
        } else {
            $emailSent = sendReceiptEmail_viaMail($emailPayload);
        }

        return [
            'status'       => 'success',
            'message'      => 'Receipt built.',
            'data'         => $orderRes,
            'emailPayload' => $emailPayload,
        ];
    }
?>