# Frontend API Interface Specification

---

## Overview
This document outlines the frontend API contract required to interact with the backend PHP application. All operations are triggered via a single endpoint (function.php) using POST or GET requests, with the action defined in the action field. Role-based access is enforced via session variables.

---

## Role Definitions

```sql
INSERT INTO `user_role` (`pk_role_id`, `role_name`, `scope`) VALUES
(1, "SystemAdmin", "Platform"),
(2, "SupportAgent", "Platform"),
(3, "ContentModerator", "Platform"),
(4, "BusinessOwner", "Tenant"),
(5, "BusinessManager", "Tenant"),
(6, "Staff", "Tenant"),
(7, "Operator", "Tenant"),
(8, "Customer", "Public");
```

## API Summary Table

| Action                            | Method | Required Role      | Payload Object           | Description                                                            |
|-----------------------------------|--------|--------------------|--------------------------|------------------------------------------------------------------------|
| `getPreAuthPayments`              | GET    |  2,4,5,6           |                          | Get a list of pre auth payment to decided to accept or reject          |


### `getPreAuthPayments`
```json
    "action" : "getPreAuthPayments",
```

## Payload Structures
