<?php
    function saveHistoryRecordStep($inputData){
            $pdo = $inputData['db']['dbApp'];
            $pdo->setAttribute(PDO::ATTR_ERRMODE, PDO::ERRMODE_EXCEPTION);
            $table              = 'food_order_history';
            $changeType         = $inputData['recordType'];
            $toJsonhistoryData  = json_encode($inputData['historyData'], JSON_PRETTY_PRINT);
            $tableOfSource      = toSnakeCase($inputData['table']);
            $oldID              = $inputData['historyData']['id'] ?? null;

            $sql = "INSERT INTO {$table} (tenant_id, change_type, table_of_source, change_data, changed_by, order_id) VALUES (:tenantId, :actionType, :tableOfSource, :historyData, :actionBy, :oldID)";
            $stmt = $pdo->prepare($sql);
            $stmt->bindValue(':tenantId', $inputData['tenantId'], PDO::PARAM_INT);
            $stmt->bindValue(':oldID', $oldID, PDO::PARAM_INT);
            $stmt->bindValue(':actionType', $changeType, PDO::PARAM_STR);
            $stmt->bindValue(':tableOfSource', $tableOfSource, PDO::PARAM_STR);
            $stmt->bindValue(':historyData', $toJsonhistoryData, PDO::PARAM_STR);
            $stmt->bindValue(':actionBy', $inputData['userId'], PDO::PARAM_INT);
            $stmt->execute();
            $lastInsertId = $pdo->lastInsertId();
            return [
                'status' => 'success',
                'message' => 'History record saved successfully',
                'id' => $lastInsertId
            ];
        }
?>