<?php
    ini_set('error_log', 'php://stderr');
    error_log("Something went wrong");

    use PHPUnit\Framework\TestCase;
    
    require_once __DIR__ . '/../../core/unit-test/scripts/bootstrap.php'; // ✅ Use shared mock DB
    //require_once __DIR__ . '/../src/function.php';
    echo "\T10_FoodOrderingTenantTest.php\n";
    
    // Print list of table that exist in the database
    //$tables = $GLOBALS['mockPdo']->query("SELECT name FROM sqlite_master WHERE type='table';")->fetchAll(PDO::FETCH_COLUMN);
    //echo("\n🔍 Tables: " . implode(', ', $tables). "\n");
    
    class T10_FoodOrderingTenantTest extends TestCase
    {
        private $mockPdo;
        private static $lastModified;

    protected function setUp(): void{
        // ✅ Use the shared mock database connection
        $_SESSION = [];
        $_GET = [];
        $_POST = [];
        $_SERVER['REMOTE_ADDR'] = '127.0.0.1';
        $_SERVER['HTTP_REFERER'] = 'http://localhost/test';
        $this->mockPdo = $GLOBALS['mockPdo'];
        if (session_status() !== PHP_SESSION_ACTIVE) {
            session_start();
        }
    }

    private function executeFunctionPhp(): array {
        ob_start();
        require __DIR__ . '/../src/function.php';
        $output = ob_get_clean();
    
        // ✅ Ensure only valid JSON output
        $decodedOutput = json_decode($output, true);
        if (json_last_error() !== JSON_ERROR_NONE) {
            throw new Exception("Invalid JSON output: " . json_last_error_msg() . "\nOutput: " . $output);
        }
    
        return [$output, $decodedOutput];
    }

    public function test001DummyTest(): void{
        $this->assertTrue(true);
    }
    public function test002DataSetup(): void {
        // insert some test data
        $this->mockPdo->exec("INSERT INTO `food_order`
            (`guest_user_id`, `tenant_id`, `delivery_address_id`, `billing_address_id`, `order_status`, `order_type`, `total_order_price`, `total_order_modified_price`, `total_order_modified_reason`, `payment_status`, `comment`, `tenant_comment`, `currency`, `transaction_id`, `payment_intent_id`)
        VALUES
            (NULL, 1, 1, 1, 'pending',      'delivery',     14.30, 1.30, 'Small Order Fee Applied, Delivery Charge Applied, Admin Fee Applied', 'payment_pre_auth',    NULL, NULL, 'GBP', NULL, 'pi_3RuTdYDMt3vZ38M11Ze26li0'),
            (NULL, 1, 1, 1, 'completed',    'delivery',     34.30, 34.30,'Small Order Fee Applied, Delivery Charge Applied, Admin Fee Applied', 'paid',                NULL, NULL, 'GBP', NULL, 'pi_3RuTdYDMt3vZ38M11Ze26li0'),
            (NULL, 1, 1, 1, 'pending',      'delivery',     14.30, 3.30, 'Small Order Fee Applied, Delivery Charge Applied, Admin Fee Applied', 'unpaid',              NULL, NULL, 'GBP', NULL, 'pi_3RuTdYDMt3vZ38M11Ze26li0'),
            (NULL, 1, 1, 1, 'pending',      'delivery',     14.30, 4.30, 'Small Order Fee Applied, Delivery Charge Applied, Admin Fee Applied', 'unpaid',              NULL, NULL, 'GBP', NULL, 'pi_3RuTdYDMt3vZ38M11Ze26li0'),
            (NULL, 1, 1, 1, 'pending',      'delivery',     14.30, 5.30, 'Small Order Fee Applied, Delivery Charge Applied, Admin Fee Applied', 'payment_pre_auth',    NULL, NULL, 'GBP', NULL, 'pi_3RuTdYDMt3vZ38M11Ze26li0'),
            (NULL, 1, 1, 1, 'cancelled',    'delivery',     14.30, 6.30, 'Small Order Fee Applied, Delivery Charge Applied, Admin Fee Applied', 'payment_pre_auth',    NULL, NULL, 'GBP', NULL, 'pi_3RuTdYDMt3vZ38M11Ze26li0'),
            (NULL, 1, 1, 1, 'confirmed',    'delivery',     14.30, 2.30, 'Small Order Fee Applied, Delivery Charge Applied, Admin Fee Applied', 'paid',                NULL, NULL, 'GBP', NULL, 'pi_3RuTdYDMt3vZ38M11Ze26li0'),
            (NULL, 1, 1, 1, 'confirmed',    'delivery',     14.30, 2.30, 'Small Order Fee Applied, Delivery Charge Applied, Admin Fee Applied', 'paid',                NULL, NULL, 'GBP', NULL, 'pi_3RuTdYDMt3vZ38M11Ze26li0'),
            (NULL, 1, 1, 1, 'confirmed',    'delivery',     14.30, 2.30, 'Small Order Fee Applied, Delivery Charge Applied, Admin Fee Applied', 'refunded',            NULL, NULL, 'GBP', NULL, 'pi_3RuTdYDMt3vZ38M11Ze26li0'),
            (NULL, 1, 1, 1, 'delivery',     'collection',   14.30, 2.30, 'Small Order Fee Applied, Delivery Charge Applied, Admin Fee Applied', 'paid',                NULL, NULL, 'GBP', NULL, 'pi_3RuTdYDMt3vZ38M11Ze26li0'),
            (NULL, 1, 1, 1, 'confirmed',    'delivery',     14.30, 2.30, 'Small Order Fee Applied, Delivery Charge Applied, Admin Fee Applied', 'paid',                NULL, NULL, 'GBP', NULL, 'pi_3RuTdYDMt3vZ38M11Ze26li0'),
            (NULL, 1, 1, 1, 'delivery',    'collection',    14.30, 2.30, 'Small Order Fee Applied, Delivery Charge Applied, Admin Fee Applied', 'paid',                NULL, NULL, 'GBP', NULL, 'pi_3RuTdYDMt3vZ38M11Ze26li0'),
            (NULL, 1, 1, 1, 'completed',    'delivery',     14.30, 2.30, 'Small Order Fee Applied, Delivery Charge Applied, Admin Fee Applied', 'paid',                NULL, NULL, 'GBP', NULL, 'pi_3RuTdYDMt3vZ38M11Ze26li0'),
            (NULL, 1, 1, 1, 'cancelled',    'collection',   14.30, 2.30, 'Small Order Fee Applied, Delivery Charge Applied, Admin Fee Applied', 'refunded',            NULL, NULL, 'GBP', NULL, 'pi_3RuTdYDMt3vZ38M11Ze26li0'),
            (NULL, 1, 1, 1, 'completed',    'delivery',     14.30, 2.30, 'Small Order Fee Applied, Delivery Charge Applied, Admin Fee Applied', 'paid',                NULL, NULL, 'GBP', NULL, 'pi_3RuTdYDMt3vZ38M11Ze26li0'),
            (NULL, 1, 1, 1, 'completed',    'delivery',     14.30, 2.30, 'Small Order Fee Applied, Delivery Charge Applied, Admin Fee Applied', 'paid',                NULL, NULL, 'GBP', NULL, 'pi_3RuTdYDMt3vZ38M11Ze26li0'),
            (NULL, 1, 1, 1, 'cancelled',    'delivery',     14.30, 2.30, 'Small Order Fee Applied, Delivery Charge Applied, Admin Fee Applied', 'partial_refund',      NULL, NULL, 'GBP', NULL, 'pi_3RuTdYDMt3vZ38M11Ze26li0'),
            (NULL, 1, 1, 1, 'completed',    'delivery',     14.30, 2.30, 'Small Order Fee Applied, Delivery Charge Applied, Admin Fee Applied', 'paid',                NULL, NULL, 'GBP', NULL, 'pi_3RuTdYDMt3vZ38M11Ze26li0'), 
            (NULL, 1, 1, 1, 'cancelled',    'collection',   14.30, 2.30, 'Small Order Fee Applied, Delivery Charge Applied, Admin Fee Applied', 'partial_refund',      NULL, NULL, 'GBP', NULL, 'pi_3RuTdYDMt3vZ38M11Ze26li0'),
            (NULL, 1, 1, 1, 'completed',    'delivery',     14.30, 2.30, 'Small Order Fee Applied, Delivery Charge Applied, Admin Fee Applied', 'paid',                NULL, NULL, 'GBP', NULL, 'pi_3RuTdYDMt3vZ38M11Ze26li0'),
            (NULL, 1, 1, 1, 'completed',    'delivery',     14.30, 2.30, 'Small Order Fee Applied, Delivery Charge Applied, Admin Fee Applied', 'paid',                NULL, NULL, 'GBP', NULL, 'pi_3RuTdYDMt3vZ38M11Ze26li0'),
            (NULL, 1, 1, 1, 'cooking',      'delivery',     14.30, 2.30, 'Small Order Fee Applied, Delivery Charge Applied, Admin Fee Applied', 'paid',                NULL, NULL, 'GBP', NULL, 'pi_3RuTdYDMt3vZ38M11Ze26li0'),
            (NULL, 1, 1, 1, 'completed',    'delivery',     14.30, 2.30, 'Small Order Fee Applied, Delivery Charge Applied, Admin Fee Applied', 'paid',                NULL, NULL, 'GBP', NULL, 'pi_3RuTdYDMt3vZ38M11Ze26li0'), 
            (NULL, 1, 1, 1, 'cooking',      'delivery',     14.30, 2.30, 'Small Order Fee Applied, Delivery Charge Applied, Admin Fee Applied', 'paid',                NULL, NULL, 'GBP', NULL, 'pi_3RuTdYDMt3vZ38M11Ze26li0'),
            (NULL, 1, 1, 1, 'completed',    'delivery',     14.30, 2.30, 'Small Order Fee Applied, Delivery Charge Applied, Admin Fee Applied', 'paid',                NULL, NULL, 'GBP', NULL, 'pi_3RuTdYDMt3vZ38M11Ze26li0'),
            (NULL, 1, 1, 1, 'delivery',    'delivery',      14.30, 2.30, 'Small Order Fee Applied, Delivery Charge Applied, Admin Fee Applied', 'paid',                NULL, NULL, 'GBP', NULL, 'pi_3RuTdYDMt3vZ38M11Ze26li0'),
            (NULL, 1, 1, 1, 'completed',    'delivery',     14.30, 2.30, 'Small Order Fee Applied, Delivery Charge Applied, Admin Fee Applied', 'paid',                NULL, NULL, 'GBP', NULL, 'pi_3RuTdYDMt3vZ38M11Ze26li0'),
            (NULL, 1, 1, 1, 'completed',    'delivery',     14.30, 2.30, 'Small Order Fee Applied, Delivery Charge Applied, Admin Fee Applied', 'paid',                NULL, NULL, 'GBP', NULL, 'pi_3RuTdYDMt3vZ38M11Ze26li0'),
            (NULL, 1, 1, 1, 'completed',    'delivery',     14.30, 2.30, 'Small Order Fee Applied, Delivery Charge Applied, Admin Fee Applied', 'paid',                NULL, NULL, 'GBP', NULL, 'pi_3RuTdYDMt3vZ38M11Ze26li0'),
            (NULL, 1, 1, 1, 'completed',    'delivery',     14.30, 2.30, 'Small Order Fee Applied, Delivery Charge Applied, Admin Fee Applied', 'paid',                NULL, NULL, 'GBP', NULL, 'pi_3RuTdYDMt3vZ38M11Ze26li0');
            ");
        $this->assertEquals(1, 1);

        // select the inserted data
        $stmt = $this->mockPdo->query("SELECT * FROM food_order WHERE tenant_id = 1");
        $rows = $stmt->fetchAll(PDO::FETCH_ASSOC);
        // Debug output
        //print_r($rows); // or var_dump($rows)

        // for order 5 lets add some items with at least 2 haveing a quantity > 1
        $this->mockPdo->exec("INSERT INTO `food_order_item` (`order_id`, `menu_item_id`, `item_name`, `item_base_price`, `item_modified_price`, `item_modified_reason`, `item_quantity`, `item_status` ) VALUES
            (5, 1, 'Test Item 1', 5.50, 11.00, 'Discount Applied', 2, 'pending'),
            (5, 2, 'Test Item 2', 3.25, 3.25, NULL, 1, 'pending'),
            (5, 3, 'Test Item 3', 6.30, 6.30, NULL, 1, 'pending'),
            (5, 4, 'Test Item 4', 3.15, 9.45, 'Discount Applied', 3, 'pending'),
            (5, 5, 'Test Item 5', 2.00, 2.00, NULL, 1, 'pending')
        ");
        $this->assertEquals(1, 1);

        // select the inserted data
        $stmt = $this->mockPdo->query("SELECT * FROM food_order_item WHERE order_id = 5");
        $rows = $stmt->fetchAll(PDO::FETCH_ASSOC);  
        // Debug output
        //print_r($rows); // or var_dump($rows)

    }
    public function test003NoDataPreAuthPayments(): void {
        $_SESSION['tenantId'] = 1;          // Tenant ID for the user  
        $_POST = [
            'action' => 'getPreAuthPayments',
            'debug' => 'CSD'
        ];
        
        list($output, $decodedOutput) = $this->executeFunctionPhp();
        $decodedOutput = json_decode($output, true);

        // Assert the output
        $this->assertEquals('failed', $decodedOutput['status']);
    }
    public function test004GetPreAuthPaymentsNotLoggedIn(): void {
        $_SESSION['tenantId'] = 1;
        $_POST = [
            'action' => 'getPreAuthPayments',
            'debug' => 'CSD'
        ];
        list($output, $decodedOutput) = $this->executeFunctionPhp();
        $decodedOutput = json_decode($output, true);
        // Assert the output
        //echo print_r($decodedOutput, true);
        $this->assertEquals('failed', $decodedOutput['status']);
    }
    public function test005GetPreAuthPayments(): void {
        $_SESSION['id'] = 293;
        $_SESSION['roleValue'] = 4;
        $_SESSION['roleTenantId'] = 1;
        $_SESSION['tenantId'] = 1;
        $_POST = [
            'action' => 'getPreAuthPayments',
            'debug' => 'CSD'
        ];
        list($output, $decodedOutput) = $this->executeFunctionPhp();
        $decodedOutput = json_decode($output, true);
        // Assert the output
        //echo print_r($decodedOutput, true);
        $this->assertEquals('success', $decodedOutput['status']);
    }
    public function test006AcceptedPreAuthPaymentNotLoggedIn(): void {
        $_SESSION['tenantId'] = 1;
        $_POST = [
            'action' => 'acceptedRejectPreAuthPayment',
            'foodOrder' => [
                'id' => 4,
                'accepted' => 1
            ],
            'debug' => 'CSD'
        ];
        list($output, $decodedOutput) = $this->executeFunctionPhp();
        $decodedOutput = json_decode($output, true);
        // Assert the output
        //echo print_r($decodedOutput, true);
        $this->assertEquals('failed', $decodedOutput['status']);
    }
    public function test007AcceptedPreAuthPayment(): void {
        $_SESSION['tenantId'] = 1;
        $_SESSION['id'] = 293;
        $_SESSION['roleValue'] = 5;
        $_SESSION['roleTenantId'] = 1;
        $_POST = [
            'action' => 'acceptedRejectPreAuthPayment',
            'foodOrder' => [
                'id' => 4,
                'accepted' => 1
            ],
            'debug' => 'CSD'
        ];
        list($output, $decodedOutput) = $this->executeFunctionPhp();
        $decodedOutput = json_decode($output, true);
        // Assert the output
        //echo print_r($decodedOutput, true);
        $this->assertEquals('success', $decodedOutput['status']);
    }
    public function test008CheckAllApprovedOrders(): void {
        $_SESSION['tenantId'] = 1;
        $_SESSION['id'] = 293;
        $_SESSION['roleValue'] = 5;
        $_SESSION['roleTenantId'] = 1;
        $_POST = [
            'action' => 'getOrderList',
            'debug' => 'CSD'
        ];
        list($output, $decodedOutput) = $this->executeFunctionPhp();
        $decodedOutput = json_decode($output, true);
        // Assert the output
        //echo print_r($decodedOutput, true);
        $this->assertEquals('success', $decodedOutput['status']);
    }
    public function test009CheckAllApprovedOrdersNotApproved(): void {
        $_SESSION['tenantId'] = 1;
        $_SESSION['id'] = 293;
        $_SESSION['roleTenantId'] = 1;
        $_POST = [
            'action' => 'getOrderList',
            'debug' => 'CSD'
        ];
        list($output, $decodedOutput) = $this->executeFunctionPhp();
        $decodedOutput = json_decode($output, true);
        // Assert the output
        //echo print_r($decodedOutput, true);
        $this->assertEquals('failed', $decodedOutput['status']);
    }
    public function test010ViewFullOrderDetailsNotLoggedIn(): void {
        $_SESSION['tenantId'] = 1;
        $_POST = [
            'action' => 'viewOrderDetails',
            'orderId' => 4,
            'debug' => 'CSD'
        ];
        list($output, $decodedOutput) = $this->executeFunctionPhp();
        $decodedOutput = json_decode($output, true);
        // Assert the output
        //echo print_r($decodedOutput, true);
        $this->assertEquals('failed', $decodedOutput['status']);
    }
    public function test011ViewFullOrderDetails(): void {
        $_SESSION['tenantId'] = 1;
        $_SESSION['id'] = 293;
        $_SESSION['roleValue'] = 6;
        $_SESSION['roleTenantId'] = 1;
        $_POST = [
            'action' => 'viewOrderDetails',
            'orderId' => 1,
            'debug' => 'CSD'
        ];
        list($output, $decodedOutput) = $this->executeFunctionPhp();
        $decodedOutput = json_decode($output, true);
        // Assert the output
        //echo print_r($decodedOutput, true);
        $this->assertEquals('success', $decodedOutput['status']);
    }
    public function test012UpdateStatusOrderNotLoggedIn(): void {
        $_SESSION['tenantId'] = 1;
        $_POST = [
            'action' => 'updateStatusOrder',
            'foodOrder' => [
                'id' => 4,
                'orderStatus' => 'completed'
            ],
            'debug' => 'CSD'
        ];
        list($output, $decodedOutput) = $this->executeFunctionPhp();
        $decodedOutput = json_decode($output, true);
        // Assert the output
        //echo print_r($decodedOutput, true);
        $this->assertEquals('failed', $decodedOutput['status']);
    }
    public function test013UpdateStatusOrderNotLoggedInMissingFields(): void {
        $_SESSION['tenantId'] = 1;
        $_POST = [
            'action' => 'updateStatusOrder',
            'foodOrder' => [
                'id' => 4
            ],
            'debug' => 'CSD'
        ];
        list($output, $decodedOutput) = $this->executeFunctionPhp();
        $decodedOutput = json_decode($output, true);
        // Assert the output
        //echo print_r($decodedOutput, true);
        $this->assertEquals('failed', $decodedOutput['status']);
    }
    public function test014UpdateStatusOrder(): void {
        //update the order status to pending
        $stmt = $this->mockPdo->query("update food_order set order_status = 'pending' WHERE id = 4");
        // view the current order status    
        $stmt = $this->mockPdo->query("SELECT * FROM food_order WHERE id = 4");
        $currentOrder = $stmt->fetch(PDO::FETCH_ASSOC);
        $this->assertEquals('pending', $currentOrder['order_status']);
        
        $_SESSION['tenantId'] = 1;
        $_SESSION['id'] = 293;
        $_SESSION['roleValue'] = 5;
        $_SESSION['roleTenantId'] = 1;
        $_POST = [
            'action' => 'updateStatusOrder',
            'foodOrder' => [
                'id' => 4,
                'orderStatus' => 'completed'
            ],
            'debug' => 'CSD'
        ];
        list($output, $decodedOutput) = $this->executeFunctionPhp();
        $decodedOutput = json_decode($output, true);
        // Assert the output
        //echo print_r($decodedOutput, true);
        $this->assertEquals('success', $decodedOutput['status']);

        // view the updated order status
        $stmt = $this->mockPdo->query("SELECT * FROM food_order WHERE id = 4");
        $updatedOrder = $stmt->fetch(PDO::FETCH_ASSOC);
        $this->assertEquals('completed', $updatedOrder['order_status']);
    }
    public function test015UpdateOrderItemStatusNotLoggedIn(): void {
        $_SESSION['tenantId'] = 1;
        $_POST = [
            'action' => 'updateStatusItem',
            'foodOrderItem' => [
                'id' => 4,
                'itemStatus' => 'completed'
            ],
            'debug' => 'CSD'
        ];
        list($output, $decodedOutput) = $this->executeFunctionPhp();
        $decodedOutput = json_decode($output, true);
        // Assert the output
        //echo print_r($decodedOutput, true);
        $this->assertEquals('failed', $decodedOutput['status']);
    }
    public function test016UpdateOrderItemStatusNotLoggedInMissingFields(): void {
        $_SESSION['tenantId'] = 1;
        $_POST = [
            'action' => 'updateStatusItem',
            'foodOrderItem' => [
                'id' => 4
            ],
            'debug' => 'CSD'
        ];
        list($output, $decodedOutput) = $this->executeFunctionPhp();
        $decodedOutput = json_decode($output, true);
        // Assert the output
        //echo print_r($decodedOutput, true);
        $this->assertEquals('failed', $decodedOutput['status']);
    }
    public function test017UpdateOrderItemStatus(): void {
        //update the order item status to pending
        $stmt = $this->mockPdo->query("update food_order_item set item_status = 'pending' WHERE id = 4");
        // view the current order item status    
        $stmt = $this->mockPdo->query("SELECT * FROM food_order_item WHERE id = 4");
        $currentOrderItem = $stmt->fetch(PDO::FETCH_ASSOC);
        $this->assertEquals('pending', $currentOrderItem['item_status']);

        $_SESSION['tenantId'] = 1;
        $_SESSION['id'] = 293;
        $_SESSION['roleValue'] = 5;
        $_SESSION['roleTenantId'] = 1;
        $_POST = [
            'action' => 'updateStatusItem',
            'foodOrderItem' => [
                'id' => 4,
                'itemStatus' => 'served'
            ],
            'debug' => 'CSD'
        ];
        list($output, $decodedOutput) = $this->executeFunctionPhp();
        $decodedOutput = json_decode($output, true);
        // Assert the output
        //echo print_r($decodedOutput, true);
        $this->assertEquals('success', $decodedOutput['status']);

        // view the updated order item status
        $stmt = $this->mockPdo->query("SELECT * FROM food_order_item WHERE id = 4");
        $updatedOrderItem = $stmt->fetch(PDO::FETCH_ASSOC);
        $this->assertEquals('served', $updatedOrderItem['item_status']);
    }
    function test018SetUpReceipt(): void {
        $_SESSION['tenantId'] = 1;
        $_POST = [
            'action' => 'Receipt',
            'orderId' => 1,
            'debug' => 'CSD'
        ];
        list($output, $decodedOutput) = $this->executeFunctionPhp();
        $decodedOutput = json_decode($output, true);
        // Assert the output
        //echo print_r($decodedOutput, true);
        $this->assertEquals('success', $decodedOutput['status']);
    }
    function test019ItemRefundHighValue(): void {
        $_SESSION['tenantId'] = 1;
        $_SESSION['id'] = 293;
        $_SESSION['roleValue'] = 5;
        $_SESSION['roleTenantId'] = 1;
        $_POST = [
            'action' => 'itemBasedRefund',
            'orderItems' => [ 
                [
                    'id'=>7,
                    'qty'=>5
                ], 
                [
                    'id'=>8,
                    'qty'=>1
                ],
                [
                    'id'=>10
                ]
            ],
            'orderId' => 5,
            'debug' => 'CSD'
        ];
        list($output, $decodedOutput) = $this->executeFunctionPhp();
        $decodedOutput = json_decode($output, true);
        // Assert the output
        //echo print_r($decodedOutput, true);
        $this->assertEquals('failed', $decodedOutput['status']);
        $this->assertEquals('Requested qty (5) exceeds ordered qty (2) for Item ID 7', $decodedOutput['message']);
    }
    function test020ItemRefund(): void {
        // view current order and items
        $stmt = $this->mockPdo->query("SELECT * FROM food_order WHERE id = 5");
        $currentOrder = $stmt->fetch(PDO::FETCH_ASSOC);
        //print_r($currentOrder);
        $stmt = $this->mockPdo->query("SELECT * FROM food_order_item WHERE order_id = 5");
        $currentOrderItems = $stmt->fetchAll(PDO::FETCH_ASSOC);
        //print_r($currentOrderItems);

        $_SESSION['tenantId'] = 1;
        $_SESSION['id'] = 293;
        $_SESSION['roleValue'] = 5;
        $_SESSION['roleTenantId'] = 1;
        $_POST = [
            'action' => 'itemBasedRefund',
            'orderItems' => [ 
                [
                    'id'=>7,
                    'qty'=>2
                ], 
                [
                    'id'=>8,
                    'qty'=>1
                ],
                [
                    'id'=>10
                ]
            ],
            'orderId' => 5,
            'debug' => 'CSD'
        ];
        list($output, $decodedOutput) = $this->executeFunctionPhp();
        $decodedOutput = json_decode($output, true);
        // Assert the output
        //echo print_r($decodedOutput, true);
        $this->assertEquals('success', $decodedOutput['status']);


        $stmt = $this->mockPdo->query("SELECT * FROM food_order WHERE id = 5");
        $currentOrder = $stmt->fetch(PDO::FETCH_ASSOC);
        //print_r($currentOrder);
        $stmt = $this->mockPdo->query("SELECT * FROM food_order_item WHERE order_id = 5");
        $currentOrderItems = $stmt->fetchAll(PDO::FETCH_ASSOC);
        //print_r($currentOrderItems);
    }
/* Test for full view of order lists*/    
    function test020ListOfOrders(): void {
        $stmt = $this->mockPdo->query("SELECT * FROM food_order WHERE tenant_id = 1");
        $rows = $stmt->fetchAll(PDO::FETCH_ASSOC);  
        // Debug output
        //print_r($rows); // or var_dump($rows)
        $this->assertEquals(1, 1);
    }
    function test021ListOfOrdersNoVariables(): void {
        $_SESSION['tenantId'] = 1;
        $_SESSION['id'] = 293;
        $_SESSION['roleValue'] = 5;
        $_SESSION['roleTenantId'] = 1;
        $_POST = [
            'action' => 'getFullOrderListPaginated',
            'debug' => 'CSD'
        ];
        list($output, $decodedOutput) = $this->executeFunctionPhp();
        $decodedOutput = json_decode($output, true);
        // Assert the output
        //echo print_r($decodedOutput, true);
        $this->assertEquals('success', $decodedOutput['status']);
        // ROW COUNT SHOULD BE 25
        $this->assertEquals(25, count($decodedOutput['orders']));
        $this->assertEquals(33, $decodedOutput['total']);
    }
    function test022ListOfOrdersWithVariables(): void {
        $_SESSION['tenantId'] = 1;
        $_SESSION['id'] = 293;
        $_SESSION['roleValue'] = 5;
        $_SESSION['roleTenantId'] = 1;
        $_POST = [
            'action' => 'getFullOrderListPaginated',
            'offset' => 25,
        ];
        list($output, $decodedOutput) = $this->executeFunctionPhp();
        $decodedOutput = json_decode($output, true);
        // Assert the output
        //echo print_r($decodedOutput, true);
        $this->assertEquals('success', $decodedOutput['status']);
        // ROW COUNT SHOULD BE 10
        $this->assertEquals(8, count($decodedOutput['orders']));
        $this->assertEquals(33, $decodedOutput['total']);
    }
    function test023ListOfOrdersWithDeliveryTypeFilter(): void {
        $stmt = $this->mockPdo->query("SELECT count(*) FROM food_order WHERE tenant_id = 1 AND order_type = 'collection'");
        $collectionCount = $stmt->fetchColumn();
        //echo("\n🔍 Collection Count: " . $collectionCount. "\n");

        $_SESSION['tenantId'] = 1;
        $_SESSION['id'] = 293;
        $_SESSION['roleValue'] = 5;
        $_SESSION['roleTenantId'] = 1;
        $_POST = [
            'action' => 'getFullOrderListPaginated',
            'orderType' => 'collection'
        ];
        list($output, $decodedOutput) = $this->executeFunctionPhp();
        $decodedOutput = json_decode($output, true);
        // Assert the output
        //echo print_r($decodedOutput, true);
        $this->assertEquals('success', $decodedOutput['status']);
        // ROW COUNT SHOULD BE 5
        $this->assertEquals(5, count($decodedOutput['orders']));
        $this->assertEquals(5, $decodedOutput['total']);
    }
    function test024ListOfOrdersWithOrderStatusFilter(): void {
        $stmt = $this->mockPdo->query("SELECT count(*) FROM food_order WHERE tenant_id = 1 AND order_status = 'completed'");
        $completedCount = $stmt->fetchColumn();
        //echo("\n🔍 Completed Count: " . $completedCount. "\n");

        $_SESSION['tenantId'] = 1;
        $_SESSION['id'] = 293;
        $_SESSION['roleValue'] = 5;
        $_SESSION['roleTenantId'] = 1;
        $_POST = [
            'action' => 'getFullOrderListPaginated',
            'orderStatus' => 'completed'
        ];
        list($output, $decodedOutput) = $this->executeFunctionPhp();
        $decodedOutput = json_decode($output, true);
        // Assert the output
        //echo print_r($decodedOutput, true);
        $this->assertEquals('success', $decodedOutput['status']);
        // ROW COUNT SHOULD BE $completedCount
        $this->assertEquals($completedCount, count($decodedOutput['orders']));
        $this->assertEquals($completedCount, $decodedOutput['total']);
    }
    function test025ListOfOrdersWithPaymentStatusFilter(): void {
        $stmt = $this->mockPdo->query("SELECT count(*) FROM food_order WHERE tenant_id = 1 AND payment_status = 'paid'");
        $paidCount = $stmt->fetchColumn();
        //echo("\n🔍 Paid Count: " . $paidCount. "\n");

        $_SESSION['tenantId'] = 1;
        $_SESSION['id'] = 293;
        $_SESSION['roleValue'] = 5;
        $_SESSION['roleTenantId'] = 1;
        $_POST = [
            'action' => 'getFullOrderListPaginated',
            'paymentStatus' => 'paid'
        ];
        list($output, $decodedOutput) = $this->executeFunctionPhp();
        $decodedOutput = json_decode($output, true);
        // Assert the output
        //echo print_r($decodedOutput, true);
        $this->assertEquals('success', $decodedOutput['status']);
        // ROW COUNT SHOULD BE $paidCount
        $this->assertEquals($paidCount, count($decodedOutput['orders']));
        $this->assertEquals($paidCount, $decodedOutput['total']);
        // count should be greater than 1 as we have multiple paid orders
        $this->assertGreaterThan(1, count($decodedOutput['orders']));
    }
    function test026ListOfOrdersWithPaymentStartDate(): void {
        // sql lite statement
        $stmt = $this->mockPdo->query("SELECT count(*) FROM food_order WHERE tenant_id = 1 AND created_at >= date('now')");
        $todayCount = $stmt->fetchColumn();
        //echo("\n🔍 Today Count: " . $todayCount. "\n");

        $_SESSION['tenantId'] = 1;
        $_SESSION['id'] = 293;
        $_SESSION['roleValue'] = 5;
        $_SESSION['roleTenantId'] = 1;
        $_POST = [
            'action' => 'getFullOrderListPaginated',
            'startDate' => date('Y-m-d')
        ];
        list($output, $decodedOutput) = $this->executeFunctionPhp();
        $decodedOutput = json_decode($output, true);
        // Assert the output
        //echo print_r($decodedOutput, true);
        $this->assertEquals('success', $decodedOutput['status']);
        // ROW COUNT SHOULD BE $todayCount
        if ($todayCount > 25) {
            $this->assertEquals(25, count($decodedOutput['orders']));
        } else {
            $this->assertEquals($todayCount, count($decodedOutput['orders']));
        }
        $this->assertEquals($todayCount, $decodedOutput['total']);
    }
    function test027ListOfOrdersWithPaymentEndDate(): void {
        // sql lite statement
        $stmt = $this->mockPdo->query("SELECT count(*) FROM food_order WHERE tenant_id = 1 AND created_at <= date('now', '+1 day')");
        $endDateCount = $stmt->fetchColumn();
        //echo("\n🔍 End Date Count: " . $endDateCount. "\n");

        $_SESSION['tenantId'] = 1;
        $_SESSION['id'] = 293;
        $_SESSION['roleValue'] = 5;
        $_SESSION['roleTenantId'] = 1;
        $_POST = [
            'action' => 'getFullOrderListPaginated',
            'endDate' => date('Y-m-d', strtotime('+1 day'))
        ];
        list($output, $decodedOutput) = $this->executeFunctionPhp();
        $decodedOutput = json_decode($output, true);
        // Assert the output
        //echo print_r($decodedOutput, true);
        $this->assertEquals('success', $decodedOutput['status']);
        // ROW COUNT SHOULD BE $endDateCount
        if ($endDateCount > 25) {
            $this->assertEquals(25, count($decodedOutput['orders']));
        } else {
            $this->assertEquals($endDateCount, count($decodedOutput['orders']));
        }
        $this->assertEquals($endDateCount, $decodedOutput['total']);
    }
    function test028ListOfOrdersWithBothStartAndEndDate(): void {
        // sql lite statement

        // alter some orders to have a created at date in the past to allow testing of between dates
        $this->mockPdo->exec("update food_order set created_at = date('now', '-10 day') WHERE id IN (6,7,8,9,10)");


        $stmt = $this->mockPdo->query("SELECT count(*) FROM food_order WHERE tenant_id = 1 AND created_at BETWEEN date('now', '-11 day') AND date('now', '-10 day')");
        $betweenCount = $stmt->fetchColumn();
        //echo("\n🔍 Between Count: " . $betweenCount. "\n");

        $_SESSION['tenantId'] = 1;
        $_SESSION['id'] = 293;
        $_SESSION['roleValue'] = 5;
        $_SESSION['roleTenantId'] = 1;
        $_POST = [
            'action' => 'getFullOrderListPaginated',
            'startDate' => date('Y-m-d', strtotime('-11 day')),
            'endDate' => date('Y-m-d', strtotime('-10 day'))
        ];
        list($output, $decodedOutput) = $this->executeFunctionPhp();
        $decodedOutput = json_decode($output, true);
        // Assert the output
        //echo print_r($decodedOutput, true);
        $this->assertEquals('success', $decodedOutput['status']);
        // ROW COUNT SHOULD BE $betweenCount
        if ($betweenCount > 25) {
            $this->assertEquals(25, count($decodedOutput['orders']));
        } else {
            $this->assertEquals($betweenCount, count($decodedOutput['orders']));
        }
        $this->assertEquals($betweenCount, $decodedOutput['total']);
    }
    function test029DashboardData(): void {
        $_SESSION['tenantId'] = 1;
        $_SESSION['id'] = 293;
        $_SESSION['roleValue'] = 5;
        $_SESSION['roleTenantId'] = 1;
        $_POST = [
            'action' => 'dashboardData',
            'debug' => 'CSD'
        ];
        list($output, $decodedOutput) = $this->executeFunctionPhp();
        $decodedOutput = json_decode($output, true);
        // Assert the output
        //echo print_r($decodedOutput, true);
        $this->assertEquals('success', $decodedOutput['status']);
        $this->assertArrayHasKey('totalOrders', $decodedOutput['data']['totalOrdersToday']);
        $this->assertArrayHasKey('totalOrders', $decodedOutput['data']['totalOrdersThisWeek']);
        $this->assertArrayHasKey('totalOrders', $decodedOutput['data']['totalOrdersThisMonth']);
        $this->assertArrayHasKey('pending',     $decodedOutput['data']['orderStatusCount24']['orderStatusCounts']);
        $this->assertArrayHasKey('cancelled',   $decodedOutput['data']['orderStatusCount24']['orderStatusCounts']);
        $this->assertArrayHasKey('completed',   $decodedOutput['data']['orderStatusCount24']['orderStatusCounts']);
        $this->assertArrayHasKey('confirmed',   $decodedOutput['data']['orderStatusCount24']['orderStatusCounts']);
        $this->assertArrayHasKey('cooking',     $decodedOutput['data']['orderStatusCount24']['orderStatusCounts']);
        $this->assertArrayHasKey('delivery',    $decodedOutput['data']['orderStatusCount24']['orderStatusCounts']);
        
        $this->assertArrayHasKey('pending',     $decodedOutput['data']['orderStatusCount7']['orderStatusCounts']);
        $this->assertArrayHasKey('cancelled',   $decodedOutput['data']['orderStatusCount7']['orderStatusCounts']);
        $this->assertArrayHasKey('completed',   $decodedOutput['data']['orderStatusCount7']['orderStatusCounts']);
        $this->assertArrayHasKey('confirmed',   $decodedOutput['data']['orderStatusCount7']['orderStatusCounts']);
        $this->assertArrayHasKey('cooking',     $decodedOutput['data']['orderStatusCount7']['orderStatusCounts']);
        $this->assertArrayHasKey('delivery',    $decodedOutput['data']['orderStatusCount7']['orderStatusCounts']);
        $this->assertArrayHasKey('pending',     $decodedOutput['data']['orderStatusCountMonth']['orderStatusCounts']);
        $this->assertArrayHasKey('cancelled',   $decodedOutput['data']['orderStatusCountMonth']['orderStatusCounts']);
        $this->assertArrayHasKey('completed',   $decodedOutput['data']['orderStatusCountMonth']['orderStatusCounts']);
        $this->assertArrayHasKey('confirmed',   $decodedOutput['data']['orderStatusCountMonth']['orderStatusCounts']);
        $this->assertArrayHasKey('cooking',     $decodedOutput['data']['orderStatusCountMonth']['orderStatusCounts']);
        $this->assertArrayHasKey('delivery',    $decodedOutput['data']['orderStatusCountMonth']['orderStatusCounts']);
        $this->assertArrayHasKey('pending',     $decodedOutput['data']['orderStatusCountYear']['orderStatusCounts']);
        $this->assertArrayHasKey('cancelled',   $decodedOutput['data']['orderStatusCountYear']['orderStatusCounts']);
        $this->assertArrayHasKey('completed',   $decodedOutput['data']['orderStatusCountYear']['orderStatusCounts']);
        $this->assertArrayHasKey('confirmed',   $decodedOutput['data']['orderStatusCountYear']['orderStatusCounts']);
        $this->assertArrayHasKey('cooking',     $decodedOutput['data']['orderStatusCountYear']['orderStatusCounts']);
        $this->assertArrayHasKey('delivery',    $decodedOutput['data']['orderStatusCountYear']['orderStatusCounts']);
        $this->assertArrayHasKey('pending',     $decodedOutput['data']['orderStatusCountAll']['orderStatusCounts']);
        $this->assertArrayHasKey('cancelled',   $decodedOutput['data']['orderStatusCountAll']['orderStatusCounts']);
        $this->assertArrayHasKey('completed',   $decodedOutput['data']['orderStatusCountAll']['orderStatusCounts']);
        $this->assertArrayHasKey('confirmed',   $decodedOutput['data']['orderStatusCountAll']['orderStatusCounts']);
        $this->assertArrayHasKey('cooking',     $decodedOutput['data']['orderStatusCountAll']['orderStatusCounts']);
        $this->assertArrayHasKey('delivery',    $decodedOutput['data']['orderStatusCountAll']['orderStatusCounts']);
    }
    function test030InsertNewTerms(): void{
        $_SESSION['tenantId'] = 1;
        $_SESSION['id'] = 293;
        $_SESSION['roleValue'] = 2;
        $_SESSION['roleTenantId'] = 1;
            $_POST = [
                'action' => 'insertNewTerms',
                'foodOrderTermsOfService' =>[
                    'tenantId' => 1,
                    'versions' => '1.0',
                    'content' => 'Sample terms and conditions content.',
                    'effectiveDate' => date('Y-m-d', strtotime('+1 day')),
                    'isActive' => 0
                ],
                'debug' => 'CSD'
            ];
        list($output, $decodedOutput) = $this->executeFunctionPhp();
        $decodedOutput = json_decode($output, true);
        // Assert the output
        //echo print_r($decodedOutput, true);
        $this->assertEquals('success', $decodedOutput['status']);

        // verify the data is in the database
        $stmt = $this->mockPdo->query("SELECT * FROM food_order_terms_of_service WHERE tenant_id = 1 AND versions = '1.0'");
        $rows = $stmt->fetchAll(PDO::FETCH_ASSOC);  
        // Debug output
        //print_r($rows); // or var_dump($rows)
        $this->assertEquals(1, count($rows));
    }
    function test031InsertNewTermsMissingFields(): void{
        $_SESSION['tenantId'] = 1;
        $_SESSION['id'] = 293;
        $_SESSION['roleValue'] = 2;
        $_SESSION['roleTenantId'] = 1;
        $_POST = [
            'action' => 'insertNewTerms',
            'foodOrderTermsOfService' =>[
                'tenantId' => 1,
                // 'version' => '1.0',   // missing version
                'content' => 'Sample terms and conditions content.',
                'effectiveDate' => date('Y-m-d', strtotime('+1 day')),
                'isActive' => 0
            ],
            'debug' => 'CSD'
        ];
        list($output, $decodedOutput) = $this->executeFunctionPhp();
        $decodedOutput = json_decode($output, true);
        // Assert the output
        //echo print_r($decodedOutput, true);
        $this->assertEquals('failed', $decodedOutput['status']);
    }
    function test032InsertNewTermsAddtinals():void{
        $_SESSION['tenantId'] = 1;
        $_SESSION['id'] = 293;
        $_SESSION['roleValue'] = 2;
        $_SESSION['roleTenantId'] = 1;
        $_POST = [
            'action' => 'insertNewTerms',
            'foodOrderTermsOfService' =>[
                'tenantId' => 1,
                'versions' => '1.1',
                'content' => 'Sample terms and conditions content.',
                'effectiveDate' => date('Y-m-d', strtotime('+1 day')),
                'isActive' => 1
            ],
            'debug' => 'CSD'
        ];
        list($output, $decodedOutput) = $this->executeFunctionPhp();
        $decodedOutput = json_decode($output, true);
        // Assert the output
        //echo print_r($decodedOutput, true);
        $this->assertEquals('success', $decodedOutput['status']);

        $_SESSION['tenantId'] = 1;
        $_SESSION['id'] = 293;
        $_SESSION['roleValue'] = 2;
        $_SESSION['roleTenantId'] = 1;
        $_POST = [
            'action' => 'insertNewTerms',
            'foodOrderTermsOfService' =>[
                'tenantId' => 1,
                'versions' => '1.2',
                'content' => 'Sample terms and conditions content.',
                'effectiveDate' => date('Y-m-d', strtotime('+1 day')),
                'isActive' => 1
            ],
            'debug' => 'CSD'
        ];
        list($output, $decodedOutput) = $this->executeFunctionPhp();
        $decodedOutput = json_decode($output, true);
        // Assert the output
        //echo print_r($decodedOutput, true);
        $this->assertEquals('success', $decodedOutput['status']);
        
        $_SESSION['tenantId'] = 1;
        $_SESSION['id'] = 293;
        $_SESSION['roleValue'] = 2;
        $_SESSION['roleTenantId'] = 1;
        $_POST = [
            'action' => 'insertNewTerms',
            'foodOrderTermsOfService' =>[
                'tenantId' => 1,
                'versions' => '1.3',
                'content' => 'Sample terms and conditions content.',
                'effectiveDate' => date('Y-m-d', strtotime('+1 day')),
                'isActive' => 0
            ],
            'debug' => 'CSD'
        ];
        list($output, $decodedOutput) = $this->executeFunctionPhp();
        $decodedOutput = json_decode($output, true);
        // Assert the output
        //echo print_r($decodedOutput, true);
        $this->assertEquals('success', $decodedOutput['status']);

        $_SESSION['tenantId'] = 3;
        $_SESSION['id'] = 293;
        $_SESSION['roleValue'] = 2;
        $_SESSION['roleTenantId'] = 3;

        $_POST = [
            'action' => 'insertNewTerms',
            'foodOrderTermsOfService' =>[
                'tenantId' => 3,
                'versions' => '2.0',
                'content' => 'Sample terms and conditions content for tenant 3.',
                'effectiveDate' => date('Y-m-d', strtotime('+1 day')),
                'isActive' => 1
            ],
            'debug' => 'CSD'
        ];

        list($output, $decodedOutput) = $this->executeFunctionPhp();
        $decodedOutput = json_decode($output, true);
        // Assert the output
        //echo print_r($decodedOutput, true);
        $this->assertEquals('success', $decodedOutput['status']);
    }
    function test033ViewTermsOfAcceptance(): void{
        $_SESSION['tenantId'] = 1;
        $_SESSION['id'] = 293;
        $_SESSION['roleValue'] = 2;
        $_SESSION['roleTenantId'] = 1;
        $_POST = [
            'action' => 'viewLatestTerms',
            'debug' => 'CSD'
        ];
        list($output, $decodedOutput) = $this->executeFunctionPhp();
        $decodedOutput = json_decode($output, true);
        // Assert the output
        //echo print_r($decodedOutput, true);
        $this->assertEquals('success', $decodedOutput['status']);
        $this->assertEquals('1.2', $decodedOutput['terms']['versions']);
    }
    function test034ViewTermsOfAcceptanceNoResult(): void{
        $stmt = $this->mockPdo->query("UPDATE food_order_terms_of_service set is_active = 0 WHERE versions = '1.2'");
        $stmt->fetchAll(PDO::FETCH_ASSOC);  

        $_SESSION['tenantId'] = 1;
        $_SESSION['id'] = 293;
        $_SESSION['roleValue'] = 2;
        $_SESSION['roleTenantId'] = 1;
        $_POST = [
            'action' => 'viewLatestTerms',
            'debug' => 'CSD'
        ];
        list($output, $decodedOutput) = $this->executeFunctionPhp();
        $decodedOutput = json_decode($output, true);
        // Assert the output
        //echo print_r($decodedOutput, true);
        $this->assertEquals('failed', $decodedOutput['status']);
        $this->assertEquals('No terms and conditions found for this tenant', $decodedOutput['message']);
    }
    function test035ViewAllTermsOfService(): void{
        $_SESSION['tenantId'] = 1;
        $_SESSION['id'] = 293;
        $_SESSION['roleValue'] = 2;
        $_SESSION['roleTenantId'] = 1;
        $_POST = [
            'action' => 'viewAllTerms',
            'debug' => 'CSD'
        ];
        list($output, $decodedOutput) = $this->executeFunctionPhp();
        $decodedOutput = json_decode($output, true);
        // Assert the output
        //echo print_r($decodedOutput, true);
        $this->assertEquals('success', $decodedOutput['status']);
        $this->assertEquals(7, count($decodedOutput['terms']));
    }
    function test036UpdateActiveTermOfService(): void{
        $_SESSION['tenantId'] = 3;
        $_SESSION['id'] = 293;
        $_SESSION['roleValue'] = 2;
        $_SESSION['roleTenantId'] = 3;
        $_POST = [
            'action' => 'setActiveTerms',
            'debug' => 'CSD',
            'termId' => 6
        ];
        list($output, $decodedOutput) = $this->executeFunctionPhp();
        $decodedOutput = json_decode($output, true);
        // Assert the output
        //echo print_r($decodedOutput, true);
        $this->assertEquals('success', $decodedOutput['status']);
    }
    function test036UpdateActiveTermOfServiceBadRole(): void{
        $_SESSION['tenantId'] = 3;
        $_SESSION['id'] = 293;
        $_SESSION['roleValue'] = 4;
        $_SESSION['roleTenantId'] = 3;
        $_POST = [
            'action' => 'setActiveTerms',
            'debug' => 'CSD',
            'termId' => 6
        ];
        list($output, $decodedOutput) = $this->executeFunctionPhp();
        $decodedOutput = json_decode($output, true);
        // Assert the output
        //echo print_r($decodedOutput, true);
        $this->assertEquals('failed', $decodedOutput['status']);
        $this->assertEquals('Access denied: insufficient permissions', $decodedOutput['message']);
    }
    function test037ViewOrderBasedOnOrderPublicCode(): void{
        
        // sql to view current orders to work out the public code we will use
        $stmt = $this->mockPdo->query("SELECT public_order_code FROM food_order WHERE tenant_id = 1 and id = 1 LIMIT 1");
        $order = $stmt->fetch(PDO::FETCH_ASSOC);
        //print_r($order);

        // add a test just to validate this is working
        $_SESSION['tenantId'] = 1;
        $_SESSION['id'] = 293;
        $_SESSION['roleValue'] = 5;
        $_SESSION['roleTenantId'] = 1;
        $_POST = [
            'action' => 'viewOrderByPublicCode',
            'publicOrderCode' => $order['public_order_code'],
            'debug' => 'CSD'
        ];
        list($output, $decodedOutput) = $this->executeFunctionPhp();
        $decodedOutput = json_decode($output, true);
        // Assert the output
        //echo print_r($decodedOutput, true);
        $this->assertEquals('success', $decodedOutput['status']);
        $this->assertEquals(1,             $decodedOutput['order']['orderDetails'][0]['id']);
        $this->assertEquals('pending',     $decodedOutput['order']['orderDetails'][0]['orderStatus']);
        $this->assertEquals('delivery',    $decodedOutput['order']['orderDetails'][0]['orderType']);
        $this->assertEquals(20.85,         $decodedOutput['order']['orderDetails'][0]['totalOrderModifiedPrice']);
        $this->assertEquals('unpaid',      $decodedOutput['order']['orderDetails'][0]['paymentStatus']);
        $this->assertEquals(1,             $decodedOutput['order']['orderDetails'][0]['deliveryAddressId']);   
        $this->assertEquals('123 Main St', $decodedOutput['order']['orderDetails'][0]['delivery']['address_line_1']);
        $this->assertEquals('Apt 4B',      $decodedOutput['order']['orderDetails'][0]['delivery']['address_line_2']);
        $this->assertEquals('Springfield', $decodedOutput['order']['orderDetails'][0]['delivery']['city']);
        $this->assertEquals('Devon',       $decodedOutput['order']['orderDetails'][0]['delivery']['county']);
        $this->assertEquals('UK',          $decodedOutput['order']['orderDetails'][0]['delivery']['country']);
        $this->assertEquals('EX1 2AB',     $decodedOutput['order']['orderDetails'][0]['delivery']['postal_code']);
        $this->assertEquals('Chips',       $decodedOutput['order']['orderDetails'][0]['details'][0]['itemName']);
        $this->assertEquals(6.48,          $decodedOutput['order']['orderDetails'][0]['details'][0]['itemModifiedPrice']);
        $this->assertEquals(2.99,          $decodedOutput['order']['orderDetails'][0]['details'][0]['itemBasePrice']);
        $this->assertEquals(2,             $decodedOutput['order']['orderDetails'][0]['details'][0]['itemQuantity']);
        $this->assertEquals('pending',     $decodedOutput['order']['orderDetails'][0]['details'][0]['itemStatus']);
        $this->assertEquals('Salt',        $decodedOutput['order']['orderDetails'][0]['details'][0]['extras'][0]['extraName']);
        $this->assertEquals(0.00,          $decodedOutput['order']['orderDetails'][0]['details'][0]['extras'][0]['extraPrice']);
        $this->assertEquals(1,             $decodedOutput['order']['orderDetails'][0]['details'][0]['extras'][0]['extraQuantity']);
        $this->assertEquals('Vinegar',     $decodedOutput['order']['orderDetails'][0]['details'][0]['extras'][1]['extraName']);
        $this->assertEquals(0.25,          $decodedOutput['order']['orderDetails'][0]['details'][0]['extras'][1]['extraPrice']);
        $this->assertEquals(1,             $decodedOutput['order']['orderDetails'][0]['details'][0]['extras'][1]['extraQuantity']);
        $this->assertEquals('Chips',       $decodedOutput['order']['orderDetails'][0]['details'][1]['itemName']);
        $this->assertEquals(6.48,          $decodedOutput['order']['orderDetails'][0]['details'][1]['itemModifiedPrice']);
        $this->assertEquals(2.99,          $decodedOutput['order']['orderDetails'][0]['details'][1]['itemBasePrice']);
        $this->assertEquals(2,             $decodedOutput['order']['orderDetails'][0]['details'][1]['itemQuantity']);
        $this->assertEquals('pending',     $decodedOutput['order']['orderDetails'][0]['details'][1]['itemStatus']);
        $this->assertEquals('Vinegar',     $decodedOutput['order']['orderDetails'][0]['details'][1]['extras'][0]['extraName']);
        $this->assertEquals(0.25,          $decodedOutput['order']['orderDetails'][0]['details'][1]['extras'][0]['extraPrice']);
        $this->assertEquals(1,             $decodedOutput['order']['orderDetails'][0]['details'][1]['extras'][0]['extraQuantity']);
    }
    function test038ViewOrderBasedOnInvalidOrderPublicCode(): void{
        $_SESSION['tenantId'] = 1;
        $_SESSION['id'] = 293;
        $_SESSION['roleValue'] = 5;
        $_SESSION['roleTenantId'] = 1;
        $_POST = [
            'action' => 'viewOrderByPublicCode',
            'publicOrderCode' => 'INVALIDCODE123',
            'debug' => 'CSD'
        ];
        list($output, $decodedOutput) = $this->executeFunctionPhp();
        $decodedOutput = json_decode($output, true);
        // Assert the output
        //echo print_r($decodedOutput, true);
        $this->assertEquals('failed', $decodedOutput['status']);
        $this->assertEquals('No order found for this public order code', $decodedOutput['message']);
    }
    function test039ViewOrderBasedOnOrderPublicCodeDifferentTenant(): void{
        // sql to view current orders to work out the public code we will use
        $stmt = $this->mockPdo->query("SELECT public_order_code FROM food_order WHERE tenant_id = 1 and id = 1 LIMIT 1");
        $order = $stmt->fetch(PDO::FETCH_ASSOC);
        //print_r($order);

        $_SESSION['tenantId'] = 2; // different tenant
        $_SESSION['id'] = 293;
        $_SESSION['roleValue'] = 5;
        $_SESSION['roleTenantId'] = 2;
        $_POST = [
            'action' => 'viewOrderByPublicCode',
            'publicOrderCode' => $order['public_order_code'],
            'debug' => 'CSD'
        ];
        list($output, $decodedOutput) = $this->executeFunctionPhp();
        $decodedOutput = json_decode($output, true);
        // Assert the output
        //echo print_r($decodedOutput, true);
        $this->assertEquals('failed', $decodedOutput['status']);
        $this->assertEquals('No order details found', $decodedOutput['message']);
    }
    function test040ViewOrderBasedOnOrderPublicCodeNoSession(): void{
        // sql to view current orders to work out the public code we will use
        $stmt = $this->mockPdo->query("SELECT public_order_code FROM food_order WHERE tenant_id = 1 and id = 1 LIMIT 1");
        $order = $stmt->fetch(PDO::FETCH_ASSOC);
        //print_r($order);

        // no session set
        $_SESSION = [];
        $_POST = [
            'action' => 'viewOrderByPublicCode',
            'publicOrderCode' => $order['public_order_code'],
            'debug' => 'CSD'
        ];
        list($output, $decodedOutput) = $this->executeFunctionPhp();
        $decodedOutput = json_decode($output, true);
        // Assert the output
        //echo print_r($decodedOutput, true);
        $this->assertEquals('failed', $decodedOutput['status']);
        $this->assertEquals('User is not logged in', $decodedOutput['message']);
    }
    function test041ViewOrderBasedOnOrderPublicCodeMissingPostVar(): void{
        // sql to view current orders to work out the public code we will use
        $stmt = $this->mockPdo->query("SELECT public_order_code FROM food_order WHERE tenant_id = 1 and id = 1 LIMIT 1");
        $order = $stmt->fetch(PDO::FETCH_ASSOC);
        //print_r($order);

        $_SESSION['tenantId'] = 1;
        $_SESSION['id'] = 293;
        $_SESSION['roleValue'] = 5;
        $_SESSION['roleTenantId'] = 1;
        $_POST = [
            'action' => 'viewOrderByPublicCode',
            'debug' => 'CSD'
        ];
        list($output, $decodedOutput) = $this->executeFunctionPhp();
        $decodedOutput = json_decode($output, true);
        // Assert the output
        //echo print_r($decodedOutput, true);
        $this->assertEquals('failed', $decodedOutput['status']);
        $this->assertEquals('Public Order Code is required', $decodedOutput['message']);
    }
    function test042ViewOrderBasedOnOrderPublicCodeInvalidRole(): void{
        // sql to view current orders to work out the public code we will use
        $stmt = $this->mockPdo->query("SELECT public_order_code FROM food_order WHERE tenant_id = 1 and id = 1 LIMIT 1");
        $order = $stmt->fetch(PDO::FETCH_ASSOC);
        //print_r($order);

        $_SESSION['tenantId'] = 1;
        $_SESSION['id'] = 293;
        $_SESSION['roleValue'] = 7; // invalid role
        $_SESSION['roleTenantId'] = 1;
        $_POST = [
            'action' => 'viewOrderByPublicCode',
            'publicOrderCode' => $order['public_order_code'],
            'debug' => 'CSD'
        ];
        list($output, $decodedOutput) = $this->executeFunctionPhp();
        $decodedOutput = json_decode($output, true);
        // Assert the output
        //echo print_r($decodedOutput, true);
        $this->assertEquals('failed', $decodedOutput['status']);
        $this->assertEquals('Access denied: insufficient permissions', $decodedOutput['message']);
    }

/*
    public function testGetCurrentAccountInfo(){
        $stmt = $this->mockPdo->query("SELECT * FROM tenant_history");
        $rows = $stmt->fetchAll(PDO::FETCH_ASSOC);
    
        // Debug output
        print_r($rows); // or var_dump($rows)
        $this->assertEquals("1", "1");
    }
*/

    /* To Do: 
        - test view as sysadmin with a deleted tenant
        - test view as owner with a deleted tenant
        - test view as public with a deleted tenant
    */
}

?>