<?php
    function logMeIn($inputData){
        $res['emailCheck']  = emailCheck($inputData);
        $_SESSION['id'] = 0;
        $results['status']  = 'failed';
        $inputData['status'] = 'failed';
        $inputData['msg'] = 'Login Failed - Email not found';
        $inputData['userId'] = 0;
        if($res['emailCheck']['UserExists']   != 'failed' && $res['emailCheck']['UserExists'] > 0 &&  $res['emailCheck']['userStatus'] == 2){
            $int['pass']            =  getPassword($inputData);
            if(password_verify($inputData['password'], $int['pass']) === true){
                $_SESSION['id'] = $res['emailCheck']['UserExists'];
                $results['status']  = 'success';
                userType($inputData);
                $results['role'] = $_SESSION['roleValue'];
                $inputData['userId'] = $_SESSION['id'];
                $inputData['status'] = 'success';
                $inputData['msg'] = 'Login Success';
            }else{
                $inputData['msg'] = "password incorrect";
            }
        }else{
            $inputData['msg'] = "User checks failed";
        }

        
        if($res['emailCheck']['userStatus'] == 1){
            $results['message'] = "Please validate your email";
            $inputData['msg'] = "Please validate your email";
        }

        if($res['emailCheck']['userStatus'] == 3){
            $results['message'] = "Account Locked";
            $inputData['msg'] = "Account Locked";
        }

        logOfLogin($inputData);
        return $results;
    }

    function passwordHashing($passwordIn){
        return  password_hash($passwordIn, PASSWORD_DEFAULT);
      }

    function oneTimeCode(){
        return random_int(100000, 999999);
    }


    function emailCheckSanatize($inputData){
        $int['emailCheck']  =  emailCheck($inputData);
        if($int['emailCheck']['UserExists']   != 'failed' && $int['emailCheck']['UserExists'] > 0){
            $res['message']     =   'Email Already Exists';
            $res['email']       =   '1';
            $res['status']     = 'failed';
        }else{
            $res['email']       =   '0';
            $res['status']     = 'success';
        }
        return $res;
    }

    function newUser($inputData){  
        $emailCheck = emailCheckSanatize($inputData);
        if($emailCheck['email'] == 0){
            $inputData['passwordHash'] = passwordHashing($inputData['password']);
            $inputData['oneTimeCode']  = oneTimeCode();
            $res = addnewuser($inputData);
            if($res['status'] == 'success'){
                validationEmail($inputData);
            }
        }else{
            $res = $emailCheck;
        }

        return $res;
    }

    function validationEmail($inputData){
        // Handle preflight request
        if ($_SERVER['REQUEST_METHOD'] === 'OPTIONS') {
            header("Access-Control-Allow-Origin: *");
            header("Access-Control-Allow-Methods: POST");
            header("Access-Control-Allow-Headers: content-type");
            exit;
        }

        // Only allow POST requests
        if ($_SERVER['REQUEST_METHOD'] !== 'POST') {
            header("Allow: POST", true, 405);
            exit;
        }
        $email = filter_var($inputData['email'], FILTER_VALIDATE_EMAIL);

        header("Access-Control-Allow-Origin: *");
        if (!$email) {
            // Handle invalid email
            http_response_code(400);
            $data['result']['email']['status']              = 'failed';
            $data['result']['email']['message']             = 'Invalid email address.';
            $data['result']['email']['http_response_code']  = 400;
            return $data;
        }

        // Get server domain for the no-reply email address
        $domain = $_SERVER['HTTP_HOST'];
        $noreplyEmail = "no-reply@$domain";

        $adminRecipient = $email;
        $adminSubject   = "Validate Email";
        $adminHeaders   = "From: $noreplyEmail\r\n";
        $adminHeaders  .= "Reply-To: $noreplyEmail\r\n";
        $adminHeaders  .= "Content-type: text/html; charset=UTF-8\r\n";

        $action = '?action=validNewUser&email='.rawurlencode($email).'&oneTimeCode='.$inputData['oneTimeCode'];
        $message = '<html>
          <head><meta http-equiv="Content-Type" content="text/html; charset=utf-8">
          <title>Finance system email validation</title>
        </head>
          <body>
            <h1>Hi '.$inputData['fname'].',</h1>
            <p>Thank you for registering with us.</p></br>
            <p>Please click the link below to validate and activate your account</p></br>
            <p>One Time Code: '.$inputData['oneTimeCode'].'</p></br>
            <a href="https://'.$domain.'/authentication'.$action.'">Validate Email</a></br>
            <p> If this like has not worked please copy and paste the address below in to the validation form</p></br>
            <p>https://'.$domain.'/authentication'.$action.'</p>
          </body>
        </html>';
    
        $adminSuccess = mail($adminRecipient, $adminSubject, $message, $adminHeaders);

        // Handle admin email success/failure
        if ($adminSuccess) {
            $data['result']['admin_status'] = 'success';
            $data['result']['admin_message'] = 'Admin email sent successfully.';
            $data['result']['admin_http_response_code'] = 200;
        } else {
            $data['result']['admin_status'] = 'failed';
            $data['result']['admin_message'] = 'Failed to send admin email.';
            $data['result']['admin_http_response_code'] = 500;
        }
    
        return $data;
      }

    function resetpasswordEmailSend($inputData){
        $to =  $inputData['email'];
        $subject = "Password Reset";
       
        $action = '?action=resetLostPassword&email='.rawurlencode($inputData['email']).'&oneTimeCode='.$inputData['oneTimeCode'];
        $message =   "<html><body>";
        $message .=  '<title>Finance system reset password</title>';
    //    $message .=  '<h1> Hi '.$input['fullName'].'</h1>';
        $message .=  '<h1> Hi</h1>';
        $message .=  '<p>Please click the link below to reset your password</p></br>';
        $message .=  '<p>or copy and paste the code below in to the reset form</p>';
        $message .=  '<p>One Time Code: '.$inputData['oneTimeCode'].'</p>';
        $message .=  '<a href="https://'.$inputData['subloc'].'.the-company.co.uk/password-reset.php'.$action.'">Validate ME!</a>';
        $message .=  '<p>This reset will end in 2 hours</p>';
        $message .=  "</body></html>";
       
        
        $headers = 'MIME-Version: 1.0 "\r\n"';
        // $headers .= 'Content-type: text/html; charset=iso-8859-1 \n';
        $headers .= 'Content-type: text/html; charset=utf-8' . "\r\n";
        $headers .= 'From: <no-reply@azui.co.uk> \n';
        
        mail($to,$subject,$message,$headers);
        return $action;
      }

    function validateEmail($inputData){
        // check if email exists 
        $simpleEmailCheck = simpleEmailCheck($inputData);
        if ($simpleEmailCheck['status'] == 'success' && $simpleEmailCheck['userId'] != 0) {
            // check if email is allready validated
            $inputData['userId'] = $simpleEmailCheck['userId'];
            $userStatusCheck = checkStatusOfUser($inputData);
            if($userStatusCheck['status'] == 'success' && $userStatusCheck['userStatus'] == 1){
                $res = updateValidateEmail($inputData);
            }else{
                $res['status'] = 'failed';
                $res['msg']    = 'Email allready validated';
            }
        }else{
            $res = $simpleEmailCheck;
        }
        return $res;
    }

    function setupPasswordReset($inputData){
        $inputData['oneTimeCode']  = oneTimeCode();
        $res =  updateForGotPassPart1($inputData);
        if($res['status'] == 'success'){
            resetpasswordEmailSend($inputData);
        }
        return $res;
    }

    function passwordResetRequest($inputData){
        $inputData['passwordHash'] = passwordHashing($inputData['password']);
        $res = updateForGotPassPart2($inputData);
        if($res['status'] == 'success'){
        //    $res['html'] = validatedMessage('p');
        }
        return $res; 
    }

    function updatePass($inputData){
        $email      = getEmailAddress($inputData);
        if($email['status'] == 'success'){    
            $inputData['email']     = $email['user_email'];
            $int['pass']            = getPassword($inputData);
            if(password_verify($inputData['oldPassword'], $int['pass']) === true){
                $inputData['passwordHash'] = passwordHashing($inputData['password']);
                $res = updatePassword($inputData);
            }
        }else{
            $res = $email;
        }
        return $res;
    }
?>
