<?php
    function emailCheck($inputData){
        $result = [];
        $db = $inputData['db']['dbLogin'];
        $stmt = $db->prepare("Select pk_user_id, fk_user_status_id from user_login where upper(user_email) = upper(:email)");
        $stmt->bindParam(':email', $inputData['email']);
        $stmt->execute();
        $row = $stmt->fetch(PDO::FETCH_ASSOC);
        if ($row) { 
            $result['UserExists'] = $row !== false ? $row['pk_user_id'] : null;
            $result['userStatus'] = $row !== false ? $row['fk_user_status_id'] : null;


        }else{
            $result['email']        = $inputData['email'];
            $result['UserExists']   = 'failed';
        }        
        return  $result;
    }

    function userType($inputData){
        $userID = $_SESSION['id'];
        $db = $inputData['db']['dbLogin'];
        $stmt = $db->prepare("select fk_role_id from `user_permissions` where fk_user_id = :userId and fk_system_id = :systemId");
        $stmt->bindParam(':userId', $userID);
        $stmt->bindParam('systemId',$inputData['systemId']);
        $stmt->execute();
        $row = $stmt->fetch(PDO::FETCH_ASSOC);
        if ($row) { 
            $roleValue = $row !== false ? $row['fk_role_id'] : 0;
        }else{
            $roleValue = 0;
        }
        $_SESSION['roleValue'] = $roleValue;
        return;        
    }

    function emailCheckWithID($inputData){
        $result = [];
        $userID =  $_SESSION['id'];
        $db = $inputData['db']['dbLogin'];
        $stmt = $db->prepare("Select fk_user_status_id from user_login where pk_user_id = :userId");
        $stmt->bindParam(':userId', $userID);
        $stmt->execute();
        $row = $stmt->fetch(PDO::FETCH_ASSOC);
        if ($row) { 
            $result['userStatus'] = $row !== false ? $row['fk_user_status_id'] : null;
            $result['status']    = 'success';

        }else{
            $result['UserExists']   = 'failed';
            $result['status']       = 'ignor';

        //    $result['emailCheck1']  = $stmt;
        //    $result['emailCheck2']  = $stmt->errorInfo();
        }        
        return  $result;
    }
    
    function getPassword($inputData){
        $result = [];
        $db = $inputData['db']['dbLogin'];
        $stmt = $db->prepare("select user_password from user_login where upper(user_email) = upper(:email)");
        $stmt->bindParam(':email', $inputData['email']);
        $stmt->execute();
        $row = $stmt->fetch(PDO::FETCH_ASSOC);
        if ($row) { 
            return $result['user_password'] = $row !== false ? $row['user_password'] : null;
        }else{
            $result['email']            = $inputData['email'];
            $result['user_password']    = 'failed';
        //    $result['getPassword1']     = $stmt;
        //    $result['getPassword2']     = $stmt->errorInfo();
        }
        return  $result;
    }

    function getEmailAddress($inputData){
        $result = [];
        $userID =  $_SESSION['id'];
        $db = $inputData['db']['dbLogin'];
        $stmt = $db->prepare("select user_email from user_login where pk_user_id = :userId");
        $stmt->bindParam(':userId', $userID);
        $stmt->execute();
        $row = $stmt->fetch(PDO::FETCH_ASSOC);
        if ($row) { 
            $result['user_email'] = $row !== false ? $row['user_email'] : null;
            $result['status']    = 'success';
        }else{
            $result['status']    = 'failed';
        //    $result['getPassword1']     = $stmt;
        //    $result['getPassword2']     = $stmt->errorInfo();
        //    $result['id'] =  $_SESSION['id'];
        }
        return  $result;
    }

    function simpleEmailCheck($inputData){
        $result = [];
        $db = $inputData['db']['dbLogin'];
        $stmt = $db->prepare("Select pk_user_id from user_login where upper(user_email) = upper(:email)");
        $stmt->bindParam(':email', $inputData['email']);
        $stmt->execute();
        $row = $stmt->fetch(PDO::FETCH_ASSOC);
        if ($row) { 
            $result['userId'] = $row !== false ? $row['pk_user_id'] : 0;
            $result['status']    = 'success';
        }else{
            $result['status']    = 'failed';
            $result['msg']       = 'Email not found';
        }        
        return  $result;
    }

    function checkStatusOfUser($inputData){
        $result = [];
        $db = $inputData['db']['dbLogin'];
        $stmt = $db->prepare("select fk_user_status_id from user_login where pk_user_id = :userId");
        $stmt->bindParam(':userId', $inputData['userId']);
        $stmt->execute();
        $row = $stmt->fetch(PDO::FETCH_ASSOC);
        if ($row) { 
            $result['userStatus'] = $row !== false ? $row['fk_user_status_id'] : 0;
            $result['status']    = 'success';
        }else{
            $result['status']    = 'failed';
            $result['msg']       = 'User not found';
        }
        return  $result;
    }
?>
