<?php
// this should only be used for testing purposes
if (defined('TEST_ENV')) {
    //require_once __DIR__ . '/../../orbit-core/src/config.php';
    require_once __DIR__ . '\..\..\core\src\Fcors.php';
    require_once __DIR__ . '\..\..\tests\scripts\bootstrap.php';
    require_once __DIR__ . '\..\..\core\src\generic.php';
    $testInfo['0'] = ("\nFunction Running in Test Environment\n");
} else {
    // this is code for live environment Dev, Uat, Production
    require_once __DIR__ . "./../generic.php";
}
    
    require_once __DIR__ . "/core.php";
    require_once __DIR__ . "/view.php";
    require_once __DIR__ . "/insert.php";
    require_once __DIR__ . "/update.php";
    $inputData = initializeGeneric();  // ✅ Ensures fresh initialization in each test

    $inputData['requiresAdmin'] = [
        'lookupUser'        => [1,2,3],             'setUpOwnerToNewSystem'         => [1],    'setUserToSystem'    => [1,2,3,4,5], 
        'getAvailableRoles' => [1,2,3,4,5]
    ];
    
    if(isset($inputData['action'])){
        $action = $inputData['action'];
    }else{
        $action = null;
    }
    
// ==========================================Login=================================================
$security = SecurityCheck($inputData); // skip security for a bit 

if($security['security'] === '1'){
    if (isset($action)) {
        switch ($action) {
            case "login":
                //Warning is this block of code somewhere
                $out = logMeIn($inputData);
                break;
            case "checkLive":
                $out = checkLive();
                break;
            case "logout":
                killSessions();
                $out['status'] = 'success';
                break;
            case "checkEmail":
                if(!isset($inputData['email']) || $inputData['email'] == ''){
                    $out['status']      = 'failed';
                    $out['message']     = 'Invalid email address.';
                    break;
                }       
                $out = emailCheckSanatize($inputData);
                break;
            case "addUser":
                if(!isset($inputData['email']) || $inputData['email'] == '' || !isset($inputData['password']) || $inputData['password'] == '' || !isset($inputData['firstName']) || $inputData['firstName'] == '' || !isset($inputData['lastName']) || $inputData['lastName'] == '' || !isset($inputData['phoneNumber']) || $inputData['phoneNumber'] == ''){
                    $out['status']      = 'failed';
                    $out['message']     = 'Invalid or missing Inputs.';
                    break;
                }
                $out = newUser($inputData);
                break;
            case "validateEmail":
                $out = validateEmail($inputData);
                break;
            case "setupPasswordReset":
                $out = setupPasswordReset($inputData);
                break;
            case "passwordResetRequest":
                $out = passwordResetRequest($inputData);
                break;
            case "updatePass":
                $out = updatePass($inputData);
                break;
            case "lookupUser":
                if(!isset($inputData['lookupUserId']) || $inputData['lookupUserId'] == ''){
                    $out['status']      = 'failed';
                    $out['message']     = 'Invalid userId.';
                    break;
                }       
                $out = lookupUser($inputData);
                break;
            case "setUpOwnerToNewSystem":
                $out = setupNewSystem($inputData);
                break;
            case "setUserToSystem":
                $out = setUserToSystem($inputData);
                break;
            case "getAvailableRoles":
                $inputData['nextOperation'] = 'viewRoles';
                $out = executeDatabaseOperation($inputData);
                break;
//            case "getCurrentUserInfoDebug":       
//                $out['status']        = 'success';
//                $out['message']       = 'Current Info';
//                $out['userId']        = $_SESSION['id'];
//                $out['roleId']        = $_SESSION['roleValue'];
//                break;
            default:
                $out['status']      = 'failed';
                $out['message']     = 'Invalid Action';
//              $out['inputData']   = $inputData;
                break;
        }
    } else {
        $out['status']      = 'failed';
        $out['message']     = 'No Action Found';
        $out['inputData']   = $inputData;
    }
}else{
    $out = $security;
    if($security['security'] === '0'){
        unset($out['security']);
    }

}
    if(defined('TEST_ENV')){
        //    $out['testInfo']['1'] = $testInfo;
        //    $out['testInfo']['2'] = $_GET;
        //    $out['testInfo']['3'] = $_POST;
        //    $out['inputData'] = $inputData;
        //    $out['security'] = $security;
              $out['action'] = $action;
        //    $out['roleValue'] = $_SESSION['roleValue'];
    }

    echo json_encode(propagateStatusAndMessage($out));
?>