CREATE TABLE `user_login` (
  `pk_user_id` int(11) NOT NULL,
  `fk_user_status_id` int(11) NOT NULL DEFAULT 1,
  `f_name` varchar(25) NOT NULL,
  `l_name` varchar(25) NOT NULL,
  `user_email` varchar(254) NOT NULL,
  `user_password` varchar(400) NOT NULL,
  `one_time_code` varchar(10) DEFAULT NULL,
  `last_updated` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp()
) ENGINE=InnoDB DEFAULT CHARSET=latin1 COLLATE=latin1_swedish_ci;

INSERT INTO `user_login` (`pk_user_id`, `fk_user_status_id`, `f_name`, `l_name`, `user_email`, `user_password`, `one_time_code`, `last_updated`) VALUES
(1, 2, '', '', 'csdx27@gmail.com', '$2y$10$Yglo8xuDUf8E/QCmpEsHeOzAd6mvBUL/483qpaKM8W9D2sYgcoU.2', NULL, '2023-07-12 15:58:48'),
(2, 2, '', '', 'admin@azui.co.uk', '$2y$10$d0aT/cDmWHwHfooHG5ZLqO1r74Il/g8dqCpbRvzYv2fnj5M2wn2ei', null , '2023-07-12 15:58:48');
-- --------------------------------------------------------


CREATE TABLE `user_permissions` (
  `pk_permission_Id` int(11) NOT NULL,
  `fk_system_id` int(11) NOT NULL,
  `fk_user_id` int(11) NOT NULL,
  `fk_role_id` int(11) NOT NULL
) ENGINE=MyISAM DEFAULT CHARSET=latin1 COLLATE=latin1_swedish_ci;

--
-- Dumping data for table `user_permissions`
--

INSERT INTO `user_permissions` (`pk_permission_Id`, `fk_system_id`, `fk_user_id`, `fk_role_id`) VALUES
(1, 1, 1, 1),
(2, 1, 2, 1);

-- --------------------------------------------------------

--
-- Table structure for table `user_role`
--

CREATE TABLE `user_role` (
  `pk_role_id` int(11) NOT NULL,
  `role_name` varchar(50) NOT NULL
) ENGINE=MyISAM DEFAULT CHARSET=latin1 COLLATE=latin1_swedish_ci;

--
-- Dumping data for table `user_role`
--

INSERT INTO `user_role` (`pk_role_id`, `role_name`) VALUES
(1, 'Builder'),
(2, 'Owner'),
(3, 'Admin'),
(4, 'Moderator'),
(5, 'User');

-- --------------------------------------------------------

--
-- Table structure for table `user_status`
--

CREATE TABLE `user_status` (
  `pk_user_status_id` int(11) NOT NULL,
  `table_ref_name` varchar(20) NOT NULL,
  `status_name` varchar(20) NOT NULL,
  `last_updated` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp()
) ENGINE=MyISAM DEFAULT CHARSET=latin1 COLLATE=latin1_swedish_ci;

--
-- Dumping data for table `user_status`
--

INSERT INTO `user_status` (`pk_user_status_id`, `table_ref_name`, `status_name`, `last_updated`) VALUES
(1, 'user_login', 'Email Validation', '2022-11-14 16:21:22'),
(3, 'user_login', 'Disabled', '2023-05-31 13:52:01'),
(2, 'user_login', 'Active', '2023-05-31 13:52:03'),
(4, 'user_login', 'Password Reset', '2022-11-15 13:08:38');

--
-- Indexes for dumped tables
--

--
-- Indexes for table `user_login`
--
ALTER TABLE `user_login`
  ADD PRIMARY KEY (`pk_user_id`),
  ADD KEY `fk_user_status_id` (`fk_user_status_id`);

--
-- Indexes for table `user_permissions`
--
ALTER TABLE `user_permissions`
  ADD PRIMARY KEY (`pk_permission_Id`),
  ADD KEY `user_permissions_user` (`fk_user_id`),
  ADD KEY `user_permissions_role` (`fk_role_id`),
  ADD KEY `user_permissions_systemName` (`fk_system_id`);

--
-- Indexes for table `user_role`
--
ALTER TABLE `user_role`
  ADD PRIMARY KEY (`pk_role_id`);

--
-- Indexes for table `user_status`
--
ALTER TABLE `user_status`
  ADD PRIMARY KEY (`pk_user_status_id`);

--
-- AUTO_INCREMENT for dumped tables
--

--
-- AUTO_INCREMENT for table `user_login`
--
ALTER TABLE `user_login`
  MODIFY `pk_user_id` int(11) NOT NULL AUTO_INCREMENT, AUTO_INCREMENT=24;

--
-- AUTO_INCREMENT for table `user_permissions`
--
ALTER TABLE `user_permissions`
  MODIFY `pk_permission_Id` int(11) NOT NULL AUTO_INCREMENT, AUTO_INCREMENT=4;

--
-- AUTO_INCREMENT for table `user_role`
--
ALTER TABLE `user_role`
  MODIFY `pk_role_id` int(11) NOT NULL AUTO_INCREMENT, AUTO_INCREMENT=3;

--
-- AUTO_INCREMENT for table `user_status`
--
ALTER TABLE `user_status`
  MODIFY `pk_user_status_id` int(11) NOT NULL AUTO_INCREMENT, AUTO_INCREMENT=6;