<?php
    function updateValidateEmail($inputData){
        $result = [];
        $db = $inputData['db']['dbLogin'];
        $stmt = $db->prepare("update user_login set fk_user_status_id = 2, one_time_code = null  where user_email = :email and one_time_code = :otc and fk_user_status_id = 1");
        $stmt->bindParam(':email', $inputData['email']);
        $stmt->bindParam(':otc', $inputData['otc']);
        $stmt->execute();
        if ($stmt->rowCount() > 0){
            $result['message'] = "Email has been validated";
            $result['status']  = 'success';
            return $result;
        }else{
            $result['status']  = 'failed';
            $result['message'] =  'Email failed to be validated';
            return $result;
        }
    }

    function updateForGotPassPart1($inputData){
        $result = [];
        $db = $inputData['db']['dbLogin'];
        $stmt = $db->prepare("update user_login set fk_user_status_id = 4, one_time_code = :otc  where user_email = :email");
        $stmt->bindParam(':email', $inputData['email']);
        $stmt->bindParam(':otc', $inputData['oneTimeCode']);
        $stmt->execute();
        if ($stmt->rowCount() > 0){
            $result['message'] = "Password marked for reset, Please check your email";
            $result['status']  = 'success';
            return $result;
        }else{
            $result['status']  = 'failed';
            $result['message'] =  'Email failed to be validated';
            return $result;
        }
    }

    function updateForGotPassPart2($inputData){
        $result = [];
        $db = $inputData['db']['dbLogin'];
        $stmt = $db->prepare("update user_login set fk_user_status_id = 2, one_time_code = null, user_password = :pass  where user_email = :email and one_time_code = :otc and fk_user_status_id = 4");
        $stmt->bindParam(':email',  $inputData['email']);
        $stmt->bindParam(':otc',    $inputData['otc']);
        $stmt->bindParam(':pass',   $inputData['passwordHash']);
        $stmt->execute();
        if ($stmt->rowCount() > 0){
            $result['message'] = "Password reset";
            $result['status']  = 'success';
            return $result;
        }else{
            $result['status']  = 'failed';
            $result['message'] =  'Email failed to be validated';
            return $result;
        }
    }

    function updatePassword($inputData){
        $result = [];
        $userID =  $_SESSION['id'];
        $db     = $inputData['db']['dbLogin'];
        $stmt   = $db->prepare("update user_login set user_password = :pass  where pk_user_id = :userID");
        $stmt->bindParam(':userID',         $userID);
        $stmt->bindParam(':pass',           $inputData['passwordHash']);
        $stmt->execute();
        if ($stmt->rowCount() > 0){
            $result['message'] = "Password Updated";
            $result['status']  = 'success';
            return $result;
        }else{
            $result['status']           = 'failed';
            $result['message']          =  'Password Failed to be updated';
            $result['passwordUpdate']   = $stmt;
            $result['passwordUpdate2']  = $stmt->errorInfo();
            $result['passwordUpdate3']  = $inputData['oldPass'];
            $result['passwordUpdate4']  = $inputData['passwordHash'];
            $result['passwordUpdate5']  = $userID;
            return $result;
        }
    }
?>