DELIMITER $$

CREATE TRIGGER revoke_permissions_on_tenant_delete
AFTER UPDATE ON tenant
FOR EACH ROW
BEGIN
  -- Only proceed if is_deleted changes from 0 to 1
  IF OLD.is_deleted = 0 AND NEW.is_deleted = 1 THEN
    UPDATE user_permissions up
    JOIN user_system us ON up.fk_system_id = us.pk_system_id
    SET up.access_status = 'revoked'
    WHERE us.fk_tenant_id = NEW.id;
  END IF;
END$$

DELIMITER ;


DELIMITER $$

CREATE TRIGGER delete_user_systems_on_tenant_delete
AFTER UPDATE ON tenant
FOR EACH ROW
BEGIN
  -- Only proceed if tenant is marked deleted
  IF OLD.is_deleted = 0 AND NEW.is_deleted = 1 THEN
    UPDATE user_system
    SET isDeleted = 1
    WHERE fk_tenant_id = NEW.id;
  END IF;
END$$

DELIMITER ;

