# Login API Interface Specification

---

## Overview
This document outlines the API contract for user authentication and management, including login, registration, password reset, and session validation. All operations are triggered via a single endpoint (`function.php`) using `POST` or `GET` requests, with the operation determined by the `action` field in the payload.

---

## API Summary Table

| Action                      | Method | Auth Required | Payload Object             | Description                                                         |
|-----------------------------|--------|---------------|----------------------------|---------------------------------------------------------------------|
| [`checkEmail`](#checkEmail)                | POST   | No            | `email`                    | Check if an email exists                                            |
| [`addUser`](#addUser)                   | POST   | No            | `user`                     | Register a new user                                                 |
| [`validNewUser`](#validNewUser)              | POST   | No            | `email`, `otc`             | Confirm user registration                                           |
| [`login`](#login)                     | POST   | No            | `email`, `password`        | Authenticate user credentials                                       |
| [`publicLogin`](#publicLogin)               | POST   | No            | `email`, `password`        | Authenticate user credentials for public, this will return name info|
| [`logout`](#logout)                    | POST   | Yes           | —                          | Log the user out                                                    |
| [`checkLive`](#checkLive)                 | GET    | Optional      | —                          | Validate user session                                               |
| [`setupPasswordReset`](#setupPasswordReset)        | POST   | No            | `email`                    | Start password reset process                                        |
| [`passwordResetRequest`](#passwordResetRequest)      | POST   | No            | `email`, `otc`, `password` | Complete password reset                                             |
| [`updatePass`](#updatePass)                | POST   | Yes           | `oldPassword`, `password`  | Change password                                                     |
| [`lookupUser`](#lookupUser)                | GET    | Yes           | `lookupUserId`             | Lookup a user (admin only)                                          |
| [`setUpNewSystem`](#setUpNewSystem)            | POST   | Yes           |  —                         |Set up a new system (admin only)                                     |
| [`setUserToSystem`](#setUserToSystem)           | POST   | Yes           |  —                         | Add a user to a new system Roles(1-5)                               | 
| [`getAvailableRoles`](#getAvailableRoles)         | GET    | Yes           |  —                         | Get a list of roles that you can set                                |
| [`addUserWithRole`](#addUserWithRole)           | POST   | Yes           |  —                         | Post a new user with there role, needs to be within a tenants space |
| [`validNewUserWithPass`](#validNewUserWithPass)      | POST   | Yes           |  —                         | Post validate user account's with onetimeCode and password          |
| [`searchUserWithEmail`](#searchUserWithEmail)       | GET    | Yes           |  —                         | Get userId based on email                                           |
| [`viewTenantUsers`](#viewTenantUsers)           | GET    | Yes           |  —                         | Get user list based on tenant id                                    |
| [`newSuperAdmin`](#newSuperAdmin)             | POST   | Yes           |  newUser                   | Set up a new Super User Account Role 1 or 2 or 3                    |
| [`viewSysAdmins`](#viewSysAdmins)             | GET    | Yes           |  View List                 | List of super admin users                                           |
| [`getAvailableRolesForTenant`](#getAvailableRolesForTenant)| GET    | Yes           |  View List                 | Get a list of roles that you can set for a tennant                  |



---

## Payload Structures

<a id="checkEmail"></a>
### `checkEmail`
```json
{
  "action": "checkEmail",        // Action to perform
  "email": "test@example.com"     // Email to check
}
```

<a id="addUser"></a>
### `addUser`
```json
{
  "action": "addUser",            // Registration trigger
  "email": "test@example.com",    // Email address
  "password": "********",         // Password
  "firstName": "John",            // First name
  "lastName": "Doe",              // Last name
  "phoneNumber": "0123456789"     // Optional phone
}
```

<a id="validNewUser"></a>
### `validNewUser`
```json
{
  "action": "validNewUser",      // Validation trigger
  "email": "test@example.com",    // Email address
  "otc": "123456"                 // One-time code sent to email
}
```

<a id="publicLogin"></a>
### `publicLogin`
```json
{
  "action": "publicLogin",        // Login request
  "email": "test@example.com",    // Email
  "password": "********"          // Password
}
```

<a id="login"></a>
### `login`
```json
{
  "action": "login",              // Login request
  "email": "test@example.com",    // Email
  "password": "********"          // Password
}
```

<a id="logout"></a>
### `logout`
```json
{
  "action": "logout"              // Logout current session
}
```

<a id="checkLive"></a>
### `checkLive`
```json
{
  "action": "checkLive"           // Check if session is active
}
```

<a id="setupPasswordReset"></a>
### `setupPasswordReset`
```json
{
  "action": "setupPasswordReset", // Trigger password reset
  "email": "test@example.com"     // User email
}
```

<a id="passwordResetRequest"></a>
### `passwordResetRequest`
```json
{
  "action": "passwordResetRequest", // Finalize reset
  "email": "test@example.com",       // Email
  "password": "NewPass123!",        // New password
  "otc": "123456"                    // One-time code
}
```

<a id="updatePass"></a>
### `updatePass`
```json
{
  "action": "updatePass",          // Password update
  "oldPassword": "OldPass123!",    // Current password
  "password": "NewPass123!"         // New password
}
```

<a id="lookupUser"></a>
### `lookupUser`
```json
{
  "action": "lookupUser",          // Admin lookup
  "lookupUserId": 123               // ID of user to retrieve
}
```

<a id="setUpNewSystem"></a>
### `setUpNewSystem`
```json
{
  "action": "setUpNewSystem",
  "tenantId"          : int,
  "systemName"        : string "Company Name",
  "tenantBaseUrl"     : string "BaseUrl",
  "systemDescription" : string "Description"
}
```

<a id="setUserToSystem"></a>
### `setUserToSystem`
```json
{
  "action": "setUserToSystem",
  "systemName"        : string "Company Name",
  "registerUser"      : int,
  "requestedRoleId"   : int
}
```

<a id="getAvailableRoles"></a>
### `getAvailableRoles`
```json
{
  "action": "getAvailableRoles",          // Admin lookup
}
```

<a id="addUserWithRole"></a>
### `addUserWithRole`
```json
{
  "action": "addUserWithRole",    // Registration trigger
  "email": "test@example.com",    // Email address
  "firstName": "John",            // First name
  "lastName": "Doe",              // Last name
  "phoneNumber": "0123456789",    // Optional phone
  "requestedRoleId": 4            // Role Owner 
}
```


### `validNewUserWithPass`
```json
{
  "action": "validNewUserWithPass", // Registration trigger
  "email": "test@example.com",      // Email address
  "password": "********",           // Password
  "otc" : int
}
```

### `validNewUserWithPass`
```json
{
  "action": "validNewUserWithPass", // Registration trigger
  "email": "test@example.com",      // Email address
  "password": "********",           // Password
  "otc" : int
}
```

<a id="searchUserWithEmail"></a>
### `searchUserWithEmail`
```json
{
  "action": "searchUserWithEmail", // Registration trigger
  "email": "test@example.com"      // Email address
}
```

<a id="viewTenantUsers"></a>
### `viewTenantUsers`
```json
{
  "action": "viewTenantUsers"  
}
```

<a id="newSuperAdmin"></a>
### `newSuperAdmin`
```json
{
  "action": "newSuperAdmin",
    "email"       : string,
    "firstName"   : "John",            // First name
    "lastName"    : "Doe",              // Last name
    "phoneNumber" : "0123456789",     // Optional phone
    "password"    : string,
    "requestedRoleId": int // [1,2,3]
}
```
<a id="viewSysAdmins"></a>
### `viewSysAdmins`
```json
{
  "action": "viewSysAdmins"
}

---

## Response Format

### Success
```json
{
  "status": "success",
  "message": "Description of result"
}
```

### Failure
```json
{
  "status": "failed",
  "message": "Error message"
}
```

---

## Notes
- Email validation is required for login.
- Passwords must be at least 8 characters.
- The same password cannot be reused.
- One-time codes (OTCs) are used for validation and password reset.
- Session state is maintained via `$_SESSION`.

---

_End of Document_

