-- ------------------------------
-- Table: user_status
-- ------------------------------
CREATE TABLE user_status (
  pk_user_status_id INTEGER PRIMARY KEY AUTOINCREMENT,
  table_ref_name TEXT NOT NULL,
  status_name TEXT NOT NULL,
  last_updated TIMESTAMP DEFAULT CURRENT_TIMESTAMP
);


-- ------------------------------
-- Table: user_role
-- ------------------------------
CREATE TABLE user_role (
  pk_role_id INTEGER PRIMARY KEY AUTOINCREMENT,
  role_name TEXT NOT NULL,
  scope TEXT NOT NULL
);


-- ------------------------------
-- Table: user_login
-- ------------------------------
CREATE TABLE user_login (
  pk_user_id INTEGER PRIMARY KEY AUTOINCREMENT,
  fk_user_status_id INTEGER NOT NULL DEFAULT 1,
  f_name TEXT NOT NULL,
  l_name TEXT NOT NULL,
  phone_number TEXT NOT NULL,
  user_email TEXT NOT NULL,
  user_password TEXT NOT NULL,
  one_time_code TEXT,
  last_updated TIMESTAMP DEFAULT CURRENT_TIMESTAMP,
  FOREIGN KEY (fk_user_status_id) REFERENCES user_status(pk_user_status_id)
);

CREATE TABLE user_permissions (
  pk_permission_id INTEGER PRIMARY KEY AUTOINCREMENT,
  fk_user_id INTEGER NOT NULL,
  fk_system_id INTEGER NOT NULL,  -- user_system ID
  fk_role_id INTEGER NOT NULL,
  access_status TEXT NOT NULL DEFAULT 'active'
    CHECK (access_status IN ('active', 'invited', 'suspended', 'revoked')),
  created_at DATETIME DEFAULT CURRENT_TIMESTAMP,
  updated_at DATETIME DEFAULT CURRENT_TIMESTAMP,
  FOREIGN KEY (fk_user_id) REFERENCES user_login(pk_user_id) ON DELETE CASCADE,
  FOREIGN KEY (fk_system_id) REFERENCES user_system(pk_system_id) ON DELETE CASCADE,
  FOREIGN KEY (fk_role_id) REFERENCES user_role(pk_role_id) ON DELETE RESTRICT
);


CREATE TABLE user_system (
  pk_system_id INTEGER PRIMARY KEY AUTOINCREMENT,
  fk_tenant_id INTEGER NOT NULL,
  tenant_base_url TEXT NOT NULL,
  system_name TEXT NOT NULL,
  system_description TEXT DEFAULT NULL,
  isDeleted TINYINT(1) DEFAULT 0
 -- FOREIGN KEY (fk_tenant_id) REFERENCES tenant(id) ON DELETE CASCADE
);

insert into user_system (fk_tenant_id, tenant_base_url, system_name, system_description) values
(1, 'admin.waitron.uk', 'Admin Waitron System', 'Admin Waitron System Description');


CREATE TABLE user_login_log (
  id INTEGER PRIMARY KEY AUTOINCREMENT,
  email_address TEXT NOT NULL,
  user_id INTEGER,
  login_date TEXT NOT NULL,        -- stored as 'YYYY-MM-DD'
  login_time TEXT NOT NULL,        -- stored as 'HH:MM:SS'
  login_ip TEXT NOT NULL,
  useragent TEXT NOT NULL,
  status TEXT,
  msg TEXT,
  created_date DATETIME DEFAULT CURRENT_TIMESTAMP
);


-- ------------------------------
-- Data Inserts
-- ------------------------------

-- user_status
INSERT INTO user_status (pk_user_status_id, table_ref_name, status_name, last_updated) VALUES
(1, 'user_login', 'Email Validation', '2022-11-14 16:21:22'),
(2, 'user_login', 'Active', '2023-05-31 13:52:03'),
(3, 'user_login', 'Disabled', '2023-05-31 13:52:01'),
(4, 'user_login', 'Password Reset', '2022-11-15 13:08:38');

-- user_role
INSERT INTO user_role (pk_role_id, role_name, scope) VALUES
(1, 'SystemAdmin', 'Platform'),
(2, 'SupportAgent', 'Platform'),
(3, 'ContentModerator', 'Platform'),
(4, 'BusinessOwner', 'Tenant'),
(5, 'BusinessManager', 'Tenant'),
(6, 'Staff', 'Tenant'),
(7, 'Operator', 'Tenant'),
(8, 'Customer', 'Public');

-- user_login
INSERT INTO user_login (pk_user_id, fk_user_status_id, f_name, l_name, phone_number, user_email, user_password, one_time_code, last_updated) VALUES
(1, 2, '', '', '00000000000', 'test00@test.com', '$2y$10$mw9KF.77MOmZN26H34tVF.Jd.r8UBAxKGE1xbPm7nOnsiYgXujtKC', NULL, '2023-07-12 15:58:48'),
(2, 1, '', '', '00000000000', 'test01@test.com', '$2y$10$mw9KF.77MOmZN26H34tVF.Jd.r8UBAxKGE1xbPm7nOnsiYgXujtKC', null , '2023-07-12 15:58:48'),
(3, 3, '', '', '00000000000', 'test02@test.com', '$2y$10$mw9KF.77MOmZN26H34tVF.Jd.r8UBAxKGE1xbPm7nOnsiYgXujtKC', null , '2023-07-12 15:58:48'),
(4, 4, '', '', '00000000000', 'test03@test.com', '$2y$10$mw9KF.77MOmZN26H34tVF.Jd.r8UBAxKGE1xbPm7nOnsiYgXujtKC', null , '2023-07-12 15:58:48'),
(5, 2, '', '', '00000000000', 'test04@test.com', '$2y$10$mw9KF.77MOmZN26H34tVF.Jd.r8UBAxKGE1xbPm7nOnsiYgXujtKC', null , '2023-07-12 15:58:48');

-- user_permissions
INSERT INTO user_permissions (pk_permission_Id, fk_system_id, fk_user_id, fk_role_id) VALUES
(1, 1, 1, 1),
(2, 1, 2, 1),
(3, 1, 5, 5);


-- Trigger: Update last_updated on UPDATE
CREATE TRIGGER trg_user_status_last_updated
AFTER UPDATE ON user_status
FOR EACH ROW
BEGIN
  UPDATE user_status SET last_updated = CURRENT_TIMESTAMP WHERE pk_user_status_id = OLD.pk_user_status_id;
END;


-- Trigger: Update last_updated on UPDATE
CREATE TRIGGER trg_user_login_last_updated
AFTER UPDATE ON user_login
FOR EACH ROW
BEGIN
  UPDATE user_login SET last_updated = CURRENT_TIMESTAMP WHERE pk_user_id = OLD.pk_user_id;
END;