<?php
// this should only be used for testing purposes
if (defined('TEST_ENV')) {
    //require_once __DIR__ . '/../../orbit-core/src/config.php';
    // Flexible path resolution for core files
    if (file_exists(__DIR__ . '\..\..\core\src\Fcors.php')) {
        require_once __DIR__ . '\..\..\core\src\Fcors.php';
    } else {
        require_once __DIR__ . '\..\..\core\Fcors.php';
    }
    require_once __DIR__ . '\..\..\core\unit-test\scripts\bootstrap.php';
    // Flexible path resolution for core files
    if (file_exists(__DIR__ . '\..\..\core\src\generic.php')) {
        require_once __DIR__ . '\..\..\core\src\generic.php';
    } else {
        require_once __DIR__ . '\..\..\core\generic.php';
    }
    $testInfo['0'] = ("\nFunction Running in Test Environment\n");
} else {
    // this is code for live environment Dev, Uat, Production
    require_once __DIR__ . "./../error_monitor.php";
    require_once __DIR__ . "./../generic.php";
}
    

    require_once __DIR__ . "/core.php";
    require_once __DIR__ . "/view.php";
    require_once __DIR__ . "/insert.php";
    require_once __DIR__ . "/update.php";
    $inputData = initializeGeneric();  // ✅ Ensures fresh initialization in each test

    $inputData['requiresAdmin'] = [
        'lookupUser'        => [1,2,3],             'setUpNewSystem'                => [1],         'setUserToSystem'       => [1,2,3,4,5], 
        'getAvailableRoles' => [1,2,3,4,5],         'addUserWithRole'               => [1,2,3,4,5], 'searchUserWithEmail'   => [1,2,3,4,5],
        'viewTenantUsers'   => [1,2,3,4,5],         'newSuperAdmin'                 => [1,2,3],     'viewSysAdmins'         => [1,2,3]
    ];
    
    if(!isset($inputData['action']) || empty($inputData['action'])){
        $out['status']   = 'failed';
        $out['message']  = 'No Action Found';
        echo json_encode(propagateStatusAndMessage($out));
        exit;
    }

    $action = $inputData['action'];
    
// ==========================================Login=================================================
$security = SecurityCheck($inputData); // skip security for a bit 

if($security['security'] === '1'){
    if (isset($action)) {
        switch ($action) {
            case "login":
                $out = logMeIn($inputData);
                break;      
            case "publicLogin":
                $inputData['loginType'] = 'public';
                $out['publicLogin'] = logMeIn($inputData);
                $out['userDetails'] = viewMyDetails($inputData);
                break;
            case "publicLogin":
                $inputData['loginType'] = 'public';
                $out['publicLogin'] = logMeIn($inputData);
                $out['userDetails'] = viewMyDetails($inputData);
                break;
            case "checkLive":
                $out = checkLive();
                break;
            case "logout":
                killSessions();
                $out['status'] = 'success';
                break;
            case "checkEmail":
                if(!isset($inputData['email']) || $inputData['email'] == ''){
                    $out['status']      = 'failed';
                    $out['message']     = 'Invalid email address.';
                    break;
                }       
                $out = emailCheckSanatize($inputData);
                break;
            case "addUser":
                if(!isset($inputData['email']) || $inputData['email'] == '' || !isset($inputData['password']) || $inputData['password'] == '' || !isset($inputData['firstName']) || $inputData['firstName'] == '' || !isset($inputData['lastName']) || $inputData['lastName'] == '' || !isset($inputData['phoneNumber']) || $inputData['phoneNumber'] == ''){
                    $out['status']      = 'failed';
                    $out['message']     = 'Invalid or missing Inputs.';
                    break;
                }
                $inputData['noPasswordFlag'] = 0;
                $out = newUser($inputData);
                break;
            case "validNewUser":
                $inputData['noPasswordFlag'] = 0;
                $out = validateEmail($inputData);
                break;
            case "setupPasswordReset":
                $out = setupPasswordReset($inputData);
                break;
            case "passwordResetRequest":
                $out = passwordResetRequest($inputData);
                break;
            case "updatePass":
                $out = updatePass($inputData);
                break;
            case "lookupUser":
                if(!isset($inputData['lookupUserId']) || $inputData['lookupUserId'] == ''){
                    $out['status']      = 'failed';
                    $out['message']     = 'Invalid userId.';
                    break;
                }       
                $out = lookupUser($inputData);
                break;
            case "setUpNewSystem":
                $out = setupNewSystem($inputData);
                break;
            case "setUserToSystem":
                $out = setUserToSystem($inputData);
                break;
            case "getAvailableRoles":
                $inputData['nextOperation'] = 'viewRoles';
                $out = executeDatabaseOperation($inputData);
                break;
            case "getAvailableRolesForTenant":
                $inputData['nextOperation'] = 'viewRoles';
                $inputData['viewType'] = 'tenant';
                $out = executeDatabaseOperation($inputData);
                break;
            case "addUserWithRole":
                if(!isset($inputData['email']) || $inputData['email'] == '' || !isset($inputData['firstName']) || $inputData['firstName'] == '' || !isset($inputData['lastName']) || $inputData['lastName'] == '' || !isset($inputData['phoneNumber']) || $inputData['phoneNumber'] == ''){
                    $out['status']      = 'failed';
                    $out['message']     = 'Invalid or missing Inputs.';
                    break;
                }
                $inputData['noPasswordFlag'] = 1;
                $inputData['nextOperation'] = 'getSysyemIdFromTenantId';
                $out = executeDatabaseOperation($inputData);
                if($out['status'] == 'failed'){
                    $out['message'] = 'Failed to get system id from tenant id';
                    $out['status'] = 'failed';
                    return $out; 
                }
                $inputData['clientDomain'] = $out['tenantBaseUrl'];
                $out[0] = newUser($inputData);
                $inputData['registerUser'] = $out[0]['userId'];
                


                $out[1] = setUserToSystem($inputData);
                break;
            case "validNewUserWithPass":
                if(!isset($inputData['email']) || $inputData['email'] == '' || !isset($inputData['password']) || $inputData['password'] == '' || !isset($inputData['otc']) || $inputData['otc'] == ''){
                    $out['status']      = 'failed';
                    $out['message']     = 'Invalid or missing Inputs.';
                    break;
                }
                $inputData['noPasswordFlag'] = 1;
                $out = validateEmail($inputData);
                break;
            case "searchUserWithEmail":
                if(!isset($inputData['email']) || $inputData['email'] == ''){
                    $out['status']      = 'failed';
                    $out['message']     = 'Invalid or missing Inputs.';
                    break;
                }
                $inputData['nextOperation'] = 'searchUserWithEmail';
                $out = executeDatabaseOperation($inputData);
                // To Build
                break;
            case "viewTenantUsers":
                // show all users in the system that have a link to the tenant that is owener, manager or staff
                $inputData['nextOperation'] = 'viewTenantUsers';
                $out = executeDatabaseOperation($inputData);
                break;
            case "newSuperAdmin":
                // create a new super admin
                $inputData['nextOperation'] = 'newSuperAdmin';
                $out = executeDatabaseOperation($inputData);
                break;

            case "updateUserDetails":
                // Name,Phone Number
                break;
            case "updateUserRole":
                // upgrade downgrade or disable 
                break;
          case "viewSysAdmins":
                $inputData['nextOperation'] = 'viewSysAdmins';
                $out = executeDatabaseOperation($inputData);
                break;
            default:
                $out['status']      = 'failed';
                $out['message']     = 'Invalid Action';
                break;
        }
    } else {
        $out['status']      = 'failed';
        $out['message']     = 'No Action Found';
        $out['inputData']   = $inputData;
    }
}else{
    $out = $security;
    if($security['security'] === '0'){
        unset($out['security']);
    }

}
    if(defined('TEST_ENV')){
        //    $out['testInfo']['1'] = $testInfo;
        //    $out['testInfo']['2'] = $_GET;
        //    $out['testInfo']['3'] = $_POST;
        //    $out['inputData'] = $inputData;
        //    $out['security'] = $security;
              $out['action'] = $action;
        //    $out['roleValue'] = $_SESSION['roleValue'];
    }

    cleanUpOutputData($out);
    echo json_encode(propagateStatusAndMessage($out));
?>