<?php
    function menuTableColumnMapping($table = null, $roleId = null) {
        $allMappings = [
            'menu_menus' => [
                'fields' => [
                    'id'          => ['mapping' => 'id',                'updateRole' => [2, 4, 5], 'optionalInsert' => null, 'optionalUpdate' => 1, 'dataType' => 'int',     'expectedValue' => null],
                    'tenantId'    => ['mapping' => 'tenant_id',         'updateRole' => [2, 4, 5], 'optionalInsert' => 0,    'optionalUpdate' => 0, 'dataType' => 'int',     'expectedValue' => null],
                    'name'        => ['mapping' => 'menu_name',         'updateRole' => [2, 4, 5], 'optionalInsert' => 0,    'optionalUpdate' => 0, 'dataType' => 'string',  'expectedValue' => null],
                    'description' => ['mapping' => 'menu_description',  'updateRole' => [2, 4, 5], 'optionalInsert' => 1,    'optionalUpdate' => 0, 'dataType' => 'string',  'expectedValue' => null],
                    'isActive'    => ['mapping' => 'is_active',         'updateRole' => [2, 4, 5], 'optionalInsert' => 1,    'optionalUpdate' => 0, 'dataType' => 'int',     'expectedValue' => [0,1]],
                    'isDeleted'   => ['mapping' => 'is_deleted',        'updateRole' => [2, 4, 5], 'optionalInsert' => 1,    'optionalUpdate' => 0, 'dataType' => 'int',     'expectedValue' => [0,1]],
                ],
                'relationships' => [['table' => 'menu_categories', 'foreignKey' => 'menuId']],
            ],
            'menu_categories' => [
                'fields' => [
                    'id'          => ['mapping' => 'id',                    'updateRole' => [2, 4, 5], 'optionalInsert' => null, 'optionalUpdate' => 1, 'dataType' => 'int',     'expectedValue' => null],
                    'menuId'      => ['mapping' => 'menu_id',               'updateRole' => [2, 4, 5], 'optionalInsert' => 0,    'optionalUpdate' => 0, 'dataType' => 'int',     'expectedValue' => null],
                    'parentId'    => ['mapping' => 'parent_id',             'updateRole' => [2, 4, 5], 'optionalInsert' => 1,    'optionalUpdate' => 0, 'dataType' => 'int',     'expectedValue' => null],
                    'name'        => ['mapping' => 'category_name',         'updateRole' => [2, 4, 5], 'optionalInsert' => 0,    'optionalUpdate' => 0, 'dataType' => 'string',  'expectedValue' => null],
                    'description' => ['mapping' => 'category_description',  'updateRole' => [2, 4, 5], 'optionalInsert' => 1,    'optionalUpdate' => 0, 'dataType' => 'string',  'expectedValue' => null],
                    'sortOrder'   => ['mapping' => 'sort_order',            'updateRole' => [2, 4, 5], 'optionalInsert' => 1,    'optionalUpdate' => 0, 'dataType' => 'int',     'expectedValue' => null],
                    'isActive'    => ['mapping' => 'is_active',             'updateRole' => [2, 4, 5], 'optionalInsert' => 1,    'optionalUpdate' => 0, 'dataType' => 'int',     'expectedValue' => null],
                    'isDeleted'   => ['mapping' => 'is_deleted',            'updateRole' => [2, 4, 5], 'optionalInsert' => 1,    'optionalUpdate' => 0, 'dataType' => 'int',     'expectedValue' => [0,1]],
                ],
                'relationships' => [['table' => 'menu_category_items', 'foreignKey' => 'categoryId']],
            ],
            'menu_items' => [
                'fields' => [
                    'id'             => ['mapping' => 'id',               'updateRole' => [2, 4, 5],     'optionalInsert' => null,  'optionalUpdate' => 1, 'dataType' => 'int',     'expectedValue' => null],
                    'name'           => ['mapping' => 'item_name',        'updateRole' => [2, 4, 5],     'optionalInsert' => 0,     'optionalUpdate' => 0, 'dataType' => 'string',  'expectedValue' => null],
                    'description'    => ['mapping' => 'item_description', 'updateRole' => [2, 4, 5],     'optionalInsert' => 1,     'optionalUpdate' => 0, 'dataType' => 'string',  'expectedValue' => null],
                    'basePrice'      => ['mapping' => 'base_price',       'updateRole' => [2, 4, 5],     'optionalInsert' => 0,     'optionalUpdate' => 0, 'dataType' => 'float',   'expectedValue' => null],
                    'nutrition_id'   => ['mapping' => 'nutrition_id',     'updateRole' => [2, 4, 5],     'optionalInsert' => 1,     'optionalUpdate' => 0, 'dataType' => 'int',     'expectedValue' => null],
                    'isDeleted'      => ['mapping' => 'is_deleted',       'updateRole' => [2, 4, 5],     'optionalInsert' => 1,     'optionalUpdate' => 0, 'dataType' => 'int',     'expectedValue' => [0,1]],
                    'isActive'       => ['mapping' => 'is_active',        'updateRole' => [2, 4, 5],     'optionalInsert' => 1,     'optionalUpdate' => 0, 'dataType' => 'int',     'expectedValue' => null],
                    
                ],
                'relationships' => [['table' => 'menu_category_items', 'foreignKey' => 'itemId'],
                                    ['table' => 'menu_option_groups', 'foreignKey' => 'itemId']]
            ],
            'menu_category_items' => [
                'fields' => [
                    'id'          => ['mapping' => 'id',                'updateRole' => [2, 4, 5], 'optionalInsert' => null, 'optionalUpdate' => 1, 'dataType' => 'int',     'expectedValue' => null],
                    'categoryId'  => ['mapping' => 'category_id',       'updateRole' => [2, 4, 5], 'optionalInsert' => 0,    'optionalUpdate' => 0, 'dataType' => 'int',     'expectedValue' => null],
                    'itemId'      => ['mapping' => 'item_id',           'updateRole' => [2, 4, 5], 'optionalInsert' => 0,    'optionalUpdate' => 0, 'dataType' => 'int',     'expectedValue' => null],
                    'isDeleted'   => ['mapping' => 'is_deleted',        'updateRole' => [2, 4, 5], 'optionalInsert' => 1,    'optionalUpdate' => 0, 'dataType' => 'int',     'expectedValue' => [0,1]],
                    'isActive'    => ['mapping' => 'is_active',         'updateRole' => [2, 4, 5], 'optionalInsert' => 1,    'optionalUpdate' => 0, 'dataType' => 'int',     'expectedValue' => null],
                ],
                'relationships' => [],
                
            ],
            'menu_option_groups' => [
                'fields' => [
                    'id'                        => ['mapping' => 'id',                          'updateRole' => [2, 4, 5], 'optionalInsert' => null, 'optionalUpdate' => 1, 'dataType' => 'int',     'expectedValue' => null],
                    'itemId'                    => ['mapping' => 'item_id',                     'updateRole' => [2, 4, 5], 'optionalInsert' => 0,    'optionalUpdate' => 0, 'dataType' => 'int',     'expectedValue' => null],
                    'groupName'                 => ['mapping' => 'group_name',                  'updateRole' => [2, 4, 5], 'optionalInsert' => 0,    'optionalUpdate' => 0, 'dataType' => 'string',  'expectedValue' => null],
                    'groupDescription'          => ['mapping' => 'group_description',           'updateRole' => [2, 4, 5], 'optionalInsert' => 1,    'optionalUpdate' => 0, 'dataType' => 'string',  'expectedValue' => null],
                    'minSelect'                 => ['mapping' => 'min_select',                  'updateRole' => [2, 4, 5], 'optionalInsert' => 1,    'optionalUpdate' => 0, 'dataType' => 'int',     'expectedValue' => null],
                    'maxSelect'                 => ['mapping' => 'max_select',                  'updateRole' => [2, 4, 5], 'optionalInsert' => 1,    'optionalUpdate' => 0, 'dataType' => 'int',     'expectedValue' => null],
                    'isRequired'                => ['mapping' => 'is_required',                 'updateRole' => [2, 4, 5], 'optionalInsert' => 1,    'optionalUpdate' => 0, 'dataType' => 'int',     'expectedValue' => [0,1]],
                    'isDeleted'                 => ['mapping' => 'is_deleted',                  'updateRole' => [2, 4, 5], 'optionalInsert' => 1,    'optionalUpdate' => 0, 'dataType' => 'int',     'expectedValue' => [0,1]],
                    'isActive'                  => ['mapping' => 'is_active',                   'updateRole' => [2, 4, 5], 'optionalInsert' => 1,    'optionalUpdate' => 0, 'dataType' => 'int',     'expectedValue' => null],
                ],
                'relationships' => [['table' => 'menu_option_extra', 'foreignKey' => 'groupId']],
            ],
            'menu_option_extra' =>[
                'fields' => [
                    'id'                        => ['mapping' => 'id',                          'updateRole' => [2, 4, 5], 'optionalInsert' => null, 'optionalUpdate' => 1, 'dataType' => 'int',     'expectedValue' => null],
                    'tenantId'                  => ['mapping' => 'tenant_id',                   'updateRole' => [2, 4, 5], 'optionalInsert' => 0,    'optionalUpdate' => 0, 'dataType' => 'int',     'expectedValue' => null],
                    'extraName'                 => ['mapping' => 'extra_name',                  'updateRole' => [2, 4, 5], 'optionalInsert' => 0,    'optionalUpdate' => 0, 'dataType' => 'string',  'expectedValue' => null],
                    'extraDescription'          => ['mapping' => 'extra_description',           'updateRole' => [2, 4, 5], 'optionalInsert' => 1,    'optionalUpdate' => 0, 'dataType' => 'string',  'expectedValue' => null],
                    'priceAdjustment'           => ['mapping' => 'price_adjustment',            'updateRole' => [2, 4, 5], 'optionalInsert' => 1,    'optionalUpdate' => 0, 'dataType' => 'float',   'expectedValue' => null],
                    'isActive'                  => ['mapping' => 'is_active',                   'updateRole' => [2, 4, 5], 'optionalInsert' => 1,    'optionalUpdate' => 0, 'dataType' => 'int',     'expectedValue' => null],
                    'nutritionId'               => ['mapping' => 'nutrition_id',                'updateRole' => [2, 4, 5], 'optionalInsert' => 1,    'optionalUpdate' => 0, 'dataType' => 'int',     'expectedValue' => null],
                    'isDeleted'                 => ['mapping' => 'is_deleted',                  'updateRole' => [2, 4, 5], 'optionalInsert' => 1,    'optionalUpdate' => 0, 'dataType' => 'int',     'expectedValue' => [0,1]],
                    'isActive'                  => ['mapping' => 'is_active',                   'updateRole' => [2, 4, 5], 'optionalInsert' => 1,    'optionalUpdate' => 0, 'dataType' => 'int',     'expectedValue' => null],
                ],
                'relationships' => [],
            ],
            'menu_option_joins' => [
                'fields' => [
                    'id'                => ['mapping' => 'id',                'updateRole' => [2, 4, 5], 'optionalInsert' => null, 'optionalUpdate' => 1, 'dataType' => 'int',     'expectedValue' => null],
                    'groupId'           => ['mapping' => 'group_id',          'updateRole' => [2, 4, 5], 'optionalInsert' => 0,    'optionalUpdate' => 0, 'dataType' => 'int',     'expectedValue' => null],
                    'extraId'           => ['mapping' => 'extra_id',          'updateRole' => [2, 4, 5], 'optionalInsert' => 0,    'optionalUpdate' => 0, 'dataType' => 'int',     'expectedValue' => null],
                    'isDefault'         => ['mapping' => 'is_default',        'updateRole' => [2, 4, 5], 'optionalInsert' => 1,    'optionalUpdate' => 0, 'dataType' => 'int',     'expectedValue' => [0,1]],
                    'priceAdjustment'   => ['mapping' => 'price_adjustment',  'updateRole' => [2, 4, 5], 'optionalInsert' => 1,    'optionalUpdate' => 0, 'dataType' => 'float',   'expectedValue' => null],
                    'isDeleted'         => ['mapping' => 'is_deleted',        'updateRole' => [2, 4, 5], 'optionalInsert' => 1,    'optionalUpdate' => 0, 'dataType' => 'int',     'expectedValue' => [0,1]],
                    'isActive'          => ['mapping' => 'is_active',         'updateRole' => [2, 4, 5], 'optionalInsert' => 1,    'optionalUpdate' => 0, 'dataType' => 'int',     'expectedValue' => null],
                ],
                'relationships' => [['table' => 'menu_option_extra',    'foreignKey' => 'extraId'], 
                                    ['table' => 'menu_option_groups',   'foreignKey' => 'groupId']],
            ]
        ];
        
        if (!$table) {
            return $allMappings;
        }
    
        $table = toSnakeCase($table);
        if (!isset($allMappings[$table])) {
            return null;
        }
    
        if ($roleId === null) {
            return $allMappings[$table];
        }
    
        $filtered = [];
        //foreach ($allMappings[$table] as $key => $meta) {
        foreach ($allMappings[$table]['fields'] as $key => $meta) {
            if (in_array($roleId, $meta['updateRole'])) {
                $filtered[$key] = $meta;
            }
        }
    
        return ['filtered' => $filtered];
    }
    function updateContent($inputData) {
        $pdo = $inputData['db']['dbApp'];
        $pdo->setAttribute(PDO::ATTR_ERRMODE, PDO::ERRMODE_EXCEPTION);
        $stage = [];
        try {
            $pdo->beginTransaction(); // Start transaction
            $tableName = toSnakeCase($inputData['table']) ?? null;
            $inputData['dataKey'] = extractDataKeyFromTableName($tableName);
            $changeType = $inputData['recordType'] ?? null;
            // ✅ Check if the extracted data block actually exists
            if (!isset($inputData['dataKey']) || empty($inputData['dataKey'])) {
                $pdo->rollback(); // Rollback transaction
                return ['status' => 'failed', 'message' => "Missing data block for table: {$tableName}"];
            }
            $stage[] = '00: Validate ID, prepare $inputData with idField, id, checkParent';
            // 00: Validate ID, prepare $inputData with idField, id, checkParent
            $res = validateUpdateInputStep($inputData);
            if ($res['status'] !== 'success') {
                $pdo->rollback(); // Rollback transaction
                if (isset($inputData['debug']) && $inputData['debug'] === $inputData['debugModeFlag']) {
                    $res['stage'] = $stage;
                }
                return $res;
            }

            $stage[] = '01: check item is not marked as deleted no update is possible';
            // 01: check item is not marked as deleted no update is possible
            $inputData['nextOperation'] = 'checkIfDeleted';
            $res = executeDatabaseOperation($inputData);
            if ($res['status'] !== 'success') {
                $pdo->rollback(); // Rollback transaction
                if (isset($inputData['debug']) && $inputData['debug'] === $inputData['debugModeFlag']) {
                    $res['stage'] = $stage;
                }
                return $res;
            }
    

        if($changeType === 'delete' || $changeType === 'update') {
            $stage[] = '02: Fetch existing history data (before change)';
            // 02: Fetch existing history data (before change)
            $inputData['nextOperation'] = 'getDataForHistory';
            $res = executeDatabaseOperation($inputData);
            if ($res['status'] !== 'success') {
                $pdo->rollback(); // Rollback transaction
                if (isset($inputData['debug']) && $inputData['debug'] === $inputData['debugModeFlag']) {
                    $res['stage'] = $stage;
                }
                return $res;
            }
            $inputData['historyData'] = $res['historyData'] ?? null;

            $stage[] = '03: Insert history record into history table';
            // 03: Insert history record into history table
            $inputData['nextOperation'] = 'saveHistoryRecordStep';
            $res = executeDatabaseOperation($inputData);

            if ($res['status'] !== 'success') {
                $pdo->rollback(); // Rollback transaction
                if (isset($inputData['debug']) && $inputData['debug'] === $inputData['debugModeFlag']) {
                    $res['stage'] = $stage;
                }
                return $res;
            }
        }
            $stage[] = '04: check if this is an update or a delete action';
            // 04: check if this is an update or a delete action
            
            if($changeType === 'delete') {
                // check if premission to delete is allowed
                $inputData['nextOperation'] = 'deleteContent';
                $res = executeDatabaseOperation($inputData);
            }

            $stage[] = '05: check if this is an update or a duplicate action';
            // 05: check if this is an update or a delete action
            if($changeType === 'update') {
                $inputData['nextOperation'] = 'updateMenuTable';
                $res = executeDatabaseOperation($inputData);
            }

            $stage[] = '06: check if this is a duplicate action';
            // 06: check if this is a duplicate action
            if($changeType === 'duplicate') {
                $inputData['nextOperation'] = 'duplicateRecored';
                $res = executeDatabaseOperation($inputData);
            }

            $stage[] = '07: check if the delete or update was successful';
            // 07: check if the delete or update was successful
            if($res['status'] !== 'success') {
                $pdo->rollback(); // Rollback transaction
                if (isset($inputData['debug']) && $inputData['debug'] === $inputData['debugModeFlag']) {
                    $res['stage'] = $stage;
                }
                return $res;
           }
            $pdo->commit();
            return [ 'status' => 'success','message' => 'Update completed successfully'];
        } catch (Exception $e) {
            $pdo->rollback(); // Rollback transaction on error
            $errorInfo = $e->errorInfo ?? [];
            $errorCode = $errorInfo[1] ?? 0; // SQL error code
            $errorMessage = $e->getMessage();
    
            // Determine the type of error
            if ($errorCode == 1062) {
                return ['status' => 'failed', 'message' => "Duplicate entry detected: " . $errorMessage];
            } elseif (isset($inputData['debug']) && $inputData['debug'] === $inputData['debugModeFlag']) {
                    
            } else {
                error_log("Error in updateContent: " . $e->getMessage());
                return ['status' => 'failed', 'message' => "Unknown failure"];
            }
        }
    }
    function findIdInData($data, $primaryKey) {
        foreach ($data as $key => $value) {
            if (is_array($value)) {
                // Recurse into sub-arrays
                $found = findIdInData($value, $primaryKey);
                if ($found !== null) {
                    return $found;
                }
            } else {
                if ($key === $primaryKey) {
                    return $value;
                }
            }
        }
        return null;
    }
    function validateUpdateInputStep(&$inputData) {
        $table = $inputData['table'] ?? null;
        $tableName = toSnakeCase($table);
        $roleId = $inputData['roleId'] ?? null;
        $dataKey = $inputData['dataKey'];

        if (!$tableName) {
            return ['status' => 'failed', 'message' => 'Table name not specified in input'];
        }
    
        if (!$dataKey) {
            return ['status' => 'failed', 'message' => 'Data key not extracted from table name'];
        }


        $tableData = $inputData[$dataKey] ?? [];
            
        $map = menuTableColumnMapping($tableName, $roleId);

        $columnMap = $map['filtered'] ?? null;
        
        if (!$columnMap) {
            return ['status' => 'failed', 'message' => 'No column mapping found for table: '. $tableName];
        }
    
        // 🆕 Find the primary key field
        $primaryKey = null;
        foreach ($columnMap as $key => $meta) {
            if (isset($meta['mapping']) && strtolower($meta['mapping']) === 'id') {
                $primaryKey = $key;
                break;
            }
        }
    
        if (!$primaryKey) {
            return ['status' => 'failed', 'message' => "No primary key (id) field found for table: {$tableName}"];
        }
    
        // 🆕 Recursively search for the ID value
        $idValue = findIdInData($tableData, $primaryKey);
    
        if ($idValue === null || $idValue === '') {
            return ['status' => 'failed', 'message' => "Missing required Id field: {$primaryKey} key: {$tableName}"];
        }
    
        // Set ID info for future steps
        $inputData['idField'] = $primaryKey;
        $inputData['id'] = $idValue;
    
        // Set checkParent flag
        $inputData['checkParent'] = array_key_exists('parentId', $columnMap) ? 1 : 0;

        return ['status' => 'success'];
    }
    function executeDatabaseOperation( $inputData) {
        $operation = $inputData['nextOperation'];
        try {
            $results =  $operation($inputData);
        } catch (PDOException $e) {
            $errorInfo = $e->errorInfo ?? [];
            $errorCode = $errorInfo[1] ?? 0; // SQL error code
            $errorMessage = $e->getMessage();
    
            // Determine the type of error
            if ($errorCode == 1062) {
                $results =  ['status' => 'failed', 'message' => "Duplicate entry detected: " . $errorMessage];
            } elseif (isset($inputData['debug']) && $inputData['debug'] === $inputData['debugModeFlag']) {
                $results = ['status' => 'failed', 'message' => $errorMessage];
            }else{
                $results = ['status' => 'failed', 'message' => "Unknown failure"];
            }
        }
        return $results;
    }
    function convertKeysToCamelCase($array) {
        $converted = [];

        foreach ($array as $key => $value) {
            // Convert snake_case to camelCase
            $camelKey = preg_replace_callback('/_([a-z])/', function ($matches) {
                return strtoupper($matches[1]);
            }, $key);

            // Lowercase first character to enforce camelCase
            $camelKey = lcfirst($camelKey);

            // Recursively handle nested arrays
            if (is_array($value)) {
                $converted[$camelKey] = convertKeysToCamelCase($value);
            } else {
                $converted[$camelKey] = $value;
            }
        }

        return $converted;
    }
    function toSnakeCase($input) {
        return strtolower(preg_replace('/([a-z])([A-Z])/', '$1_$2', $input));
    }
    function renameIdKeys($array, $newKeyName) {
        $converted = [];

        foreach ($array as $key => $value) {
            // Recursively handle nested arrays
            if (is_array($value)) {
                $value = renameIdKeys($value, $newKeyName);
            }

            if ($key === 'id') {
                $converted[$newKeyName] = $value;
            } else {
                $converted[$key] = $value;
            }
        }

        return $converted;
    }
    function extractDataKeyFromTableName($tableName) {
        $parts = explode('_', $tableName, 2);
        $base = $parts[1] ?? $tableName;
    
        $baseParts = explode('_', $base);
    
        $camelCase = array_shift($baseParts);
    
        foreach ($baseParts as $part) {
            $camelCase .= ucfirst($part);
        }
    
        return $camelCase;
    }
    function roleViewType($roleId) {
        if(in_array($roleId, [1, 2, 3])) {
            return 'sysAdmin';
        } elseif($roleId == 4) {
            return 'owner';
        } elseif($roleId == 5) {
            return 'manager';
        } elseif($roleId == 6) {
            return 'staff';
        } else{
            return 'guest';
        }
    }
    function insertIfArrayOrSingle($inputData){ 
        $table = $inputData['table'] ?? null;
        $table = toSnakeCase($table);
        $joiningTableBuild = 0;
        $dataKey = extractDataKeyFromTableName($inputData['table']);
        if(isset($inputData['joiningTable']) && !empty($inputData['joiningTable'])) {
            $joiningTable = $inputData['joiningTable'];
            $joiningTableBuild = 1;
        }
        $data = $inputData[$dataKey] ?? [];
        $out = [];
        if (isset($data[0]) && is_array($data[0])) {
        // It's a list of associative arrays — loop through
            foreach ($data as $item) {
                // Do something with each $item
                $inputData[$dataKey] = $item; // Set the current item
                $res = insertData($inputData);
                $status = $res['status'];
                if ($status !== 'success') {
                    $out['status'] = 'failed';
                    $out['message'] = $res['message'];
                    $out['failedItem'] = $item;
                    return $out; // Return early if any insert fails
                }
                if($joiningTableBuild == 1){
                    $joiningData['groupId']         = $inputData['groupId']; // Set groupId for each item
                    $joiningData['extraId']   = $res['id'] ?? null; // Set option_item_id for each item
                     $joiningData['isActive']       = $item['isActive'] ?? 1; // Set isActive for each item
                    $out[$joiningTable][]           = $joiningData;
                }
            }
            $out['status'] = 'success';
        }/* else {
            // It's a single associative array — just pass it on
            $res = insertData($inputData);
            $status = $res['status'] ?? 'failed';
            if ($status !== 'success') {
                $out['status'] = 'failed';
                $out['message'] = $res['message'];
                
                return $out; // Return early if any insert fails
            }
            $out['status'] = 'success';
            if($joiningTableBuild == 1){
                $joiningData['groupId']         = $inputData['groupId']; // Set groupId for each item
                $joiningData['extraId']   = $res['id']; // Set itemId for each item
                $out[$joiningTable]             = $joiningData;
            }
        }
        */
        return $out;
    }
    function castNumericFields(array &$item, array $numericFields) {
        foreach ($numericFields as $field) {
            if (isset($item[$field]) && is_numeric($item[$field])) {
                $item[$field] = (float)$item[$field];
            }
        }
    }

    function insertMenuOptionExtra($inputData){
                if (!isset($inputData['tenantId']) || $inputData['tenantId'] == null) {
                    $out['status']   = 'failed';
                    $out['message']  = 'Tenant ID is required';
                    return $out;
                }
                $inputData['table'] = 'menuOptionExtra';
                $inputData['menuOptionExtra']['tenantId'] = $inputData['tenantId'];
                $inputData['uniqueFields'] = ['tenantId', 'extraName'];
                $inputData['menuCategoryItems']['tenantId'] = $inputData['tenantId'];
                $inputData['showId'] = true;
                $inputData['nextOperation'] = 'checkDuplicateRecord';
                $out = executeDatabaseOperation($inputData);
                if($out['status'] === 'success'){
                    $inputData['nextOperation'] = 'insertData'; // Insert single menu option item
                    $out = executeDatabaseOperation($inputData);
                }
                return $out;
    }



?>