<?php
    function checkIfDeleted($inputData) {
        $table = $inputData['table'];
        $table = toSnakeCase($table);
        $id = $inputData['id'];
        $db = $inputData['db']['dbLogin'];
        $stmt = $db->prepare("SELECT id FROM $table WHERE id = :id and is_deleted = 1");
        $stmt->bindParam(':id', $id, PDO::PARAM_INT);
        $stmt->execute();
        $data = $stmt->fetch(PDO::FETCH_ASSOC);
            if ($data) {
                        return ['status' => 'failed', 'message' => 'Record already deleted'];
            } else {
                return ['status' => 'success'];
            }
    }
    function getDataForHistory($inputData) {
        $table = $inputData['table'];
        $table = toSnakeCase($table);
        $id = $inputData['id'];
        $db = $inputData['db']['dbLogin'];
        $stmt = $db->prepare("SELECT * FROM $table WHERE id = :id");
        $stmt->bindParam(':id', $id, PDO::PARAM_INT);
        $stmt->execute();
        // convert result to json with column names as keys
        $data = $stmt->fetch(PDO::FETCH_ASSOC);
        json_encode($data);
        if ($data) {
            return ['status' => 'success', 'historyData' => $data];
        } else {
            return ['status' => 'failed', 'message' => 'Record not found'];
        }
    }
    function viewContentMenus($inputData) {
        $roleId = $inputData['roleId'];
        // role is system admin,
        $viewType = $inputData['view'];

        if (!in_array($viewType, ['sysAdmin', 'owner', 'staff', 'guest'])) {
            return ['status' => 'failed', 'message' => 'Invalid view type'];
        }

        if ($viewType === 'sysAdmin') {
            $sql = "SELECT * FROM menu_menus WHERE tenant_id = :tenantId order by is_deleted, id desc";
        } elseif ($viewType === 'owner') {
            $sql = "SELECT `id`, `menu_name`, `menu_description`, is_active FROM menu_menus WHERE tenant_id = :tenantId AND is_deleted = 0 order by is_active, id desc";
        } else {
            $sql = "SELECT `menu_name`, `menu_description` FROM menu_menus WHERE tenant_id = :tenantId AND is_deleted = 0 and is_active = 1 order by is_deleted, id desc";
        }

        $pdo = $inputData['db']['dbApp'];
        $pdo->setAttribute(PDO::ATTR_ERRMODE, PDO::ERRMODE_EXCEPTION);
        $stmt = $pdo->prepare($sql);
        $stmt->bindValue(':tenantId', $inputData['tenantId'], PDO::PARAM_INT);
        $stmt->execute();

        $rows = $stmt->fetchAll(PDO::FETCH_ASSOC);
    
        if (!$rows || ($viewType === 'restricted' && $rows[0]['is_active'] != 1)) {
            return ['status' => 'failed', 'message' => 'Menu not found', 'tenantId' => $inputData['tenantId'], 'viewType' => $viewType, 'row_is_active' => $rows[0]['is_active'] ?? null];
        }

        $menu = array_map(function($row) {
            return convertKeysToCamelCase(renameIdKeys($row, 'menuId'));
        }, $rows);

        if ($menu) {
            return ['status' => 'success', 'menuMenus' => $menu];
        } else {
            return ['status' => 'failed', 'message' => 'Record not found'];
        }
    }
    function checkDuplicateRecord($inputData) {
        $pdo = $inputData['db']['dbApp'];
        $pdo->setAttribute(PDO::ATTR_ERRMODE, PDO::ERRMODE_EXCEPTION);

        $table = $inputData['table'] ?? null;
        $table = toSnakeCase($table);
        $dataKey = extractDataKeyFromTableName($inputData['table']);
        $data = $inputData[$dataKey] ?? [];
        $showId = $inputData['showId'] ?? false;

        if (!$table) {
            return ['status' => 'failed', 'message' => 'Table not specified'];
        }

        $map = menuTableColumnMapping($table, $inputData['roleId'] ?? 0);
        $columnMap = $map['filtered'] ?? null;

        if (!$columnMap) {
            return ['status' => 'failed', 'message' => 'Invalid table or insufficient permissions'];
        }

        // Define which fields make the record unique (you may want to pass this in $inputData)
        $uniqueFields = $inputData['uniqueFields'];
        $whereClauses = [];
        $params = [];

        foreach ($uniqueFields as $fieldKey) {
            $meta = $columnMap[$fieldKey] ?? null;
            $dbField = $meta['mapping'] ?? null;

            if (!$dbField || !isset($data[$fieldKey])) {
                return ['status' => 'failed', 'message' => "$fieldKey is required"];
            }

            $whereClauses[] = "$dbField = :$fieldKey";
            $params[$fieldKey] = $data[$fieldKey];
        }

        // Add soft delete clause
        $whereClauses[] = "is_deleted = 0";

        $whereSql = implode(' AND ', $whereClauses);
        $sql = "SELECT id FROM $table WHERE $whereSql";
        $stmt = $pdo->prepare($sql);
        foreach ($params as $key => $value) {
            $stmt->bindValue(":$key", $value);
        }
        $stmt->execute();
        $result = $stmt->fetch(PDO::FETCH_ASSOC);
        if ($result) {
            if ($showId) {
                return ['status' => 'failed', 'message' => 'Record already exists', 'id' => $result['id']];
            }
            return ['status' => 'failed', 'message' => 'Record already exists'];
        }

        return ['status' => 'success'];
    }  
    function getMenuView($inputData){
        $pdo = $inputData['db']['dbApp'];
        $pdo->setAttribute(PDO::ATTR_ERRMODE, PDO::ERRMODE_EXCEPTION);
        $viewType = $inputData['viewType'] ?? 'restricted'; // default to restricted view
        if (!in_array($viewType, ['sysAdmin', 'owner', 'restricted'])) {
            return ['status' => 'failed', 'message' => 'Invalid view type'];
        }
        $tenantId = "";
        if(isset($inputData['tenantId'])){
            $tenantId = $inputData['tenantId'];
        }else{
             return ['status' => 'failed', 'message' => 'Tenant Id not found', ];
        }
        if ($viewType === 'sysAdmin') {
            $sql = "SELECT * FROM menu_menus WHERE tenant_id = :tenantId order by is_deleted, is_active desc, id desc";
        } elseif ($viewType === 'owner') {
            $sql = "SELECT `id`, `menu_name`, `menu_description`, is_active FROM menu_menus WHERE tenant_id = :tenantId AND is_deleted = 0 order by is_active desc, id desc";
        } else {
            $sql = "SELECT `id`, `menu_name`, `menu_description`, is_active FROM menu_menus WHERE tenant_id = :tenantId AND is_deleted = 0 and is_active = 1 order by is_active desc, is_deleted asc, id desc";
        }
        $stmt = $pdo->prepare($sql);
        $stmt->bindValue(':tenantId', $tenantId, PDO::PARAM_INT);
        $stmt->execute();
        $rows = $stmt->fetchAll(PDO::FETCH_ASSOC);
        if (!$rows || ($viewType === 'restricted' && $rows[0]['is_active'] != 1)) {
            return ['status' => 'failed', 'message' => 'Menu not found'];
        }
        // if the viewType is restricted, we only return the active menus and remove the is_active column
      

        foreach ($rows as &$row) {
            // convert keys to camelCase and rename id to menuId
            $row = convertKeysToCamelCase(renameIdKeys($row, 'menuId'));
            $menuId = $row['menuId'];
            $inputData['menuId'] = $menuId;
            // fetch categories for this menu
            $cat = getMenuCategories($inputData);
            $row['categories'] = $cat['data'] ?? [];
            if ($cat['status'] === 'failed') {
                // if categories fetch failed, we still return the menu but with empty categories
                //$row['categories'] = [];
            }   
            if ($viewType === 'restricted') {
                unset($row['isActive']);
                unset($row['menuId']);
            } 
        }

        // loop through the rows for category and items
        
        //$menu = array_map(function($row) {
            //return convertKeysToCamelCase(renameIdKeys($row, 'menuId'));
        //}, $rows);

        $menu = $rows;

        if ($menu) {
            return ['status' => 'success', 'menuMenus' => $menu];
        } else {
            return ['status' => 'failed', 'message' => 'Record not found'];
        }
    }
    function getMenuCategories($inputData) {
        $pdo = $inputData['db']['dbApp'];
        $pdo->setAttribute(PDO::ATTR_ERRMODE, PDO::ERRMODE_EXCEPTION);
        $menuId = $inputData['menuId'] ?? null;
        if (!$menuId) {
            return ['status' => 'failed', 'message' => 'Menu ID not specified'];
        }

        $viewType = $inputData['viewType'] ?? 'restricted';
        if (!in_array($viewType, ['sysAdmin', 'owner', 'restricted'])) {
            return ['status' => 'failed', 'message' => 'Invalid view type'];
        }

        // Define select columns and filters based on view type
        $columns = ($viewType === 'sysAdmin') ? '*' : 'id, category_name, category_description, is_active, parent_id';
        $conditions = 'menu_id = :menuId';
        if ($viewType === 'owner') {
            $conditions .= ' AND is_deleted = 0';
        } elseif ($viewType === 'restricted') {
            $conditions .= ' AND is_deleted = 0 AND is_active = 1';
        }

        // Fetch all relevant categories
        $sql = "SELECT $columns FROM menu_categories WHERE $conditions ORDER BY id ASC, parent_id ASC";
        $stmt = $pdo->prepare($sql);
        $stmt->bindValue(':menuId', $menuId, PDO::PARAM_INT);
        $stmt->execute();
        $categories = $stmt->fetchAll(PDO::FETCH_ASSOC);

        if (!$categories) {
            return ['status' => 'failed', 'message' => 'Categories not found'];
        }

        // Group categories by parent_id
        $tree = [];
        $map = [];

        foreach ($categories as &$cat) {
            $catId = $cat['id'];
            $parentId = $cat['parent_id'] ?? 0;

            // Optional: Remove 'is_active' from restricted view
            if ($viewType === 'restricted') {
                unset($cat['is_active']);
                unset($cat['id']);
                unset($cat['parent_id']);
            }

            $map[$catId] = &$cat;

            $inputData['categoryId'] = $catId;

            $items = getMenuCategoryItems($inputData);
            if ($items['status'] === 'success') {
                $cat['items'] = $items['data'];
            }

            if (empty($parentId) || !isset($map[$parentId])) {
                $tree[] = &$cat;
            } else {
                $map[$parentId]['subCategories'][] = &$cat;
            }

        }

        $tree = array_map(function($tree) {
            return convertKeysToCamelCase(renameIdKeys($tree, 'categoryId'));
        }, $tree);

        return ['status' => 'success', 'data' => $tree];
    }
    function getMenuCategoryItems($inputData) {
        $pdo = $inputData['db']['dbApp'];
        $pdo->setAttribute(PDO::ATTR_ERRMODE, PDO::ERRMODE_EXCEPTION);
        $categoryId = $inputData['categoryId'] ?? null;
        if (!$categoryId) {
            return ['status' => 'failed', 'message' => 'Category ID not specified'];
        }
        $viewType = $inputData['viewType'] ?? 'restricted';
        if (!in_array($viewType, ['sysAdmin', 'owner', 'restricted'])) {
            return ['status' => 'failed', 'message' => 'Invalid view type'];
        }
        // Define select columns and filters based on view type

        if ($viewType === 'sysAdmin') {
            $columns = "mi.*, mci.id as category_item_id, mci.is_active as category_item_is_active, mci.is_deleted as category_item_is_deleted";
        } elseif ($viewType === 'owner') {
            $columns = "mi.id as id, mi.item_name as item_name, mi.item_description as item_description, mi.is_active as is_active, mi.base_price as base_price";
        } else {
            $columns = "mi.id as id, mi.item_name as item_name, mi.item_description as item_description, mi.is_active as is_active, mi.base_price as base_price";
        }

        
        $conditions = 'category_id = :categoryId';
        if ($viewType === 'owner') {
            $conditions .= ' AND mi.is_deleted = 0 and mci.is_deleted = 0';
        } elseif ($viewType === 'restricted') {
            $conditions .= ' AND mi.is_deleted = 0 AND mi.is_active = 1 and mci.is_active = 1 and mci.is_deleted = 0';
        }
        // Fetch all relevant items
        $sql = "SELECT $columns FROM menu_items mi left join menu_category_items mci on mi.id = mci.item_id WHERE $conditions ORDER BY mi.is_active desc, mci.is_active desc, mi.is_deleted, mci.is_deleted,  mi.id ASC";
        $stmt = $pdo->prepare($sql);
        $stmt->bindValue(':categoryId', $categoryId, PDO::PARAM_INT);
        $stmt->execute();
        $items = $stmt->fetchAll(PDO::FETCH_ASSOC);
        if (!$items) {
            return ['status' => 'failed', 'message' => 'Items not found'];
        }
        // Optional: Remove 'is_active' from restricted view
       
            foreach ($items as &$item) {
                $inputData['itemId'] = $item['id'];
                $res = getMenOptions($inputData);
                if ($res['status'] === 'success') {
                    $item['options'] = $res['data'];
                }
                
                castNumericFields($item, ['base_price']);

                if ($viewType === 'restricted') {
                    unset($item['is_active']);
                 }
            }

        // Convert keys to camelCase and rename id to itemId
        $items = array_map(function($item) {
            return convertKeysToCamelCase(renameIdKeys($item, 'itemId'));
        }, $items);
        return ['status' => 'success', 'data' => $items];
    }
    function getMenOptions($inputData) {
        $pdo = $inputData['db']['dbApp'];
        $pdo->setAttribute(PDO::ATTR_ERRMODE, PDO::ERRMODE_EXCEPTION);
        $itemId = $inputData['itemId'] ?? null;
        if (!$itemId) {
            return ['status' => 'failed', 'message' => 'Item ID not specified'];
        }
        $viewType = $inputData['viewType'] ?? 'restricted';
        if (!in_array($viewType, ['sysAdmin', 'owner', 'restricted'])) {
            return ['status' => 'failed', 'message' => 'Invalid view type'];
        }
        // Define select columns and filters based on view type
        if ($viewType === 'sysAdmin') {
            $columns = '*';
        } else{
            $columns = 'id, group_name, group_description, min_select, max_select, is_required, is_active';
        }
        // Fetch all relevant options
        $conditions = 'item_id = :item_id';
        if ($viewType === 'owner') {
            $conditions .= ' AND is_deleted = 0';
        } elseif ($viewType === 'restricted') {
            $conditions .= ' AND is_deleted = 0 AND is_active = 1';
        }
        $sql = "SELECT $columns FROM menu_option_groups WHERE $conditions ORDER BY is_active DESC, is_deleted ASC, id ASC";
        $stmt = $pdo->prepare($sql);
        $stmt->bindValue(':item_id', $itemId, PDO::PARAM_INT);
        $stmt->execute();
        $options = $stmt->fetchAll(PDO::FETCH_ASSOC);
        if (!$options) {
            return ['status' => 'failed', 'message' => 'Options not found'];
        }
        // Optional: Remove 'is_active' from restricted view
        foreach ($options as &$option) {
            $inputData['optionGroupId'] = $option['id'];
            $res = getOptionItem($inputData);
            if ($res['status'] === 'success') {
                $option['extras'] = $res['data'];
            }
            if ($viewType === 'restricted') {
                unset($option['is_active']);
            }
        }
        // Convert keys to camelCase and rename id to optionId
        $options = array_map(function($option) {
            return convertKeysToCamelCase(renameIdKeys($option, 'optionId'));
        }, $options);
        
        return ['status' => 'success', 'data' => $options];
    }
    function getOptionItem($inputData){
        // get the option item details joined with the option group via the option join table
        $pdo = $inputData['db']['dbApp'];
        $pdo->setAttribute(PDO::ATTR_ERRMODE, PDO::ERRMODE_EXCEPTION);
        $optionId = $inputData['optionGroupId'] ?? null;
        if (!$optionId) {
            return ['status' => 'failed', 'message' => 'Option ID not specified'];
        }
        $viewType = $inputData['viewType'] ?? 'restricted';
        if (!in_array($viewType, ['sysAdmin', 'owner', 'restricted']))
        {
            return ['status' => 'failed', 'message' => 'Invalid view type'];
        }
        // Define select columns and filters based on view type
        
        $columns = 'moj.id as join_id, moj.extra_id as extra_id, moj.is_active as join_is_active, moj.is_deleted as join_is_deleted, moj.created_at as join_created_at, moj.updated_at as join_updated_at,
                    moi.extra_name as extra_name, moi.extra_description as extra_description, moj.price_adjustment as price_adjustment, moj.is_default as is_default, moi.is_deleted as is_deleted, moi.is_active as is_active, moi.created_at as created_at, moi.updated_at as updated_at ';
        // Fetch all relevant option items
        $conditions = 'group_id = :optionId';
        if ($viewType === 'owner') {
            $conditions .= ' AND moj.is_deleted = 0 and moi.is_deleted = 0';
        } elseif ($viewType === 'restricted') {
            $conditions .= ' AND moj.is_deleted = 0 AND moj.is_active = 1 and moi.is_active = 1 and moi.is_deleted = 0';
        }
        $sql = "SELECT $columns 
                FROM 		menu_option_joins moj
                LEFT JOIN	menu_option_extra moi on moj.extra_id = moi.id
                WHERE $conditions ORDER BY moj.is_active DESC, moi.is_active DESC, moj.is_deleted, moi.is_deleted, moi.id ASC";
        $stmt = $pdo->prepare($sql);
        $stmt->bindValue(':optionId', $optionId, PDO::PARAM_INT);
        $stmt->execute();
        $optionItems = $stmt->fetchAll(PDO::FETCH_ASSOC);
        if (!$optionItems) {
            return ['status' => 'failed', 'message' => 'Option items not found'];
        }
        // Optional: Remove 'is_active' from restricted view
        if( $viewType === 'owner' || $viewType === 'restricted') {    
            foreach ($optionItems as &$item) {
                unset($item['join_created_at']);
                unset($item['join_updated_at']);
                unset($item['created_at']);
                unset($item['updated_at']);
                if ($viewType === 'restricted') {
                    unset($item['is_active']);
                    unset($item['join_id']); 
                }
            }
        }
        
        foreach ($optionItems as &$item) {
           castNumericFields($item, ['price_adjustment']);
        }
        
        // Convert keys to camelCase and rename id to optionItemId
        $optionItems = array_map(function($item) {
            return convertKeysToCamelCase(renameIdKeys($item, 'optionItemId'));
        }, $optionItems);
        return ['status' => 'success', 'data' => $optionItems];
    }
    function setTenantId($inputData) {
        $pdo = $inputData['db']['dbApp'];
        $pdo->setAttribute(PDO::ATTR_ERRMODE, PDO::ERRMODE_EXCEPTION);
        $host = $_SERVER['HTTP_HOST'] ?? '';
        $host = strtolower($host);
        $parts = explode('.', $host);
        $cleanParts = array_filter($parts, fn($part) => $part !== 'admin');
        $cleanHost = implode('.', $cleanParts);
        $cleanUrl = 'https://' . $cleanHost;
        // strip www. if it exists
        $cleanUrl = preg_replace('/^https?:\/\/(www\.)?/', 'https://', $cleanUrl);

        // Build SQL
        $sql = "SELECT id FROM tenant WHERE domain = :http and is_deleted = 0";
        $stmt = $pdo->prepare($sql);
        $stmt->bindParam(':http', $cleanUrl);
        $stmt->execute();
        $data = $stmt->fetch(PDO::FETCH_ASSOC);
        if ($data) {
            $_SESSION['tenantId']       = $data['id'];
            return ['status' => 'success', 'message' => 'Tenant ID found'];
        } else {
            return ['status' => 'failed', 'message' => 'Tenant ID not found'];
        }
    }
    function getItemExtras($inputData){
        $pdo = $inputData['db']['dbApp'];
        $pdo->setAttribute(PDO::ATTR_ERRMODE, PDO::ERRMODE_EXCEPTION);
        $tenantId = $inputData['tenantId'] ?? null;
        if (!$tenantId) {
            return ['status' => 'failed', 'message' => 'Tenant ID not specified'];
        }

        // Fetch all relevant option items
        $sql = "Select id, extra_name, extra_description, price_adjustment, is_deleted, created_at, updated_at 
                from menu_option_extra 
                where tenant_id = :tenantId and is_deleted = 0 
                order by is_active desc, id asc";
        $stmt = $pdo->prepare($sql);
        $stmt->bindValue(':tenantId', $tenantId, PDO::PARAM_INT);
        $stmt->execute();
        $optionItems = $stmt->fetchAll(PDO::FETCH_ASSOC);
        if (!$optionItems) {
            return ['status' => 'failed', 'message' => 'Option items not found'];
        }
        
        foreach ($optionItems as &$item) {
           castNumericFields($item, ['price_adjustment']);
           unset($item['created_at']);
           unset($item['updated_at']);
        }
        
        // Convert keys to camelCase and rename id to optionItemId
        $optionItems = array_map(function($item) {
            return convertKeysToCamelCase(renameIdKeys($item, 'extraId'));
        }, $optionItems);
        return ['status' => 'success', 'data' => $optionItems];
    }
?>