<?php
    // this should only be used for testing purposes
    if (defined('TEST_ENV')) {
        //require_once __DIR__ . '/../../orbit-core/src/config.php';
        require_once __DIR__ . '\..\..\core\src\Fcors.php';
        require_once __DIR__ . '\..\..\tests\scripts\bootstrap.php';
        require_once __DIR__ . '\..\..\core\src\generic.php';
        $testInfo['0'] = ("\nFunction Running in Test Environment\n");
    } else {
        // this is code for live environment Dev, Uat, Production
        require_once __DIR__ . "./../error_monitor.php";
        require_once __DIR__ . "./../generic.php";
    }

    
    require_once __DIR__ . "/core.php";
    require_once __DIR__ . "/view.php";
    require_once __DIR__ . "/insert.php";
    require_once __DIR__ . "/update.php";

    $inputData = initializeGeneric();

    $inputData['requiresAdmin'] = [ 'insertIntoMenuMenus'           =>  [2,4,5], 'updateMenuMenus'          => [2,4,5], 'deleteMenuMenus'           =>  [2,4,5],
                                    'duplicateMenuMenus'            =>  [2,4,5], 'insertIntoMenuCategories' => [2,4,5], 'updateMenuCategories'      =>  [2,4,5],
                                    'insertItemIntoMenu'            =>  [2,4,5], 'updateMenuItems'          => [2,4,5], 'deleteMenuItems'           =>  [2,4,5],
                                    'insertItemIntoMenuCategory'    =>  [2,4,5], 'updateMenuCategoryItems'  => [2,4,5], 'deleteMenuCategoryItems'   =>  [2,4,5],
                                    'viewSuperAdminMenus'           =>  [1,2,3], 'viewAdminMenus'           => [4,5,6], 'insertMenuOptionsSet'      =>  [2,4,5],
                                    'insertMenuOptionExtra'         =>  [2,4,5], 'updateMenuOptionExtra'    => [2,4,5], 'updateMenuOptionGroup'     =>  [2,4,5],
                                    'deleteMenuOptionExtra'         =>  [2,4,5], 'deleteMenuOptionGroup'    => [2,4,5], 'insertMenuOptionJoins'     =>  [2,4,5],
                                    'updateMenuOptionJoins'         =>  [2,4,5], 'deleteMenuOptionJoins'    => [2,4,5], 'viewItemExtras'            =>  [1,2,3,4,5]
                                ];
    $inputData['keepLive'] = checkLive();

    if(!isset($inputData['action']) || empty($inputData['action'])){
        $out['status']   = 'failed';
        $out['message']  = 'No Action Found';
        echo json_encode(propagateStatusAndMessage($out));
exit;
    }
    
    $action = $inputData['action'];

    // check if action need auth and if does check it valid otherwise move to swithc statments 
    $security = SecurityCheck($inputData); // skip security for a bit 

    if(isset($inputData['tenantId']) == false || $inputData['tenantId'] == null ){
        setTenantId($inputData);
        reinitializeTenantId($inputData);
    }
    if($security['security'] === '1'){
        switch ($action) {
            case "test":
                $out['status']   = 'success';
                $out['message']  = 'Test Passed';
                break;
        // View Operations
            case "viewMenuMenus":
                $inputData['table'] = 'menuMenus';
                $inputData['view'] = roleViewType($inputData['roleId']);
                $inputData['nextOperation'] = 'viewContentMenus';
                $out = executeDatabaseOperation($inputData);
                break;
            case "viewSuperAdminMenus":
                $inputData['viewType'] = 'sysAdmin';
                $inputData['nextOperation'] = 'getMenuView';
                $out = executeDatabaseOperation($inputData);
                break;
            case "viewAdminMenus":
                $inputData['viewType'] = 'owner';
                $inputData['nextOperation'] = 'getMenuView';
                $out = executeDatabaseOperation($inputData);
                break;
            case "viewPublicMenus":
                $inputData['viewType'] = 'restricted';
                $inputData['nextOperation'] = 'getMenuView';
                $out = executeDatabaseOperation($inputData);
                break;
            case "viewItemExtras":
                $inputData['nextOperation'] = 'getItemExtras';
                $out = executeDatabaseOperation($inputData);
                break;
        // Insert Operations
            case "insertIntoMenuMenus":
                $inputData['table'] = 'menuMenus';
                $inputData['menuMenus']['tenantId'] = $inputData['tenantId'];
                $inputData['nextOperation'] = 'insertData';
                $out = executeDatabaseOperation($inputData);
                break;
            case "insertIntoMenuCategories":
                $inputData['table'] = 'menuCategories';
                $inputData['menuCategories']['tenantId'] = $inputData['tenantId'];
                $inputData['nextOperation'] = 'insertData';
                $out = executeDatabaseOperation($inputData);
                break;
            case "insertItemIntoMenu":
                $inputData['table'] = 'menuItems';
                $inputData['menuItems']['tenantId'] = $inputData['tenantId'];
                $inputData['nextOperation'] = 'insertData';
                $out[0] = executeDatabaseOperation($inputData);
                if($out[0]['status'] === 'success'){
                    if(isset($inputData['menuItems']['categoryId']) && $inputData['menuItems']['categoryId'] > 0){
                        $inputData['menuCategoryItems']['categoryId'] = $inputData['menuItems']['categoryId'];
                        $inputData['menuCategoryItems']['itemId'] = $out[0]['id'];
                        $inputData['menuCategoryItems']['tenantId'] = $inputData['tenantId'];
                        $inputData['menuCategoryItems']['isActive'] = $inputData['menuItems']['isActive'] ?? 0;
                        $inputData['table'] = 'menuCategoryItems';
                        $inputData['menuItems']['tenantId'] = $inputData['tenantId'];
                        $inputData['nextOperation'] = 'insertData';
                        $out[1] = executeDatabaseOperation($inputData);
                        break;
                    }
                }
                break;
            case "insertItemIntoMenuCategory":
                $inputData['table'] = 'menuCategoryItems';
                $inputData['uniqueFields'] = ['categoryId', 'itemId'];
                $inputData['menuCategoryItems']['tenantId'] = $inputData['tenantId'];
                $inputData['nextOperation'] = 'checkDuplicateRecord';
                $out = executeDatabaseOperation($inputData);
                if($out['status'] === 'success'){
                    // Item does not exist in this category, proceed with insert
                    $inputData['nextOperation'] = 'insertData';
                    $out = executeDatabaseOperation($inputData);
                }
                break;
            case "insertMenuOptionsSet":
                // placed logic into core as more complex than what should be in this file
                $out = insertMenuOptionSet($inputData);
                break;
            case "insertMenuOptionExtra":
                $out = insertMenuOptionExtra($inputData);
                break;
            case "insertMenuOptionJoins":
                $inputData['table'] = 'menuOptionJoins';
                $inputData['nextOperation'] = 'insertData'; // Insert single menu option item
                $out = executeDatabaseOperation($inputData);
                break;
        // Update Operations
            case "updateMenuMenus":
                $inputData['table'] = 'menuMenus';
                $inputData['recordType'] = 'update';
                $inputData['menuMenus']['tenantId'] = $inputData['tenantId'];
                $out = updateContent($inputData);
                break;
            case "updateMenuCategories":
                $inputData['table'] = 'menuCategories';
                $inputData['recordType'] = 'update';
                $inputData['menuCategories']['tenantId'] = $inputData['tenantId'];
                $out = updateContent($inputData);
                break;        
            case "updateMenuItems":
                $inputData['table'] = 'menuItems';
                $inputData['recordType'] = 'update';
                $inputData['menuItems']['tenantId'] = $inputData['tenantId'];
                $out = updateContent($inputData);
                break;
            case "updateMenuCategoryItems":
                $inputData['table'] = 'menuCategoryItems';
                $inputData['recordType'] = 'update';    
                $inputData['menuCategoryItems']['tenantId'] = $inputData['tenantId'];
                $out = updateContent($inputData);
                break;
            case "updateMenuOptionExtra":
                $inputData['table'] = 'menuOptionExtra';
                $inputData['recordType'] = 'update';
                $out = updateContent($inputData);
                break;
            case "updateMenuOptionGroup":
                $inputData['table'] = 'menuOptionGroups';
                $inputData['recordType'] = 'update';
                $out = updateContent($inputData);
                break;
            case "updateMenuOptionJoins":
                $inputData['table'] = 'menuOptionJoins';
                $inputData['recordType'] = 'update';
                $out = updateContent($inputData);
                break;
        // Delete Operations
            case "deleteMenuCategories":
                $inputData['table'] = 'menuCategories';
                $inputData['recordType'] = 'delete';
                $inputData['menuCategories']['tenantId'] = $inputData['tenantId'];
                $out = updateContent($inputData);
                break;
            case "deleteMenuMenus":
                $inputData['table'] = 'menuMenus';
                $inputData['recordType'] = 'delete';
                $inputData['menuMenus']['tenantId'] = $inputData['tenantId'];
                $out = updateContent($inputData);
                break;
            case "deleteMenuItems":
                $inputData['table'] = 'menuItems';
                $inputData['recordType'] = 'delete';
                $inputData['menuItems']['tenantId'] = $inputData['tenantId'];
                $out = updateContent($inputData);
                break;
            case "deleteMenuCategoryItems":
                $inputData['table'] = 'menuCategoryItems';
                $inputData['recordType'] = 'delete';
                $inputData['menuCategoryItems']['tenantId'] = $inputData['tenantId'];
                $out = updateContent($inputData);
                break;
            case "deleteMenuOptionExtra":
                $inputData['table'] = 'menuOptionExtra';
                $inputData['recordType'] = 'delete';
                $inputData['menuOptionExtra']['tenantId'] = $inputData['tenantId'];
                $out = updateContent($inputData);
                break;
            case "deleteMenuOptionGroup":
                $inputData['table'] = 'menuOptionGroups';
                $inputData['recordType'] = 'delete';
                $inputData['menuOptionGroups']['tenantId'] = $inputData['tenantId'];
                $out = updateContent($inputData);
                break;
            case "deleteMenuOptionJoins":
                $inputData['table'] = 'menuOptionJoins';
                $inputData['recordType'] = 'delete';
                $inputData['menuOptionGroups']['tenantId'] = $inputData['tenantId'];
                $out = updateContent($inputData);
                break;
        // Duplicate Operations
            case "duplicateMenuMenus":
                $inputData['table'] = 'menuMenus';
                $inputData['recordType'] = 'duplicate';
                $inputData['menuMenus']['tenantId'] = $inputData['tenantId'];
                $out = updateContent($inputData);
                break;
        // Other Operations
            default:
                $out['status']   = 'failed';
                $out['message']  = 'No Action Found';
                break;
        }
    }else{
        $out = $security;
        if($security['security'] === '0'){
            unset($out['security']);
        }

    }

    // need to add a way to view current extras so they can be added to the to an option group

    if(defined('TEST_ENV')){
    //    $out['testInfo']['1'] = $testInfo;
    //    $out['testInfo']['2'] = $_GET;
    //    $out['testInfo']['3'] = $_POST;
    //    $out['inputData']     = $inputData;
        $out['security']      = $security;
        $out['action']        = $action;
    }
    
    cleanUpOutputData($out);
    echo json_encode(propagateStatusAndMessage($out));
?>
